/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSNotNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;

@NodeInfo(shortName="!")
public abstract class JSNotNode
extends JSUnaryNode {
    protected JSNotNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode operand) {
        if (operand instanceof JSNotNode) {
            JSNotNode childNode = (JSNotNode)operand;
            JavaScriptNode childOperand = childNode.getOperand();
            if (!childOperand.hasSourceSection() && childNode.hasSourceSection()) {
                JSNotNode.transferSourceSectionAndTags(childNode, childOperand);
            }
            if (childOperand.isResultAlwaysOfType(Boolean.TYPE)) {
                return childOperand;
            }
            return JSToBooleanUnaryNode.create(childOperand);
        }
        if (operand instanceof JSConstantNode.JSConstantBooleanNode) {
            boolean value = (Boolean)operand.execute(null);
            return JSConstantNode.createBoolean(!value);
        }
        if (operand instanceof JSConstantNode.JSConstantIntegerNode) {
            int value = (Integer)operand.execute(null);
            return JSConstantNode.createBoolean(value == 0);
        }
        return JSNotNodeGen.create(operand);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!this.getOperand().hasSourceSection()) {
            JSNotNode.transferSourceSectionAndTags(this, this.getOperand());
        }
        return this;
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", this.getClass().getAnnotation(NodeInfo.class).shortName());
    }

    @Specialization
    protected boolean doBoolean(boolean a2) {
        return !a2;
    }

    @Specialization
    protected boolean doNonBoolean(Object a2, @Cached(inline=true) JSToBooleanNode toBooleanNode) {
        return !toBooleanNode.executeBoolean(this, a2);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSNotNodeGen.create(JSNotNode.cloneUninitialized(this.getOperand(), materializedTags));
    }
}

