/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ExportByteSourceNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

public abstract class ExportByteSourceNode
extends JavaScriptBaseNode {
    private final JSContext context;
    private final String nonByteSourceMessage;
    private final String emptyByteSourceMessage;

    protected ExportByteSourceNode(JSContext context, String nonByteSourceMessage, String emptyByteSourceMessage) {
        this.context = context;
        this.nonByteSourceMessage = nonByteSourceMessage;
        this.emptyByteSourceMessage = emptyByteSourceMessage;
    }

    public abstract Object execute(Object var1);

    public static ExportByteSourceNode create(JSContext context, String nonByteSourceMessage, String emptyByteSourceMessage) {
        return ExportByteSourceNodeGen.create(context, nonByteSourceMessage, emptyByteSourceMessage);
    }

    @Specialization
    protected Object exportBuffer(JSArrayBufferObject arrayBuffer) {
        int length = !this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer) ? 0 : arrayBuffer.getByteLength();
        return this.exportBuffer(arrayBuffer, 0, length);
    }

    @Specialization
    protected Object exportTypedArray(JSTypedArrayObject typedArray) {
        int offset = JSArrayBufferView.getByteOffset(typedArray, this.context);
        int length = JSArrayBufferView.getByteLength(typedArray, this.context);
        return this.exportBuffer(typedArray.getArrayBuffer(), offset, length);
    }

    @Specialization
    protected Object exportDataView(JSDataViewObject dataView) {
        int offset = JSDataView.dataViewGetByteOffset(dataView);
        int length = JSDataView.dataViewGetByteLength(dataView);
        return this.exportBuffer(dataView.getArrayBuffer(), offset, length);
    }

    @Fallback
    protected Object exportOther(Object other) {
        throw Errors.createTypeError(this.nonByteSourceMessage, (Node)this);
    }

    private Object exportBuffer(JSArrayBufferObject arrayBuffer, int offset, int length) {
        JSArrayBufferObject buffer = arrayBuffer;
        if (this.emptyByteSourceMessage != null && length == 0) {
            throw Errors.createCompileError(this.emptyByteSourceMessage, (Node)this);
        }
        JSRealm realm = this.getRealm();
        if (!this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
            buffer = JSArrayBuffer.createArrayBuffer(this.context, realm, 0);
        }
        byte bufferType = JSArrayBuffer.isJSInteropArrayBuffer(arrayBuffer) ? (byte)-1 : (JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer) ? (byte)0 : (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer) ? (byte)1 : 2));
        TypedArray arrayType = TypedArrayFactory.Uint8Array.createArrayType(bufferType, offset != 0, true);
        return JSArrayBufferView.createArrayBufferView(this.context, realm, buffer, arrayType, offset, length);
    }
}

