/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSMetaType;

@ExportLibrary(value=InteropLibrary.class)
@CompilerDirectives.ValueType
public final class BigInt
implements Comparable<BigInt>,
TruffleObject {
    private final BigInteger value;
    private final boolean foreign;
    public static final BigInt ZERO = new BigInt(BigInteger.ZERO);
    public static final BigInt ONE = new BigInt(BigInteger.ONE);
    public static final BigInt NEGATIVE_ONE = new BigInt(BigInteger.valueOf(-1L));
    public static final BigInt TWO = new BigInt(BigInteger.valueOf(2L));
    public static final BigInt MAX_INT = new BigInt(BigInteger.valueOf(Integer.MAX_VALUE));
    public static final BigInt MIN_INT = new BigInt(BigInteger.valueOf(Integer.MIN_VALUE));
    private static final BigInteger TWO64 = BigInteger.ONE.shiftLeft(64);

    public BigInt(BigInteger v2) {
        this(v2, false);
    }

    private BigInt(BigInteger v2, boolean foreign) {
        this.foreign = foreign;
        this.value = v2;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt fromBigInteger(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (value.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new BigInt(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt fromForeignBigInteger(BigInteger value) {
        return new BigInt(value, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt valueOf(String s2) {
        return new BigInt(BigInt.parseBigInteger(s2));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt valueOf(long i2) {
        return new BigInt(BigInteger.valueOf(i2));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt valueOfUnsigned(long i2) {
        if (i2 >= 0L) {
            return new BigInt(BigInteger.valueOf(i2));
        }
        return new BigInt(BigInteger.valueOf(i2).mod(TWO64));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger parseBigInteger(String valueString) {
        String trimmedString;
        block10: {
            block11: {
                trimmedString = valueString.trim();
                if (trimmedString.isEmpty()) {
                    return BigInteger.ZERO;
                }
                if (trimmedString.charAt(0) != '0') break block10;
                if (trimmedString.length() <= 2) break block11;
                switch (trimmedString.charAt(1)) {
                    case 'X': 
                    case 'x': {
                        if (JSRuntime.isHex(trimmedString.charAt(2))) {
                            return new BigInteger(trimmedString.substring(2), 16);
                        }
                        break block10;
                    }
                    case 'O': 
                    case 'o': {
                        if (JSRuntime.valueInRadix(trimmedString.charAt(2), 8) != -1) {
                            return new BigInteger(trimmedString.substring(2), 8);
                        }
                        break block10;
                    }
                    case 'B': 
                    case 'b': {
                        if (JSRuntime.valueInRadix(trimmedString.charAt(2), 2) != -1) {
                            return new BigInteger(trimmedString.substring(2), 2);
                        }
                        break block10;
                    }
                    default: {
                        return new BigInteger(trimmedString, 10);
                    }
                }
            }
            if (trimmedString.length() == 1) {
                return BigInteger.ZERO;
            }
        }
        return new BigInteger(trimmedString, 10);
    }

    @CompilerDirectives.TruffleBoundary
    public int intValue() {
        return this.value.intValue();
    }

    @CompilerDirectives.TruffleBoundary
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValueOf(BigInteger value) {
        return value.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt toBigInt64() {
        return BigInt.valueOf(this.value.longValue());
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt toBigUint64() {
        return new BigInt(this.value.mod(TWO64));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt pow(int e2) {
        return new BigInt(this.value.pow(e2));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt mod(BigInt m2) {
        return new BigInt(this.value.mod(m2.value));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int compareTo(BigInt b2) {
        return this.value.compareTo(b2.value);
    }

    @CompilerDirectives.TruffleBoundary
    public int compareValueTo(long b2) {
        return this.value.compareTo(BigInteger.valueOf(b2));
    }

    @CompilerDirectives.TruffleBoundary
    public int compareValueTo(double b2) {
        assert (!Double.isNaN(b2)) : "unexpected NAN in BigInt value comparison";
        if (b2 == Double.POSITIVE_INFINITY) {
            return -1;
        }
        if (b2 == Double.NEGATIVE_INFINITY) {
            return 1;
        }
        BigDecimal thisValue = new BigDecimal(this.value);
        BigDecimal theOtherValue = new BigDecimal(b2);
        return thisValue.compareTo(theOtherValue);
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt subtract(BigInt b2) {
        return new BigInt(this.value.subtract(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt add(BigInt b2) {
        return new BigInt(this.value.add(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString(int radix) {
        return this.value.toString(radix);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString toTString() {
        return this.toTString(10);
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString toTString(int radix) {
        return Strings.fromJavaString(this.value.toString(radix));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean testBit(int n2) {
        return this.value.testBit(n2);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int signum() {
        return this.value.signum();
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt negate() {
        return new BigInt(this.value.negate());
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt not() {
        return new BigInt(this.value.not());
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigInt other = (BigInt)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt and(BigInt b2) {
        return new BigInt(this.value.and(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt or(BigInt b2) {
        return new BigInt(this.value.or(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt xor(BigInt b2) {
        return new BigInt(this.value.xor(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt multiply(BigInt b2) {
        return new BigInt(this.value.multiply(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt divide(BigInt b2) {
        return new BigInt(this.value.divide(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt remainder(BigInt b2) {
        return new BigInt(this.value.remainder(b2.value));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt[] divideAndRemainder(BigInt b2) {
        BigInteger[] qr = this.value.divideAndRemainder(b2.value);
        return new BigInt[]{new BigInt(qr[0]), new BigInt(qr[1])};
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt shiftLeft(int b2) {
        return new BigInt(this.value.shiftLeft(b2));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt shiftRight(int b2) {
        return new BigInt(this.value.shiftRight(b2));
    }

    @CompilerDirectives.TruffleBoundary
    public BigInt abs() {
        return new BigInt(this.value.abs());
    }

    @CompilerDirectives.TruffleBoundary
    public long longValueExact() {
        return this.value.longValueExact();
    }

    @CompilerDirectives.TruffleBoundary
    public long longValue() {
        return this.value.longValue();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.value.toString(10);
    }

    @ExportMessage
    boolean isNumber() {
        return true;
    }

    @ExportMessage
    boolean fitsInBigInteger() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInByte() {
        return this.value.bitLength() < 8;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInShort() {
        return this.value.bitLength() < 16;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInInt() {
        return this.value.bitLength() < 32;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean fitsInLong() {
        return this.value.bitLength() < 64;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean fitsInDouble() {
        if (this.value.bitLength() <= 53) {
            return true;
        }
        double doubleValue = this.value.doubleValue();
        if (!Double.isFinite(doubleValue)) {
            return false;
        }
        return new BigDecimal(doubleValue).toBigIntegerExact().equals(this.value);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInFloat() {
        if (this.value.bitLength() <= 24) {
            return true;
        }
        float floatValue = this.value.floatValue();
        if (!Float.isFinite(floatValue)) {
            return false;
        }
        return new BigDecimal(floatValue).toBigIntegerExact().equals(this.value);
    }

    @ExportMessage
    BigInteger asBigInteger() {
        return this.value;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    byte asByte() throws UnsupportedMessageException {
        try {
            return this.value.byteValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    short asShort() throws UnsupportedMessageException {
        try {
            return this.value.shortValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    int asInt() throws UnsupportedMessageException {
        try {
            return this.value.intValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long asLong() throws UnsupportedMessageException {
        try {
            return this.longValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    float asFloat() throws UnsupportedMessageException {
        if (this.fitsInFloat()) {
            return this.value.floatValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    double asDouble() throws UnsupportedMessageException {
        if (this.fitsInDouble()) {
            return this.value.doubleValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.toString() + "n";
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return JSMetaType.JS_BIGINT;
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public BigInt clearForeign() {
        return this.setForeign(false);
    }

    private BigInt setForeign(boolean foreign) {
        if (this.foreign == foreign) {
            return this;
        }
        return new BigInt(this.value, foreign);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int bitLength() {
        return this.value.bitLength();
    }
}

