/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TypedArrayFactory
extends Enum<TypedArrayFactory>
implements PrototypeSupplier {
    public static final /* enum */ TypedArrayFactory Int8Array = new TypedArrayFactory(1){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropInt8Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Int8Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectInt8Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectInt8Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Uint8Array = new TypedArrayFactory(1){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropUint8Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Uint8Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectUint8Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectUint8Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Uint8ClampedArray = new TypedArrayFactory(1){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropUint8ClampedArray(this, offset, fixedLength);
                case 0 -> new TypedArray.Uint8ClampedArray(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectUint8ClampedArray((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectUint8ClampedArray((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Int16Array = new TypedArrayFactory(2){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropInt16Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Int16Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectInt16Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectInt16Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Uint16Array = new TypedArrayFactory(2){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropUint16Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Uint16Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectUint16Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectUint16Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Int32Array = new TypedArrayFactory(4){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropInt32Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Int32Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectInt32Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectInt32Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Uint32Array = new TypedArrayFactory(4){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropUint32Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Uint32Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectUint32Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectUint32Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Float32Array = new TypedArrayFactory(4){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropFloat32Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Float32Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectFloat32Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectFloat32Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Float64Array = new TypedArrayFactory(8){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropFloat64Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Float64Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectFloat64Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectFloat64Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory BigInt64Array = new TypedArrayFactory(8){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropBigInt64Array(this, offset, fixedLength);
                case 0 -> new TypedArray.BigInt64Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectBigInt64Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectBigInt64Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory BigUint64Array = new TypedArrayFactory(8){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropBigUint64Array(this, offset, fixedLength);
                case 0 -> new TypedArray.BigUint64Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectBigUint64Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectBigUint64Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    public static final /* enum */ TypedArrayFactory Float16Array = new TypedArrayFactory(2){

        @Override
        TypedArray instantiateArrayType(byte bufferType, boolean offset, boolean fixedLength) {
            return switch (bufferType) {
                case -1 -> new TypedArray.InteropFloat16Array(this, offset, fixedLength);
                case 0 -> new TypedArray.Float16Array(this, offset, fixedLength);
                case 1 -> new TypedArray.DirectFloat16Array((TypedArrayFactory)this, false, offset, fixedLength);
                case 2 -> new TypedArray.DirectFloat16Array((TypedArrayFactory)this, true, offset, fixedLength);
                default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
            };
        }
    };
    private final int bytesPerElement;
    private final byte bytesPerElementShift;
    private final TruffleString name;
    private final TypedArray arrayType;
    private final TypedArray arrayTypeWithOffset;
    private final TypedArray arrayTypeAutoLength;
    private final TypedArray arrayTypeWithOffsetAutoLength;
    private final TypedArray directArrayType;
    private final TypedArray directArrayTypeWithOffset;
    private final TypedArray directArrayTypeAutoLength;
    private final TypedArray directArrayTypeWithOffsetAutoLength;
    private final TypedArray sharedArrayType;
    private final TypedArray sharedArrayTypeWithOffset;
    private final TypedArray sharedArrayTypeAutoLength;
    private final TypedArray sharedArrayTypeWithOffsetAutoLength;
    private final TypedArray interopArrayType;
    private final TypedArray interopArrayTypeWithOffset;
    private final TypedArray interopArrayTypeAutoLength;
    private final TypedArray interopArrayTypeWithOffsetAutoLength;
    static final TypedArrayFactory[] FACTORIES_ALL;
    static final TypedArrayFactory[] FACTORIES_DEFAULT;
    static final TypedArrayFactory[] FACTORIES_NO_BIGINT;
    private static final /* synthetic */ TypedArrayFactory[] $VALUES;

    public static TypedArrayFactory[] values() {
        return (TypedArrayFactory[])$VALUES.clone();
    }

    public static TypedArrayFactory valueOf(String name) {
        return Enum.valueOf(TypedArrayFactory.class, name);
    }

    private TypedArrayFactory(int bytesPerElement) {
        this.bytesPerElement = bytesPerElement;
        this.bytesPerElementShift = (byte)Integer.numberOfTrailingZeros(bytesPerElement);
        assert (1 << this.bytesPerElementShift == bytesPerElement);
        this.name = Strings.constant(this.name());
        this.arrayType = this.instantiateArrayType((byte)0, false, true);
        this.arrayTypeWithOffset = this.instantiateArrayType((byte)0, true, true);
        this.arrayTypeAutoLength = this.instantiateArrayType((byte)0, false, false);
        this.arrayTypeWithOffsetAutoLength = this.instantiateArrayType((byte)0, true, false);
        this.directArrayType = this.instantiateArrayType((byte)1, false, true);
        this.directArrayTypeWithOffset = this.instantiateArrayType((byte)1, true, true);
        this.directArrayTypeAutoLength = this.instantiateArrayType((byte)1, false, false);
        this.directArrayTypeWithOffsetAutoLength = this.instantiateArrayType((byte)1, true, false);
        this.sharedArrayType = this.instantiateArrayType((byte)2, false, true);
        this.sharedArrayTypeWithOffset = this.instantiateArrayType((byte)2, true, true);
        this.sharedArrayTypeAutoLength = this.instantiateArrayType((byte)2, false, false);
        this.sharedArrayTypeWithOffsetAutoLength = this.instantiateArrayType((byte)2, true, false);
        this.interopArrayType = this.instantiateArrayType((byte)-1, false, true);
        this.interopArrayTypeWithOffset = this.instantiateArrayType((byte)-1, true, true);
        this.interopArrayTypeAutoLength = this.instantiateArrayType((byte)-1, false, false);
        this.interopArrayTypeWithOffsetAutoLength = this.instantiateArrayType((byte)-1, true, false);
        assert (!this.arrayType.hasOffset() && this.arrayTypeWithOffset.hasOffset() && !this.arrayType.isDirect() && !this.arrayTypeWithOffset.isDirect() && !this.directArrayType.hasOffset() && this.directArrayTypeWithOffset.hasOffset() && this.directArrayType.isDirect() && this.directArrayTypeWithOffset.isDirect() && !this.interopArrayType.hasOffset() && this.interopArrayTypeWithOffset.hasOffset() && this.interopArrayType.isInterop() && this.interopArrayTypeWithOffset.isInterop());
    }

    public final TypedArray createArrayType(byte bufferType, boolean offset, boolean fixedLength) {
        return switch (bufferType) {
            case -1 -> {
                if (offset) {
                    if (fixedLength) {
                        yield this.interopArrayTypeWithOffset;
                    }
                    yield this.interopArrayTypeWithOffsetAutoLength;
                }
                if (fixedLength) {
                    yield this.interopArrayType;
                }
                yield this.interopArrayTypeAutoLength;
            }
            case 0 -> {
                if (offset) {
                    if (fixedLength) {
                        yield this.arrayTypeWithOffset;
                    }
                    yield this.arrayTypeWithOffsetAutoLength;
                }
                if (fixedLength) {
                    yield this.arrayType;
                }
                yield this.arrayTypeAutoLength;
            }
            case 1 -> {
                if (offset) {
                    if (fixedLength) {
                        yield this.directArrayTypeWithOffset;
                    }
                    yield this.directArrayTypeWithOffsetAutoLength;
                }
                if (fixedLength) {
                    yield this.directArrayType;
                }
                yield this.directArrayTypeAutoLength;
            }
            case 2 -> {
                if (offset) {
                    if (fixedLength) {
                        yield this.sharedArrayTypeWithOffset;
                    }
                    yield this.sharedArrayTypeWithOffsetAutoLength;
                }
                if (fixedLength) {
                    yield this.sharedArrayType;
                }
                yield this.sharedArrayTypeAutoLength;
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue(bufferType);
        };
    }

    public final int getBytesPerElement() {
        return this.bytesPerElement;
    }

    public final byte getBytesPerElementShift() {
        return this.bytesPerElementShift;
    }

    public final int getFactoryIndex() {
        return this.ordinal();
    }

    public final TruffleString getName() {
        return this.name;
    }

    abstract TypedArray instantiateArrayType(byte var1, boolean var2, boolean var3);

    @Override
    public final JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayBufferViewPrototype(this);
    }

    public final boolean isBigInt() {
        return this == BigInt64Array || this == BigUint64Array;
    }

    public final boolean isFloat() {
        return this == Float64Array || this == Float32Array || this == Float16Array;
    }

    private static /* synthetic */ TypedArrayFactory[] $values() {
        return new TypedArrayFactory[]{Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array, Float64Array, BigInt64Array, BigUint64Array, Float16Array};
    }

    static {
        $VALUES = TypedArrayFactory.$values();
        FACTORIES_ALL = TypedArrayFactory.values();
        FACTORIES_DEFAULT = Arrays.copyOf(FACTORIES_ALL, Float16Array.ordinal());
        FACTORIES_NO_BIGINT = Arrays.copyOf(FACTORIES_ALL, BigInt64Array.ordinal());
    }
}

