/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.DynamicArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.ArrayAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

public abstract class JSArrayBase
extends JSNonProxyObject {
    int length;
    int usedLength;
    int indexOffset;
    int arrayOffset;
    int holeCount;
    Object arrayStorage;
    ScriptArray arrayStrategy;
    ArrayAllocationSite allocationSite;

    protected JSArrayBase(Shape shape, JSDynamicObject proto, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        super(shape, proto);
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        this.length = (int)length;
        this.usedLength = usedLength;
        this.indexOffset = indexOffset;
        this.arrayOffset = arrayOffset;
        this.holeCount = holeCount;
        this.arrayStorage = Objects.requireNonNull(array);
        this.arrayStrategy = arrayType;
        this.allocationSite = site;
    }

    public final ArrayAccess arrayAccess() {
        return ArrayAccess.SINGLETON;
    }

    public final ScriptArray getArrayType() {
        return this.arrayStrategy;
    }

    public final void setArrayType(ScriptArray arrayType) {
        this.arrayStrategy = arrayType;
    }

    public final Object getArray() {
        return this.arrayStorage;
    }

    public final void setArray(Object array) {
        this.arrayStorage = Objects.requireNonNull(array);
    }

    @Override
    public final boolean testIntegrityLevel(boolean frozen) {
        DynamicArray array = (DynamicArray)this.getArrayType();
        boolean arrayIs = frozen ? array.isFrozen() : array.isSealed();
        return arrayIs && JSNonProxy.testIntegrityLevelFast(this, frozen);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean preventExtensions(boolean doThrow) {
        boolean result = super.preventExtensions(doThrow);
        DynamicArray arr = (DynamicArray)this.getArrayType();
        this.setArrayType(arr.preventExtensions());
        assert (!this.isExtensible());
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean setIntegrityLevel(boolean freeze, boolean doThrow) {
        if (this.testIntegrityLevel(freeze)) {
            return true;
        }
        DynamicArray arr = (DynamicArray)this.getArrayType();
        this.setArrayType(freeze ? arr.freeze() : arr.seal());
        return JSNonProxy.setIntegrityLevelFast(this, freeze);
    }
}

