/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSBooleanObject
extends JSNonProxyObject {
    private final boolean value;

    protected JSBooleanObject(Shape shape, JSDynamicObject proto, boolean value) {
        super(shape, proto);
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public TruffleString getClassName() {
        return this.getBuiltinToStringTag();
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSBoolean.CLASS_NAME;
    }

    public static JSBooleanObject create(Shape shape, JSDynamicObject proto, boolean value) {
        return new JSBooleanObject(shape, proto, value);
    }

    @ExportMessage
    public boolean isBoolean() {
        return true;
    }

    @ExportMessage
    public boolean asBoolean() {
        return JSBoolean.valueOf(this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.concatAll(Strings.BRACKET_BOOLEAN_SPC, Strings.fromBoolean(JSBoolean.valueOf(this)), Strings.BRACKET_CLOSE);
        }
        boolean primitiveValue = JSBoolean.valueOf(this);
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, this.getBuiltinToStringTag(), new TruffleString[]{Strings.PRIMITIVE_VALUE}, new Object[]{primitiveValue});
    }
}

