/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.util.Arrays;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicSet;

public final class JSForInIteratorObject
extends JSNonProxyObject {
    public JSDynamicObject object;
    public Shape objectShape;
    public boolean objectWasVisited;
    public EconomicSet<Object> visitedKeys;
    public List<?> remainingKeys;
    public int remainingKeysSize;
    public int remainingKeysIndex;
    public Shape[] visitedShapes;
    public int visitedShapesSize;
    public boolean fastOwnKeys;
    public int protoDepth;
    public final boolean iterateValues;

    protected JSForInIteratorObject(Shape shape, JSDynamicObject proto, JSDynamicObject obj, boolean iterateValues) {
        super(shape, proto);
        this.object = obj;
        this.iterateValues = iterateValues;
        this.visitedShapes = new Shape[4];
    }

    public void addVisitedShape(Shape shape, Node node, InlinedBranchProfile growBranch) {
        if (this.visitedShapesSize >= this.visitedShapes.length) {
            growBranch.enter(node);
            this.visitedShapes = Arrays.copyOf(this.visitedShapes, this.visitedShapes.length * 2);
        }
        this.visitedShapes[this.visitedShapesSize++] = shape;
    }

    public boolean addVisitedKey(Object key) {
        if (this.visitedKeys == null) {
            this.visitedKeys = Boundaries.economicSetCreate();
        }
        return Boundaries.economicSetAdd(this.visitedKeys, key);
    }

    public boolean isVisitedKey(Object key) {
        return this.visitedShapesSize > 0 && JSForInIteratorObject.visitedShapeSetContainsKey(this.visitedShapes, this.visitedShapesSize, key) || this.visitedKeys != null && Boundaries.economicSetContains(this.visitedKeys, key);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean visitedShapeSetContainsKey(Shape[] visitedShapes, int size, Object key) {
        for (int i2 = 0; i2 < size; ++i2) {
            Shape visitedShape = visitedShapes[i2];
            if (!visitedShape.hasProperty(key)) continue;
            return true;
        }
        return false;
    }
}

