/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.lang.ref.WeakReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.WeakRefPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSWeakRefObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWeakRef
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWeakRef INSTANCE = new JSWeakRef();
    public static final TruffleString CLASS_NAME = Strings.constant("WeakRef");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("WeakRef.prototype");

    private JSWeakRef() {
    }

    public static JSWeakRefObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object referent) {
        TruffleWeakReference<Object> weakReference = new TruffleWeakReference<Object>(referent);
        JSObjectFactory factory = context.getWeakRefFactory();
        Shape shape = factory.getShape(realm, proto);
        JSWeakRefObject weakRefObj = factory.initProto(new JSWeakRefObject(shape, proto, weakReference), realm, proto);
        factory.trackAllocation(weakRefObj);
        context.addWeakRefTargetToSet(referent);
        return factory.trackAllocation(weakRefObj);
    }

    public static TruffleWeakReference<?> getInternalWeakRef(JSDynamicObject obj) {
        assert (JSWeakRef.isJSWeakRef(obj));
        return ((JSWeakRefObject)obj).getWeakReference();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WeakRefPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSWeakRef(Object obj) {
        return obj instanceof JSWeakRefObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWeakRefPrototype();
    }

    public static final class TruffleWeakReference<T>
    extends WeakReference<T> {
        public TruffleWeakReference(T t2) {
            super(t2);
        }
    }
}

