/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.Locale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.CollatorFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.CollatorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.Collator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.RuleBasedCollator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSCollator
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Collator");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Collator.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.Collator");
    public static final JSCollator INSTANCE = new JSCollator();

    private JSCollator() {
    }

    public static boolean isJSCollator(Object obj) {
        return obj instanceof JSCollatorObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject collatorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(collatorPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, collatorPrototype, CollatorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, collatorPrototype, CollatorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(collatorPrototype, TO_STRING_TAG);
        return collatorPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initializeCollator(JSContext ctx, InternalState state, String[] locales, String usage, String localeMatcher, String optco, Boolean optkn, String optkf, String sensitivity, boolean ignorePunctuation) {
        boolean searchUsage;
        String[] validCollations;
        String collation;
        String kfType;
        String kf;
        state.initializedCollator = true;
        state.usage = usage;
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        Locale.Builder builder = new Locale.Builder().setLocale(strippedLocale);
        Boolean kn = optkn;
        if (kn == null) {
            String knType = selectedLocale.getUnicodeLocaleType("kn");
            if ("".equals(knType) || "true".equals(knType)) {
                kn = true;
            } else if ("false".equals(knType)) {
                kn = false;
            }
            if (kn != null) {
                String value = kn != false ? "" : "false";
                builder.setUnicodeLocaleKeyword("kn", value);
            }
        }
        if (kn != null) {
            state.numeric = kn;
        }
        if ((kf = optkf) == null && ("upper".equals(kfType = selectedLocale.getUnicodeLocaleType("kf")) || "lower".equals(kfType) || "false".equals(kfType))) {
            kf = kfType;
            builder.setUnicodeLocaleKeyword("kf", kfType);
        }
        if (kf != null) {
            state.caseFirst = kf;
        }
        String string = collation = optco == null ? selectedLocale.getUnicodeLocaleType("co") : optco;
        if (collation != null && !Arrays.asList(validCollations = IntlUtil.availableCollations(ULocale.forLocale(strippedLocale), false)).contains(collation)) {
            collation = null;
        }
        if (!(searchUsage = "search".equals(usage)) && collation != null) {
            state.collation = collation;
            builder.setUnicodeLocaleKeyword("co", collation);
        }
        if (sensitivity != null) {
            state.sensitivity = sensitivity;
        }
        state.ignorePunctuation = ignorePunctuation;
        Locale collatorLocale = builder.build();
        state.locale = collatorLocale.toLanguageTag();
        if (searchUsage) {
            collatorLocale = builder.setUnicodeLocaleKeyword("co", "search").build();
        }
        state.collator = Collator.getInstance(collatorLocale);
        state.collator.setDecomposition(17);
        switch (state.sensitivity) {
            case "base": {
                state.collator.setStrength(0);
                break;
            }
            case "accent": {
                state.collator.setStrength(1);
                break;
            }
            case "case": {
                state.collator.setStrength(0);
                if (!(state.collator instanceof RuleBasedCollator)) break;
                ((RuleBasedCollator)state.collator).setCaseLevel(true);
                break;
            }
            case "variant": {
                state.collator.setStrength(2);
            }
        }
        if (state.collator instanceof RuleBasedCollator) {
            ((RuleBasedCollator)state.collator).setAlternateHandlingShifted(state.ignorePunctuation);
        }
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, CollatorFunctionBuiltins.BUILTINS);
    }

    public static JSCollatorObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getCollatorFactory();
        return JSCollator.create(factory, realm, factory.getPrototype(realm));
    }

    public static JSCollatorObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        JSObjectFactory factory = context.getCollatorFactory();
        return JSCollator.create(factory, realm, proto);
    }

    private static JSCollatorObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        Shape shape = factory.getShape(realm, proto);
        JSCollatorObject newObj = factory.initProto(new JSCollatorObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static Collator getCollatorProperty(JSDynamicObject obj) {
        return JSCollator.getInternalState((JSDynamicObject)obj).collator;
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(JSDynamicObject collatorObj, String one, String two) {
        Collator collator = JSCollator.getCollatorProperty(collatorObj);
        return collator.compare(JSCollator.normalize(one), JSCollator.normalize(two));
    }

    private static String normalize(String s2) {
        return Normalizer.normalize(s2, Normalizer.Form.NFD);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject resolvedOptions(JSContext context, JSRealm realm, JSDynamicObject collatorObj) {
        InternalState state = JSCollator.getInternalState(collatorObj);
        return state.toResolvedOptionsObject(context, realm);
    }

    public static InternalState getInternalState(JSDynamicObject collatorObj) {
        assert (JSCollator.isJSCollator(collatorObj));
        return ((JSCollatorObject)collatorObj).getInternalState();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getCollatorPrototype();
    }

    public static class InternalState {
        private boolean initializedCollator = false;
        private Collator collator;
        private JSDynamicObject boundCompareFunction = null;
        private String locale;
        private String usage = "sort";
        private String sensitivity = "variant";
        private String collation = "default";
        private boolean ignorePunctuation = false;
        private boolean numeric = false;
        private String caseFirst = "false";

        JSObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            JSObject result = JSOrdinary.create(context, realm);
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.locale), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_USAGE, Strings.fromJavaString(this.usage), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_SENSITIVITY, Strings.fromJavaString(this.sensitivity), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_IGNORE_PUNCTUATION, this.ignorePunctuation, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_COLLATION, Strings.fromJavaString(this.collation), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_NUMERIC, this.numeric, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result, IntlUtil.KEY_CASE_FIRST, Strings.fromJavaString(this.caseFirst), JSAttributes.getDefault());
            return result;
        }

        public boolean isInitializedCollator() {
            return this.initializedCollator;
        }

        public JSDynamicObject getBoundCompareFunction() {
            return this.boundCompareFunction;
        }

        public void setBoundCompareFunction(JSDynamicObject boundCompareFunction) {
            this.boundCompareFunction = boundCompareFunction;
        }
    }
}

