/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl;

import java.util.Locale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.InitializeLocaleNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IntlUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSLocale
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Locale");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Locale.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.Locale");
    public static final JSLocale INSTANCE = new JSLocale();

    private JSLocale() {
    }

    public static boolean isJSLocale(Object obj) {
        return obj instanceof JSLocaleObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject localePrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(localePrototype, ctor);
        JSObjectUtil.putToStringTag(localePrototype, TO_STRING_TAG);
        JSObjectUtil.putFunctionsFromContainer(realm, localePrototype, LocalePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, localePrototype, LocalePrototypeBuiltins.BUILTINS);
        return localePrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static JSLocaleObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getLocaleFactory();
        Shape shape = factory.getShape(realm, proto);
        JSLocaleObject newObj = factory.initProto(new JSLocaleObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(InternalState state, Locale locale) {
        state.locale = locale;
        state.calendar = locale.getUnicodeLocaleType("ca");
        state.caseFirst = locale.getUnicodeLocaleType("kf");
        state.collation = locale.getUnicodeLocaleType("co");
        state.firstDayOfWeek = InitializeLocaleNode.weekDayToNumber(locale.getUnicodeLocaleType("fw"));
        state.hourCycle = locale.getUnicodeLocaleType("hc");
        String kn = locale.getUnicodeLocaleType("kn");
        state.numeric = "true".equals(kn) || "".equals(kn);
        state.numberingSystem = locale.getUnicodeLocaleType("nu");
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getLocalePrototype();
    }

    public static class InternalState {
        private Locale locale;
        String calendar;
        String caseFirst;
        String collation;
        int firstDayOfWeek;
        String hourCycle;
        boolean numeric;
        String numberingSystem;

        @CompilerDirectives.TruffleBoundary
        public ULocale getULocale() {
            return ULocale.forLocale(this.locale);
        }

        @CompilerDirectives.TruffleBoundary
        public String getLocale() {
            return IntlUtil.maybeAppendMissingLanguageSubTag(this.locale.toLanguageTag());
        }

        @CompilerDirectives.TruffleBoundary
        public String getBaseName() {
            return this.locale.stripExtensions().toLanguageTag();
        }

        public String getCalendar() {
            return this.calendar;
        }

        public String getCaseFirst() {
            return this.caseFirst;
        }

        public String getCollation() {
            return this.collation;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public String getHourCycle() {
            return this.hourCycle;
        }

        public boolean getNumeric() {
            return this.numeric;
        }

        public String getNumberingSystem() {
            return this.numberingSystem;
        }

        @CompilerDirectives.TruffleBoundary
        public String getLanguage() {
            return this.locale.getLanguage();
        }

        @CompilerDirectives.TruffleBoundary
        public String getScript() {
            return this.locale.getScript();
        }

        @CompilerDirectives.TruffleBoundary
        public String getRegion() {
            return this.locale.getCountry();
        }

        @CompilerDirectives.TruffleBoundary
        public String maximize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(max.getLanguage());
            builder.setScript(max.getScript());
            builder.setRegion(max.getCountry());
            return builder.build().toLanguageTag();
        }

        @CompilerDirectives.TruffleBoundary
        public String minimize() {
            ULocale max = ULocale.addLikelySubtags(ULocale.forLocale(this.locale));
            ULocale min = ULocale.minimizeSubtags(max);
            Locale.Builder builder = new Locale.Builder().setLocale(this.locale);
            builder.setLanguage(min.getLanguage());
            builder.setScript(min.getScript());
            builder.setRegion(min.getCountry());
            return builder.build().toLanguageTag();
        }
    }
}

