/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainTimeFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalPlainTimePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public final class JSTemporalPlainTime
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalPlainTime INSTANCE = new JSTemporalPlainTime();
    public static final TruffleString CLASS_NAME = Strings.constant("PlainTime");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PlainTime.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.PlainTime");

    private JSTemporalPlainTime() {
    }

    public static JSTemporalPlainTimeObject create(JSContext context, JSRealm realm, int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, Node node, InlinedBranchProfile errorBranch) {
        return JSTemporalPlainTime.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), hours, minutes, seconds, milliseconds, microseconds, nanoseconds, node, errorBranch);
    }

    @HostCompilerDirectives.InliningCutoff
    public static JSTemporalPlainTimeObject create(JSContext context, JSRealm realm, JSDynamicObject proto, int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, Node node, InlinedBranchProfile errorBranch) {
        if (!TemporalUtil.isValidTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorTimeOutsideRange();
        }
        JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(context, realm);
        JSObjectFactory factory = context.getTemporalPlainTimeFactory();
        Shape shape = factory.getShape(realm, proto);
        JSTemporalPlainTimeObject newObj = factory.initProto(new JSTemporalPlainTimeObject(shape, proto, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, calendar), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalPlainTimePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalPlainTimePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalPlainTimePrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalPlainTimeFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalPlainTime(Object obj) {
        return obj instanceof JSTemporalPlainTimeObject;
    }

    public static JSDynamicObject toPartialTime(Object temporalTimeLike, JSToIntegerThrowOnInfinityNode toInt, JSContext ctx) {
        JSRealm realm = JSRealm.get(null);
        JSObject result = JSOrdinary.create(ctx, realm);
        boolean any = false;
        for (TruffleString property : TemporalUtil.TIME_LIKE_PROPERTIES) {
            Object value = JSRuntime.get(temporalTimeLike, property);
            if (value == Undefined.instance) continue;
            any = true;
            value = toInt.executeDouble(value);
            JSObjectUtil.putDataProperty(result, property, value);
        }
        if (!any) {
            throw TemporalErrors.createTypeErrorTemporalTimePropertyExpected();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalTimeToString(long hour, long minute, long second, long millisecond, long microsecond, long nanosecond, Object precision) {
        TruffleString hourString = TemporalUtil.toZeroPaddedDecimalString(hour, 2);
        TruffleString minuteString = TemporalUtil.toZeroPaddedDecimalString(minute, 2);
        TruffleString secondString = TemporalUtil.formatSecondsStringPart(second, millisecond, microsecond, nanosecond, precision);
        return Strings.format("%s:%s%s", hourString, minuteString, secondString);
    }
}

