/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal;

import java.time.ZoneId;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZone;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalTimeZoneObject
extends JSNonProxyObject {
    private final BigInt offsetNanoseconds;
    private final TruffleString identifier;

    protected JSTemporalTimeZoneObject(Shape shape, JSDynamicObject proto, BigInt offsetNanoseconds, TruffleString identifier) {
        super(shape, proto);
        assert (TemporalUtil.isValidEpochNanoseconds(offsetNanoseconds));
        this.offsetNanoseconds = offsetNanoseconds;
        this.identifier = identifier;
    }

    public BigInt getNanoseconds() {
        return this.offsetNanoseconds;
    }

    public TruffleString getIdentifier() {
        return this.identifier;
    }

    @ExportMessage
    boolean isTimeZone() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() {
        return ZoneId.of(this.identifier.toJavaStringUncached());
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalTimeZone.TO_STRING_TAG;
    }
}

