/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import java.nio.ByteBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

public final class JSWebAssemblyMemoryObject
extends JSNonProxyObject {
    private final Object wasmMemory;
    private JSArrayBufferObject bufferObject;
    private boolean shared;

    protected JSWebAssemblyMemoryObject(Shape shape, JSDynamicObject proto, Object wasmMemory, boolean shared) {
        super(shape, proto);
        this.wasmMemory = wasmMemory;
        this.shared = shared;
    }

    public Object getWASMMemory() {
        return this.wasmMemory;
    }

    public JSArrayBufferObject getBufferObject(JSContext context, JSRealm realm) {
        if (this.bufferObject == null) {
            if (!this.shared) {
                this.bufferObject = JSArrayBuffer.createInteropArrayBuffer(context, realm, this.wasmMemory);
            } else {
                InteropLibrary lib = InteropLibrary.getUncached();
                ByteBuffer buffer = JSInteropUtil.foreignInteropBufferAsByteBuffer(this.wasmMemory, lib, realm);
                this.bufferObject = JSSharedArrayBuffer.createSharedArrayBuffer(context, realm, buffer);
                boolean status = this.bufferObject.setIntegrityLevel(true, false);
                if (!status) {
                    throw Errors.createTypeError("Failed to set integrity level of buffer object");
                }
            }
        }
        return this.bufferObject;
    }

    public void resetBufferObject() {
        if (this.bufferObject != null && !this.shared) {
            JSArrayBuffer.detachArrayBuffer(this.bufferObject);
        }
        this.bufferObject = null;
    }

    @Override
    public TruffleString getClassName() {
        return JSWebAssemblyMemory.WEB_ASSEMBLY_MEMORY;
    }
}

