/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IterableToListNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.InteropArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

@ExportLibrary(value=InteropLibrary.class)
public class WebAssemblyHostFunction
implements TruffleObject {
    private final Object fn;
    private final TruffleString[] resultTypes;
    private final boolean anyReturnTypeIsI64;
    private final boolean anyArgTypeIsI64;
    private final boolean anyReturnTypeIsV128;
    private final boolean anyArgTypeIsV128;

    public WebAssemblyHostFunction(JSContext context, Object fn, TruffleString typeInfo) {
        assert (JSRuntime.isCallable(fn));
        this.fn = fn;
        int idxOpen = Strings.indexOf(typeInfo, '(');
        int idxClose = Strings.indexOf(typeInfo, ')');
        TruffleString returnTypes = Strings.lazySubstring(typeInfo, idxClose + 1);
        this.resultTypes = !Strings.isEmpty(returnTypes) ? Strings.split(context, returnTypes, Strings.SPACE) : new TruffleString[]{};
        this.anyReturnTypeIsI64 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.I64, idxClose + 1) >= 0;
        this.anyArgTypeIsI64 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.I64, idxOpen + 1, idxClose) >= 0;
        this.anyReturnTypeIsV128 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.V128, idxClose + 1) >= 0;
        this.anyArgTypeIsV128 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.V128, idxOpen + 1, idxClose) >= 0;
    }

    @ExportMessage
    public static final boolean isExecutable(WebAssemblyHostFunction receiver) {
        return true;
    }

    @ExportMessage
    public final Object execute(Object[] args, @Bind(value="$node") Node node, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @Cached ToJSValueNode toJSValueNode, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached InlinedBranchProfile errorBranch, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IterableToListNode iterableToListNode, @CachedLibrary(value="this") InteropLibrary self) {
        JSContext context = JavaScriptLanguage.get(self).getJSContext();
        if (!context.getLanguageOptions().wasmBigInt() && (this.anyReturnTypeIsI64 || this.anyArgTypeIsI64) || this.anyReturnTypeIsV128 || this.anyArgTypeIsV128) {
            errorBranch.enter(node);
            throw Errors.createTypeError("wasm function signature contains illegal type");
        }
        Object[] jsArgs = new Object[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            jsArgs[i2] = toJSValueNode.execute(args[i2]);
        }
        Object result = callNode.executeCall(JSArguments.create(Undefined.instance, this.fn, jsArgs));
        if (this.resultTypes.length == 0) {
            return Undefined.instance;
        }
        if (this.resultTypes.length == 1) {
            return toWebAssemblyValueNode.execute(result, this.resultTypes[0]);
        }
        IteratorRecord iterator = getIteratorNode.execute(node, result);
        SimpleArrayList<Object> values = iterableToListNode.execute(iterator);
        if (this.resultTypes.length != values.size()) {
            errorBranch.enter(node);
            throw Errors.createTypeError("invalid result array arity");
        }
        Object[] wasmValues = new Object[values.size()];
        for (int i3 = 0; i3 < values.size(); ++i3) {
            wasmValues[i3] = toWebAssemblyValueNode.execute(values.get(i3), this.resultTypes[i3]);
        }
        return InteropArray.create(wasmValues);
    }
}

