/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;

public final class AsyncContext {
    private static final AsyncContext EMPTY = new AsyncContext();
    private final Object[] mapping;

    private AsyncContext() {
        this(ScriptArray.EMPTY_OBJECT_ARRAY);
    }

    private AsyncContext(Object[] mapping) {
        this.mapping = mapping;
    }

    public static AsyncContext empty() {
        return EMPTY;
    }

    public AsyncContext withMapping(Symbol key, Object value) {
        int len = this.mapping.length;
        for (int i2 = 0; i2 < len; i2 += 2) {
            Object k2 = this.mapping[i2];
            Object v2 = this.mapping[i2 + 1];
            if (k2 != key) continue;
            if (v2 == value) {
                return this;
            }
            Object[] newMapping = Arrays.copyOf(this.mapping, len);
            assert (newMapping[i2] == key);
            newMapping[i2 + 1] = value;
            return new AsyncContext(newMapping);
        }
        Object[] newMapping = Arrays.copyOf(this.mapping, len + 2);
        newMapping[len] = key;
        newMapping[len + 1] = value;
        return new AsyncContext(newMapping);
    }

    public Object getOrDefault(Symbol asyncContextKey, Object defaultValue) {
        for (int i2 = 0; i2 < this.mapping.length; i2 += 2) {
            Object k2 = this.mapping[i2];
            if (k2 != asyncContextKey) continue;
            return this.mapping[i2 + 1];
        }
        return defaultValue;
    }

    public String toString() {
        return "AsyncContext" + Arrays.toString(this.mapping);
    }
}

