/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ExactMath;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.DateDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZone;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.IteratorUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;

public final class TemporalUtil {
    private static final Function<Object, Object> toIntegerThrowOnInfinity = TemporalUtil::toIntegerThrowOnInfinity;
    private static final Function<Object, Object> toPositiveInteger = TemporalUtil::toPositiveInteger;
    private static final Function<Object, Object> toString = JSRuntime::toString;
    public static final Map<TruffleString, TruffleString> singularToPlural = Map.ofEntries(Map.entry(TemporalConstants.YEAR, TemporalConstants.YEARS), Map.entry(TemporalConstants.MONTH, TemporalConstants.MONTHS), Map.entry(TemporalConstants.WEEK, TemporalConstants.WEEKS), Map.entry(TemporalConstants.DAY, TemporalConstants.DAYS), Map.entry(TemporalConstants.HOUR, TemporalConstants.HOURS), Map.entry(TemporalConstants.MINUTE, TemporalConstants.MINUTES), Map.entry(TemporalConstants.SECOND, TemporalConstants.SECONDS), Map.entry(TemporalConstants.MILLISECOND, TemporalConstants.MILLISECONDS), Map.entry(TemporalConstants.MICROSECOND, TemporalConstants.MICROSECONDS), Map.entry(TemporalConstants.NANOSECOND, TemporalConstants.NANOSECONDS));
    private static final Map<TruffleString, Function<Object, Object>> temporalFieldConversion = Map.ofEntries(Map.entry(TemporalConstants.YEAR, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MONTH, toPositiveInteger), Map.entry(TemporalConstants.MONTH_CODE, toString), Map.entry(TemporalConstants.DAY, toPositiveInteger), Map.entry(TemporalConstants.HOUR, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MINUTE, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.SECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MILLISECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.MICROSECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.NANOSECOND, toIntegerThrowOnInfinity), Map.entry(TemporalConstants.OFFSET, toString), Map.entry(TemporalConstants.ERA, toString), Map.entry(TemporalConstants.ERA_YEAR, toIntegerThrowOnInfinity));
    public static final Map<TruffleString, Object> temporalFieldDefaults = Map.ofEntries(Map.entry(TemporalConstants.YEAR, Undefined.instance), Map.entry(TemporalConstants.MONTH, Undefined.instance), Map.entry(TemporalConstants.MONTH_CODE, Undefined.instance), Map.entry(TemporalConstants.DAY, Undefined.instance), Map.entry(TemporalConstants.HOUR, 0), Map.entry(TemporalConstants.MINUTE, 0), Map.entry(TemporalConstants.SECOND, 0), Map.entry(TemporalConstants.MILLISECOND, 0), Map.entry(TemporalConstants.MICROSECOND, 0), Map.entry(TemporalConstants.NANOSECOND, 0), Map.entry(TemporalConstants.YEARS, 0), Map.entry(TemporalConstants.MONTHS, 0), Map.entry(TemporalConstants.WEEKS, 0), Map.entry(TemporalConstants.DAYS, 0), Map.entry(TemporalConstants.HOURS, 0), Map.entry(TemporalConstants.MINUTES, 0), Map.entry(TemporalConstants.SECONDS, 0), Map.entry(TemporalConstants.MILLISECONDS, 0), Map.entry(TemporalConstants.MICROSECONDS, 0), Map.entry(TemporalConstants.NANOSECONDS, 0), Map.entry(TemporalConstants.OFFSET, Undefined.instance), Map.entry(TemporalConstants.ERA, Undefined.instance), Map.entry(TemporalConstants.ERA_YEAR, Undefined.instance));
    public static final List<TruffleString> listEmpty = List.of();
    public static final List<TruffleString> listDMMCY = List.of(TemporalConstants.DAY, TemporalConstants.MONTH, TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listMMCY = List.of(TemporalConstants.MONTH, TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listMCY = List.of(TemporalConstants.MONTH_CODE, TemporalConstants.YEAR);
    public static final List<TruffleString> listDMC = List.of(TemporalConstants.DAY, TemporalConstants.MONTH_CODE);
    public static final List<TruffleString> listYD = List.of(TemporalConstants.YEAR, TemporalConstants.DAY);
    public static final List<TruffleString> listY = List.of(TemporalConstants.YEAR);
    public static final List<TruffleString> listD = List.of(TemporalConstants.DAY);
    private static final List<TruffleString> singularDateUnits = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH, TemporalConstants.WEEK, TemporalConstants.DAY);
    private static final List<TruffleString> singularTimeUnits = List.of(TemporalConstants.HOUR, TemporalConstants.MINUTE, TemporalConstants.SECOND, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECOND);
    private static final List<TruffleString> singularDateTimeUnits = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH, TemporalConstants.WEEK, TemporalConstants.DAY, TemporalConstants.HOUR, TemporalConstants.MINUTE, TemporalConstants.SECOND, TemporalConstants.MILLISECOND, TemporalConstants.MICROSECOND, TemporalConstants.NANOSECOND);
    private static final List<TruffleString> singularYearMonthUnits = List.of(TemporalConstants.YEAR, TemporalConstants.MONTH);
    public static final Map<TruffleString, Unit> unitMappingDate = TemporalUtil.createUnitMapping(singularDateUnits, new TruffleString[0]);
    public static final Map<TruffleString, Unit> unitMappingDateOrAuto = TemporalUtil.createUnitMapping(singularDateUnits, TemporalConstants.AUTO);
    public static final Map<TruffleString, Unit> unitMappingTime = TemporalUtil.createUnitMapping(singularTimeUnits, new TruffleString[0]);
    public static final Map<TruffleString, Unit> unitMappingTimeOrDay = TemporalUtil.createUnitMapping(singularTimeUnits, TemporalConstants.DAY);
    public static final Map<TruffleString, Unit> unitMappingTimeOrAuto = TemporalUtil.createUnitMapping(singularTimeUnits, TemporalConstants.AUTO);
    public static final Map<TruffleString, Unit> unitMappingDateTime = TemporalUtil.createUnitMapping(singularDateTimeUnits, new TruffleString[0]);
    public static final Map<TruffleString, Unit> unitMappingDateTimeOrAuto = TemporalUtil.createUnitMapping(singularDateTimeUnits, TemporalConstants.AUTO);
    public static final Map<TruffleString, Unit> unitMappingYearMonth = TemporalUtil.createUnitMapping(singularYearMonthUnits, new TruffleString[0]);
    public static final Map<TruffleString, Unit> unitMappingYearMonthOrAuto = TemporalUtil.createUnitMapping(singularYearMonthUnits, TemporalConstants.AUTO);
    public static final List<TruffleString> listAuto = List.of(TemporalConstants.AUTO);
    public static final List<TruffleString> listAutoNever = List.of(TemporalConstants.AUTO, TemporalConstants.NEVER);
    public static final List<TruffleString> listAutoNeverCritical = List.of(TemporalConstants.AUTO, TemporalConstants.NEVER, TemporalConstants.CRITICAL);
    public static final List<TruffleString> listAutoAlwaysNeverCritical = List.of(TemporalConstants.AUTO, TemporalConstants.ALWAYS, TemporalConstants.NEVER, TemporalConstants.CRITICAL);
    public static final List<TruffleString> listConstrainReject = List.of(TemporalConstants.CONSTRAIN, TemporalConstants.REJECT);
    public static final List<TruffleString> listTimeZone = List.of(TemporalConstants.TIME_ZONE);
    public static final List<TruffleString> listTimeZoneOffset = List.of(TemporalConstants.TIME_ZONE, TemporalConstants.OFFSET);
    public static final List<TruffleString> listRoundingMode = List.of(TemporalConstants.CEIL, TemporalConstants.FLOOR, TemporalConstants.EXPAND, TemporalConstants.TRUNC, TemporalConstants.HALF_FLOOR, TemporalConstants.HALF_CEIL, TemporalConstants.HALF_EXPAND, TemporalConstants.HALF_TRUNC, TemporalConstants.HALF_EVEN);
    public static final List<TruffleString> listOffset = List.of(TemporalConstants.OFFSET);
    public static final List<TruffleString> listOffsets = List.of(TemporalConstants.PREFER, TemporalConstants.USE, TemporalConstants.IGNORE, TemporalConstants.REJECT);
    public static final List<TruffleString> listDisambiguation = List.of(TemporalConstants.COMPATIBLE, TemporalConstants.EARLIER, TemporalConstants.LATER, TemporalConstants.REJECT);
    public static final TruffleString[] TIME_LIKE_PROPERTIES = new TruffleString[]{TemporalConstants.HOUR, TemporalConstants.MICROSECOND, TemporalConstants.MILLISECOND, TemporalConstants.MINUTE, TemporalConstants.NANOSECOND, TemporalConstants.SECOND};
    public static final int MS_PER_DAY = 86400000;
    public static final long NS_PER_DAY_LONG = 86400000000000L;
    public static final double NS_PER_DAY = 8.64E13;
    public static final BigInt BI_NS_PER_DAY = BigInt.valueOf(86400000000000L);
    private static final int INSTANT_MAX_OFFSET_EPOCH_DAYS = 100000000;
    private static final BigInt upperEpochNSLimit = BI_NS_PER_DAY.multiply(BigInt.valueOf(100000000L));
    private static final BigInt lowerEpochNSLimit = upperEpochNSLimit.negate();
    private static final BigInt isoTimeUpperBound = upperEpochNSLimit.add(BI_NS_PER_DAY);
    private static final BigInt isoTimeLowerBound = isoTimeUpperBound.negate();
    private static final int isoTimeBoundYears = 270000;
    private static final int ISO_DATE_MAX_UTC_OFFSET_DAYS = 100000001;
    private static final BigInt MAX_TIME_DURATION = BigInt.valueOf(0x20000000000000L).multiply(BigInt.valueOf(1000000000L)).subtract(BigInt.ONE);
    public static final BigInt BI_NS_PER_HOUR = BigInt.valueOf(3600000000000L);
    public static final BigInt BI_NS_PER_MINUTE = BigInt.valueOf(60000000000L);
    public static final BigInt BI_NS_PER_SECOND = BigInt.valueOf(1000000000L);
    public static final BigInt BI_NS_PER_MS = BigInt.valueOf(1000000L);
    public static final BigInt BI_1000 = BigInt.valueOf(1000L);
    public static final BigInt BI_24 = BigInt.valueOf(24L);
    public static final BigInt BI_60 = BigInt.valueOf(60L);
    public static final BigDecimal BD_10 = BigDecimal.valueOf(10L);
    public static final BigDecimal BD_60 = BigDecimal.valueOf(60L);
    public static final BigDecimal BD_1000 = BigDecimal.valueOf(1000L);
    public static final MathContext mc_20_floor = new MathContext(20, java.math.RoundingMode.FLOOR);
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SINCE = -1;
    public static final int UNTIL = 1;
    public static final int SUBTRACT = -1;
    public static final int ADD = 1;
    private static final Set<String> AVAILABLE_CALENDARS = Set.of("iso8601", "gregory", "japanese");

    private static Map<TruffleString, Unit> createUnitMapping(List<TruffleString> singularUnits, TruffleString ... extraValues) {
        HashMap<TruffleString, Unit> map = new HashMap<TruffleString, Unit>();
        for (TruffleString singular : IteratorUtil.concatLists(singularUnits, List.of(extraValues))) {
            Unit unit = Unit.valueOf(singular.toJavaStringUncached().toUpperCase(Locale.ROOT));
            map.put(singular, unit);
            TruffleString plural = singularToPlural.get(singular);
            if (plural == null) continue;
            map.put(plural, unit);
        }
        return Map.copyOf(map);
    }

    public static int validateTemporalRoundingIncrement(int increment, long dividend, boolean inclusive, Node node, InlinedBranchProfile errorBranch) {
        double maximum;
        if (inclusive) {
            maximum = dividend;
        } else {
            assert (dividend > 1L) : dividend;
            maximum = dividend - 1L;
        }
        if ((double)increment > maximum || dividend % (long)increment != 0L) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Increment out of range.");
        }
        return increment;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalPrecisionRecord toSecondsStringPrecisionRecord(Unit smallestUnit, int fractionalDigitCount) {
        return switch (smallestUnit.ordinal()) {
            case 7 -> JSTemporalPrecisionRecord.create(TemporalConstants.MINUTE, Unit.MINUTE, 1);
            case 8 -> JSTemporalPrecisionRecord.create(0, Unit.SECOND, 1);
            case 9 -> JSTemporalPrecisionRecord.create(3, Unit.MILLISECOND, 1);
            case 10 -> JSTemporalPrecisionRecord.create(6, Unit.MICROSECOND, 1);
            case 11 -> JSTemporalPrecisionRecord.create(9, Unit.NANOSECOND, 1);
            case 0 -> {
                switch (fractionalDigitCount) {
                    case -1: {
                        yield JSTemporalPrecisionRecord.create(TemporalConstants.AUTO, Unit.NANOSECOND, 1);
                    }
                    case 0: {
                        yield JSTemporalPrecisionRecord.create(0, Unit.SECOND, 1);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        yield JSTemporalPrecisionRecord.create(fractionalDigitCount, Unit.MILLISECOND, (int)Math.pow(10.0, 3 - fractionalDigitCount));
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        yield JSTemporalPrecisionRecord.create(fractionalDigitCount, Unit.MICROSECOND, (int)Math.pow(10.0, 6 - fractionalDigitCount));
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        yield JSTemporalPrecisionRecord.create(fractionalDigitCount, Unit.NANOSECOND, (int)Math.pow(10.0, 9 - fractionalDigitCount));
                    }
                }
                throw Errors.shouldNotReachHereUnexpectedValue(fractionalDigitCount);
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)smallestUnit);
        };
    }

    @CompilerDirectives.TruffleBoundary
    public static ParseISODateTimeResult parseTemporalRelativeToString(TruffleString isoString) {
        if (!new TemporalParser(isoString).isTemporalDateTimeString()) {
            throw TemporalErrors.createRangeErrorInvalidRelativeToString();
        }
        return TemporalUtil.parseISODateTime(isoString, false, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalMonthDayString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseMonthDay();
        if (rec != null) {
            int d2;
            if (rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
                throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
            }
            int y2 = rec.getYear() == Long.MIN_VALUE ? Integer.MIN_VALUE : TemporalUtil.ltoi(rec.getYear());
            int m2 = rec.getMonth() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getMonth());
            int n2 = d2 = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
            if (!TemporalUtil.isValidISODate(y2, m2, d2)) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
            return JSTemporalDateTimeRecord.createCalendar(y2, m2, d2, 0, 0, 0, 0, 0, 0, rec.getCalendar());
        }
        throw Errors.createRangeError("cannot parse MonthDay");
    }

    private static ParseISODateTimeResult parseISODateTime(TruffleString string) {
        return TemporalUtil.parseISODateTime(string, false, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static ParseISODateTimeResult parseISODateTime(TruffleString string, boolean failWithUTCDesignator, boolean timeExpected) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseISODateTime();
        if (rec != null) {
            if (failWithUTCDesignator && rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (timeExpected && rec.getHour() == Long.MIN_VALUE) {
                throw Errors.createRangeError("cannot parse the ISO date time string");
            }
            return TemporalUtil.parseISODateTimeIntl(string, rec);
        }
        throw Errors.createRangeError("cannot parse the ISO date time string");
    }

    private static ParseISODateTimeResult parseISODateTimeIntl(TruffleString string, JSTemporalParserRecord rec) {
        TruffleString fraction = rec.getFraction();
        fraction = fraction == null ? TemporalConstants.ZEROS : Strings.concat(fraction, TemporalConstants.ZEROS);
        if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
            throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
        }
        int y2 = rec.getYear() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getYear());
        int m2 = rec.getMonth() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getMonth());
        int d2 = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
        int h2 = rec.getHour() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getHour());
        int min = rec.getMinute() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getMinute());
        int s2 = rec.getSecond() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getSecond());
        int ms = 0;
        int mus = 0;
        int ns = 0;
        try {
            ms = (int)Strings.parseLong(Strings.lazySubstring(fraction, 0, 3));
            mus = (int)Strings.parseLong(Strings.lazySubstring(fraction, 3, 3));
            ns = (int)Strings.parseLong(Strings.lazySubstring(fraction, 6, 3));
        }
        catch (TruffleString.NumberFormatException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
        if (s2 == 60) {
            s2 = 59;
        }
        if (!TemporalUtil.isValidISODate(y2, m2, d2)) {
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        if (!TemporalUtil.isValidTime(h2, min, s2, ms, mus, ns)) {
            throw TemporalErrors.createRangeErrorTimeOutsideRange();
        }
        JSTemporalTimeZoneRecord timeZoneResult = JSTemporalTimeZoneRecord.create(rec.getZ(), rec.getTimeZoneUTCOffsetName(), rec.getTimeZoneIdentifier());
        return new ParseISODateTimeResult(y2, m2, d2, h2, min, s2, ms, mus, ns, rec.getCalendar(), timeZoneResult);
    }

    public static void validateTemporalUnitRange(Unit largestUnit, Unit smallestUnit) {
        if (TemporalUtil.largerOfTwoTemporalUnits(largestUnit, smallestUnit) != largestUnit) {
            throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
        }
    }

    public static Integer maximumTemporalDurationRoundingIncrement(Unit unit) {
        if (unit == Unit.YEAR || unit == Unit.MONTH || unit == Unit.WEEK || unit == Unit.DAY) {
            return null;
        }
        if (unit == Unit.HOUR) {
            return 24;
        }
        if (unit == Unit.MINUTE || unit == Unit.SECOND) {
            return 60;
        }
        assert (unit == Unit.MILLISECOND || unit == Unit.MICROSECOND || unit == Unit.NANOSECOND);
        return 1000;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatSecondsStringPart(long second, long millisecond, long microsecond, long nanosecond, Object precision) {
        assert (JSTemporalPrecisionRecord.isValidPrecision(precision)) : precision;
        if (precision.equals(TemporalConstants.MINUTE)) {
            return Strings.EMPTY_STRING;
        }
        TruffleString secondString = Strings.concat(Strings.COLON, TemporalUtil.toZeroPaddedDecimalString(second, 2));
        long fraction = millisecond * 1000000L + microsecond * 1000L + nanosecond;
        TruffleString fractionString = Strings.EMPTY_STRING;
        if (precision.equals(TemporalConstants.AUTO)) {
            if (fraction == 0L) {
                return secondString;
            }
            fractionString = Strings.concatAll(fractionString, TemporalUtil.toZeroPaddedDecimalString(millisecond, 3), TemporalUtil.toZeroPaddedDecimalString(microsecond, 3), TemporalUtil.toZeroPaddedDecimalString(nanosecond, 3));
            fractionString = TemporalUtil.longestSubstring(fractionString);
        } else {
            if (precision.equals(0)) {
                return secondString;
            }
            fractionString = Strings.concatAll(fractionString, TemporalUtil.toZeroPaddedDecimalString(millisecond, 3), TemporalUtil.toZeroPaddedDecimalString(microsecond, 3), TemporalUtil.toZeroPaddedDecimalString(nanosecond, 3));
            fractionString = Strings.lazySubstring(fractionString, 0, (Integer)precision);
        }
        return Strings.concatAll(secondString, Strings.DOT, fractionString);
    }

    private static TruffleString longestSubstring(TruffleString str) {
        int length;
        for (length = Strings.length(str); length > 0 && Strings.charAt(str, length - 1) == '0'; --length) {
        }
        if (length == 0) {
            return Strings.EMPTY_STRING;
        }
        if (length == Strings.length(str)) {
            return str;
        }
        assert (Strings.length(str) <= 9);
        return Strings.lazySubstring(str, 0, length);
    }

    public static int nonNegativeModulo(double x2, int y2) {
        assert (y2 > 0) : y2;
        int result = (int)(x2 % (double)y2);
        if (result < 0) {
            result += y2;
        }
        return result;
    }

    public static int nonNegativeModulo(long x2, int y2) {
        assert (y2 > 0) : y2;
        int result = (int)(x2 % (long)y2);
        if (result < 0) {
            result += y2;
        }
        return result;
    }

    public static int nonNegativeModulo(int x2, int y2) {
        assert (y2 > 0) : y2;
        int result = x2 % y2;
        if (result < 0) {
            result += y2;
        }
        return result;
    }

    public static int constrainToRange(int value, int minimum, int maximum) {
        return Math.min(Math.max(value, minimum), maximum);
    }

    public static UnsignedRoundingMode getUnsignedRoundingMode(RoundingMode roundingMode, boolean isNegative) {
        switch (roundingMode.ordinal()) {
            case 1: {
                return isNegative ? UnsignedRoundingMode.ZERO : UnsignedRoundingMode.INFINITY;
            }
            case 2: {
                return isNegative ? UnsignedRoundingMode.INFINITY : UnsignedRoundingMode.ZERO;
            }
            case 3: {
                return UnsignedRoundingMode.INFINITY;
            }
            case 4: {
                return UnsignedRoundingMode.ZERO;
            }
            case 9: {
                return isNegative ? UnsignedRoundingMode.HALF_ZERO : UnsignedRoundingMode.HALF_INFINITY;
            }
            case 8: {
                return isNegative ? UnsignedRoundingMode.HALF_INFINITY : UnsignedRoundingMode.HALF_ZERO;
            }
            case 5: {
                return UnsignedRoundingMode.HALF_INFINITY;
            }
            case 6: {
                return UnsignedRoundingMode.HALF_ZERO;
            }
            case 7: {
                return UnsignedRoundingMode.HALF_EVEN;
            }
        }
        return UnsignedRoundingMode.EMPTY;
    }

    public static double applyUnsignedRoundingMode(double x2, double r1, double r2, UnsignedRoundingMode urm) {
        assert (urm != UnsignedRoundingMode.EMPTY);
        if (x2 == r1) {
            return r1;
        }
        assert (r1 <= x2 && x2 <= r2);
        if (urm == UnsignedRoundingMode.ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.INFINITY) {
            return r2;
        }
        double d1 = x2 - r1;
        double d2 = r2 - x2;
        if (d1 < d2) {
            return r1;
        }
        if (d2 < d1) {
            return r2;
        }
        assert (d1 == d2);
        if (urm == UnsignedRoundingMode.HALF_ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.HALF_INFINITY) {
            return r2;
        }
        assert (urm == UnsignedRoundingMode.HALF_EVEN);
        double cardinality = r1 / (r2 - r1) % 2.0;
        if (cardinality == 0.0) {
            return r1;
        }
        return r2;
    }

    @CompilerDirectives.TruffleBoundary
    public static double applyUnsignedRoundingMode(BigInt numerator, BigInt denominator, double r1, double r2, UnsignedRoundingMode urm) {
        assert (urm != UnsignedRoundingMode.EMPTY);
        if (numerator.signum() == 0) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.INFINITY) {
            return r2;
        }
        int half = TemporalUtil.compareHalf(numerator, denominator);
        if (half < 0) {
            return r1;
        }
        if (half > 0) {
            return r2;
        }
        if (urm == UnsignedRoundingMode.HALF_ZERO) {
            return r1;
        }
        if (urm == UnsignedRoundingMode.HALF_INFINITY) {
            return r2;
        }
        assert (urm == UnsignedRoundingMode.HALF_EVEN);
        double cardinality = r1 / (r2 - r1) % 2.0;
        if (cardinality == 0.0) {
            return r1;
        }
        return r2;
    }

    @CompilerDirectives.TruffleBoundary
    public static double roundNumberToIncrement(double x2, double increment, RoundingMode roundingMode) {
        boolean isNegative;
        assert (JSRuntime.isIntegralNumber(increment)) : increment;
        double quotient = x2 / increment;
        if (quotient < 0.0) {
            isNegative = true;
            quotient = -quotient;
        } else {
            isNegative = false;
        }
        UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, isNegative);
        double r1 = Math.floor(quotient);
        double r2 = r1 + 1.0;
        double rounded = TemporalUtil.applyUnsignedRoundingMode(quotient, r1, r2, unsignedRoundingMode);
        if (isNegative) {
            rounded = -rounded;
        }
        return rounded * increment;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt roundNumberToIncrementAsIfPositive(BigInt x2, BigInt increment, RoundingMode roundingMode) {
        BigInt[] divRes = x2.divideAndRemainder(increment);
        BigInt quotient = divRes[0];
        BigInt remainder = divRes[1];
        int sign = remainder.signum();
        if (sign == 0) {
            return x2;
        }
        UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, false);
        BigInt r1 = sign < 0 ? quotient.subtract(BigInt.ONE) : quotient;
        BigInt r2 = sign >= 0 ? quotient.add(BigInt.ONE) : quotient;
        BigInt rounded = TemporalUtil.applyUnsignedRoundingMode(remainder, increment, r1, r2, unsignedRoundingMode);
        return rounded.multiply(increment);
    }

    private static BigInt applyUnsignedRoundingMode(BigInt remainder, BigInt increment, BigInt r1, BigInt r2, UnsignedRoundingMode unsignedRoundingMode) {
        int half = TemporalUtil.compareHalf(remainder, increment);
        return switch (unsignedRoundingMode.ordinal()) {
            case 1 -> r1;
            case 2 -> r2;
            case 4 -> {
                if (half <= 0) {
                    yield r1;
                }
                yield r2;
            }
            case 3 -> {
                if (half < 0) {
                    yield r1;
                }
                yield r2;
            }
            case 5 -> {
                if (half < 0) {
                    yield r1;
                }
                if (half > 0) {
                    yield r2;
                }
                if (TemporalUtil.isEven(r1)) {
                    yield r1;
                }
                yield r2;
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unsignedRoundingMode);
        };
    }

    private static int compareHalf(BigInt remainder, BigInt divisor) {
        return remainder.multiply(BigInt.valueOf(2L)).abs().compareTo(divisor.abs());
    }

    private static boolean isEven(BigInt value) {
        return !value.testBit(0);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt roundNormalizedTimeDurationToIncrement(BigInt normalizedTimeDuration, long unitLengthInNs, int increment, RoundingMode roundingMode) {
        BigInt normalizedIncrement = BigInt.valueOf(unitLengthInNs).multiply(BigInt.valueOf(increment));
        return TemporalUtil.roundNormalizedTimeDurationToIncrement(normalizedTimeDuration, normalizedIncrement, roundingMode);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt roundNormalizedTimeDurationToIncrement(BigInt normalizedTimeDuration, BigInt increment, RoundingMode roundingMode) {
        boolean isNegative;
        BigInt[] divRes = normalizedTimeDuration.divideAndRemainder(increment);
        BigInt quotient = divRes[0];
        BigInt remainder = divRes[1];
        int sign = remainder.signum();
        if (sign == 0) {
            return normalizedTimeDuration;
        }
        boolean bl = isNegative = sign < 0;
        if (isNegative) {
            quotient = quotient.negate();
        }
        UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, isNegative);
        BigInt r1 = quotient;
        BigInt r2 = quotient.add(BigInt.ONE);
        BigInt rounded = TemporalUtil.applyUnsignedRoundingMode(remainder, increment, r1, r2, unsignedRoundingMode);
        if (isNegative) {
            rounded = rounded.negate();
        }
        return rounded.multiply(increment);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString parseTemporalCalendarString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseCalendarString();
        if (rec == null) {
            throw Errors.createRangeError("cannot parse Calendar");
        }
        TruffleString id = rec.getCalendar();
        if (id == null) {
            return TemporalConstants.ISO8601;
        }
        return id;
    }

    public static double toPositiveInteger(Object value) {
        double result = JSRuntime.doubleValue(TemporalUtil.toIntegerThrowOnInfinity(value));
        if (result <= 0.0) {
            throw Errors.createRangeError("positive value expected");
        }
        return result;
    }

    public static int toPositiveIntegerConstrainInt(Object value, JSToIntegerThrowOnInfinityNode toIntegerThrowOnInfinityNode, Node node, InlinedBranchProfile errorBranch) {
        int integer = toIntegerThrowOnInfinityNode.executeIntOrThrow(value);
        if (integer <= 0) {
            errorBranch.enter(node);
            throw Errors.createRangeError("positive value expected");
        }
        return integer;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject prepareTemporalFields(JSContext ctx, Object fields, List<TruffleString> fieldNames, List<TruffleString> requiredFields) {
        boolean duplicateBehaviourThrow = true;
        JSObject result = JSOrdinary.createWithNullPrototype(ctx);
        boolean any = false;
        ArrayList<TruffleString> sortedFieldNames = new ArrayList<TruffleString>(fieldNames);
        sortedFieldNames.sort(Strings::compareTo);
        TruffleString previousProperty = null;
        for (TruffleString property : sortedFieldNames) {
            if (JSObject.CONSTRUCTOR.equals(property) || JSObject.PROTO.equals(property)) {
                throw Errors.createRangeErrorFormat("Invalid field: %s", null, property);
            }
            if (property.equals(previousProperty)) {
                if (!duplicateBehaviourThrow) continue;
                throw Errors.createRangeErrorFormat("Duplicate field: %s", null, property);
            }
            previousProperty = property;
            Object value = JSRuntime.get(fields, property);
            if (value == Undefined.instance) {
                if (requiredFields != null) {
                    if (requiredFields.contains(property)) {
                        throw TemporalErrors.createTypeErrorPropertyRequired(property);
                    }
                    if (temporalFieldDefaults.containsKey(property)) {
                        value = temporalFieldDefaults.get(property);
                    }
                }
            } else {
                any = true;
                if (temporalFieldConversion.containsKey(property)) {
                    Function<Object, Object> conversion = temporalFieldConversion.get(property);
                    value = conversion.apply(value);
                }
            }
            TemporalUtil.createDataPropertyOrThrow(ctx, result, property, value);
        }
        if (requiredFields == null && !any) {
            throw Errors.createTypeError("No relevant field provided");
        }
        return result;
    }

    public static ISOYearMonthRecord regulateISOYearMonth(int year, int month, Overflow overflow) {
        assert (Overflow.CONSTRAIN == overflow || Overflow.REJECT == overflow);
        if (Overflow.CONSTRAIN == overflow) {
            return TemporalUtil.constrainISOYearMonth(year, month);
        }
        assert (Overflow.REJECT == overflow);
        if (!TemporalUtil.isValidISOMonth(month)) {
            throw Errors.createRangeError("validation of year and month failed");
        }
        return new ISOYearMonthRecord(year, month);
    }

    private static boolean isValidISOMonth(int month) {
        return 1 <= month && month <= 12;
    }

    private static ISOYearMonthRecord constrainISOYearMonth(int year, int month) {
        int monthPrepared = TemporalUtil.constrainToRange(month, 1, 12);
        return new ISOYearMonthRecord(TemporalUtil.ltoi(year), monthPrepared);
    }

    public static long toISODayOfWeek(int year, int month, int day) {
        int weekDay;
        int m2 = month - 2;
        if (m2 == -1) {
            m2 = 11;
        } else if (m2 == 0) {
            m2 = 12;
        }
        int c2 = Math.floorDiv(year, 100);
        int y2 = Math.floorMod(year, 100);
        if (m2 == 11 || m2 == 12) {
            --y2;
        }
        if ((weekDay = Math.floorMod((long)day + (long)Math.floor(2.6 * (double)m2 - 0.2) - (long)(2 * c2) + (long)y2 + (long)Math.floorDiv(y2, 4) + (long)Math.floorDiv(c2, 4), 7)) == 0) {
            return 7L;
        }
        return weekDay;
    }

    public static int toISODayOfYear(int year, int month, int day) {
        int days = 0;
        for (int m2 = 1; m2 < month; ++m2) {
            days += TemporalUtil.isoDaysInMonth(year, m2);
        }
        return days + day;
    }

    @CompilerDirectives.TruffleBoundary
    public static long weekOfToISOWeekOfYear(int year, int month, int day) {
        long daysAfterThursday;
        long daysInYear;
        long daysLaterInYear;
        long dayOfWeek;
        long wednesday = 3L;
        long thursday = 4L;
        long friday = 5L;
        long saturday = 6L;
        long daysInWeek = 7L;
        long maxWeekNumber = 53L;
        long dayOfYear = TemporalUtil.toISODayOfYear(year, month, day);
        long week = Math.floorDiv(dayOfYear + daysInWeek - (dayOfWeek = TemporalUtil.toISODayOfWeek(year, month, day)) + wednesday, daysInWeek);
        if (week < 1L) {
            long dayOfJan1st = TemporalUtil.toISODayOfWeek(year, 1, 1);
            if (dayOfJan1st == friday || dayOfJan1st == saturday && JSDate.isLeapYear(year - 1)) {
                return maxWeekNumber;
            }
            return maxWeekNumber - 1L;
        }
        if (week == maxWeekNumber && (daysLaterInYear = (daysInYear = (long)TemporalUtil.isoDaysInYear(year)) - dayOfYear) < (daysAfterThursday = thursday - dayOfWeek)) {
            return 1L;
        }
        return week;
    }

    @CompilerDirectives.TruffleBoundary
    public static long yearOfToISOWeekOfYear(int year, int month, int day) {
        long daysAfterThursday;
        long daysInYear;
        long daysLaterInYear;
        long dayOfWeek;
        long wednesday = 3L;
        long thursday = 4L;
        long daysInWeek = 7L;
        long maxWeekNumber = 53L;
        long dayOfYear = TemporalUtil.toISODayOfYear(year, month, day);
        long week = Math.floorDiv(dayOfYear + daysInWeek - (dayOfWeek = TemporalUtil.toISODayOfWeek(year, month, day)) + wednesday, daysInWeek);
        if (week < 1L) {
            return year - 1;
        }
        if (week == maxWeekNumber && (daysLaterInYear = (daysInYear = (long)TemporalUtil.isoDaysInYear(year)) - dayOfYear) < (daysAfterThursday = thursday - dayOfWeek)) {
            return year + 1;
        }
        return year;
    }

    public static int isoDaysInYear(int year) {
        if (JSDate.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    public static int isoDaysInMonth(int year, int month) {
        assert (month >= 1 && month <= 12);
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (JSDate.isLeapYear(year)) {
            return 29;
        }
        return 28;
    }

    public static ISODateRecord balanceISOYearMonth(int year, int month) {
        if (year == Integer.MAX_VALUE || year == Integer.MIN_VALUE || month == Integer.MAX_VALUE || month == Integer.MIN_VALUE) {
            throw Errors.createRangeError("value out of range");
        }
        int yearPrepared = (int)((double)year + Math.floor(((double)month - 1.0) / 12.0));
        int monthPrepared = TemporalUtil.nonNegativeModulo(month - 1, 12) + 1;
        return new ISODateRecord(yearPrepared, monthPrepared, 0);
    }

    public static ISODateRecord balanceISOYearMonth(double year, double month) {
        assert (JSRuntime.isIntegralNumber(year)) : year;
        assert (JSRuntime.isIntegralNumber(month)) : month;
        double yearPrepared = year + Math.floor((month - 1.0) / 12.0);
        int monthPrepared = TemporalUtil.nonNegativeModulo(month - 1.0, 12) + 1;
        return new ISODateRecord((int)yearPrepared, monthPrepared, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBuiltinCalendar(TruffleString id) {
        String lowerCaseID = id.toJavaStringUncached().toLowerCase();
        return AVAILABLE_CALENDARS.contains(lowerCaseID);
    }

    public static JSTemporalCalendarObject getISO8601Calendar(JSContext ctx, JSRealm realm) {
        return TemporalUtil.getBuiltinCalendar(TemporalConstants.ISO8601, ctx, realm);
    }

    public static JSTemporalCalendarObject getBuiltinCalendar(TruffleString id, JSContext ctx, JSRealm realm) {
        assert (TemporalUtil.isBuiltinCalendar(id)) : id;
        return JSTemporalCalendar.create(ctx, realm, id);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleString> iterableToListOfTypeString(JSDynamicObject items) {
        IteratorRecord iter = JSRuntime.getIterator(items);
        ArrayList<TruffleString> values = new ArrayList<TruffleString>();
        Object next = Boolean.TRUE;
        while (next != Boolean.FALSE) {
            next = JSRuntime.iteratorStep(iter);
            if (next == Boolean.FALSE) continue;
            Object nextValue = JSRuntime.iteratorValue(next);
            if (!(nextValue instanceof TruffleString)) {
                JSRuntime.iteratorClose(iter.getIterator());
                throw Errors.createTypeError("string expected");
            }
            TruffleString str = (TruffleString)nextValue;
            values.add(str);
        }
        return values;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalDateTimeString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseCalendarDateTime();
        if (rec == null) {
            throw Errors.createRangeError("cannot parse the date string");
        }
        if (rec.getZ()) {
            throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
        }
        ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string, true, false);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalDateString(TruffleString string) {
        JSTemporalDateTimeRecord rec = TemporalUtil.parseTemporalDateTimeString(string);
        return JSTemporalDateTimeRecord.createCalendar(rec.getYear(), rec.getMonth(), rec.getDay(), 0, 0, 0, 0, 0, 0, rec.getCalendar());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalTimeString(TruffleString string) {
        ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string, true, true);
        if (result.hasCalendar()) {
            return JSTemporalDateTimeRecord.createCalendar(0, 0, 0, result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), result.getCalendar());
        }
        return JSTemporalDateTimeRecord.create(0, 0, 0, result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString buildISOMonthCode(int month) {
        TruffleString numberPart = Strings.fromInt(month);
        assert (1 <= Strings.length(numberPart) && Strings.length(numberPart) <= 2);
        return Strings.concat(Strings.length(numberPart) >= 2 ? Strings.UC_M : Strings.UC_M0, numberPart);
    }

    public static JSTemporalTimeZoneObject createTemporalTimeZone(JSContext ctx, JSRealm realm, TruffleString identifier) {
        return TemporalUtil.createTemporalTimeZone(ctx, realm, ctx.getTemporalTimeZoneFactory().getPrototype(realm), identifier);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalTimeZoneObject createTemporalTimeZone(JSContext ctx, JSRealm realm, JSDynamicObject proto, TruffleString identifier) {
        BigInt offsetNs;
        TruffleString newIdentifier = identifier;
        JSTemporalParserRecord rec = new TemporalParser(identifier).parseTimeZoneNumericUTCOffset();
        if (rec != null) {
            long result = TemporalUtil.parseTimeZoneOffsetNs(rec);
            newIdentifier = TemporalUtil.formatTimeZoneOffsetString(result);
            offsetNs = BigInt.valueOf(result);
        } else {
            assert (TemporalUtil.canonicalizeTimeZoneName(identifier).equals(identifier)) : identifier;
            offsetNs = null;
        }
        return JSTemporalTimeZone.create(ctx, realm, proto, offsetNs, newIdentifier);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString canonicalizeTimeZoneName(TruffleString timeZone) {
        String tzId = JSDateTimeFormat.canonicalizeTimeZoneName(timeZone);
        return tzId == null ? null : Strings.fromJavaString(tzId);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isoDateTimeWithinLimits(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        if (-270000 <= year && year <= 270000) {
            assert (TemporalUtil.isoDateTimeWithinLimitsExact(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond));
            return true;
        }
        if (year >= -999999999 && year <= 999999999) {
            return TemporalUtil.isoDateTimeWithinLimitsExact(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isoDateTimeWithinLimitsExact(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        BigInt ns = TemporalUtil.getUTCEpochNanoseconds(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
        return ns.compareTo(isoTimeLowerBound) > 0 && ns.compareTo(isoTimeUpperBound) < 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt getUTCEpochNanoseconds(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond) {
        assert (TemporalUtil.isValidISODate(year, month, day)) : List.of(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day));
        assert (TemporalUtil.isValidTime(hour, minute, second, millisecond, microsecond, nanosecond));
        long date = JSDate.isoDateToEpochDays(year, month - 1, day);
        long time = hour * 3600000 + minute * 60000 + second * 1000 + millisecond;
        BigInt ms = BigInt.valueOf(date).multiply(BigInt.valueOf(86400000L)).add(BigInt.valueOf(time));
        BigInt epochNanoseconds = ms.multiply(BI_NS_PER_MS).add(BigInt.valueOf(microsecond * 1000)).add(BigInt.valueOf(nanosecond));
        return epochNanoseconds;
    }

    @CompilerDirectives.TruffleBoundary
    public static Overflow toTemporalOverflow(Object options) {
        if (options == Undefined.instance) {
            return Overflow.CONSTRAIN;
        }
        Object value = JSRuntime.get(options, TemporalConstants.OVERFLOW);
        if (value == Undefined.instance) {
            return Overflow.CONSTRAIN;
        }
        TruffleString strValue = JSRuntime.toString(value);
        if (!listConstrainReject.contains(strValue)) {
            throw TemporalErrors.createRangeErrorOptionsNotContained(listConstrainReject, strValue);
        }
        return TemporalUtil.toOverflow(strValue);
    }

    @HostCompilerDirectives.InliningCutoff
    public static Overflow toTemporalOverflow(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        if (options == Undefined.instance) {
            return Overflow.CONSTRAIN;
        }
        TruffleString result = (TruffleString)getOptionNode.execute(options, TemporalConstants.OVERFLOW, OptionType.STRING, listConstrainReject, TemporalConstants.CONSTRAIN);
        return TemporalUtil.toOverflow(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static Overflow toOverflow(TruffleString result) {
        if (TemporalConstants.CONSTRAIN.equals(result)) {
            return Overflow.CONSTRAIN;
        }
        if (TemporalConstants.REJECT.equals(result)) {
            return Overflow.REJECT;
        }
        throw Errors.shouldNotReachHereUnexpectedValue(result);
    }

    public static JSTemporalDateTimeRecord interpretTemporalDateTimeFields(CalendarMethodsRecord calendarRec, JSDynamicObject fields, JSDynamicObject options, TemporalGetOptionNode getOptionNode, TemporalCalendarDateFromFieldsNode dateFromFieldsNode) {
        JSTemporalDateTimeRecord timeResult = TemporalUtil.toTemporalTimeRecord(fields);
        JSTemporalPlainDateObject date = dateFromFieldsNode.execute(calendarRec, fields, options);
        Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        JSTemporalDurationRecord timeResult2 = TemporalUtil.regulateTime(timeResult.getHour(), timeResult.getMinute(), timeResult.getSecond(), timeResult.getMillisecond(), timeResult.getMicrosecond(), timeResult.getNanosecond(), overflow);
        return JSTemporalDateTimeRecord.create(date.getYear(), date.getMonth(), date.getDay(), TemporalUtil.dtoi(timeResult2.getHours()), TemporalUtil.dtoi(timeResult2.getMinutes()), TemporalUtil.dtoi(timeResult2.getSeconds()), TemporalUtil.dtoi(timeResult2.getMilliseconds()), TemporalUtil.dtoi(timeResult2.getMicroseconds()), TemporalUtil.dtoi(timeResult2.getNanoseconds()));
    }

    public static JSTemporalDurationRecord regulateTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        if (overflow == Overflow.CONSTRAIN) {
            return TemporalUtil.constrainTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        }
        if (!TemporalUtil.isValidTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            throw Errors.createRangeError("Given time outside the range.");
        }
        return JSTemporalDurationRecord.create(0.0, 0.0, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static JSTemporalDurationRecord constrainTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds) {
        return JSTemporalDurationRecord.create(0.0, 0.0, 0.0, TemporalUtil.constrainToRange(hours, 0, 23), TemporalUtil.constrainToRange(minutes, 0, 59), TemporalUtil.constrainToRange(seconds, 0, 59), TemporalUtil.constrainToRange(milliseconds, 0, 999), TemporalUtil.constrainToRange(microseconds, 0, 999), TemporalUtil.constrainToRange(nanoseconds, 0, 999));
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord toTemporalTimeRecord(JSDynamicObject temporalTimeLike) {
        boolean any = false;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int microsecond = 0;
        int nanosecond = 0;
        for (TruffleString property : TIME_LIKE_PROPERTIES) {
            Object val = JSObject.get(temporalTimeLike, property);
            int iVal = 0;
            if (val == Undefined.instance) {
                iVal = 0;
            } else {
                any = true;
                iVal = JSRuntime.intValue(TemporalUtil.toIntegerThrowOnInfinity(val));
            }
            if (TemporalConstants.HOUR.equals(property)) {
                hour = iVal;
                continue;
            }
            if (TemporalConstants.MINUTE.equals(property)) {
                minute = iVal;
                continue;
            }
            if (TemporalConstants.SECOND.equals(property)) {
                second = iVal;
                continue;
            }
            if (TemporalConstants.MILLISECOND.equals(property)) {
                millisecond = iVal;
                continue;
            }
            if (TemporalConstants.MICROSECOND.equals(property)) {
                microsecond = iVal;
                continue;
            }
            if (!TemporalConstants.NANOSECOND.equals(property)) continue;
            nanosecond = iVal;
        }
        if (!any) {
            throw Errors.createTypeError("at least one time-like field expected");
        }
        return JSTemporalDateTimeRecord.create(0, 0, 0, hour, minute, second, millisecond, microsecond, nanosecond);
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toIntegerThrowOnInfinity(Object value) {
        Number integer = TemporalUtil.toIntegerOrInfinity(value);
        if (Double.isInfinite(JSRuntime.doubleValue(integer))) {
            throw Errors.createRangeError("value outside bounds");
        }
        return integer;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toIntegerOrInfinity(Object value) {
        Number number = JSRuntime.toNumber(value);
        double d2 = number.doubleValue();
        if (d2 == 0.0 || Double.isNaN(d2)) {
            return 0L;
        }
        if (Double.isInfinite(d2)) {
            return d2;
        }
        return JSRuntime.truncateDouble(d2);
    }

    public static JSTemporalPlainDateObject calendarDateAdd(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject date, JSTemporalDurationObject duration, JSDynamicObject options, ToTemporalCalendarObjectNode toCalendarObject, JSFunctionCallNode callDateAdd) {
        Object dateAddPrepared = calendarRec.dateAdd();
        Object calendar = toCalendarObject.execute(calendarRec.receiver());
        Object addedDate = callDateAdd.executeCall(JSArguments.create(calendar, dateAddPrepared, date, duration, options));
        return TemporalUtil.requireTemporalDate(addedDate);
    }

    public static JSTemporalDurationObject calendarDateUntil(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject one, JSTemporalPlainDateObject two, JSObject options, ToTemporalCalendarObjectNode toCalendarObject, JSFunctionCallNode callDateUntil) {
        Object dateUntilPrepared = calendarRec.dateUntil();
        Object calendar = toCalendarObject.execute(calendarRec.receiver());
        Object date = callDateUntil.executeCall(JSArguments.create(calendar, dateUntilPrepared, one, two, options));
        return TemporalUtil.requireTemporalDuration(date);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt roundTemporalInstant(BigInt ns, int increment, Unit unit, RoundingMode roundingMode) {
        BigInt incrementNs = BigInt.valueOf(increment);
        if (Unit.HOUR == unit) {
            incrementNs = incrementNs.multiply(BI_NS_PER_HOUR);
        } else if (Unit.MINUTE == unit) {
            incrementNs = incrementNs.multiply(BI_NS_PER_MINUTE);
        } else if (Unit.SECOND == unit) {
            incrementNs = incrementNs.multiply(BI_NS_PER_SECOND);
        } else if (Unit.MILLISECOND == unit) {
            incrementNs = incrementNs.multiply(BI_NS_PER_MS);
        } else if (Unit.MICROSECOND == unit) {
            incrementNs = incrementNs.multiply(BI_1000);
        } else {
            assert (Unit.NANOSECOND == unit) : unit;
            if (incrementNs.compareTo(BigInt.ONE) == 0) {
                return ns;
            }
        }
        return TemporalUtil.roundNumberToIncrementAsIfPositive(ns, incrementNs, roundingMode);
    }

    public static ISODateRecord regulateISODate(int year, int monthParam, int dayParam, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        int month = monthParam;
        int day = dayParam;
        if (overflow == Overflow.REJECT) {
            if (!TemporalUtil.isValidISODate(year, month, day)) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
        } else {
            assert (overflow == Overflow.CONSTRAIN);
            month = TemporalUtil.constrainToRange(month, 1, 12);
            day = TemporalUtil.constrainToRange(day, 1, TemporalUtil.isoDaysInMonth(year, month));
        }
        return new ISODateRecord(year, month, day);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord balanceISODate(int year, int month, int day) {
        if (year < -1000000 || 1000000 < year || day < -100000001 || 100000001 < day) {
            throw Errors.createRangeError("Date outside of supported range");
        }
        long epochDays = JSDate.isoDateToEpochDays(year, month - 1, day);
        long ms = epochDays * 86400000L;
        return TemporalUtil.createISODateRecord(JSDate.yearFromTime(ms), JSDate.monthFromTime(ms) + 1, JSDate.dateFromTime(ms));
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord createISODateRecord(int year, int month, int day) {
        assert (TemporalUtil.isValidISODate(year, month, day));
        return new ISODateRecord(year, month, day);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord balanceISODate(int year, int month, double day) {
        assert (JSRuntime.isIntegralNumber(day));
        return TemporalUtil.balanceISODate(year, month, (int)day);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord balanceISODate(double year, double month, double day) {
        assert (JSRuntime.isIntegralNumber(year) && JSRuntime.isIntegralNumber(month) && JSRuntime.isIntegralNumber(day));
        return TemporalUtil.balanceISODate((int)year, (int)month, (int)day);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord addISODate(int year, int month, int day, int years, int months, int weeks, int daysP, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        int days = daysP;
        ISODateRecord intermediateYM = TemporalUtil.balanceISOYearMonth(year + years, month + months);
        ISODateRecord intermediate = TemporalUtil.regulateISODate(intermediateYM.year(), intermediateYM.month(), day, overflow);
        int d2 = TemporalUtil.add(intermediate.day(), days += 7 * weeks, overflow);
        return TemporalUtil.balanceISODate(intermediate.year(), intermediate.month(), d2);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord addISODate(int year, int month, int day, double years, double months, double weeks, double daysP, Overflow overflow) {
        assert (overflow == Overflow.CONSTRAIN || overflow == Overflow.REJECT);
        double days = daysP;
        ISODateRecord intermediateYM = TemporalUtil.balanceISOYearMonth((double)year + years, (double)month + months);
        ISODateRecord intermediate = TemporalUtil.regulateISODate(intermediateYM.year(), intermediateYM.month(), day, overflow);
        intermediate = TemporalUtil.balanceISODate(intermediate.year(), intermediate.month(), (double)intermediate.day() + (days += 7.0 * weeks));
        return TemporalUtil.regulateISODate(intermediate.year(), intermediate.month(), intermediate.day(), overflow);
    }

    public static int compareISODate(int y1, int m1, int d1, int y2, int m2, int d2) {
        if (y1 > y2) {
            return 1;
        }
        if (y1 < y2) {
            return -1;
        }
        if (m1 > m2) {
            return 1;
        }
        if (m1 < m2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 0;
    }

    public static JSTemporalPlainDateObject requireTemporalDate(Object obj, Node node, InlinedBranchProfile errorBranch) {
        if (!(obj instanceof JSTemporalPlainDateObject)) {
            errorBranch.enter(node);
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
        return (JSTemporalPlainDateObject)obj;
    }

    public static JSTemporalPlainDateObject requireTemporalDate(Object obj) {
        if (!(obj instanceof JSTemporalPlainDateObject)) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
        return (JSTemporalPlainDateObject)obj;
    }

    public static JSTemporalDurationObject requireTemporalDuration(Object obj) {
        if (!(obj instanceof JSTemporalDurationObject)) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
        return (JSTemporalDurationObject)obj;
    }

    public static boolean isTemporalZonedDateTime(Object obj) {
        return JSTemporalZonedDateTime.isJSTemporalZonedDateTime(obj);
    }

    public static ShowCalendar toShowCalendarOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        return TemporalUtil.toShowCalendar((TruffleString)getOptionNode.execute(options, TemporalConstants.CALENDAR_NAME, OptionType.STRING, listAutoAlwaysNeverCritical, TemporalConstants.AUTO), equalNode);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toZeroPaddedDecimalString(long number, int digits) {
        TruffleString decimalStr = Strings.fromLong(number);
        int length = Strings.length(decimalStr);
        if (length < digits) {
            TruffleStringBuilderUTF16 sb = TruffleStringBuilderUTF16.createUTF16(digits);
            for (int i2 = length; i2 < digits; ++i2) {
                Strings.builderAppend(sb, '0');
            }
            Strings.builderAppend(sb, decimalStr);
            return Strings.builderToString(sb);
        }
        return decimalStr;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString padISOYear(int year) {
        if (0 <= year && year <= 9999) {
            return TemporalUtil.toZeroPaddedDecimalString(year, 4);
        }
        TruffleString sign = year > 0 ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        int y2 = Math.abs(year);
        return Strings.concat(sign, TemporalUtil.toZeroPaddedDecimalString(y2, 6));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString maybeFormatCalendarAnnotation(Object calendar, ShowCalendar showCalendar) {
        if (showCalendar == ShowCalendar.NEVER) {
            return Strings.EMPTY_STRING;
        }
        TruffleString calendarID = ToTemporalCalendarIdentifierNode.getUncached().executeString(calendar);
        return TemporalUtil.formatCalendarAnnotation(calendarID, showCalendar);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatCalendarAnnotation(TruffleString id, ShowCalendar showCalendar) {
        if (ShowCalendar.NEVER == showCalendar) {
            return Strings.EMPTY_STRING;
        }
        if (ShowCalendar.AUTO == showCalendar && TemporalConstants.ISO8601.equals(id)) {
            return Strings.EMPTY_STRING;
        }
        TruffleString flag = showCalendar == ShowCalendar.CRITICAL ? Strings.EXCLAMATION_MARK : Strings.EMPTY_STRING;
        return Strings.concatAll(Strings.BRACKET_OPEN, flag, TemporalConstants.U_CA_EQUALS, id, Strings.BRACKET_CLOSE);
    }

    public static RoundingMode negateTemporalRoundingMode(RoundingMode roundingMode) {
        return switch (roundingMode.ordinal()) {
            case 1 -> RoundingMode.FLOOR;
            case 2 -> RoundingMode.CEIL;
            case 8 -> RoundingMode.HALF_CEIL;
            case 9 -> RoundingMode.HALF_FLOOR;
            default -> roundingMode;
        };
    }

    public static boolean calendarEquals(Object one, Object two, ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
        if (one == two) {
            return true;
        }
        return Boundaries.equals(toCalendarIdentifier.executeString(one), toCalendarIdentifier.executeString(two));
    }

    public static JSDynamicObject calendarMergeFields(JSContext ctx, JSRealm realm, CalendarMethodsRecord calendarRec, JSDynamicObject fields, JSDynamicObject additionalFields, Node node, InlinedBranchProfile errorBranch) {
        Object calendar;
        boolean isBuiltinCalendar;
        Object calendarSlotValue = calendarRec.receiver();
        if (calendarSlotValue instanceof TruffleString) {
            TruffleString calendarID = (TruffleString)calendarSlotValue;
            isBuiltinCalendar = true;
            calendar = TemporalUtil.getBuiltinCalendar(calendarID, ctx, realm);
        } else {
            isBuiltinCalendar = false;
            calendar = calendarSlotValue;
        }
        Object result = JSRuntime.call(calendarRec.mergeFields(), calendar, new Object[]{fields, additionalFields});
        if (!isBuiltinCalendar && !JSRuntime.isObject(result)) {
            throw TemporalErrors.createTypeErrorObjectExpected();
        }
        return TemporalUtil.toJSDynamicObject(result, node, errorBranch);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject defaultMergeFields(JSContext ctx, JSDynamicObject fields, JSDynamicObject additionalFields) {
        JSObject merged = JSOrdinary.createWithNullPrototype(ctx);
        List<Object> originalKeys = JSObject.ownPropertyKeys(fields);
        for (Object nextKey : originalKeys) {
            Object propValue;
            if (TemporalConstants.MONTH.equals(nextKey) || TemporalConstants.MONTH_CODE.equals(nextKey) || (propValue = JSObject.get(fields, nextKey)) == Undefined.instance) continue;
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, nextKey, propValue);
        }
        boolean hasMonthOrMonthCode = false;
        List<Object> newKeys = JSObject.ownPropertyKeys(additionalFields);
        for (Object nextKey : newKeys) {
            Object propValue = JSObject.get(additionalFields, nextKey);
            if (propValue == Undefined.instance) continue;
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, nextKey, propValue);
            if (!TemporalConstants.MONTH.equals(nextKey) && !TemporalConstants.MONTH_CODE.equals(nextKey)) continue;
            hasMonthOrMonthCode = true;
        }
        if (!hasMonthOrMonthCode) {
            Object monthCode;
            Object month = JSObject.get(fields, TemporalConstants.MONTH);
            if (month != Undefined.instance) {
                TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.MONTH, month);
            }
            if ((monthCode = JSObject.get(fields, TemporalConstants.MONTH_CODE)) != Undefined.instance) {
                TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.MONTH_CODE, monthCode);
            }
        }
        return merged;
    }

    public static void createDataPropertyOrThrow(JSContext ctx, JSDynamicObject obj, Object key, Object value) {
        JSObjectUtil.defineDataProperty(ctx, obj, key, value, JSAttributes.configurableEnumerableWritable());
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleString> listJoinRemoveDuplicates(List<TruffleString> first, List<TruffleString> second) {
        ArrayList<TruffleString> newList = new ArrayList<TruffleString>(first.size() + second.size());
        newList.addAll(first);
        for (TruffleString elem : second) {
            if (first.contains(elem)) continue;
            newList.add(elem);
        }
        return newList;
    }

    public static Unit largerOfTwoTemporalUnits(Unit a2, Unit b2) {
        assert (Unit.YEAR.compareTo(a2) <= 0 && a2.compareTo(Unit.NANOSECOND) <= 0) : a2;
        assert (Unit.YEAR.compareTo(b2) <= 0 && b2.compareTo(Unit.NANOSECOND) <= 0) : b2;
        return a2.compareTo(b2) <= 0 ? a2 : b2;
    }

    public static DateDurationRecord createDateDurationRecord(double years, double months, double weeks, double days) {
        if (!TemporalUtil.isValidDuration(years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)) {
            throw TemporalErrors.createTypeErrorDurationOutsideRange();
        }
        return new DateDurationRecord(years, months, weeks, days);
    }

    public static NormalizedDurationRecord createNormalizedDurationRecord(double years, double months, double weeks, double days, BigInt normalizedTimeDuration) {
        DateDurationRecord dateDurationRecord = TemporalUtil.createDateDurationRecord(years, months, weeks, days);
        return TemporalUtil.combineDateAndNormalizedTimeDuration(dateDurationRecord, normalizedTimeDuration);
    }

    public static NormalizedDurationRecord combineDateAndNormalizedTimeDuration(DateDurationRecord dateDuration, BigInt normalizedTimeDuration) {
        int dateSign = TemporalUtil.durationSign(dateDuration.years(), dateDuration.months(), dateDuration.weeks(), dateDuration.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        int timeSign = TemporalUtil.normalizedTimeDurationSign(normalizedTimeDuration);
        if (dateSign != 0 && timeSign != 0 && dateSign != timeSign) {
            throw Errors.createRangeError("mixed-sign values not allowed as duration fields");
        }
        return new NormalizedDurationRecord(dateDuration.years(), dateDuration.months(), dateDuration.weeks(), dateDuration.days(), normalizedTimeDuration);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject mergeLargestUnitOption(JSContext ctx, EnumerableOwnPropertyNamesNode namesNode, JSDynamicObject options, Unit largestUnit) {
        JSObject merged = JSOrdinary.createWithNullPrototype(ctx);
        UnmodifiableArrayList<? extends Object> keys = namesNode.execute(options);
        for (Object object : keys) {
            if (!(object instanceof TruffleString)) continue;
            TruffleString key = (TruffleString)object;
            Object propValue = JSObject.get(options, key);
            TemporalUtil.createDataPropertyOrThrow(ctx, merged, key, propValue);
        }
        TemporalUtil.createDataPropertyOrThrow(ctx, merged, TemporalConstants.LARGEST_UNIT, largestUnit.toTruffleString());
        return merged;
    }

    public static int durationSign(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        if (years < 0.0) {
            return -1;
        }
        if (years > 0.0) {
            return 1;
        }
        if (months < 0.0) {
            return -1;
        }
        if (months > 0.0) {
            return 1;
        }
        if (weeks < 0.0) {
            return -1;
        }
        if (weeks > 0.0) {
            return 1;
        }
        if (days < 0.0) {
            return -1;
        }
        if (days > 0.0) {
            return 1;
        }
        if (hours < 0.0) {
            return -1;
        }
        if (hours > 0.0) {
            return 1;
        }
        if (minutes < 0.0) {
            return -1;
        }
        if (minutes > 0.0) {
            return 1;
        }
        if (seconds < 0.0) {
            return -1;
        }
        if (seconds > 0.0) {
            return 1;
        }
        if (milliseconds < 0.0) {
            return -1;
        }
        if (milliseconds > 0.0) {
            return 1;
        }
        if (microseconds < 0.0) {
            return -1;
        }
        if (microseconds > 0.0) {
            return 1;
        }
        if (nanoseconds < 0.0) {
            return -1;
        }
        if (nanoseconds > 0.0) {
            return 1;
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static void rejectDurationSign(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        long sign = TemporalUtil.durationSign(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        if (years < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Years is negative but it should be positive.");
        }
        if (years > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Years is positive but it should be negative.");
        }
        if (months < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Months is negative but it should be positive.");
        }
        if (months > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Months is positive but it should be negative.");
        }
        if (weeks < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Weeks is negative but it should be positive.");
        }
        if (weeks > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Weeks is positive but it should be negative.");
        }
        if (days < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Days is negative but it should be positive.");
        }
        if (days > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Days is positive but it should be negative.");
        }
        if (hours < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Hours is negative but it should be positive.");
        }
        if (hours > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Hours is positive but it should be negative.");
        }
        if (minutes < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Minutes is negative but it should be positive.");
        }
        if (minutes > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Minutes is positive but it should be negative.");
        }
        if (seconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Seconds is negative but it should be positive.");
        }
        if (seconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Seconds is positive but it should be negative.");
        }
        if (milliseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Milliseconds is negative but it should be positive.");
        }
        if (milliseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Milliseconds is positive but it should be negative.");
        }
        if (microseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Microseconds is negative but it should be positive.");
        }
        if (microseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Microseconds is positive but it should be negative.");
        }
        if (nanoseconds < 0.0 && sign > 0L) {
            throw Errors.createRangeError("Nanoseconds is negative but it should be positive.");
        }
        if (nanoseconds > 0.0 && sign < 0L) {
            throw Errors.createRangeError("Nanoseconds is positive but it should be negative.");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeDurationRecord balanceTimeDuration(BigInt normalizedTimeDuration, Unit largestUnit) {
        BigInt d2 = BigInt.ZERO;
        BigInt h2 = BigInt.ZERO;
        BigInt min = BigInt.ZERO;
        BigInt s2 = BigInt.ZERO;
        BigInt ms = BigInt.ZERO;
        BigInt us = BigInt.ZERO;
        double sign = TemporalUtil.normalizedTimeDurationSign(normalizedTimeDuration);
        BigInt ns = TemporalUtil.normalizedTimeDurationAbs(normalizedTimeDuration);
        switch (largestUnit.ordinal()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s2 = qr[0];
                ms = qr[1];
                qr = s2.divideAndRemainder(BI_60);
                min = qr[0];
                s2 = qr[1];
                qr = min.divideAndRemainder(BI_60);
                h2 = qr[0];
                min = qr[1];
                qr = h2.divideAndRemainder(BI_24);
                d2 = qr[0];
                h2 = qr[1];
                break;
            }
            case 6: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s2 = qr[0];
                ms = qr[1];
                qr = s2.divideAndRemainder(BI_60);
                min = qr[0];
                s2 = qr[1];
                qr = min.divideAndRemainder(BI_60);
                h2 = qr[0];
                min = qr[1];
                break;
            }
            case 7: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s2 = qr[0];
                ms = qr[1];
                qr = s2.divideAndRemainder(BI_60);
                min = qr[0];
                s2 = qr[1];
                break;
            }
            case 8: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                qr = ms.divideAndRemainder(BI_1000);
                s2 = qr[0];
                ms = qr[1];
                break;
            }
            case 9: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                qr = us.divideAndRemainder(BI_1000);
                ms = qr[0];
                us = qr[1];
                break;
            }
            case 10: {
                BigInt[] qr = ns.divideAndRemainder(BI_1000);
                us = qr[0];
                ns = qr[1];
                break;
            }
            default: {
                assert (largestUnit == Unit.NANOSECOND) : largestUnit;
                break;
            }
        }
        double days = d2.doubleValue() * sign;
        double hours = h2.doubleValue() * sign;
        double minutes = min.doubleValue() * sign;
        double seconds = s2.doubleValue() * sign;
        double milliseconds = ms.doubleValue() * sign;
        double microseconds = us.doubleValue() * sign;
        double nanoseconds = ns.doubleValue() * sign;
        if (!TemporalUtil.isValidDuration(0.0, 0.0, 0.0, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            throw Errors.createRangeError("Time is infinite");
        }
        return new TimeDurationRecord(days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static JSDynamicObject toDynamicObject(Object obj) {
        if (obj instanceof JSDynamicObject) {
            return (JSDynamicObject)obj;
        }
        throw Errors.createTypeErrorNotAnObject(obj);
    }

    public static JSDynamicObject toJSDynamicObject(Object item, Node node, InlinedBranchProfile errorBranch) {
        if (item instanceof JSDynamicObject) {
            return (JSDynamicObject)item;
        }
        errorBranch.enter(node);
        throw Errors.createTypeError("Interop types not supported in Temporal");
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidDuration(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        int sign = TemporalUtil.durationSign(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        if (years < 0.0 && sign > 0) {
            return false;
        }
        if (years > 0.0 && sign < 0) {
            return false;
        }
        if (months < 0.0 && sign > 0) {
            return false;
        }
        if (months > 0.0 && sign < 0) {
            return false;
        }
        if (weeks < 0.0 && sign > 0) {
            return false;
        }
        if (weeks > 0.0 && sign < 0) {
            return false;
        }
        if (days < 0.0 && sign > 0) {
            return false;
        }
        if (days > 0.0 && sign < 0) {
            return false;
        }
        if (hours < 0.0 && sign > 0) {
            return false;
        }
        if (hours > 0.0 && sign < 0) {
            return false;
        }
        if (minutes < 0.0 && sign > 0) {
            return false;
        }
        if (minutes > 0.0 && sign < 0) {
            return false;
        }
        if (seconds < 0.0 && sign > 0) {
            return false;
        }
        if (seconds > 0.0 && sign < 0) {
            return false;
        }
        if (milliseconds < 0.0 && sign > 0) {
            return false;
        }
        if (milliseconds > 0.0 && sign < 0) {
            return false;
        }
        if (microseconds < 0.0 && sign > 0) {
            return false;
        }
        if (microseconds > 0.0 && sign < 0) {
            return false;
        }
        if (nanoseconds < 0.0 && sign > 0) {
            return false;
        }
        if (nanoseconds > 0.0 && sign < 0) {
            return false;
        }
        double twoPow32 = 4.294967296E9;
        if (Math.abs(years) >= twoPow32 || Math.abs(months) >= twoPow32 || Math.abs(weeks) >= twoPow32) {
            return false;
        }
        long normalizedSeconds = 86400L * (long)days + 3600L * (long)hours + 60L * (long)minutes + (long)seconds + (long)milliseconds / 1000L + (long)microseconds / 1000000L + (long)nanoseconds / 1000000000L;
        return Math.abs(normalizedSeconds) < 0x20000000000000L;
    }

    public static Unit defaultTemporalLargestUnit(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds) {
        if (years != 0.0) {
            return Unit.YEAR;
        }
        if (months != 0.0) {
            return Unit.MONTH;
        }
        if (weeks != 0.0) {
            return Unit.WEEK;
        }
        if (days != 0.0) {
            return Unit.DAY;
        }
        if (hours != 0.0) {
            return Unit.HOUR;
        }
        if (minutes != 0.0) {
            return Unit.MINUTE;
        }
        if (seconds != 0.0) {
            return Unit.SECOND;
        }
        if (milliseconds != 0.0) {
            return Unit.MILLISECOND;
        }
        if (microseconds != 0.0) {
            return Unit.MICROSECOND;
        }
        return Unit.NANOSECOND;
    }

    public static AddDaysToZonedDateTimeResult addDaysToZonedDateTime(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime, TimeZoneMethodsRecord timeZoneRec, int days) {
        return TemporalUtil.addDaysToZonedDateTime(ctx, realm, instant, dateTime, timeZoneRec, days, Overflow.CONSTRAIN);
    }

    public static AddDaysToZonedDateTimeResult addDaysToZonedDateTime(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime, TimeZoneMethodsRecord timeZoneRec, int days, Overflow overflow) {
        if (days == 0) {
            return new AddDaysToZonedDateTimeResult(instant.getNanoseconds(), instant, dateTime);
        }
        ISODateRecord addedDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, days, overflow);
        JSTemporalPlainDateTimeObject dateTimeResult = JSTemporalPlainDateTime.create(ctx, realm, addedDate.year(), addedDate.month(), addedDate.day(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), dateTime.getCalendar());
        JSTemporalInstantObject instantResult = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTimeResult, Disambiguation.COMPATIBLE);
        return new AddDaysToZonedDateTimeResult(instantResult.getNanoseconds(), instant, dateTimeResult);
    }

    private static BigInt dtobi(double d2) {
        CompilerAsserts.neverPartOfCompilation();
        return BigInt.fromBigInteger(new BigDecimal(d2).toBigInteger());
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt totalDurationNanoseconds(double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        BigInt d2 = TemporalUtil.dtobi(days).multiply(BI_24);
        BigInt h2 = TemporalUtil.dtobi(hours).add(d2);
        BigInt min = TemporalUtil.dtobi(minutes).add(h2.multiply(BI_60));
        BigInt s2 = TemporalUtil.dtobi(seconds).add(min.multiply(BI_60));
        BigInt ms = TemporalUtil.dtobi(milliseconds).add(s2.multiply(BI_1000));
        BigInt us = TemporalUtil.dtobi(microseconds).add(ms.multiply(BI_1000));
        BigInt ns = TemporalUtil.dtobi(nanoseconds).add(us.multiply(BI_1000));
        return ns;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt normalizeTimeDuration(double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        BigInt h2 = TemporalUtil.dtobi(hours);
        BigInt min = TemporalUtil.dtobi(minutes).add(h2.multiply(BI_60));
        BigInt s2 = TemporalUtil.dtobi(seconds).add(min.multiply(BI_60));
        BigInt ms = TemporalUtil.dtobi(milliseconds).add(s2.multiply(BI_1000));
        BigInt us = TemporalUtil.dtobi(microseconds).add(ms.multiply(BI_1000));
        BigInt ns = TemporalUtil.dtobi(nanoseconds).add(us.multiply(BI_1000));
        return ns;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt add24HourDaysToNormalizedTimeDuration(BigInt timeDurationTotalNanoseconds, double days) {
        assert (JSRuntime.isIntegralNumber(days)) : days;
        BigInt result = timeDurationTotalNanoseconds.add(TemporalUtil.dtobi(days).multiply(BI_NS_PER_DAY));
        if (result.abs().compareTo(MAX_TIME_DURATION) > 0) {
            throw Errors.createRangeError("Time duration out of range");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addNormalizedTimeDurationToEpochNanoseconds(BigInt timeDurationTotalNanoseconds, BigInt epochNs) {
        return epochNs.add(timeDurationTotalNanoseconds);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addNormalizedTimeDuration(BigInt one, BigInt two) {
        BigInt result = one.add(two);
        if (result.abs().compareTo(MAX_TIME_DURATION) > 0) {
            throw Errors.createRangeError("Time duration out of range");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt subtractNormalizedTimeDuration(BigInt one, BigInt two) {
        BigInt result = one.subtract(two);
        if (result.abs().compareTo(MAX_TIME_DURATION) > 0) {
            throw Errors.createRangeError("Time duration out of range");
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt normalizedTimeDurationFromEpochNanosecondsDifference(BigInt one, BigInt two) {
        BigInt result = one.subtract(two);
        assert (result.abs().compareTo(MAX_TIME_DURATION) <= 0) : result;
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static double divideNormalizedTimeDurationAsDouble(BigInt normalizedTimeDuration, long divisor) {
        assert (divisor != 0L);
        BigDecimal result = new BigDecimal(normalizedTimeDuration.bigIntegerValue()).divide(BigDecimal.valueOf(divisor), MathContext.DECIMAL128);
        return result.doubleValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static double divideNormalizedTimeDurationAsDoubleTruncate(BigInt normalizedTimeDuration, long divisor) {
        assert (divisor != 0L);
        return normalizedTimeDuration.divide(BigInt.valueOf(divisor)).doubleValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt remainderNormalizedTimeDuration(BigInt normalizedTimeDuration, long divisor) {
        assert (divisor != 0L);
        BigDecimal result = new BigDecimal(normalizedTimeDuration.bigIntegerValue()).remainder(BigDecimal.valueOf(divisor), MathContext.DECIMAL128);
        return BigInt.fromBigInteger(result.toBigInteger());
    }

    @CompilerDirectives.TruffleBoundary
    public static double normalizeTimeDurationSeconds(BigInt timeDurationTotalNanoseconds) {
        return timeDurationTotalNanoseconds.divide(BI_NS_PER_SECOND).doubleValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static double normalizeTimeDurationSubseconds(BigInt timeDurationTotalNanoseconds) {
        return timeDurationTotalNanoseconds.remainder(BI_NS_PER_SECOND).doubleValue();
    }

    public static BigInt normalizedTimeDurationAbs(BigInt timeDurationTotalNanoseconds) {
        return timeDurationTotalNanoseconds.abs();
    }

    public static int normalizedTimeDurationSign(BigInt timeDurationTotalNanoseconds) {
        return timeDurationTotalNanoseconds.signum();
    }

    public static BigInt zeroTimeDuration() {
        return BigInt.ZERO;
    }

    @CompilerDirectives.TruffleBoundary
    public static long daysUntil(JSTemporalPlainDateObject earlier, JSTemporalPlainDateObject later) {
        long epochDays1 = JSDate.isoDateToEpochDays(earlier.getYear(), earlier.getMonth() - 1, earlier.getDay());
        long epochDays2 = JSDate.isoDateToEpochDays(later.getYear(), later.getMonth() - 1, later.getDay());
        return epochDays2 - epochDays1;
    }

    public static BigInt differenceTime(int h1, int min1, int s1, int ms1, int mus1, int ns1, int h2, int min2, int s2, int ms2, int mus2, int ns2) {
        int hours = h2 - h1;
        int minutes = min2 - min1;
        int seconds = s2 - s1;
        int milliseconds = ms2 - ms1;
        int microseconds = mus2 - mus1;
        int nanoseconds = ns2 - ns1;
        BigInt norm = TemporalUtil.normalizeTimeDuration(hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
        assert (TemporalUtil.normalizedTimeDurationAbs(norm).compareTo(BI_NS_PER_DAY) < 0) : norm;
        return norm;
    }

    public static NormalizedDurationWithTotalRecord roundTimeDuration(double days0, BigInt norm0, int increment, Unit unit, RoundingMode roundingMode) {
        double total;
        assert (!unit.isCalendarUnit()) : unit;
        double days = days0;
        BigInt norm = norm0;
        if (unit == Unit.DAY) {
            double fractionalDays = days + TemporalUtil.divideNormalizedTimeDurationAsDouble(norm, 86400000000000L);
            days = TemporalUtil.roundNumberToIncrement(fractionalDays, increment, roundingMode);
            total = fractionalDays;
            norm = TemporalUtil.zeroTimeDuration();
        } else {
            long divisor = unit.getLengthInNanoseconds();
            total = TemporalUtil.divideNormalizedTimeDurationAsDouble(norm, divisor);
            norm = TemporalUtil.roundNormalizedTimeDurationToIncrement(norm, divisor, increment, roundingMode);
        }
        return new NormalizedDurationWithTotalRecord(TemporalUtil.createNormalizedDurationRecord(0.0, 0.0, 0.0, days, norm), total);
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeRecord roundTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, int increment, Unit unit, RoundingMode roundingMode, Long dayLengthNsParam) {
        double quantity;
        double fractionalSecond = (double)nanoseconds / 1.0E9 + (double)microseconds / 1000000.0 + (double)milliseconds / 1000.0 + (double)seconds;
        if (unit == Unit.DAY) {
            long dayLengthNs = dayLengthNsParam == null ? 86300000000000L : dayLengthNsParam;
            quantity = (double)(((((hours * 60 + minutes) * 60 + seconds) * 1000 + milliseconds) * 1000 + microseconds) * 1000 + nanoseconds) / (double)dayLengthNs;
        } else if (unit == Unit.HOUR) {
            quantity = (fractionalSecond / 60.0 + (double)minutes) / 60.0 + (double)hours;
        } else if (unit == Unit.MINUTE) {
            quantity = fractionalSecond / 60.0 + (double)minutes;
        } else if (unit == Unit.SECOND) {
            quantity = fractionalSecond;
        } else if (unit == Unit.MILLISECOND) {
            quantity = (double)nanoseconds / 1000000.0 + (double)microseconds / 1000.0 + (double)milliseconds;
        } else if (unit == Unit.MICROSECOND) {
            quantity = (double)nanoseconds / 1000.0 + (double)microseconds;
        } else {
            assert (unit == Unit.NANOSECOND);
            quantity = nanoseconds;
        }
        long result = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(quantity, increment, roundingMode));
        if (unit == Unit.DAY) {
            return new TimeRecord(result, 0, 0, 0, 0, 0, 0);
        }
        if (unit == Unit.HOUR) {
            return TemporalUtil.balanceTime(result, 0L, 0L, 0L, 0L, 0L);
        }
        if (unit == Unit.MINUTE) {
            return TemporalUtil.balanceTime(hours, result, 0L, 0L, 0L, 0L);
        }
        if (unit == Unit.SECOND) {
            return TemporalUtil.balanceTime(hours, minutes, result, 0L, 0L, 0L);
        }
        if (unit == Unit.MILLISECOND) {
            return TemporalUtil.balanceTime(hours, minutes, seconds, result, 0L, 0L);
        }
        if (unit == Unit.MICROSECOND) {
            return TemporalUtil.balanceTime(hours, minutes, seconds, milliseconds, result, 0L);
        }
        assert (unit == Unit.NANOSECOND);
        return TemporalUtil.balanceTime(hours, minutes, seconds, milliseconds, microseconds, result);
    }

    public static TimeRecord balanceTimeDouble(double h2, double min, double sec, double mils, double mics, double ns, Node node, InlinedBranchProfile errorBranch) {
        if (h2 == Double.POSITIVE_INFINITY || h2 == Double.NEGATIVE_INFINITY || min == Double.POSITIVE_INFINITY || min == Double.NEGATIVE_INFINITY || sec == Double.POSITIVE_INFINITY || sec == Double.NEGATIVE_INFINITY || mils == Double.POSITIVE_INFINITY || mils == Double.NEGATIVE_INFINITY || mics == Double.POSITIVE_INFINITY || mics == Double.NEGATIVE_INFINITY || ns == Double.POSITIVE_INFINITY || ns == Double.NEGATIVE_INFINITY) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Time is infinite");
        }
        double microseconds = mics;
        double milliseconds = mils;
        double nanoseconds = ns;
        double seconds = sec;
        double minutes = min;
        double hours = h2;
        microseconds += Math.floor(nanoseconds / 1000.0);
        nanoseconds = TemporalUtil.nonNegativeModulo(nanoseconds, 1000);
        milliseconds += Math.floor(microseconds / 1000.0);
        microseconds = TemporalUtil.nonNegativeModulo(microseconds, 1000);
        seconds += Math.floor(milliseconds / 1000.0);
        milliseconds = TemporalUtil.nonNegativeModulo(milliseconds, 1000);
        minutes += Math.floor(seconds / 60.0);
        seconds = TemporalUtil.nonNegativeModulo(seconds, 60);
        hours += Math.floor(minutes / 60.0);
        minutes = TemporalUtil.nonNegativeModulo(minutes, 60);
        double days = Math.floor(hours / 24.0);
        hours = TemporalUtil.nonNegativeModulo(hours, 24);
        return new TimeRecord(days, (int)hours, (int)minutes, (int)seconds, (int)milliseconds, (int)microseconds, (int)nanoseconds);
    }

    public static TimeRecord balanceTime(long h2, long min, long sec, long mils, long mics, long ns) {
        long microseconds = mics;
        long milliseconds = mils;
        long nanoseconds = ns;
        long seconds = sec;
        long minutes = min;
        long hours = h2;
        microseconds += Math.floorDiv(nanoseconds, 1000);
        nanoseconds = TemporalUtil.nonNegativeModulo(nanoseconds, 1000);
        milliseconds += Math.floorDiv(microseconds, 1000);
        microseconds = TemporalUtil.nonNegativeModulo(microseconds, 1000);
        seconds += Math.floorDiv(milliseconds, 1000);
        milliseconds = TemporalUtil.nonNegativeModulo(milliseconds, 1000);
        minutes += Math.floorDiv(seconds, 60);
        seconds = TemporalUtil.nonNegativeModulo(seconds, 60);
        hours += Math.floorDiv(minutes, 60);
        minutes = TemporalUtil.nonNegativeModulo(minutes, 60);
        long days = Math.floorDiv(hours, 24);
        hours = TemporalUtil.nonNegativeModulo(hours, 24);
        return new TimeRecord(days, (int)hours, (int)minutes, (int)seconds, (int)milliseconds, (int)microseconds, (int)nanoseconds);
    }

    public static int compareTemporalTime(int h1, int min1, int s1, int ms1, int mus1, int ns1, int h2, int min2, int s2, int ms2, int mus2, int ns2) {
        if (h1 > h2) {
            return 1;
        }
        if (h1 < h2) {
            return -1;
        }
        if (min1 > min2) {
            return 1;
        }
        if (min1 < min2) {
            return -1;
        }
        if (s1 > s2) {
            return 1;
        }
        if (s1 < s2) {
            return -1;
        }
        if (ms1 > ms2) {
            return 1;
        }
        if (ms1 < ms2) {
            return -1;
        }
        if (mus1 > mus2) {
            return 1;
        }
        if (mus1 < mus2) {
            return -1;
        }
        if (ns1 > ns2) {
            return 1;
        }
        if (ns1 < ns2) {
            return -1;
        }
        return 0;
    }

    public static TimeRecord addTimeDouble(int hour, int minute, int second, int millisecond, int microsecond, double nanosecond, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds, Node node, InlinedBranchProfile errorBranch) {
        return TemporalUtil.balanceTimeDouble((double)hour + hours, (double)minute + minutes, (double)second + seconds, (double)millisecond + milliseconds, (double)microsecond + microseconds, nanosecond + nanoseconds, node, errorBranch);
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeRecord addTime(int hour, int minute, int second, int millisecond, int microsecond, double nanosecond, BigInt normalizedTimeDuration, Node node, InlinedBranchProfile errorBranch) {
        BigInt[] qr = normalizedTimeDuration.divideAndRemainder(BI_NS_PER_SECOND);
        double seconds = (double)second + qr[0].doubleValue();
        double nanoseconds = nanosecond + qr[1].doubleValue();
        return TemporalUtil.balanceTimeDouble(hour, minute, seconds, millisecond, microsecond, nanoseconds, node, errorBranch);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDurationRecord roundISODateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond, int increment, Unit unit, RoundingMode roundingMode, Long dayLength) {
        TimeRecord rt = TemporalUtil.roundTime(hour, minute, second, millisecond, microsecond, nanosecond, increment, unit, roundingMode, dayLength);
        ISODateRecord br = TemporalUtil.balanceISODate(year, month, day + TemporalUtil.dtoi(rt.days()));
        return JSTemporalDurationRecord.create(br.year(), br.month(), br.day(), rt.hour(), rt.minute(), rt.second(), rt.millisecond(), rt.microsecond(), rt.nanosecond());
    }

    public static boolean isValidTime(int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds) {
        if (hours < 0 || hours > 23) {
            return false;
        }
        if (minutes < 0 || minutes > 59) {
            return false;
        }
        if (seconds < 0 || seconds > 59) {
            return false;
        }
        if (milliseconds < 0 || milliseconds > 999) {
            return false;
        }
        if (microseconds < 0 || microseconds > 999) {
            return false;
        }
        return nanoseconds >= 0 && nanoseconds <= 999;
    }

    public static boolean isValidISODate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= TemporalUtil.isoDaysInMonth(year, month);
    }

    public static JSTemporalPlainDateTimeObject systemDateTime(Object temporalTimeZoneLike, Object calendarLike, JSContext ctx, JSRealm realm, ToTemporalCalendarSlotValueNode toCalendarSlotValue, ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue) {
        Object timeZone = temporalTimeZoneLike == Undefined.instance ? TemporalUtil.systemTimeZoneIdentifier(realm) : toTimeZoneSlotValue.execute(temporalTimeZoneLike);
        Object calendar = toCalendarSlotValue.execute(calendarLike);
        JSTemporalInstantObject instant = TemporalUtil.systemInstant(ctx, realm);
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(realm, timeZone);
        return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, calendar);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalPlainDateTimeObject builtinTimeZoneGetPlainDateTimeFor(JSContext ctx, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSTemporalInstantObject instant, Object calendar) {
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, instant);
        return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, calendar, offsetNanoseconds);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalPlainDateTimeObject builtinTimeZoneGetPlainDateTimeFor(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, Object calendar, long precalculatedOffsetNanoseconds) {
        long offsetNanoseconds = precalculatedOffsetNanoseconds;
        assert ((double)Math.abs(offsetNanoseconds) < 8.64E13) : offsetNanoseconds;
        JSTemporalDateTimeRecord result = TemporalUtil.getISOPartsFromEpoch(instant.getNanoseconds());
        JSTemporalDateTimeRecord result2 = TemporalUtil.balanceISODateTime(result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), (long)result.getNanosecond() + offsetNanoseconds);
        return JSTemporalPlainDateTime.create(ctx, realm, result2.getYear(), result2.getMonth(), result2.getDay(), result2.getHour(), result2.getMinute(), result2.getSecond(), result2.getMillisecond(), result2.getMicrosecond(), result2.getNanosecond(), calendar);
    }

    public static JSTemporalDateTimeRecord balanceISODateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, long nanosecond) {
        TimeRecord bt = TemporalUtil.balanceTime(hour, minute, second, millisecond, microsecond, nanosecond);
        ISODateRecord bd = TemporalUtil.balanceISODate(year, month, day + (int)bt.days());
        return JSTemporalDateTimeRecord.create(bd.year(), bd.month(), bd.day(), bt.hour(), bt.minute(), bt.second(), bt.millisecond(), bt.microsecond(), bt.nanosecond());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord getISOPartsFromEpoch(BigInt epochNanoseconds) {
        long epochMilliseconds;
        long remainderNs;
        if (epochNanoseconds.fitsInLong()) {
            remainderNs = epochNanoseconds.longValue() % 1000000L;
            epochMilliseconds = (epochNanoseconds.longValue() - remainderNs) / 1000000L;
        } else {
            BigInt[] result = epochNanoseconds.divideAndRemainder(BI_NS_PER_MS);
            remainderNs = result[1].longValue();
            epochMilliseconds = result[0].longValue();
        }
        int year = JSDate.yearFromTime(epochMilliseconds);
        int month = JSDate.monthFromTime(epochMilliseconds) + 1;
        int day = JSDate.dateFromTime(epochMilliseconds);
        int hour = JSDate.hourFromTime(epochMilliseconds);
        int minute = JSDate.minFromTime(epochMilliseconds);
        int second = JSDate.secFromTime(epochMilliseconds);
        int millisecond = JSDate.msFromTime(epochMilliseconds);
        int microsecond = (int)(remainderNs / 1000L % 1000L);
        int nanosecond = (int)(remainderNs % 1000L);
        return JSTemporalDateTimeRecord.create(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
    }

    @CompilerDirectives.TruffleBoundary
    public static long getOffsetNanosecondsFor(JSContext context, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSDynamicObject instant) {
        Object offsetNanoseconds;
        assert (timeZoneRec.getOffsetNanosecondsFor() != null);
        Object getOffsetNanosecondsFor = timeZoneRec.getOffsetNanosecondsFor();
        Object receiver = timeZoneRec.receiver();
        if (receiver instanceof TruffleString) {
            TruffleString identifier = (TruffleString)receiver;
            receiver = TemporalUtil.createTemporalTimeZone(context, realm, identifier);
        }
        if (!JSRuntime.isNumber(offsetNanoseconds = JSRuntime.call(getOffsetNanosecondsFor, receiver, new Object[]{instant})) && !(offsetNanoseconds instanceof Long)) {
            throw Errors.createTypeError("Number expected");
        }
        if (offsetNanoseconds instanceof Integer) {
            Integer intValue = (Integer)offsetNanoseconds;
            return intValue.intValue();
        }
        double nanos = ((Number)offsetNanoseconds).doubleValue();
        if (!JSRuntime.isInteger(nanos) || Math.abs(nanos) >= 8.64E13) {
            throw Errors.createRangeError("out-of-range Number");
        }
        return (long)nanos;
    }

    public static JSTemporalZonedDateTimeObject systemZonedDateTime(Object temporalTimeZoneLike, Object calendarLike, JSContext ctx, JSRealm realm, ToTemporalCalendarSlotValueNode toCalendarSlotValue, ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue) {
        Object timeZone = temporalTimeZoneLike == Undefined.instance ? TemporalUtil.systemTimeZoneIdentifier(realm) : toTimeZoneSlotValue.execute(temporalTimeZoneLike);
        Object calendar = toCalendarSlotValue.execute(calendarLike);
        BigInt ns = TemporalUtil.systemUTCEpochNanoseconds();
        return JSTemporalZonedDateTime.create(ctx, realm, ns, timeZone, calendar);
    }

    public static JSTemporalInstantObject systemInstant(JSContext ctx, JSRealm realm) {
        BigInt ns = TemporalUtil.systemUTCEpochNanoseconds();
        return JSTemporalInstant.create(ctx, realm, ns);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt systemUTCEpochNanoseconds() {
        JSRealm realm = JSRealm.get(null);
        BigInt ns = BigInt.valueOf(realm.nanoTimeWallClock());
        assert (ns.compareTo(upperEpochNSLimit) <= 0 && ns.compareTo(lowerEpochNSLimit) >= 0);
        return ns;
    }

    public static JSTemporalTimeZoneObject systemTimeZone(JSContext ctx, JSRealm realm) {
        return TemporalUtil.createTemporalTimeZone(ctx, realm, TemporalUtil.systemTimeZoneIdentifier(realm));
    }

    public static TruffleString systemTimeZoneIdentifier(JSRealm realm) {
        return Strings.fromJavaString(realm.getLocalTimeZoneId().getId());
    }

    public static boolean isTemporalInstant(Object obj) {
        return JSTemporalInstant.isJSTemporalInstant(obj);
    }

    public static int compareEpochNanoseconds(BigInt one, BigInt two) {
        return one.compareTo(two);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidEpochNanoseconds(BigInt nanoseconds) {
        if (nanoseconds == null) {
            return true;
        }
        return nanoseconds.compareTo(lowerEpochNSLimit) >= 0 && nanoseconds.compareTo(upperEpochNSLimit) <= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addInstant(BigInt epochNanoseconds, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        return TemporalUtil.addInstant(epochNanoseconds, TemporalUtil.dtol(hours), TemporalUtil.dtol(minutes), TemporalUtil.dtol(seconds), TemporalUtil.dtol(milliseconds), TemporalUtil.dtol(microseconds), BigInt.valueOf(TemporalUtil.dtol(nanoseconds)));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addInstant(BigInt epochNanoseconds, long hours, long minutes, long seconds, long milliseconds, long microseconds, BigInt nanoseconds) {
        BigInt result = epochNanoseconds.add(nanoseconds);
        result = result.add(BigInt.valueOf(microseconds).multiply(BI_1000));
        result = result.add(BigInt.valueOf(milliseconds).multiply(BI_NS_PER_MS));
        result = result.add(BigInt.valueOf(seconds).multiply(BI_NS_PER_SECOND));
        result = result.add(BigInt.valueOf(minutes).multiply(BI_NS_PER_MINUTE));
        if (!TemporalUtil.isValidEpochNanoseconds(result = result.add(BigInt.valueOf(hours).multiply(BI_NS_PER_HOUR)))) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt addInstant(BigInt epochNanoseconds, BigInt normalizedTimeDuration) {
        BigInt result = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(normalizedTimeDuration, epochNanoseconds);
        if (!TemporalUtil.isValidEpochNanoseconds(result)) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static NormalizedTimeDurationWithTotalRecord differenceInstant(BigInt ns1, BigInt ns2, int roundingIncrement, Unit smallestUnit, RoundingMode roundingMode) {
        BigInt difference = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(ns2, ns1);
        NormalizedDurationWithTotalRecord roundRecord = TemporalUtil.roundTimeDuration(0.0, difference, roundingIncrement, smallestUnit, roundingMode);
        return new NormalizedTimeDurationWithTotalRecord(roundRecord.normalizedDuration().normalizedTimeTotalNanoseconds(), roundRecord.total());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalInstantToString(JSContext ctx, JSRealm realm, JSTemporalInstantObject instant, Object timeZone, Object precision) {
        Object outputTimeZone = timeZone;
        if (outputTimeZone == Undefined.instance) {
            outputTimeZone = TemporalConstants.UTC;
        }
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(realm, outputTimeZone);
        long offsetNs = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, instant);
        JSTemporalPlainDateTimeObject dateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, TemporalConstants.ISO8601, offsetNs);
        TruffleString dateTimeString = JSTemporalPlainDateTime.temporalDateTimeToString(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), Undefined.instance, precision, ShowCalendar.NEVER);
        TruffleString timeZoneString = timeZone == Undefined.instance ? Strings.UC_Z : TemporalUtil.formatISOTimeZoneOffsetString(offsetNs);
        return Strings.concat(dateTimeString, timeZoneString);
    }

    public static TimeZoneMethodsRecord createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(JSRealm realm, Object timeZone) {
        Object getOffsetNanosecondsForMethod = timeZone instanceof TruffleString ? realm.getTemporalTimeZoneGetOffsetNanosecondsForFunctionObject() : JSRuntime.get(timeZone, TemporalConstants.GET_OFFSET_NANOSECONDS_FOR);
        return new TimeZoneMethodsRecord(timeZone, getOffsetNanosecondsForMethod, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString builtinTimeZoneGetOffsetStringFor(JSContext context, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSDynamicObject instant) {
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(context, realm, timeZoneRec, instant);
        return TemporalUtil.formatTimeZoneOffsetString(offsetNanoseconds);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatTimeZoneOffsetString(long offsetNanosecondsParam) {
        TruffleString sign = offsetNanosecondsParam >= 0L ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        long offsetNanoseconds = Math.abs(offsetNanosecondsParam);
        long nanoseconds = offsetNanoseconds % 1000000000L;
        double s1 = Math.floor((double)offsetNanoseconds / 1.0E9) % 60.0;
        double m1 = Math.floor((double)offsetNanoseconds / 6.0E10) % 60.0;
        double h1 = Math.floor((double)offsetNanoseconds / 3.6E12);
        long seconds = (long)s1;
        long minutes = (long)m1;
        long hours = (long)h1;
        TruffleString h2 = TemporalUtil.toZeroPaddedDecimalString(hours, 2);
        TruffleString m2 = TemporalUtil.toZeroPaddedDecimalString(minutes, 2);
        TruffleString s2 = TemporalUtil.toZeroPaddedDecimalString(seconds, 2);
        TruffleString post = Strings.EMPTY_STRING;
        if (nanoseconds != 0L) {
            TruffleString fraction = TemporalUtil.longestSubstring(TemporalUtil.toZeroPaddedDecimalString(nanoseconds, 9));
            post = Strings.concatAll(Strings.COLON, s2, Strings.DOT, fraction);
        } else if (seconds != 0L) {
            post = Strings.concat(Strings.COLON, s2);
        }
        return Strings.concatAll(sign, h2, Strings.COLON, m2, post);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseTimeZoneOffsetString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseTimeZoneNumericUTCOffset();
        if (rec == null) {
            throw Errors.createRangeError("TemporalTimeZoneNumericUTCOffset expected");
        }
        return TemporalUtil.parseTimeZoneOffsetNs(rec);
    }

    private static long parseTimeZoneOffsetNs(JSTemporalParserRecord rec) {
        long nanoseconds;
        if (rec.getOffsetFraction() == null) {
            nanoseconds = 0L;
        } else {
            TruffleString fraction = Strings.concat(rec.getOffsetFraction(), TemporalConstants.ZEROS);
            fraction = Strings.lazySubstring(fraction, 0, 9);
            try {
                nanoseconds = Strings.parseLong(fraction, 10);
            }
            catch (TruffleString.NumberFormatException e2) {
                throw CompilerDirectives.shouldNotReachHere(e2);
            }
        }
        TruffleString signS = rec.getOffsetSign();
        int sign = Strings.SYMBOL_MINUS.equals(signS) || Strings.UNICODE_MINUS_SIGN.equals(signS) ? -1 : 1;
        long hours = rec.getOffsetHour() == Long.MIN_VALUE ? 0L : rec.getOffsetHour();
        long minutes = rec.getOffsetMinute() == Long.MIN_VALUE ? 0L : rec.getOffsetMinute();
        long seconds = rec.getOffsetSecond() == Long.MIN_VALUE ? 0L : rec.getOffsetSecond();
        return (long)sign * (((hours * 60L + minutes) * 60L + seconds) * 1000000000L + nanoseconds);
    }

    public static JSTemporalTimeZoneRecord parseTemporalTimeZoneString(TruffleString string) {
        return TemporalUtil.parseTemporalTimeZoneString(string, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSTemporalTimeZoneRecord parseTemporalTimeZoneString(TruffleString string, boolean offsetRequired) {
        JSTemporalParserRecord rec;
        TemporalParser parser = new TemporalParser(string);
        if (offsetRequired) {
            rec = parser.parseISODateTime();
        } else {
            rec = parser.parseTimeZoneIdentifier();
            if (rec == null && (rec = parser.parseISODateTime()) != null) {
                if (rec.getTimeZoneANYName() != null) {
                    rec = new TemporalParser(rec.getTimeZoneANYName()).parseTimeZoneIdentifier();
                } else if (rec.getTimeZoneNumericUTCOffset() != null) {
                    rec = new TemporalParser(rec.getTimeZoneNumericUTCOffset()).parseTimeZoneIdentifier();
                } else if (!rec.getZ()) {
                    rec = null;
                }
            }
        }
        if (rec == null) {
            throw Errors.createRangeError("TemporalTimeZoneString expected");
        }
        if (offsetRequired && rec.getOffsetHour() == Long.MIN_VALUE && !rec.getZ()) {
            throw TemporalErrors.createRangeErrorTimeZoneOffsetExpected();
        }
        TruffleString name = rec.getTimeZoneIANAName();
        TruffleString offsetString = rec.getTimeZoneNumericUTCOffset();
        if (rec.getZ()) {
            return JSTemporalTimeZoneRecord.create(true, null, name);
        }
        return JSTemporalTimeZoneRecord.create(false, offsetString, name);
    }

    public static Disambiguation toTemporalDisambiguation(JSDynamicObject options, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        if (options == Undefined.instance) {
            return Disambiguation.COMPATIBLE;
        }
        return TemporalUtil.toDisambiguation((TruffleString)getOptionNode.execute(options, TemporalConstants.DISAMBIGUATION, OptionType.STRING, listDisambiguation, TemporalConstants.COMPATIBLE), equalNode);
    }

    public static OffsetOption toTemporalOffset(JSDynamicObject options, TruffleString fallback, TemporalGetOptionNode getOptionNode, TruffleString.EqualNode equalNode) {
        TruffleString result = fallback;
        if (options != Undefined.instance) {
            result = (TruffleString)getOptionNode.execute(options, TemporalConstants.OFFSET, OptionType.STRING, listOffsets, fallback);
        }
        return TemporalUtil.toOffsetOption(result, equalNode);
    }

    public static TruffleString toShowTimeZoneNameOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        return (TruffleString)getOptionNode.execute(options, TemporalConstants.TIME_ZONE_NAME, OptionType.STRING, listAutoNeverCritical, TemporalConstants.AUTO);
    }

    public static TruffleString toShowOffsetOption(JSDynamicObject options, TemporalGetOptionNode getOptionNode) {
        return (TruffleString)getOptionNode.execute(options, TemporalConstants.OFFSET, OptionType.STRING, listAutoNever, TemporalConstants.AUTO);
    }

    public static TruffleString temporalZonedDateTimeToString(JSContext ctx, JSRealm realm, JSDynamicObject zonedDateTime, Object precision, ShowCalendar showCalendar, TruffleString showTimeZone, TruffleString showOffset) {
        return TemporalUtil.temporalZonedDateTimeToString(ctx, realm, zonedDateTime, precision, showCalendar, showTimeZone, showOffset, null, Unit.EMPTY, RoundingMode.EMPTY);
    }

    public static int compareISODateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, int year2, int month2, int day2, int hours2, int minutes2, int seconds2, int milliseconds2, int microseconds2, int nanoseconds2) {
        int date = TemporalUtil.compareISODate(year, month, day, year2, month2, day2);
        if (date == 0) {
            return TemporalUtil.compareTemporalTime(hours, minutes, seconds, milliseconds, microseconds, nanoseconds, hours2, minutes2, seconds2, milliseconds2, microseconds2, nanoseconds2);
        }
        return date;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalDateTimeRecord parseTemporalYearMonthString(TruffleString string) {
        JSTemporalParserRecord rec = new TemporalParser(string).parseYearMonth();
        if (rec != null) {
            if (rec.getZ()) {
                throw TemporalErrors.createRangeErrorUnexpectedUTCDesignator();
            }
            if (rec.getYear() == 0L && (Strings.indexOf(string, TemporalConstants.MINUS_000000) >= 0 || Strings.indexOf(string, TemporalConstants.UNICODE_MINUS_SIGN_000000) >= 0)) {
                throw TemporalErrors.createRangeErrorInvalidPlainDateTime();
            }
            int y2 = rec.getYear() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getYear());
            int m2 = rec.getMonth() == Long.MIN_VALUE ? 0 : TemporalUtil.ltoi(rec.getMonth());
            int d2 = rec.getDay() == Long.MIN_VALUE ? 1 : TemporalUtil.ltoi(rec.getDay());
            return JSTemporalDateTimeRecord.createCalendar(y2, m2, d2, 0, 0, 0, 0, 0, 0, rec.getCalendar());
        }
        throw Errors.createRangeError("cannot parse YearMonth");
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalZonedDateTimeToString(JSContext ctx, JSRealm realm, JSDynamicObject zonedDateTimeParam, Object precision, ShowCalendar showCalendar, TruffleString showTimeZone, TruffleString showOffset, Integer incrementParam, Unit unitParam, RoundingMode roundingModeParam) {
        assert (TemporalUtil.isTemporalZonedDateTime(zonedDateTimeParam));
        assert (unitParam != null && roundingModeParam != null);
        JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)zonedDateTimeParam;
        int increment = incrementParam == null ? 1 : incrementParam;
        Unit unit = unitParam == Unit.EMPTY ? Unit.NANOSECOND : unitParam;
        RoundingMode roundingMode = roundingModeParam == RoundingMode.EMPTY ? RoundingMode.TRUNC : roundingModeParam;
        BigInt ns = TemporalUtil.roundTemporalInstant(zonedDateTime.getNanoseconds(), increment, unit, roundingMode);
        Object timeZone = zonedDateTime.getTimeZone();
        JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, ns);
        JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(ctx, realm);
        TimeZoneMethodsRecord timeZoneRec = TemporalUtil.createTimeZoneMethodsRecordOnlyGetOffsetNanosecondsFor(realm, zonedDateTime.getTimeZone());
        long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, instant);
        JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, instant, isoCalendar, offsetNanoseconds);
        TruffleString dateTimeString = JSTemporalPlainDateTime.temporalDateTimeToString(temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), isoCalendar, precision, ShowCalendar.NEVER);
        TruffleString offsetString = null;
        TruffleString timeZoneString = null;
        offsetString = TemporalConstants.NEVER.equals(showOffset) ? Strings.EMPTY_STRING : TemporalUtil.formatISOTimeZoneOffsetString(offsetNanoseconds);
        if (TemporalConstants.NEVER.equals(showTimeZone)) {
            timeZoneString = Strings.EMPTY_STRING;
        } else {
            TruffleString timeZoneID = ToTemporalTimeZoneIdentifierNode.getUncached().executeString(timeZone);
            if (TemporalConstants.CRITICAL.equals(showTimeZone)) {
                timeZoneID = Strings.concat(Strings.EXCLAMATION_MARK, timeZoneID);
            }
            timeZoneString = Strings.addBrackets(timeZoneID);
        }
        TruffleString calendarString = TemporalUtil.maybeFormatCalendarAnnotation(zonedDateTime.getCalendar(), showCalendar);
        return Strings.concatAll(dateTimeString, offsetString, timeZoneString, calendarString);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatISOTimeZoneOffsetString(long offsetNs) {
        long offsetNanoseconds = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(offsetNs, 6.0E10, RoundingMode.HALF_EXPAND));
        TruffleString sign = Strings.EMPTY_STRING;
        sign = offsetNanoseconds >= 0L ? Strings.SYMBOL_PLUS : Strings.SYMBOL_MINUS;
        offsetNanoseconds = Math.abs(offsetNanoseconds);
        long minutes = offsetNanoseconds / 60000000000L % 60L;
        long hours = (long)Math.floor(offsetNanoseconds / 3600000000000L);
        TruffleString h2 = TemporalUtil.toZeroPaddedDecimalString(hours, 2);
        TruffleString m2 = TemporalUtil.toZeroPaddedDecimalString(minutes, 2);
        return Strings.concatAll(sign, h2, Strings.COLON, m2);
    }

    @CompilerDirectives.TruffleBoundary
    public static ParseISODateTimeResult parseTemporalZonedDateTimeString(TruffleString string) {
        if (!new TemporalParser(string).isTemporalZonedDateTimeString()) {
            throw Errors.createRangeError("cannot be parsed as TemporalZonedDateTimeString");
        }
        try {
            return TemporalUtil.parseISODateTime(string);
        }
        catch (Exception ex) {
            throw Errors.createRangeError("cannot be parsed as TemporalZonedDateTimeString");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt parseTemporalInstant(TruffleString string) {
        long offsetNanoseconds;
        ParseISODateTimeResult result = TemporalUtil.parseTemporalInstantString(string);
        TruffleString offsetString = result.getTimeZoneResult().getOffsetString();
        assert (offsetString != null);
        BigInt utc = TemporalUtil.getUTCEpochNanoseconds(result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond());
        BigInt instant = utc.subtract(BigInt.valueOf(offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString)));
        if (!TemporalUtil.isValidEpochNanoseconds(instant)) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        return instant;
    }

    @CompilerDirectives.TruffleBoundary
    private static ParseISODateTimeResult parseTemporalInstantString(TruffleString string) {
        try {
            ParseISODateTimeResult result = TemporalUtil.parseISODateTime(string);
            JSTemporalTimeZoneRecord timeZoneResult = TemporalUtil.parseTemporalTimeZoneString(string, true);
            TruffleString offsetString = timeZoneResult.getOffsetString();
            if (timeZoneResult.isZ()) {
                offsetString = TemporalConstants.OFFSET_ZERO;
            }
            assert (offsetString != null);
            return result.withTimeZoneResult(JSTemporalTimeZoneRecord.create(timeZoneResult.isZ(), offsetString, timeZoneResult.getName()));
        }
        catch (Exception ex) {
            throw Errors.createRangeError("Instant cannot be parsed");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalInstantObject builtinTimeZoneGetInstantFor(JSContext ctx, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject dateTime, Disambiguation disambiguation) {
        List<JSTemporalInstantObject> possibleInstants = TemporalUtil.getPossibleInstantsFor(ctx, realm, timeZoneRec, dateTime);
        return TemporalUtil.disambiguatePossibleInstants(ctx, realm, possibleInstants, timeZoneRec, dateTime, disambiguation);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSTemporalInstantObject disambiguatePossibleInstants(JSContext ctx, JSRealm realm, List<JSTemporalInstantObject> possibleInstants, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject dateTime, Disambiguation disambiguation) {
        int n2 = possibleInstants.size();
        if (n2 == 1) {
            return possibleInstants.get(0);
        }
        if (n2 != 0) {
            if (Disambiguation.EARLIER == disambiguation || Disambiguation.COMPATIBLE == disambiguation) {
                return possibleInstants.get(0);
            }
            if (Disambiguation.LATER == disambiguation) {
                return possibleInstants.get(n2 - 1);
            }
            assert (Disambiguation.REJECT == disambiguation);
            throw Errors.createRangeError("invalid disambiguation");
        }
        assert (n2 == 0);
        if (Disambiguation.REJECT == disambiguation) {
            throw Errors.createRangeError("disambiguation failed");
        }
        BigInt epochNanoseconds = TemporalUtil.getUTCEpochNanoseconds(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond());
        BigInt dayBeforeNs = epochNanoseconds.subtract(BI_NS_PER_DAY);
        BigInt dayAfterNs = epochNanoseconds.add(BI_NS_PER_DAY);
        if (!TemporalUtil.isValidEpochNanoseconds(dayBeforeNs) || !TemporalUtil.isValidEpochNanoseconds(dayAfterNs)) {
            throw TemporalErrors.createRangeErrorInvalidNanoseconds();
        }
        JSTemporalInstantObject dayBefore = JSTemporalInstant.create(ctx, realm, dayBeforeNs);
        JSTemporalInstantObject dayAfter = JSTemporalInstant.create(ctx, realm, dayAfterNs);
        long offsetBefore = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, dayBefore);
        long offsetAfter = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, dayAfter);
        long nanoseconds = offsetAfter - offsetBefore;
        if (Disambiguation.EARLIER == disambiguation) {
            TimeRecord earlierTime = TemporalUtil.addTimeDouble(dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), 0.0, 0.0, 0.0, 0.0, 0.0, -nanoseconds, null, InlinedBranchProfile.getUncached());
            ISODateRecord earlierDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, TemporalUtil.dtoi(earlierTime.days()), Overflow.CONSTRAIN);
            JSTemporalPlainDateTimeObject earlierDateTime = JSTemporalPlainDateTime.create(ctx, realm, earlierDate.year(), earlierDate.month(), earlierDate.day(), earlierTime.hour(), earlierTime.minute(), earlierTime.second(), earlierTime.millisecond(), earlierTime.microsecond(), earlierTime.nanosecond(), TemporalConstants.ISO8601, null, InlinedBranchProfile.getUncached());
            List<JSTemporalInstantObject> possibleInstants2 = TemporalUtil.getPossibleInstantsFor(ctx, realm, timeZoneRec, earlierDateTime);
            if (possibleInstants2.size() == 0) {
                throw Errors.createRangeError("nothing found");
            }
            return possibleInstants2.get(0);
        }
        assert (Disambiguation.LATER == disambiguation || Disambiguation.COMPATIBLE == disambiguation);
        TimeRecord laterTime = TemporalUtil.addTimeDouble(dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), 0.0, 0.0, 0.0, 0.0, 0.0, nanoseconds, null, InlinedBranchProfile.getUncached());
        ISODateRecord laterDate = TemporalUtil.addISODate(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, TemporalUtil.dtoi(laterTime.days()), Overflow.CONSTRAIN);
        JSTemporalPlainDateTimeObject laterDateTime = JSTemporalPlainDateTime.create(ctx, realm, laterDate.year(), laterDate.month(), laterDate.day(), laterTime.hour(), laterTime.minute(), laterTime.second(), laterTime.millisecond(), laterTime.microsecond(), laterTime.nanosecond(), TemporalConstants.ISO8601, null, InlinedBranchProfile.getUncached());
        List<JSTemporalInstantObject> possibleInstants2 = TemporalUtil.getPossibleInstantsFor(ctx, realm, timeZoneRec, laterDateTime);
        n2 = possibleInstants2.size();
        if (n2 == 0) {
            throw Errors.createRangeError("nothing found");
        }
        return possibleInstants2.get(n2 - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt interpretISODateTimeOffset(JSContext ctx, JSRealm realm, int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond, OffsetBehaviour offsetBehaviour, Object offsetNanosecondsParam, TimeZoneMethodsRecord timeZoneRec, Disambiguation disambiguation, OffsetOption offsetOption, MatchBehaviour matchBehaviour) {
        double offsetNs = offsetNanosecondsParam == null || offsetNanosecondsParam == Undefined.instance ? Double.NaN : ((Number)offsetNanosecondsParam).doubleValue();
        JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(ctx, realm);
        JSTemporalPlainDateTimeObject dateTime = JSTemporalPlainDateTime.create(ctx, realm, year, month, day, hour, minute, second, millisecond, microsecond, nanosecond, calendar);
        if (offsetBehaviour == OffsetBehaviour.WALL || OffsetOption.IGNORE == offsetOption) {
            JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTime, disambiguation);
            return instant.getNanoseconds();
        }
        if (offsetBehaviour == OffsetBehaviour.EXACT || OffsetOption.USE == offsetOption) {
            BigInt epochNanoseconds = TemporalUtil.getUTCEpochNanoseconds(year, month, day, hour, minute, second, millisecond, microsecond, nanosecond);
            return epochNanoseconds.subtract(BigInt.valueOf((long)offsetNs));
        }
        assert (offsetBehaviour == OffsetBehaviour.OPTION);
        assert (OffsetOption.PREFER == offsetOption || OffsetOption.REJECT == offsetOption);
        List<JSTemporalInstantObject> possibleInstants = TemporalUtil.getPossibleInstantsFor(ctx, realm, timeZoneRec, dateTime);
        for (JSTemporalInstantObject candidate : possibleInstants) {
            long roundedCandidateNanoseconds;
            long candidateNanoseconds = TemporalUtil.getOffsetNanosecondsFor(ctx, realm, timeZoneRec, candidate);
            if ((double)candidateNanoseconds == offsetNs) {
                return candidate.getNanoseconds();
            }
            if (matchBehaviour != MatchBehaviour.MATCH_MINUTES || (double)(roundedCandidateNanoseconds = TemporalUtil.dtol(TemporalUtil.roundNumberToIncrement(candidateNanoseconds, 6.0E10, RoundingMode.HALF_EXPAND))) != offsetNs) continue;
            return candidate.getNanoseconds();
        }
        if (OffsetOption.REJECT == offsetOption) {
            throw Errors.createRangeError("cannot interpret DateTime offset");
        }
        JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, dateTime, disambiguation);
        return instant.getNanoseconds();
    }

    public static boolean timeZoneEquals(Object tz1, Object tz2, ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier) {
        if (tz1 == tz2) {
            return true;
        }
        TruffleString s1 = toTimeZoneIdentifier.executeString(tz1);
        TruffleString s2 = toTimeZoneIdentifier.executeString(tz2);
        return Boundaries.equals(s1, s2);
    }

    public static Object consolidateCalendars(Object one, Object two, ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
        if (one == two) {
            return two;
        }
        TruffleString s1 = toCalendarIdentifier.executeString(one);
        TruffleString s2 = toCalendarIdentifier.executeString(two);
        return TemporalUtil.consolidateCalendarsIntl(one, two, s1, s2);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object consolidateCalendarsIntl(Object one, Object two, TruffleString s1, TruffleString s2) {
        if (s1.equals(s2)) {
            return two;
        }
        if (TemporalConstants.ISO8601.equals(s1)) {
            return two;
        }
        if (TemporalConstants.ISO8601.equals(s2)) {
            return one;
        }
        throw Errors.createRangeError("cannot consolidate calendars");
    }

    private static List<JSTemporalInstantObject> getPossibleInstantsFor(JSContext context, JSRealm realm, TimeZoneMethodsRecord timeZoneRec, JSDynamicObject dateTime) {
        assert (timeZoneRec.getPossibleInstantsFor() != null);
        Object receiver = timeZoneRec.receiver();
        boolean isBuiltin = false;
        if (receiver instanceof TruffleString) {
            TruffleString identifier = (TruffleString)receiver;
            isBuiltin = true;
            receiver = TemporalUtil.createTemporalTimeZone(context, realm, identifier);
        }
        Object possibleInstants = JSRuntime.call(timeZoneRec.getPossibleInstantsFor(), receiver, new Object[]{dateTime});
        ArrayList<JSTemporalInstantObject> list = new ArrayList<JSTemporalInstantObject>();
        if (isBuiltin) {
            JSDynamicObject possibleInstantsObject = (JSDynamicObject)possibleInstants;
            long len = JSRuntime.toLength(JSObject.get(possibleInstantsObject, JSAbstractArray.LENGTH));
            for (long index = 0L; index < len; ++index) {
                Object next = JSObject.get(possibleInstantsObject, index);
                list.add((JSTemporalInstantObject)next);
            }
            return list;
        }
        IteratorRecord iteratorRecord = JSRuntime.getIterator(possibleInstants);
        Object next = true;
        while (next != Boolean.FALSE) {
            next = JSRuntime.iteratorStep(iteratorRecord);
            if (next == Boolean.FALSE) continue;
            Object nextValue = JSRuntime.iteratorValue(next);
            if (!TemporalUtil.isTemporalInstant(nextValue)) {
                JSRuntime.iteratorClose(possibleInstants);
                throw Errors.createTypeError("unexpected value");
            }
            list.add((JSTemporalInstantObject)nextValue);
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<BigInt> getIANATimeZoneEpochValue(TruffleString identifier, long isoYear, long isoMonth, long isoDay, long hours, long minutes, long seconds, long milliseconds, long microseconds, long nanoseconds) {
        ArrayList<BigInt> list;
        block2: {
            list = new ArrayList<BigInt>();
            try {
                ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
                long fractions = milliseconds * 1000000L + microseconds * 1000L + nanoseconds;
                ZonedDateTime zdt = ZonedDateTime.of((int)isoYear, (int)isoMonth, (int)isoDay, (int)hours, (int)minutes, (int)seconds, (int)fractions, zoneId);
                list.add(BigInt.valueOf(zdt.toEpochSecond()).multiply(BigInt.valueOf(1000000000L)).add(BigInt.valueOf(fractions)));
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static double getIANATimeZoneOffsetNanoseconds(BigInt nanoseconds, TruffleString identifier) {
        try {
            Instant instant = Instant.ofEpochSecond(0L, nanoseconds.longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffset offset = zoneRule.getOffset(instant);
            return (double)offset.getTotalSeconds() * 1.0E9;
        }
        catch (Exception ex) {
            assert (false);
            return -9.223372036854776E18;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static OptionalLong getIANATimeZoneNextTransition(BigInt nanoseconds, TruffleString identifier) {
        try {
            BigInt[] sec = nanoseconds.divideAndRemainder(BI_NS_PER_SECOND);
            Instant instant = Instant.ofEpochSecond(sec[0].longValue(), sec[1].longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffsetTransition nextTransition = zoneRule.nextTransition(instant);
            if (nextTransition == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(nextTransition.toEpochSecond() * 1000000000L);
        }
        catch (Exception ex) {
            assert (false);
            return OptionalLong.of(Long.MIN_VALUE);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static OptionalLong getIANATimeZonePreviousTransition(BigInt nanoseconds, TruffleString identifier) {
        try {
            BigInt[] sec = nanoseconds.divideAndRemainder(BI_NS_PER_SECOND);
            Instant instant = Instant.ofEpochSecond(sec[0].longValue(), sec[1].longValue());
            ZoneId zoneId = ZoneId.of(Strings.toJavaString(identifier));
            ZoneRules zoneRule = zoneId.getRules();
            ZoneOffsetTransition previousTransition = zoneRule.previousTransition(instant);
            if (previousTransition == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(previousTransition.toEpochSecond() * 1000000000L);
        }
        catch (Exception ex) {
            assert (false);
            return OptionalLong.empty();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean canParseAsTimeZoneNumericUTCOffset(TruffleString string) {
        try {
            return new TemporalParser(string).parseTimeZoneNumericUTCOffset() != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isoYearMonthWithinLimits(int year, int month) {
        if (year < -271821 || year > 275760) {
            return false;
        }
        if (year == -271821 && month < 4) {
            return false;
        }
        return year != 275760 || month <= 9;
    }

    public static Number calendarYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.YEAR);
    }

    public static Number calendarMonth(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.MONTH);
    }

    public static TruffleString calendarMonthCode(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.executeString(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.MONTH_CODE);
    }

    public static Number calendarDay(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.executeInteger(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAY);
    }

    public static Object calendarDayOfWeek(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAY_OF_WEEK);
    }

    public static Object calendarDayOfYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAY_OF_YEAR);
    }

    public static Object calendarWeekOfYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.WEEK_OF_YEAR);
    }

    public static Object calendarYearOfWeek(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.YEAR_OF_WEEK);
    }

    public static Object calendarDaysInWeek(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAYS_IN_WEEK);
    }

    public static Object calendarDaysInMonth(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAYS_IN_MONTH);
    }

    public static Object calendarDaysInYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.DAYS_IN_YEAR);
    }

    public static Object calendarMonthsInYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.MONTHS_IN_YEAR);
    }

    public static Object calendarInLeapYear(TemporalCalendarGetterNode getterNode, Object calendar, JSDynamicObject dateLike) {
        return getterNode.execute(calendar, dateLike, CalendarMethodsRecordLookupNode.Key.IN_LEAP_YEAR);
    }

    @CompilerDirectives.TruffleBoundary
    public static void isoResolveMonth(JSContext ctx, JSDynamicObject fields, JSToIntegerOrInfinityNode toIntegerOrInfinity) {
        Object month = JSObject.get(fields, TemporalConstants.MONTH);
        Object monthCode = JSObject.get(fields, TemporalConstants.MONTH_CODE);
        if (monthCode == Undefined.instance) {
            if (month == Undefined.instance) {
                throw Errors.createTypeError("No month or month code present.");
            }
            return;
        }
        int monthLength = Strings.length((TruffleString)monthCode);
        if (monthLength != 3) {
            throw Errors.createRangeError("Month code should be in 3 character code.");
        }
        if (Strings.charAt((TruffleString)monthCode, 0) != 'M') {
            throw Errors.createRangeError("Month code should start with 'M'");
        }
        TruffleString monthCodeDigits = Strings.substring(ctx, (TruffleString)monthCode, 1);
        double monthCodeInteger = JSRuntime.doubleValue(toIntegerOrInfinity.executeNumber(monthCodeDigits));
        if (Double.isNaN(monthCodeInteger) || monthCodeInteger < 1.0 || monthCodeInteger > 12.0) {
            throw Errors.createRangeErrorFormat("Invalid month code: %s", null, monthCode);
        }
        if (month != Undefined.instance && JSRuntime.doubleValue((Number)month) != monthCodeInteger) {
            throw Errors.createRangeError("Month does not equal the month code.");
        }
        TemporalUtil.createDataPropertyOrThrow(ctx, fields, TemporalConstants.MONTH, monthCodeInteger);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord isoDateFromFields(JSDynamicObject fields, Overflow overflow) {
        Number year = (Number)JSObject.get(fields, TemporalConstants.YEAR);
        Number month = (Number)JSObject.get(fields, TemporalConstants.MONTH);
        Number day = (Number)JSObject.get(fields, TemporalConstants.DAY);
        return TemporalUtil.regulateISODate(TemporalUtil.dtoi(JSRuntime.doubleValue(year)), TemporalUtil.dtoi(JSRuntime.doubleValue(month)), TemporalUtil.dtoi(JSRuntime.doubleValue(day)), overflow);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord isoYearMonthFromFields(JSDynamicObject fields, Overflow overflow) {
        Number year = (Number)JSObject.get(fields, TemporalConstants.YEAR);
        Number month = (Number)JSObject.get(fields, TemporalConstants.MONTH);
        ISOYearMonthRecord result = TemporalUtil.regulateISOYearMonth(TemporalUtil.dtoi(JSRuntime.doubleValue(year)), TemporalUtil.dtoi(JSRuntime.doubleValue(month)), overflow);
        return new ISODateRecord(result.year(), result.month(), 1);
    }

    @CompilerDirectives.TruffleBoundary
    public static ISODateRecord isoMonthDayFromFields(JSDynamicObject fields, Overflow overflow) {
        Number month = (Number)JSObject.get(fields, TemporalConstants.MONTH);
        Number day = (Number)JSObject.get(fields, TemporalConstants.DAY);
        Object year = JSObject.get(fields, TemporalConstants.YEAR);
        int referenceISOYear = 1972;
        int yearForRegulateISODate = year == Undefined.instance ? referenceISOYear : TemporalUtil.dtoi(JSRuntime.doubleValue((Number)year));
        ISODateRecord result = TemporalUtil.regulateISODate(yearForRegulateISODate, TemporalUtil.dtoi(JSRuntime.doubleValue(month)), TemporalUtil.dtoi(JSRuntime.doubleValue(day)), overflow);
        return new ISODateRecord(referenceISOYear, result.month(), result.day());
    }

    public static JSTemporalDurationRecord createDurationRecord(double years, double months, double weeks, double days, double hours, double minutes, double seconds, double milliseconds, double microseconds, double nanoseconds) {
        if (!TemporalUtil.isValidDuration(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds)) {
            throw TemporalErrors.createTypeErrorDurationOutsideRange();
        }
        return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }

    public static long dtol(double d2) {
        assert (JSRuntime.doubleIsRepresentableAsLong(d2));
        return (long)d2;
    }

    public static int dtoi(double d2) {
        if (d2 == 0.0) {
            return 0;
        }
        assert (JSRuntime.doubleIsRepresentableAsInt(d2));
        return (int)d2;
    }

    @CompilerDirectives.TruffleBoundary
    public static long dtol(double d2, boolean failOnError) {
        if (failOnError && !JSRuntime.doubleIsRepresentableAsLong(d2)) {
            throw Errors.createRangeError("value out of range");
        }
        return (long)d2;
    }

    @CompilerDirectives.TruffleBoundary
    public static int ltoi(long l2) {
        if (!JSRuntime.longIsRepresentableAsInt(l2)) {
            throw Errors.createRangeError("value out of range");
        }
        return (int)l2;
    }

    @CompilerDirectives.TruffleBoundary
    public static int bitoi(BigInt bi) {
        double value = bi.doubleValue();
        assert (Double.isFinite(value));
        assert (JSRuntime.doubleIsRepresentableAsInt(value));
        return bi.intValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static long bigIntToLong(BigInt val) {
        return val.longValueExact();
    }

    @CompilerDirectives.TruffleBoundary
    private static int add(int a2, int b2, Overflow overflow) {
        try {
            return Math.addExact(a2, b2);
        }
        catch (ArithmeticException ex) {
            if (overflow == Overflow.REJECT) {
                throw TemporalErrors.createRangeErrorDateOutsideRange();
            }
            assert (overflow == Overflow.CONSTRAIN);
            return Integer.MAX_VALUE;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static RoundingMode toRoundingMode(TruffleString mode, TruffleString.EqualNode equalNode) {
        if (mode == null) {
            return RoundingMode.EMPTY;
        }
        if (equalNode.execute(mode, TemporalConstants.FLOOR, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.FLOOR;
        }
        if (equalNode.execute(mode, TemporalConstants.CEIL, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.CEIL;
        }
        if (equalNode.execute(mode, TemporalConstants.EXPAND, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.EXPAND;
        }
        if (equalNode.execute(mode, TemporalConstants.TRUNC, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.TRUNC;
        }
        if (equalNode.execute(mode, TemporalConstants.HALF_FLOOR, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_FLOOR;
        }
        if (equalNode.execute(mode, TemporalConstants.HALF_CEIL, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_CEIL;
        }
        if (equalNode.execute(mode, TemporalConstants.HALF_EXPAND, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_EXPAND;
        }
        if (equalNode.execute(mode, TemporalConstants.HALF_TRUNC, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_TRUNC;
        }
        if (equalNode.execute(mode, TemporalConstants.HALF_EVEN, TruffleString.Encoding.UTF_16)) {
            return RoundingMode.HALF_EVEN;
        }
        throw Errors.shouldNotReachHereUnexpectedValue(mode);
    }

    @CompilerDirectives.TruffleBoundary
    public static Disambiguation toDisambiguation(TruffleString disambiguation, TruffleString.EqualNode equalNode) {
        if (equalNode.execute(disambiguation, TemporalConstants.EARLIER, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.EARLIER;
        }
        if (equalNode.execute(disambiguation, TemporalConstants.LATER, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.LATER;
        }
        if (equalNode.execute(disambiguation, TemporalConstants.COMPATIBLE, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.COMPATIBLE;
        }
        if (equalNode.execute(disambiguation, TemporalConstants.REJECT, TruffleString.Encoding.UTF_16)) {
            return Disambiguation.REJECT;
        }
        throw Errors.shouldNotReachHereUnexpectedValue(disambiguation);
    }

    @CompilerDirectives.TruffleBoundary
    public static OffsetOption toOffsetOption(TruffleString offsetOption, TruffleString.EqualNode equalNode) {
        if (equalNode.execute(offsetOption, TemporalConstants.USE, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.USE;
        }
        if (equalNode.execute(offsetOption, TemporalConstants.IGNORE, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.IGNORE;
        }
        if (equalNode.execute(offsetOption, TemporalConstants.PREFER, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.PREFER;
        }
        if (equalNode.execute(offsetOption, TemporalConstants.REJECT, TruffleString.Encoding.UTF_16)) {
            return OffsetOption.REJECT;
        }
        throw Errors.shouldNotReachHereUnexpectedValue(offsetOption);
    }

    public static ShowCalendar toShowCalendar(TruffleString showCalendar, TruffleString.EqualNode equalNode) {
        if (Strings.equals(equalNode, showCalendar, TemporalConstants.AUTO)) {
            return ShowCalendar.AUTO;
        }
        if (Strings.equals(equalNode, showCalendar, TemporalConstants.NEVER)) {
            return ShowCalendar.NEVER;
        }
        if (Strings.equals(equalNode, showCalendar, TemporalConstants.ALWAYS)) {
            return ShowCalendar.ALWAYS;
        }
        if (Strings.equals(equalNode, showCalendar, TemporalConstants.CRITICAL)) {
            return ShowCalendar.CRITICAL;
        }
        throw Errors.shouldNotReachHereUnexpectedValue(showCalendar);
    }

    public static double roundTowardsZero(double d2) {
        return ExactMath.truncate(d2);
    }

    public static enum Unit {
        EMPTY(Strings.EMPTY_STRING),
        AUTO(TemporalConstants.AUTO),
        YEAR(TemporalConstants.YEAR),
        MONTH(TemporalConstants.MONTH),
        WEEK(TemporalConstants.WEEK),
        DAY(TemporalConstants.DAY),
        HOUR(TemporalConstants.HOUR),
        MINUTE(TemporalConstants.MINUTE),
        SECOND(TemporalConstants.SECOND),
        MILLISECOND(TemporalConstants.MILLISECOND),
        MICROSECOND(TemporalConstants.MICROSECOND),
        NANOSECOND(TemporalConstants.NANOSECOND);

        @CompilerDirectives.CompilationFinal(dimensions=1)
        public static final Unit[] VALUES;
        public static final Unit REQUIRED;
        private final TruffleString name;

        private Unit(TruffleString name) {
            this.name = name;
        }

        public TruffleString toTruffleString() {
            return this.name;
        }

        public long getLengthInNanoseconds() {
            return switch (this.ordinal()) {
                case 11 -> 1L;
                case 10 -> 1000L;
                case 9 -> 1000000L;
                case 8 -> 1000000000L;
                case 7 -> 60000000000L;
                case 6 -> 3600000000000L;
                case 5 -> 86400000000000L;
                default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)this);
            };
        }

        public boolean isCalendarUnit() {
            return switch (this.ordinal()) {
                case 2, 3, 4 -> true;
                default -> false;
            };
        }

        public boolean isDateUnit() {
            return switch (this.ordinal()) {
                case 2, 3, 4, 5 -> true;
                default -> false;
            };
        }

        public boolean isTimeUnit() {
            return switch (this.ordinal()) {
                case 6, 7, 8, 9, 10, 11 -> true;
                default -> false;
            };
        }

        static {
            VALUES = Unit.values();
            REQUIRED = null;
        }
    }

    public static enum RoundingMode {
        EMPTY,
        CEIL,
        FLOOR,
        EXPAND,
        TRUNC,
        HALF_EXPAND,
        HALF_TRUNC,
        HALF_EVEN,
        HALF_FLOOR,
        HALF_CEIL;

    }

    public static enum UnsignedRoundingMode {
        EMPTY,
        ZERO,
        INFINITY,
        HALF_INFINITY,
        HALF_ZERO,
        HALF_EVEN;

    }

    public static enum Overflow {
        CONSTRAIN,
        REJECT;

    }

    public record ISOYearMonthRecord(int year, int month) {
    }

    public static enum OptionType {
        STRING,
        NUMBER,
        BOOLEAN,
        NUMBER_AND_STRING;


        public boolean allowsNumber() {
            return this == NUMBER || this == NUMBER_AND_STRING;
        }

        public boolean allowsString() {
            return this == STRING || this == NUMBER_AND_STRING;
        }

        public boolean allowsBoolean() {
            return this == BOOLEAN;
        }

        public OptionType getLast() {
            switch (this.ordinal()) {
                case 0: 
                case 3: {
                    return STRING;
                }
                case 1: {
                    return NUMBER;
                }
                case 2: {
                    return BOOLEAN;
                }
            }
            throw Errors.shouldNotReachHere();
        }
    }

    public static enum ShowCalendar {
        AUTO,
        ALWAYS,
        NEVER,
        CRITICAL;

    }

    public record AddDaysToZonedDateTimeResult(BigInt epochNanoseconds, JSTemporalInstantObject instant, JSTemporalPlainDateTimeObject dateTime) {
    }

    public static enum Disambiguation {
        EARLIER,
        LATER,
        COMPATIBLE,
        REJECT;

    }

    public record NormalizedDurationWithTotalRecord(NormalizedDurationRecord normalizedDuration, double total) {
    }

    public record NormalizedTimeDurationWithTotalRecord(BigInt normalizedTimeDuration, double total) {
    }

    public static enum OffsetOption {
        USE,
        IGNORE,
        PREFER,
        REJECT;

    }

    public static enum OffsetBehaviour {
        OPTION,
        WALL,
        EXACT;

    }

    public static enum MatchBehaviour {
        MATCH_EXACTLY,
        MATCH_MINUTES;

    }
}

