/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.object;

import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.StrongKeyWeakValueEntry;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.TransitionMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.WeakKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Equivalence;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableMapCursor;

final class EconomicTransitionMap<K, V>
extends TransitionMap<K, V> {
    private final EconomicMap<Object, StrongKeyWeakValueEntry<Object, V>> map = EconomicMap.create(WEAK_KEY_EQUIVALENCE);
    private static final Equivalence WEAK_KEY_EQUIVALENCE = new WeakKeyEquivalence();

    EconomicTransitionMap() {
    }

    @Override
    private V getValue(StrongKeyWeakValueEntry<? super K, V> entry) {
        return entry == null ? null : (V)entry.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            return this.getValue((StrongKeyWeakValueEntry)this.map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putAnyKey(Object key, V value) {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue(this.map.put(key, new StrongKeyWeakValueEntry<Object, V>(key, value, this.queue)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putAnyKeyIfAbsent(Object key, V value) {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            V prevValue = this.getValue((StrongKeyWeakValueEntry)this.map.get(key));
            if (prevValue != null) {
                return prevValue;
            }
            this.map.put(key, new StrongKeyWeakValueEntry<Object, V>(key, value, this.queue));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            this.expungeStaleEntries();
            return this.getValue(this.map.removeKey(key));
        }
    }

    @Override
    protected void expungeStaleEntry(StrongKeyWeakValueEntry<Object, V> entry) {
        if (this.map.get(entry.getKey()) == entry) {
            this.map.removeKey(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            UnmodifiableMapCursor cursor = this.map.getEntries();
            while (cursor.advance()) {
                Object key;
                Object value = ((StrongKeyWeakValueEntry)cursor.getValue()).get();
                if (value == null || (key = this.unwrapKey(cursor.getKey())) == null) continue;
                consumer.accept(key, value);
            }
        }
    }

    private static final class WeakKeyEquivalence
    extends Equivalence {
        private WeakKeyEquivalence() {
        }

        @Override
        public int hashCode(Object o2) {
            return o2.hashCode();
        }

        @Override
        public boolean equals(Object a2, Object b2) {
            boolean aIsWeak = a2 instanceof WeakKey;
            boolean bIsWeak = b2 instanceof WeakKey;
            if (aIsWeak && !bIsWeak) {
                return Objects.equals(((WeakKey)a2).get(), b2);
            }
            if (!aIsWeak && bIsWeak) {
                return Objects.equals(a2, ((WeakKey)b2).get());
            }
            return a2.equals(b2);
        }
    }
}

