/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.object;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Location;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Property;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.Flags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.LayoutImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.LocationImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.PropertyImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.PropertyMap;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.ShapeImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.object.Transition;

public abstract class LayoutStrategy {
    protected LayoutStrategy() {
    }

    protected abstract int getLocationOrdinal(Location var1);

    protected abstract boolean updateShape(DynamicObject var1);

    protected abstract ShapeImpl ensureValid(ShapeImpl var1);

    protected abstract ShapeImpl ensureSpace(ShapeImpl var1, Location var2);

    public abstract ShapeImpl.BaseAllocator createAllocator(LayoutImpl var1);

    public abstract ShapeImpl.BaseAllocator createAllocator(ShapeImpl var1);

    protected ShapeImpl defineProperty(ShapeImpl shape, Object key, Object value, int flags) {
        return this.defineProperty(shape, key, value, flags, 0);
    }

    protected ShapeImpl defineProperty(ShapeImpl shape, Object key, Object value, int flags, int putFlags) {
        ShapeImpl oldShape = shape;
        if (!oldShape.isValid()) {
            oldShape = this.ensureValid(oldShape);
        }
        Property existing = oldShape.getProperty(key);
        return this.defineProperty(oldShape, key, value, flags, existing, putFlags);
    }

    protected ShapeImpl defineProperty(ShapeImpl oldShape, Object key, Object value, int propertyFlags, Property existing, int putFlags) {
        if (existing == null) {
            if (Flags.isSeparateShape(putFlags)) {
                return this.definePropertySeparateShape(oldShape, key, value, propertyFlags, putFlags);
            }
            return this.defineNewProperty(oldShape, key, value, propertyFlags, putFlags);
        }
        if (existing.getFlags() == propertyFlags) {
            if (existing.getLocation().canStore(value)) {
                return oldShape;
            }
            return this.definePropertyGeneralize(oldShape, existing, value, putFlags);
        }
        return this.definePropertyChangeFlags(oldShape, existing, value, propertyFlags, putFlags);
    }

    private ShapeImpl defineNewProperty(ShapeImpl oldShape, Object key, Object value, int propertyFlags, int putFlags) {
        Transition.AddPropertyTransition addTransition;
        ShapeImpl cachedShape;
        Class<?> locationType;
        if (!Flags.isConstant(putFlags) && !Flags.isDeclaration(putFlags) && (locationType = this.detectLocationType(value)) != null && (cachedShape = oldShape.queryTransition(addTransition = new Transition.AddPropertyTransition(key, propertyFlags, locationType))) != null) {
            return this.ensureValid(cachedShape);
        }
        Location location = this.createLocationForValue(oldShape, value, putFlags);
        Property property = Property.create(key, location, propertyFlags);
        return this.addProperty(oldShape, property);
    }

    protected Class<?> detectLocationType(Object value) {
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        if (value instanceof Long) {
            return Long.TYPE;
        }
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        return Object.class;
    }

    protected abstract Location createLocationForValue(ShapeImpl var1, Object var2, int var3);

    protected ShapeImpl definePropertyChangeFlags(ShapeImpl oldShape, Property existing, Object value, int propertyFlags, int putFlags) {
        assert (existing.getFlags() != propertyFlags);
        oldShape.onPropertyTransition(existing);
        if (existing.getLocation().canStore(value)) {
            Property newProperty = Property.create(existing.getKey(), existing.getLocation(), propertyFlags);
            return this.replaceProperty(oldShape, existing, newProperty);
        }
        return this.generalizePropertyWithFlags(oldShape, existing, value, propertyFlags, putFlags);
    }

    protected ShapeImpl definePropertyGeneralize(ShapeImpl oldShape, Property oldProperty, Object value, int putFlags) {
        oldShape.onPropertyTransition(oldProperty);
        if (Flags.isSeparateShape(putFlags)) {
            Location newLocation = this.createLocationForValue(oldShape, value, putFlags);
            Property newProperty = ((PropertyImpl)oldProperty).relocate(newLocation);
            return this.separateReplaceProperty(oldShape, oldProperty, newProperty);
        }
        if (oldProperty.getLocation().isValue()) {
            Location newLocation = this.createLocationForValue(oldShape, value, putFlags);
            Property newProperty = ((PropertyImpl)oldProperty).relocate(newLocation);
            return this.directReplaceProperty(oldShape, oldProperty, newProperty);
        }
        return this.generalizeProperty(oldProperty, value, oldShape, oldShape, putFlags);
    }

    protected ShapeImpl generalizeProperty(Property oldProperty, Object value, ShapeImpl currentShape, ShapeImpl nextShape, int putFlags) {
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = currentShape.allocator().locationForValueUpcast(value, oldLocation, putFlags);
        Property newProperty = ((PropertyImpl)oldProperty).relocate(newLocation);
        nextShape.onPropertyTransition(oldProperty);
        return this.replaceProperty(nextShape, oldProperty, newProperty);
    }

    protected ShapeImpl generalizePropertyWithFlags(ShapeImpl currentShape, Property oldProperty, Object value, int propertyFlags, int putFlags) {
        assert (!oldProperty.getLocation().canStore(value));
        Location newLocation = currentShape.allocator().locationForValueUpcast(value, oldProperty.getLocation(), putFlags);
        Property newProperty = Property.create(oldProperty.getKey(), newLocation, propertyFlags);
        return this.replaceProperty(currentShape, oldProperty, newProperty);
    }

    private ShapeImpl definePropertySeparateShape(ShapeImpl oldShape, Object key, Object value, int propertyFlags, int putFlags) {
        Location location = this.createLocationForValue(oldShape, value, putFlags);
        Property property = Property.create(key, location, propertyFlags);
        return this.createSeparateShape(oldShape).addProperty(property);
    }

    protected ShapeImpl replaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        return this.directReplaceProperty(shape, oldProperty, newProperty);
    }

    protected ShapeImpl removeProperty(ShapeImpl shape, Property property) {
        shape.onPropertyTransition(property);
        boolean direct = shape.isShared();
        Transition.RemovePropertyTransition transition = this.newRemovePropertyTransition(property, direct);
        ShapeImpl cachedShape = shape.queryTransition(transition);
        if (cachedShape != null) {
            return this.ensureValid(cachedShape);
        }
        if (direct) {
            return LayoutStrategy.directRemoveProperty(shape, property, transition);
        }
        return this.indirectRemoveProperty(shape, property, transition);
    }

    protected Transition.RemovePropertyTransition newRemovePropertyTransition(Property property, boolean direct) {
        return new Transition.RemovePropertyTransition(property, this.toLocationOrType(property.getLocation()), direct);
    }

    private ShapeImpl indirectRemoveProperty(ShapeImpl shape, Property property, Transition.RemovePropertyTransition transition) {
        ShapeImpl owningShape = LayoutStrategy.getShapeFromProperty(shape, property.getKey());
        if (owningShape == null) {
            return null;
        }
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        ShapeImpl current = shape;
        while (current != owningShape) {
            Transition transitionFromParent = current.getTransitionFromParent();
            if (!(transitionFromParent instanceof Transition.DirectReplacePropertyTransition) || !((Transition.DirectReplacePropertyTransition)transitionFromParent).getPropertyBefore().getKey().equals(property.getKey())) {
                transitionList.add(transitionFromParent);
            }
            current = current.parent;
        }
        ShapeImpl newShape = owningShape.parent;
        ListIterator iterator = transitionList.listIterator(transitionList.size());
        while (iterator.hasPrevious()) {
            Transition previous = (Transition)iterator.previous();
            newShape = this.applyTransition(newShape, previous, true);
        }
        return shape.addIndirectTransition(transition, newShape);
    }

    private static ShapeImpl directRemoveProperty(ShapeImpl shape, Property property, Transition.RemovePropertyTransition transition) {
        PropertyMap newPropertyMap = shape.getPropertyMap().removeCopy(property);
        ShapeImpl newShape = shape.createShape(shape.getLayout(), shape.sharedData, shape, shape.objectType, newPropertyMap, transition, shape.allocator(), shape.flags);
        return shape.addDirectTransition(transition, newShape);
    }

    protected ShapeImpl directReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        return this.directReplaceProperty(shape, oldProperty, newProperty, true);
    }

    protected ShapeImpl directReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty, boolean ensureValid) {
        ShapeImpl newShape = LayoutStrategy.directReplacePropertyInner(shape, oldProperty, newProperty);
        Property actualProperty = newShape.getProperty(newProperty.getKey());
        this.ensureSameTypeOrMoreGeneral(actualProperty, newProperty);
        return ensureValid ? this.ensureValid(newShape) : newShape;
    }

    private static ShapeImpl directReplacePropertyInner(ShapeImpl shape, Property oldProperty, Property newProperty) {
        assert (oldProperty.getKey().equals(newProperty.getKey()));
        if (oldProperty.equals(newProperty)) {
            return shape;
        }
        shape.onPropertyTransition(oldProperty);
        Transition.DirectReplacePropertyTransition replacePropertyTransition = new Transition.DirectReplacePropertyTransition(oldProperty, newProperty);
        ShapeImpl cachedShape = shape.queryTransition(replacePropertyTransition);
        if (cachedShape != null) {
            return cachedShape;
        }
        PropertyMap newPropertyMap = shape.getPropertyMap().replaceCopy(oldProperty, newProperty);
        ShapeImpl.BaseAllocator allocator = shape.allocator().addLocation(newProperty.getLocation());
        ShapeImpl newShape = shape.createShape(shape.getLayout(), shape.sharedData, shape, shape.objectType, newPropertyMap, replacePropertyTransition, allocator, shape.flags);
        newShape = shape.addDirectTransition(replacePropertyTransition, newShape);
        if (!shape.isValid()) {
            newShape.invalidateValidAssumption();
        }
        return newShape;
    }

    protected ShapeImpl separateReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        ShapeImpl newRoot;
        ShapeImpl newShape = newRoot = shape.createShape(shape.getLayout(), shape.sharedData, null, shape.objectType, PropertyMap.empty(), null, shape.getLayout().createAllocator(), shape.flags);
        boolean found = false;
        Iterator<Property> iterator = shape.getPropertyMap().orderedValueIterator();
        while (iterator.hasNext()) {
            Property p2 = iterator.next();
            if (!found && p2.equals(oldProperty)) {
                p2 = newProperty;
                found = true;
            }
            newShape = newShape.addProperty(newProperty);
        }
        assert (found);
        assert (newShape.isValid());
        return newShape;
    }

    protected ShapeImpl createSeparateShape(ShapeImpl shape) {
        ShapeImpl newRoot;
        ShapeImpl newShape = newRoot = shape.createShape(shape.getLayout(), shape.sharedData, null, shape.objectType, PropertyMap.empty(), null, shape.getLayout().createAllocator(), shape.flags);
        Iterator<Property> iterator = shape.getPropertyMap().orderedValueIterator();
        while (iterator.hasNext()) {
            Property p2 = iterator.next();
            newShape = newShape.addProperty(p2);
        }
        assert (newShape.isValid());
        return newShape;
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property) {
        return this.addProperty(shape, property, true);
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property, boolean ensureValid) {
        ShapeImpl newShape = this.addPropertyInner(shape, property);
        Property actualProperty = newShape.getLastProperty();
        this.ensureSameTypeOrMoreGeneral(actualProperty, property);
        return ensureValid ? this.ensureValid(newShape) : newShape;
    }

    private ShapeImpl addPropertyInner(ShapeImpl shape, Property property) {
        assert (!shape.hasProperty(property.getKey())) : "duplicate property " + String.valueOf(property.getKey());
        shape.onPropertyTransition(property);
        Transition.AddPropertyTransition addTransition = this.newAddPropertyTransition(property);
        ShapeImpl cachedShape = shape.queryTransition(addTransition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl oldShape = this.ensureSpace(shape, property.getLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithAddedProperty(oldShape, addTransition);
        newShape = oldShape.addDirectTransition(addTransition, newShape);
        if (!oldShape.isValid()) {
            newShape.invalidateValidAssumption();
        }
        return newShape;
    }

    protected Transition.AddPropertyTransition newAddPropertyTransition(Property property) {
        return new Transition.AddPropertyTransition(property, this.toLocationOrType(property.getLocation()));
    }

    protected Object toLocationOrType(Location location) {
        Class<?> type;
        if (location instanceof LocationImpl && (type = ((LocationImpl)location).getType()) != null) {
            return type;
        }
        return location;
    }

    protected ShapeImpl applyTransition(ShapeImpl shape, Transition transition, boolean append) {
        if (transition instanceof Transition.AddPropertyTransition) {
            ShapeImpl newShape;
            Property property = ((Transition.AddPropertyTransition)transition).getProperty();
            if (append) {
                Property newProperty = ((PropertyImpl)property).relocate(shape.allocator().moveLocation(property.getLocation()));
                newShape = this.addProperty(shape, newProperty, true);
            } else {
                newShape = this.addProperty(shape, property, false);
            }
            return newShape;
        }
        if (transition instanceof Transition.ObjectTypeTransition) {
            return shape.setDynamicType(((Transition.ObjectTypeTransition)transition).getObjectType());
        }
        if (transition instanceof Transition.ObjectFlagsTransition) {
            return shape.setFlags(((Transition.ObjectFlagsTransition)transition).getObjectFlags());
        }
        if (transition instanceof Transition.DirectReplacePropertyTransition) {
            Property oldProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyBefore();
            Property newProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyAfter();
            if (append) {
                boolean sameLocation = oldProperty.getLocation().equals(newProperty.getLocation());
                oldProperty = shape.getProperty(oldProperty.getKey());
                Location newLocation = sameLocation ? oldProperty.getLocation() : shape.allocator().moveLocation(newProperty.getLocation());
                newProperty = ((PropertyImpl)newProperty).relocate(newLocation);
            }
            return this.directReplaceProperty(shape, oldProperty, newProperty, append);
        }
        throw new UnsupportedOperationException(transition.getClass().getName());
    }

    protected static ShapeImpl getShapeFromProperty(ShapeImpl shape, Object propertyName) {
        ShapeImpl root = shape.getRoot();
        for (ShapeImpl current = shape; current != root; current = current.getParent()) {
            if (!(current.getTransitionFromParent() instanceof Transition.AddPropertyTransition) || !((Transition.AddPropertyTransition)current.getTransitionFromParent()).getPropertyKey().equals(propertyName)) continue;
            return current;
        }
        return null;
    }

    protected void ensureSameTypeOrMoreGeneral(Property generalProperty, Property specificProperty) {
        assert (((PropertyImpl)generalProperty).isSame(specificProperty)) : generalProperty;
        if (generalProperty.getLocation() != specificProperty.getLocation()) assert (((LocationImpl)generalProperty.getLocation()).getType() == ((LocationImpl)specificProperty.getLocation()).getType()) : generalProperty;
    }
}

