/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex;

import java.util.Arrays;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ArrayUtils;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSyntaxException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.ECMAScriptFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.MatchingMode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.PythonFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.RubyFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.java.JavaFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;

public final class RegexOptions {
    private static final int U180E_WHITESPACE = 1;
    public static final String U180E_WHITESPACE_NAME = "U180EWhitespace";
    private static final int REGRESSION_TEST_MODE = 2;
    public static final String REGRESSION_TEST_MODE_NAME = "RegressionTestMode";
    private static final int DUMP_AUTOMATA = 4;
    public static final String DUMP_AUTOMATA_NAME = "DumpAutomata";
    private static final int STEP_EXECUTION = 8;
    public static final String STEP_EXECUTION_NAME = "StepExecution";
    private static final int ALWAYS_EAGER = 16;
    public static final String ALWAYS_EAGER_NAME = "AlwaysEager";
    private static final int UTF_16_EXPLODE_ASTRAL_SYMBOLS = 32;
    public static final String UTF_16_EXPLODE_ASTRAL_SYMBOLS_NAME = "UTF16ExplodeAstralSymbols";
    private static final int VALIDATE = 64;
    public static final String VALIDATE_NAME = "Validate";
    private static final int IGNORE_ATOMIC_GROUPS = 128;
    public static final String IGNORE_ATOMIC_GROUPS_NAME = "IgnoreAtomicGroups";
    private static final int GENERATE_DFA_IMMEDIATELY = 256;
    private static final String GENERATE_DFA_IMMEDIATELY_NAME = "GenerateDFAImmediately";
    private static final int BOOLEAN_MATCH = 512;
    public static final String BOOLEAN_MATCH_NAME = "BooleanMatch";
    private static final int MUST_ADVANCE = 1024;
    public static final String MUST_ADVANCE_NAME = "MustAdvance";
    private static final int GENERATE_INPUT = 2048;
    public static final String GENERATE_INPUT_NAME = "GenerateInput";
    public static final String FLAVOR_NAME = "Flavor";
    public static final String FLAVOR_PYTHON = "Python";
    public static final String FLAVOR_RUBY = "Ruby";
    public static final String FLAVOR_ORACLE_DB = "OracleDB";
    public static final String FLAVOR_ECMASCRIPT = "ECMAScript";
    public static final String FLAVOR_JAVA = "JavaUtilPattern";
    private static final String[] FLAVOR_OPTIONS = new String[]{"Python", "Ruby", "OracleDB", "ECMAScript", "JavaUtilPattern"};
    public static final String ENCODING_NAME = "Encoding";
    public static final String PYTHON_METHOD_NAME = "PythonMethod";
    public static final String MATCHING_MODE_NAME = "MatchingMode";
    public static final String MATCHING_MODE_SEARCH = "search";
    public static final String MATCHING_MODE_MATCH = "match";
    public static final String MATCHING_MODE_FULLMATCH = "fullmatch";
    private static final String[] MATCHING_MODE_OPTIONS = new String[]{"search", "match", "fullmatch"};
    public static final String PYTHON_LOCALE_NAME = "PythonLocale";
    public static final String JAVA_JDK_VERSION_NAME = "JavaJDKVersion";
    public static final String[] JAVA_JDK_VERSION_OPTIONS = new String[]{"21", "22", "23"};
    public static final int JAVA_JDK_VERSION_MIN = 21;
    public static final int JAVA_JDK_VERSION_MAX = 23;
    private static final byte JAVA_JDK_VERSION_DEFAULT = 23;
    public static final String MAX_DFA_SIZE_NAME = "MaxDFASize";
    public static final String MAX_BACK_TRACKER_SIZE_NAME = "MaxBackTrackerCompileSize";
    private static final String PARSE_SHORT_ERROR_MSG = "expected a short integer value";
    public static final RegexOptions DEFAULT = new RegexOptions(0, 1300, 200, ECMAScriptFlavor.INSTANCE, Encodings.UTF_16_RAW, null, null, 23);
    private final int options;
    private final short maxDFASize;
    private final short maxBackTrackerCompileSize;
    private final RegexFlavor flavor;
    private final Encodings.Encoding encoding;
    private final MatchingMode matchingMode;
    private final String pythonLocale;
    private final byte javaJDKVersion;

    private RegexOptions(int options, short maxDFASize, short maxBackTrackerCompileSize, RegexFlavor flavor, Encodings.Encoding encoding, MatchingMode matchingMode, String pythonLocale, byte javaJDKVersion) {
        this.options = options;
        this.maxDFASize = maxDFASize;
        this.maxBackTrackerCompileSize = maxBackTrackerCompileSize;
        this.flavor = flavor;
        this.encoding = encoding;
        this.matchingMode = matchingMode;
        this.pythonLocale = pythonLocale;
        this.javaJDKVersion = javaJDKVersion;
    }

    public static Builder builder(Source source, String sourceString) {
        return new Builder(source, sourceString);
    }

    private boolean isBitSet(int bit) {
        return (this.options & bit) != 0;
    }

    public short getMaxDFASize() {
        return this.maxDFASize;
    }

    public short getMaxBackTrackerCompileSize() {
        return this.maxBackTrackerCompileSize;
    }

    public boolean isU180EWhitespace() {
        return this.isBitSet(1);
    }

    public boolean isRegressionTestMode() {
        return this.isBitSet(2);
    }

    public boolean isDumpAutomata() {
        return this.isBitSet(4);
    }

    public boolean isDumpAutomataWithSourceSections() {
        return this.isDumpAutomata() && (this.getFlavor() == ECMAScriptFlavor.INSTANCE || this.getFlavor() == OracleDBFlavor.INSTANCE);
    }

    public boolean isStepExecution() {
        return this.isBitSet(8);
    }

    public boolean isGenerateDFAImmediately() {
        return this.isBitSet(256);
    }

    public boolean isBooleanMatch() {
        return this.isBitSet(512);
    }

    public boolean isAlwaysEager() {
        return this.isBitSet(16);
    }

    public boolean isUTF16ExplodeAstralSymbols() {
        return this.isBitSet(32);
    }

    public boolean isValidate() {
        return this.isBitSet(64);
    }

    public boolean isIgnoreAtomicGroups() {
        return this.isBitSet(128);
    }

    public boolean isMustAdvance() {
        return this.isBitSet(1024);
    }

    public boolean isGenerateInput() {
        return this.isBitSet(2048);
    }

    public RegexFlavor getFlavor() {
        return this.flavor;
    }

    public Encodings.Encoding getEncoding() {
        return this.encoding;
    }

    public MatchingMode getMatchingMode() {
        return this.matchingMode;
    }

    public String getPythonLocale() {
        return this.pythonLocale;
    }

    public int getJavaJDKVersion() {
        return this.javaJDKVersion;
    }

    public RegexOptions withBooleanMatch() {
        return new RegexOptions(this.options | 0x200, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion);
    }

    public RegexOptions withoutBooleanMatch() {
        return new RegexOptions(this.options & 0xFFFFFDFF, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion);
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.options;
        hash = 31 * hash + Objects.hashCode(this.maxDFASize);
        hash = 31 * hash + Objects.hashCode(this.maxBackTrackerCompileSize);
        hash = 31 * hash + Objects.hashCode(this.flavor);
        hash = 31 * hash + this.encoding.hashCode();
        hash = 31 * hash + Objects.hashCode((Object)this.matchingMode);
        hash = 31 * hash + Objects.hashCode(this.pythonLocale);
        hash = 31 * hash + Objects.hashCode(this.javaJDKVersion);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegexOptions)) {
            return false;
        }
        RegexOptions other = (RegexOptions)obj;
        return this.options == other.options && this.maxDFASize == other.maxDFASize && this.maxBackTrackerCompileSize == other.maxBackTrackerCompileSize && this.flavor == other.flavor && this.encoding == other.encoding && this.matchingMode == other.matchingMode && this.pythonLocale.equals(other.pythonLocale) && this.javaJDKVersion == other.javaJDKVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.maxDFASize != 1300) {
            sb.append("MaxDFASize=").append(this.maxDFASize).append(',');
        }
        if (this.maxBackTrackerCompileSize != 200) {
            sb.append("MaxBackTrackerCompileSize=").append(this.maxBackTrackerCompileSize).append(',');
        }
        if (this.isU180EWhitespace()) {
            sb.append("U180EWhitespace=true,");
        }
        if (this.isRegressionTestMode()) {
            sb.append("RegressionTestMode=true,");
        }
        if (this.isDumpAutomata()) {
            sb.append("DumpAutomata=true,");
        }
        if (this.isStepExecution()) {
            sb.append("StepExecution=true,");
        }
        if (this.isAlwaysEager()) {
            sb.append("AlwaysEager=true,");
        }
        if (this.isUTF16ExplodeAstralSymbols()) {
            sb.append("UTF16ExplodeAstralSymbols=true,");
        }
        if (this.isValidate()) {
            sb.append("Validate=true,");
        }
        if (this.isIgnoreAtomicGroups()) {
            sb.append("IgnoreAtomicGroups=true,");
        }
        if (this.isGenerateDFAImmediately()) {
            sb.append("GenerateDFAImmediately=true,");
        }
        if (this.isBooleanMatch()) {
            sb.append("BooleanMatch=true,");
        }
        if (this.isMustAdvance()) {
            sb.append("MustAdvance=true,");
        }
        if (this.flavor == PythonFlavor.INSTANCE) {
            sb.append("Flavor=Python,");
        } else if (this.flavor == RubyFlavor.INSTANCE) {
            sb.append("Flavor=Ruby,");
        } else if (this.flavor == OracleDBFlavor.INSTANCE) {
            sb.append("Flavor=OracleDB,");
        } else if (this.flavor == JavaFlavor.INSTANCE) {
            sb.append("Flavor=JavaUtilPattern,");
        }
        sb.append("Encoding=").append(this.encoding.getName()).append(",");
        if (this.matchingMode != null) {
            sb.append(MATCHING_MODE_NAME).append('=').append((Object)this.matchingMode).append(',');
        }
        if (this.pythonLocale != null) {
            sb.append("PythonLocale=").append(this.pythonLocale).append(",");
        }
        if (this.isGenerateInput()) {
            sb.append(GENERATE_INPUT_NAME).append("=true").append(",");
        }
        if (this.javaJDKVersion != 23) {
            sb.append(JAVA_JDK_VERSION_NAME).append("=").append(this.javaJDKVersion).append(",");
        }
        if (!sb.isEmpty()) {
            assert (sb.charAt(sb.length() - 1) == ',');
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final class Builder {
        private final Source source;
        private final String src;
        private int i;
        private int options;
        private short maxDFASize = (short)1300;
        private short maxBackTrackerCompileSize = (short)200;
        private RegexFlavor flavor;
        private Encodings.Encoding encoding = Encodings.UTF_16_RAW;
        private MatchingMode matchingMode;
        private String pythonLocale;
        private byte javaJDKVersion = (byte)23;

        private Builder(Source source, String sourceString) {
            this.source = source;
            this.src = sourceString;
            this.options = 0;
            this.flavor = ECMAScriptFlavor.INSTANCE;
        }

        @CompilerDirectives.TruffleBoundary
        public int parseOptions() throws RegexSyntaxException {
            this.i = 0;
            block36: while (this.i < this.src.length()) {
                switch (this.src.charAt(this.i)) {
                    case 'A': {
                        this.parseBooleanOption(RegexOptions.ALWAYS_EAGER_NAME, 16);
                        continue block36;
                    }
                    case 'B': {
                        this.parseBooleanOption(RegexOptions.BOOLEAN_MATCH_NAME, 512);
                        continue block36;
                    }
                    case 'D': {
                        this.parseBooleanOption(RegexOptions.DUMP_AUTOMATA_NAME, 4);
                        continue block36;
                    }
                    case 'E': {
                        this.encoding = this.parseEncoding();
                        continue block36;
                    }
                    case 'F': {
                        this.flavor = this.parseFlavor();
                        continue block36;
                    }
                    case 'G': {
                        switch (this.lookAheadInKey("Generate".length())) {
                            case 'D': {
                                this.parseBooleanOption(RegexOptions.GENERATE_DFA_IMMEDIATELY_NAME, 256);
                                continue block36;
                            }
                            case 'I': {
                                this.parseBooleanOption(RegexOptions.GENERATE_INPUT_NAME, 2048);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'I': {
                        this.parseBooleanOption(RegexOptions.IGNORE_ATOMIC_GROUPS_NAME, 128);
                        continue block36;
                    }
                    case 'J': {
                        short version = this.parseShortOption(RegexOptions.JAVA_JDK_VERSION_NAME);
                        if (version < 21 || version > 23) {
                            throw this.optionsSyntaxErrorUnexpectedValue(JAVA_JDK_VERSION_OPTIONS);
                        }
                        this.javaJDKVersion = (byte)version;
                        continue block36;
                    }
                    case 'M': {
                        switch (this.lookAheadInKey(3)) {
                            case 'B': {
                                this.maxBackTrackerCompileSize = this.parseShortOption(RegexOptions.MAX_BACK_TRACKER_SIZE_NAME);
                                continue block36;
                            }
                            case 'D': {
                                this.maxDFASize = this.parseShortOption(RegexOptions.MAX_DFA_SIZE_NAME);
                                continue block36;
                            }
                            case 'c': {
                                this.matchingMode = this.parseMatchingMode(RegexOptions.MATCHING_MODE_NAME);
                                continue block36;
                            }
                            case 't': {
                                this.parseBooleanOption(RegexOptions.MUST_ADVANCE_NAME, 1024);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'P': {
                        switch (this.lookAheadInKey(RegexOptions.FLAVOR_PYTHON.length())) {
                            case 'M': {
                                this.matchingMode = this.parseMatchingMode(RegexOptions.PYTHON_METHOD_NAME);
                                continue block36;
                            }
                            case 'L': {
                                this.pythonLocale = this.parseStringOption(RegexOptions.PYTHON_LOCALE_NAME, "expected a python locale name");
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'R': {
                        this.parseBooleanOption(RegexOptions.REGRESSION_TEST_MODE_NAME, 2);
                        continue block36;
                    }
                    case 'S': {
                        this.parseBooleanOption(RegexOptions.STEP_EXECUTION_NAME, 8);
                        continue block36;
                    }
                    case 'U': {
                        switch (this.lookAheadInKey(1)) {
                            case '1': {
                                this.parseBooleanOption(RegexOptions.U180E_WHITESPACE_NAME, 1);
                                continue block36;
                            }
                            case 'T': {
                                this.parseBooleanOption(RegexOptions.UTF_16_EXPLODE_ASTRAL_SYMBOLS_NAME, 32);
                                continue block36;
                            }
                        }
                        throw this.optionsSyntaxErrorUnexpectedKey();
                    }
                    case 'V': {
                        this.parseBooleanOption(RegexOptions.VALIDATE_NAME, 64);
                        continue block36;
                    }
                    case ',': {
                        ++this.i;
                        continue block36;
                    }
                    case '/': {
                        return this.i;
                    }
                }
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            return this.i;
        }

        private char lookAheadInKey(int offset) {
            if (Integer.compareUnsigned(this.i + offset, this.src.length()) >= 0) {
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            return this.src.charAt(this.i + offset);
        }

        private void expectOptionName(String key) {
            if (!this.src.regionMatches(this.i, key, 0, key.length()) || this.src.charAt(this.i + key.length()) != '=') {
                throw this.optionsSyntaxErrorUnexpectedKey();
            }
            this.i += key.length() + 1;
        }

        private <T> T expectValue(T returnValue, String value, String ... expected) {
            if (!this.src.regionMatches(this.i, value, 0, value.length())) {
                throw this.optionsSyntaxErrorUnexpectedValue(expected);
            }
            this.i += value.length();
            return returnValue;
        }

        private void parseBooleanOption(String key, int flag) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.src.regionMatches(this.i, "true", 0, "true".length())) {
                this.options |= flag;
                this.i += "true".length();
            } else if (this.src.regionMatches(this.i, "false", 0, "false".length())) {
                this.i += "false".length();
            } else {
                throw this.optionsSyntaxErrorUnexpectedValue("true", "false");
            }
        }

        private short parseShortOption(String key) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
            }
            int endPos = this.findValueEndPos(RegexOptions.PARSE_SHORT_ERROR_MSG);
            try {
                int value = Integer.parseUnsignedInt(this.src, this.i, endPos, 10);
                if (value < 0 || value > Short.MAX_VALUE) {
                    throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
                }
                this.i = endPos;
                return (short)value;
            }
            catch (NumberFormatException e2) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(RegexOptions.PARSE_SHORT_ERROR_MSG);
            }
        }

        private String parseStringOption(String key, String errorMsg) throws RegexSyntaxException {
            this.expectOptionName(key);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(errorMsg);
            }
            int endPos = this.findValueEndPos(errorMsg);
            String value = this.src.substring(this.i, endPos);
            this.i = endPos;
            return value;
        }

        private int findValueEndPos(String errorMsg) {
            int endPos = ArrayUtils.indexOf(this.src, this.i, this.src.length(), ',', '/');
            if (endPos < 0) {
                throw this.optionsSyntaxErrorUnexpectedValueMsg(errorMsg);
            }
            return endPos;
        }

        private RegexFlavor parseFlavor() throws RegexSyntaxException {
            this.expectOptionName(RegexOptions.FLAVOR_NAME);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(FLAVOR_OPTIONS);
            }
            switch (this.src.charAt(this.i)) {
                case 'E': {
                    return this.expectValue(ECMAScriptFlavor.INSTANCE, RegexOptions.FLAVOR_ECMASCRIPT, FLAVOR_OPTIONS);
                }
                case 'J': {
                    return this.expectValue(JavaFlavor.INSTANCE, RegexOptions.FLAVOR_JAVA, FLAVOR_OPTIONS);
                }
                case 'R': {
                    return this.expectValue(RubyFlavor.INSTANCE, RegexOptions.FLAVOR_RUBY, FLAVOR_OPTIONS);
                }
                case 'O': {
                    return this.expectValue(OracleDBFlavor.INSTANCE, RegexOptions.FLAVOR_ORACLE_DB, FLAVOR_OPTIONS);
                }
                case 'P': {
                    return this.expectValue(PythonFlavor.INSTANCE, RegexOptions.FLAVOR_PYTHON, FLAVOR_OPTIONS);
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(FLAVOR_OPTIONS);
        }

        private Encodings.Encoding parseEncoding() throws RegexSyntaxException {
            this.expectOptionName(RegexOptions.ENCODING_NAME);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
            }
            switch (this.src.charAt(this.i)) {
                case 'A': {
                    return this.expectEncodingValue(Encodings.ASCII);
                }
                case 'B': {
                    return this.expectValue(Encodings.BYTES, "BYTES", Encodings.ALL_NAMES);
                }
                case 'L': {
                    return this.expectEncodingValue(Encodings.LATIN_1);
                }
                case 'U': {
                    switch (this.lookAheadInKey(4)) {
                        case '8': {
                            return this.expectEncodingValue(Encodings.UTF_8);
                        }
                        case '1': {
                            return this.expectEncodingValue(Encodings.UTF_16);
                        }
                        case '3': {
                            return this.expectEncodingValue(Encodings.UTF_32);
                        }
                    }
                    throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(Encodings.ALL_NAMES);
        }

        private Encodings.Encoding expectEncodingValue(Encodings.Encoding enc) {
            return this.expectValue(enc, enc.getName(), Encodings.ALL_NAMES);
        }

        private MatchingMode parseMatchingMode(String optionName) throws RegexSyntaxException {
            this.expectOptionName(optionName);
            if (this.i >= this.src.length()) {
                throw this.optionsSyntaxErrorUnexpectedValue(MATCHING_MODE_OPTIONS);
            }
            switch (this.src.charAt(this.i)) {
                case 's': {
                    return this.expectValue(MatchingMode.search, RegexOptions.MATCHING_MODE_SEARCH, MATCHING_MODE_OPTIONS);
                }
                case 'm': {
                    return this.expectValue(MatchingMode.match, RegexOptions.MATCHING_MODE_MATCH, MATCHING_MODE_OPTIONS);
                }
                case 'f': {
                    return this.expectValue(MatchingMode.fullmatch, RegexOptions.MATCHING_MODE_FULLMATCH, MATCHING_MODE_OPTIONS);
                }
            }
            throw this.optionsSyntaxErrorUnexpectedValue(MATCHING_MODE_OPTIONS);
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedKey() {
            int eqlPos = this.src.indexOf(61, this.i);
            return this.optionsSyntaxError(String.format("unexpected option '%s'", this.src.substring(this.i, eqlPos < 0 ? this.src.length() : eqlPos)));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedValue(String ... expected) {
            return this.optionsSyntaxErrorUnexpectedValueMsg(String.format("expected one of %s", Arrays.toString(expected)));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxErrorUnexpectedValueMsg(String msg) {
            int commaPos = this.src.indexOf(44, this.i);
            String value = this.src.substring(this.i, commaPos < 0 ? this.src.length() : commaPos);
            return this.optionsSyntaxError(String.format("unexpected value '%s', %s", value, msg));
        }

        @CompilerDirectives.TruffleBoundary
        private RegexSyntaxException optionsSyntaxError(String msg) {
            return RegexSyntaxException.createOptions(this.source, String.format("Invalid options syntax in '%s': %s", this.src, msg), this.i);
        }

        private boolean isBitSet(int bit) {
            return (this.options & bit) != 0;
        }

        public boolean isUtf16ExplodeAstralSymbols() {
            return this.isBitSet(32);
        }

        public Builder flavor(RegexFlavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public RegexFlavor getFlavor() {
            return this.flavor;
        }

        public Builder encoding(Encodings.Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Encodings.Encoding getEncoding() {
            return this.encoding;
        }

        public RegexOptions build() {
            return new RegexOptions(this.options, this.maxDFASize, this.maxBackTrackerCompileSize, this.flavor, this.encoding, this.matchingMode, this.pythonLocale, this.javaJDKVersion);
        }
    }
}

