/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.analysis;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.runtime.nodes.ToLongNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.runtime.nodes.ToLongNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TruffleNull;

public final class InputStringGenerator {
    private static final CodePointSet ALLOWED_CHARACTERS = CodePointSet.createNoDedup(1, 0x10FFFF);
    private final RegexAST ast;
    private final Random rng;
    private final int[] groupBoundaries;
    private Input input = new Input();
    private int index = 0;
    private boolean forward = true;
    private Term next;
    private State state = State.advance;
    private final IntArrayBuffer lookAroundIndexReset = new IntArrayBuffer();
    private final ArrayDeque<QuantifierStackEntry> quantifierStack = new ArrayDeque();
    private final ArrayDeque<StackEntry> backtrackStack = new ArrayDeque();
    private final IntRangesBuffer scratch = new IntRangesBuffer();

    private InputStringGenerator(RegexAST ast, long rngSeed) {
        this.ast = ast;
        this.rng = new Random(rngSeed);
        this.groupBoundaries = new int[ast.getNumberOfCaptureGroups() * 2];
        Arrays.fill(this.groupBoundaries, Integer.MIN_VALUE);
        this.next = ast.getRoot();
    }

    private void incIndex() {
        this.index += this.forward ? 1 : -1;
    }

    private void decIndex() {
        this.index += this.forward ? -1 : 1;
    }

    private void setGroupStart(Group group) {
        this.setGroupBoundary(this.forward ? InputStringGenerator.groupBoundaryIndexStart(group) : InputStringGenerator.groupBoundaryIndexEnd(group));
    }

    private void setGroupEnd(Group group) {
        this.setGroupBoundary(this.forward ? InputStringGenerator.groupBoundaryIndexEnd(group) : InputStringGenerator.groupBoundaryIndexStart(group));
    }

    private int getGroupStart(int groupNumber) {
        return this.groupBoundaries[groupNumber << 1];
    }

    private int getGroupEnd(int groupNumber) {
        return this.groupBoundaries[(groupNumber << 1) + 1];
    }

    private void setGroupBoundary(int boundaryIndex) {
        this.backtrackStack.push(new SetGroupBoundaryAction(boundaryIndex, this.groupBoundaries[boundaryIndex]));
        this.groupBoundaries[boundaryIndex] = this.index;
    }

    private static int groupBoundaryIndexStart(Group group) {
        return group.getGroupNumber() << 1;
    }

    private static int groupBoundaryIndexEnd(Group group) {
        return (group.getGroupNumber() << 1) + 1;
    }

    private void setDirection(RegexASTSubtreeRootNode rootNode) {
        if (!rootNode.isLookBehindAssertion() && !this.forward || rootNode.isLookBehindAssertion() && this.forward) {
            this.forward = !this.forward;
            this.backtrackStack.push(new ChangeDirectionAction());
        }
    }

    private void pushLookAroundIndexReset() {
        this.lookAroundIndexReset.add(this.index);
        this.backtrackStack.push(new PushLookAroundIndexReset());
    }

    private void popLookAroundIndexReset() {
        int oldIndex = this.index;
        this.index = this.lookAroundIndexReset.removeLast();
        this.backtrackStack.push(new PopLookAroundIndexReset(oldIndex, this.index));
    }

    private void pushQuantifierIterations(int repetitions) {
        assert (this.next.isQuantifiableTerm());
        this.quantifierStack.push(new QuantifierStackEntry(this.next.asQuantifiableTerm(), repetitions));
        this.backtrackStack.push(new PushQuantifierStack());
    }

    private boolean popQuantifierIteration() {
        assert (!this.quantifierStack.isEmpty());
        if (this.quantifierStack.peek().count == 1) {
            this.backtrackStack.push(new PopQuantifierStack(this.quantifierStack.pop().term));
            return false;
        }
        --this.quantifierStack.peek().count;
        this.backtrackStack.push(new DecQuantifierStack());
        return true;
    }

    public static RootNode generateRootNode(RegexLanguage language, RegexAST ast) {
        return new GeneratorRootNode(language, ast);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString generate(RegexAST ast, long rngSeed) {
        return new InputStringGenerator(ast, rngSeed).generate();
    }

    private TruffleString generate() {
        this.next = this.ast.getRoot();
        while (true) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.processTerm(this.next);
                    break;
                }
                case 1: {
                    if (this.backtrackStack.isEmpty()) {
                        return this.input.toTString(this.rng, this.ast.getEncoding().getTStringEncoding());
                    }
                    this.backtrackStack.pop().apply(this);
                    break;
                }
                case 2: {
                    return this.input.toTString(this.rng, this.ast.getEncoding().getTStringEncoding());
                }
            }
        }
    }

    private void processGroup(Group group) {
        Sequence seq;
        if (group.isCapturing()) {
            this.setGroupStart(group);
        }
        if (group.size() == 1) {
            seq = group.getFirstAlternative();
        } else {
            LotteryBox randSequenceNumber = new LotteryBox(this.rng, group.size());
            seq = group.getAlternatives().get(randSequenceNumber.next());
            assert (randSequenceNumber.hasNext());
            this.backtrackStack.push(new BacktrackGroupEntry(randSequenceNumber, group));
        }
        this.processSeq(group, seq);
    }

    private void processSeq(Group group, Sequence seq) {
        if (seq.isEmpty()) {
            this.afterTerm(group);
        } else {
            this.next = this.forward ? seq.getFirstTerm() : seq.getLastTerm();
        }
    }

    private void afterTerm(Term t2) {
        Sequence parentSeq;
        int seqIndex;
        Term term = t2;
        while (true) {
            if (term.isGroup() && term.asGroup().isCapturing()) {
                this.setGroupEnd(term.asGroup());
            }
            if (term.getParent().isSubtreeRoot()) {
                assert (term.isGroup() && !term.asGroup().hasQuantifier());
                if (term.getParent().isRoot()) {
                    this.state = State.done;
                    return;
                }
                if (term.getParent().isLookAroundAssertion()) {
                    this.popLookAroundIndexReset();
                }
                this.setDirection(term.getParent().getSubTreeParent());
                term = term.getParent().asSubtreeRootNode();
                continue;
            }
            if (!this.quantifierStack.isEmpty() && term == this.quantifierStack.peek().term) {
                if (!this.popQuantifierIteration()) continue;
                this.next = term;
                return;
            }
            seqIndex = term.getSeqIndex();
            parentSeq = term.getParent().asSequence();
            if (seqIndex != (this.forward ? parentSeq.size() - 1 : 0)) break;
            term = parentSeq.getParent();
        }
        this.next = parentSeq.get(seqIndex + (this.forward ? 1 : -1));
    }

    private void processTerm(Term term) {
        if (term.isQuantifiableTerm() && term.asQuantifiableTerm().hasQuantifier() && (this.quantifierStack.isEmpty() || this.quantifierStack.peek().term != term)) {
            Token.Quantifier quantifier = term.asQuantifiableTerm().getQuantifier();
            if (quantifier.isDead() || quantifier.getMin() == Integer.MAX_VALUE) {
                this.state = State.backtrack;
                return;
            }
            int max = Integer.min(quantifier.getMin() + 10, quantifier.isInfiniteLoop() || quantifier.getMax() == Integer.MAX_VALUE ? Integer.MAX_VALUE : quantifier.getMax() + 1);
            int repetitions = this.rng.nextInt(quantifier.getMin(), max);
            if (repetitions == 0) {
                this.afterTerm(term);
                return;
            }
            this.pushQuantifierIterations(repetitions);
        }
        if (term.isPositionAssertion()) {
            this.afterTerm(term);
        } else if (term.isGroup()) {
            this.processGroup(term.asGroup());
        } else if (term.isLookAroundAssertion()) {
            this.setDirection(term.asSubtreeRootNode());
            this.pushLookAroundIndexReset();
            this.processGroup(term.asLookAroundAssertion().getGroup());
        } else if (term.isAtomicGroup()) {
            this.processGroup(term.asAtomicGroup().getGroup());
        } else if (term.isCharacterClass()) {
            CodePointSet cps = term.asCharacterClass().getCharSet();
            if (!cps.isEmpty()) {
                cps = ALLOWED_CHARACTERS.createIntersectionSingleRange(cps);
            }
            if (cps.isEmpty()) {
                this.state = State.backtrack;
                return;
            }
            if (this.input.hasNext(this.index, this.forward)) {
                CodePointSet old = this.input.get(this.index, this.forward).getCodePointSet(this.input);
                CodePointSet intersection = cps.createIntersection(this.input.get(this.index, this.forward).getCodePointSet(this.input), this.scratch);
                if (intersection.isEmpty()) {
                    this.state = State.backtrack;
                    return;
                }
                this.input.get(this.index, this.forward).setCodePointSet(intersection, this.input);
                this.backtrackStack.push(new SetCCElement(this.index - (this.forward ? 0 : 1), old));
            } else {
                this.input.append(new CCElement(cps), this.forward);
                this.backtrackStack.push(new AppendElement());
            }
            this.incIndex();
            this.afterTerm(term);
        } else if (term.isBackReference()) {
            int[] groupNumbers = term.asBackReference().getGroupNumbers();
            int groupNumber = groupNumbers[this.rng.nextInt(groupNumbers.length)];
            int start = this.getGroupStart(groupNumber);
            int end = this.getGroupEnd(groupNumber);
            if (start == Integer.MIN_VALUE || end == Integer.MIN_VALUE) {
                this.state = State.backtrack;
                return;
            }
            for (int i2 = start; i2 < end; ++i2) {
                if (this.input.hasNext(this.index, this.forward)) {
                    InputElement old = this.input.get(this.index, this.forward);
                    int indexDirect = this.index - (this.forward ? 0 : 1);
                    if (i2 != indexDirect) {
                        this.input.replace(this.index, this.forward, new BackRefElement(i2));
                        this.backtrackStack.push(new ReplaceElement(indexDirect, old));
                    }
                } else {
                    this.input.append(new BackRefElement(i2), this.forward);
                    this.backtrackStack.push(new AppendElement());
                }
                this.incIndex();
            }
            this.afterTerm(term);
        } else if (term.isSubexpressionCall()) {
            this.processGroup(this.ast.getGroup(term.asSubexpressionCall().getGroupNr()));
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static final class Input {
        private final ArrayList<InputElement> elements = new ArrayList();
        private int nPrepended = 0;

        private Input() {
        }

        public void append(InputElement e2, boolean forward) {
            if (forward) {
                this.elements.add(e2);
            } else {
                this.elements.addFirst(e2);
                ++this.nPrepended;
            }
        }

        public InputElement get(int index, boolean forward) {
            return this.elements.get(index + this.nPrepended - (forward ? 0 : 1));
        }

        public void removeLast(boolean forward) {
            if (forward) {
                this.elements.removeLast();
            } else {
                --this.nPrepended;
                this.elements.removeFirst();
            }
        }

        public void replace(int index, boolean forward, InputElement element) {
            this.elements.set(index + this.nPrepended - (forward ? 0 : 1), element);
        }

        public boolean hasNext(int index, boolean forward) {
            return forward ? index + this.nPrepended < this.elements.size() : index + this.nPrepended > 0;
        }

        public TruffleString toTString(Random rng, TruffleString.Encoding encoding) {
            int[] codepoints = new int[this.elements.size()];
            for (int i2 = 0; i2 < this.elements.size(); ++i2) {
                InputElement e2 = this.elements.get(i2);
                if (e2 instanceof CCElement) {
                    CodePointSet codePointSet = this.elements.get(i2).getCodePointSet(this);
                    int iRange = rng.nextInt(codePointSet.size());
                    codepoints[i2] = rng.nextInt(codePointSet.getLo(iRange), codePointSet.getHi(iRange) + 1);
                    continue;
                }
                if (!(e2 instanceof BackRefElement)) continue;
                BackRefElement backRef = (BackRefElement)e2;
                codepoints[i2] = codepoints[backRef.ref];
            }
            return TruffleString.fromIntArrayUTF32Uncached(codepoints).switchEncodingUncached(encoding);
        }
    }

    static enum State {
        advance,
        backtrack,
        done;

    }

    private static final class SetGroupBoundaryAction
    extends StateChange {
        private final int boundaryIndex;
        private final int oldValue;

        private SetGroupBoundaryAction(int boundaryIndex, int oldValue) {
            this.boundaryIndex = boundaryIndex;
            this.oldValue = oldValue;
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.groupBoundaries[this.boundaryIndex] = this.oldValue;
        }
    }

    private static final class ChangeDirectionAction
    extends StateChange {
        private ChangeDirectionAction() {
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.forward = !gen.forward;
        }
    }

    private static final class PushLookAroundIndexReset
    extends StateChange {
        private PushLookAroundIndexReset() {
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.lookAroundIndexReset.removeLast();
        }
    }

    private static final class PopLookAroundIndexReset
    extends StateChange {
        private final int oldIndex;
        private final int lookAroundIndexReset;

        private PopLookAroundIndexReset(int oldIndex, int lookAroundIndexReset) {
            this.oldIndex = oldIndex;
            this.lookAroundIndexReset = lookAroundIndexReset;
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.index = this.oldIndex;
            gen.lookAroundIndexReset.add(this.lookAroundIndexReset);
        }
    }

    private static final class QuantifierStackEntry {
        private final QuantifiableTerm term;
        private int count;

        private QuantifierStackEntry(QuantifiableTerm term, int count) {
            this.term = term;
            this.count = count;
        }
    }

    private static final class PushQuantifierStack
    extends StateChange {
        private PushQuantifierStack() {
        }

        @Override
        void apply(InputStringGenerator gen) {
            assert (!gen.quantifierStack.isEmpty());
            gen.quantifierStack.pop();
        }
    }

    private static final class PopQuantifierStack
    extends StateChange {
        private final QuantifiableTerm term;

        private PopQuantifierStack(QuantifiableTerm term) {
            this.term = term;
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.quantifierStack.push(new QuantifierStackEntry(this.term, 1));
        }
    }

    private static final class DecQuantifierStack
    extends StateChange {
        private DecQuantifierStack() {
        }

        @Override
        void apply(InputStringGenerator gen) {
            assert (!gen.quantifierStack.isEmpty());
            ++gen.quantifierStack.peek().count;
        }
    }

    private static final class GeneratorRootNode
    extends RootNode {
        private final RegexAST ast;
        @Node.Child
        private ToLongNode toLongNode = ToLongNodeGen.create();

        private GeneratorRootNode(RegexLanguage language, RegexAST ast) {
            super(language);
            this.ast = ast;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            long rngSeed = this.toLongNode.execute(frame.getArguments()[0]);
            return Objects.requireNonNullElse(InputStringGenerator.generate(this.ast, rngSeed), TruffleNull.INSTANCE);
        }
    }

    private static abstract class StackEntry {
        private StackEntry() {
        }

        abstract void apply(InputStringGenerator var1);
    }

    private static final class LotteryBox
    implements Iterator<Integer> {
        private final Random rng;
        private final int[] choices;
        private int nChoices;

        private LotteryBox(Random rng, int nChoices) {
            this.rng = rng;
            this.choices = new int[nChoices];
            this.nChoices = nChoices;
            for (int i2 = 0; i2 < nChoices; ++i2) {
                this.choices[i2] = i2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nChoices > 0;
        }

        @Override
        public Integer next() {
            int i2 = this.rng.nextInt(this.nChoices);
            int ret = this.choices[i2];
            --this.nChoices;
            this.choices[i2] = this.choices[this.nChoices];
            return ret;
        }
    }

    private static final class BacktrackGroupEntry
    extends BacktrackingEntry {
        private final Group group;

        private BacktrackGroupEntry(LotteryBox choices, Group group) {
            super(choices);
            this.group = group;
        }

        @Override
        void apply(InputStringGenerator gen) {
            int i2 = this.choices.next();
            if (this.choices.hasNext()) {
                gen.backtrackStack.push(this);
            }
            gen.processSeq(this.group, this.group.getAlternatives().get(i2));
        }
    }

    private static abstract class InputElement {
        private InputElement() {
        }

        abstract CodePointSet getCodePointSet(Input var1);

        abstract CodePointSet setCodePointSet(CodePointSet var1, Input var2);
    }

    private static final class SetCCElement
    extends StateChange {
        private final int index;
        private final CodePointSet oldCPS;

        private SetCCElement(int index, CodePointSet oldCPS) {
            this.index = index;
            this.oldCPS = oldCPS;
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.input.get(this.index, true).setCodePointSet(this.oldCPS, gen.input);
            gen.decIndex();
        }
    }

    private static final class CCElement
    extends InputElement {
        private CodePointSet cps;

        private CCElement(CodePointSet cps) {
            this.cps = cps;
        }

        @Override
        CodePointSet getCodePointSet(Input input) {
            return this.cps;
        }

        @Override
        CodePointSet setCodePointSet(CodePointSet cps, Input input) {
            this.cps = cps;
            return this.cps;
        }
    }

    private static final class AppendElement
    extends StateChange {
        private AppendElement() {
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.input.removeLast(gen.forward);
            gen.decIndex();
        }
    }

    private static final class BackRefElement
    extends InputElement {
        private final int ref;

        private BackRefElement(int ref) {
            this.ref = ref;
        }

        @Override
        CodePointSet getCodePointSet(Input input) {
            return input.get(this.ref, true).getCodePointSet(input);
        }

        @Override
        CodePointSet setCodePointSet(CodePointSet cps, Input input) {
            return input.get(this.ref, true).setCodePointSet(cps, input);
        }
    }

    private static final class ReplaceElement
    extends StateChange {
        private final int index;
        private final InputElement oldElement;

        private ReplaceElement(int index, InputElement oldElement) {
            this.index = index;
            this.oldElement = oldElement;
        }

        @Override
        void apply(InputStringGenerator gen) {
            gen.input.replace(this.index, true, this.oldElement);
            gen.decIndex();
        }
    }

    private static abstract class StateChange
    extends StackEntry {
        private StateChange() {
        }
    }

    private static abstract class BacktrackingEntry
    extends StackEntry {
        final LotteryBox choices;

        private BacktrackingEntry(LotteryBox choices) {
            this.choices = choices;
        }
    }
}

