/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Range;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;

public final class SingleRangeMatcher
extends InvertibleCharMatcher {
    private final int lo;
    private final int hi;

    SingleRangeMatcher(boolean invert, int lo, int hi) {
        super(invert);
        this.lo = lo;
        this.hi = hi;
    }

    public static SingleRangeMatcher create(boolean invert, int lo, int hi) {
        return new SingleRangeMatcher(invert, lo, hi);
    }

    public int getLo() {
        return this.lo;
    }

    public int getHi() {
        return this.hi;
    }

    @Override
    public boolean match(int c2) {
        return this.result(this.lo <= c2 && this.hi >= c2);
    }

    @Override
    public int estimatedCost() {
        return 2;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + Range.toString(this.lo, this.hi);
    }
}

