/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTStep;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTStepVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTSuccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.ASTTransitionCanonicalizer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Counter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class NFAGenerator {
    private final RegexAST ast;
    private final Counter.ThresholdCounter stateID = new Counter.ThresholdCounter(3500, "NFA explosion");
    private final Counter.ThresholdCounter transitionID = new Counter.ThresholdCounter(Short.MAX_VALUE, "NFA transition explosion");
    private final NFAState dummyInitialState;
    private final NFAState[] anchoredInitialStates;
    private final NFAState[] initialStates;
    private final NFAState advancedInitialState;
    private final NFAState anchoredFinalState;
    private final NFAState finalState;
    private final NFAStateTransition[] anchoredEntries;
    private final NFAStateTransition[] unAnchoredEntries;
    private final NFAStateTransition anchoredReverseEntry;
    private final NFAStateTransition unAnchoredReverseEntry;
    private NFAStateTransition initialLoopBack;
    private final Deque<NFAState> expansionQueue = new ArrayDeque<NFAState>();
    private final Map<NFAStateID, NFAState> nfaStates = new HashMap<NFAStateID, NFAState>();
    private final List<NFAState> hardPrefixStates = new ArrayList<NFAState>();
    private final ASTStepVisitor astStepVisitor;
    private final ASTTransitionCanonicalizer astTransitionCanonicalizer;
    private final TBitSet transitionGBUpdateIndices;
    private final TBitSet transitionGBClearIndices;
    private final ArrayList<NFAStateTransition> transitionsBuffer = new ArrayList();
    private final CompilationBuffer compilationBuffer;

    private NFAGenerator(RegexAST ast, CompilationBuffer compilationBuffer) {
        int i2;
        this.ast = ast;
        this.astStepVisitor = new ASTStepVisitor(ast);
        this.transitionGBUpdateIndices = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.transitionGBClearIndices = new TBitSet(ast.getNumberOfCaptureGroups() * 2);
        this.astTransitionCanonicalizer = new ASTTransitionCanonicalizer(ast, true, false);
        this.compilationBuffer = compilationBuffer;
        this.dummyInitialState = new NFAState((short)this.stateID.inc(), StateSet.create(ast, ast.getWrappedRoot()), CodePointSet.getEmpty(), Collections.emptySet(), false, ast.getOptions().isMustAdvance());
        this.nfaStates.put(NFAStateID.create(this.dummyInitialState), this.dummyInitialState);
        this.anchoredFinalState = this.createFinalState(StateSet.create(ast, ast.getRoot().getSubTreeParent().getAnchoredFinalState()), false);
        this.anchoredFinalState.setAnchoredFinalState();
        this.finalState = this.createFinalState(StateSet.create(ast, ast.getRoot().getSubTreeParent().getMatchFound()), false);
        this.finalState.setUnAnchoredFinalState();
        assert (this.transitionGBUpdateIndices.isEmpty() && this.transitionGBClearIndices.isEmpty());
        this.anchoredReverseEntry = this.createTransition(this.anchoredFinalState, this.dummyInitialState, ast.getEncoding().getFullSet(), -1);
        this.unAnchoredReverseEntry = this.createTransition(this.finalState, this.dummyInitialState, ast.getEncoding().getFullSet(), -1);
        int nEntries = ast.getWrappedPrefixLength() + 1;
        this.initialStates = new NFAState[nEntries];
        this.advancedInitialState = ast.getOptions().isMustAdvance() ? this.createFinalState(StateSet.create(ast, ast.getNFAUnAnchoredInitialState(0)), false) : null;
        this.unAnchoredEntries = new NFAStateTransition[nEntries];
        for (i2 = 0; i2 < this.initialStates.length; ++i2) {
            this.initialStates[i2] = this.createFinalState(StateSet.create(ast, ast.getNFAUnAnchoredInitialState(i2)), ast.getOptions().isMustAdvance());
            this.initialStates[i2].setUnAnchoredInitialState(true);
            this.unAnchoredEntries[i2] = this.createTransition(this.dummyInitialState, this.initialStates[i2], ast.getEncoding().getFullSet(), -1);
            if (i2 <= 0) continue;
            this.initialStates[i2].setHasPrefixStates(true);
        }
        if (ast.getReachableCarets().isEmpty()) {
            this.anchoredInitialStates = this.initialStates;
            this.anchoredEntries = this.unAnchoredEntries;
            dummyInitNext = Arrays.copyOf(this.anchoredEntries, nEntries);
            this.dummyInitialState.setSuccessors(dummyInitNext, false);
        } else {
            this.anchoredInitialStates = new NFAState[nEntries];
            this.anchoredEntries = new NFAStateTransition[nEntries];
            for (i2 = 0; i2 < this.anchoredInitialStates.length; ++i2) {
                this.anchoredInitialStates[i2] = this.createFinalState(StateSet.create(ast, ast.getNFAAnchoredInitialState(i2)), ast.getOptions().isMustAdvance());
                this.anchoredInitialStates[i2].setAnchoredInitialState();
                if (i2 > 0) {
                    this.initialStates[i2].setHasPrefixStates(true);
                }
                this.anchoredEntries[i2] = this.createTransition(this.dummyInitialState, this.anchoredInitialStates[i2], ast.getEncoding().getFullSet(), -1);
            }
            dummyInitNext = Arrays.copyOf(this.anchoredEntries, nEntries * 2);
            System.arraycopy(this.unAnchoredEntries, 0, dummyInitNext, nEntries, nEntries);
            this.dummyInitialState.setSuccessors(dummyInitNext, false);
        }
        AbstractTransition[] dummyInitPrev = new NFAStateTransition[]{this.anchoredReverseEntry, this.unAnchoredReverseEntry};
        this.dummyInitialState.setPredecessors(dummyInitPrev);
    }

    public static NFA createNFA(RegexAST ast, CompilationBuffer compilationBuffer) {
        return new NFAGenerator(ast, compilationBuffer).doCreateNFA();
    }

    private NFA doCreateNFA() {
        Collections.addAll(this.expansionQueue, this.initialStates);
        if (this.ast.getOptions().isMustAdvance()) {
            this.expansionQueue.add(this.advancedInitialState);
        }
        if (!this.ast.getReachableCarets().isEmpty()) {
            Collections.addAll(this.expansionQueue, this.anchoredInitialStates);
        }
        while (!this.expansionQueue.isEmpty()) {
            this.expandNFAState(this.expansionQueue.pop());
        }
        assert (this.transitionGBUpdateIndices.isEmpty() && this.transitionGBClearIndices.isEmpty());
        for (int i2 = 1; i2 < this.initialStates.length; ++i2) {
            this.addNewLoopBackTransition(this.initialStates[i2], this.initialStates[i2 - 1]);
        }
        if (this.ast.getOptions().isMustAdvance()) {
            this.addNewLoopBackTransition(this.initialStates[0], this.advancedInitialState);
            this.initialLoopBack = this.createTransition(this.advancedInitialState, this.advancedInitialState, this.ast.getEncoding().getFullSet(), -1);
        } else {
            this.initialLoopBack = this.createTransition(this.initialStates[0], this.initialStates[0], this.ast.getEncoding().getFullSet(), -1);
        }
        for (NFAState s2 : this.nfaStates.values()) {
            if (s2 == this.dummyInitialState || !this.ast.getHardPrefixNodes().isDisjoint(s2.getStateSet()) && !this.ast.getFlags().isSticky()) continue;
            s2.linkPredecessors();
        }
        this.pruneDeadStates();
        return new NFA(this.ast, this.dummyInitialState, this.anchoredEntries, this.unAnchoredEntries, this.anchoredReverseEntry, this.unAnchoredReverseEntry, this.nfaStates.values(), this.stateID, this.transitionID, this.initialLoopBack, null);
    }

    private void pruneDeadStates() {
        ArrayList<NFAState> deadStates = new ArrayList<NFAState>();
        this.findDeadStates(deadStates);
        while (!deadStates.isEmpty()) {
            for (NFAState state : deadStates) {
                for (NFAStateTransition nFAStateTransition : (NFAStateTransition[])state.getPredecessors()) {
                    nFAStateTransition.getSource().removeSuccessor(state);
                }
                for (NFAState prefixState : this.hardPrefixStates) {
                    prefixState.removeSuccessor(state);
                }
                for (NFAState nFAState : this.initialStates) {
                    nFAState.removeSuccessor(state);
                }
                for (NFAState nFAState : this.anchoredInitialStates) {
                    nFAState.removeSuccessor(state);
                }
                for (int i2 = 0; i2 < this.unAnchoredEntries.length; ++i2) {
                    if (this.unAnchoredEntries[i2] == null || this.unAnchoredEntries[i2].getTarget() != state) continue;
                    this.unAnchoredEntries[i2] = null;
                }
                for (int i2 = 0; i2 < this.anchoredEntries.length; ++i2) {
                    if (this.anchoredEntries[i2] == null || this.anchoredEntries[i2].getTarget() != state) continue;
                    this.anchoredEntries[i2] = null;
                }
                if (this.initialLoopBack != null && this.initialLoopBack.getTarget() == state) {
                    this.initialLoopBack = null;
                }
                if (this.ast.getOptions().isMustAdvance()) {
                    this.advancedInitialState.removeSuccessor(state);
                }
                this.dummyInitialState.removeSuccessor(state);
                this.nfaStates.remove(NFAStateID.create(state));
            }
            deadStates.clear();
            this.findDeadStates(deadStates);
        }
    }

    private void findDeadStates(ArrayList<NFAState> deadStates) {
        for (NFAState state : this.nfaStates.values()) {
            if (!state.isDead(true)) continue;
            deadStates.add(state);
        }
    }

    private void expandNFAState(NFAState curState) {
        boolean isHardPrefixState;
        ASTStep nextStep = this.astStepVisitor.step(curState);
        boolean bl = isHardPrefixState = !this.ast.getHardPrefixNodes().isDisjoint(curState.getStateSet());
        if (isHardPrefixState) {
            this.hardPrefixStates.add(curState);
        }
        curState.setSuccessors(this.createNFATransitions(curState, nextStep), !isHardPrefixState || this.ast.getFlags().isSticky());
    }

    private NFAStateTransition[] createNFATransitions(NFAState sourceState, ASTStep nextStep) {
        this.transitionsBuffer.clear();
        for (ASTSuccessor successor : nextStep.getSuccessors()) {
            for (TransitionBuilder<RegexAST, Term, ASTTransition> mergeBuilder : successor.getMergedStates(this.astTransitionCanonicalizer, this.compilationBuffer)) {
                StateSet<RegexAST, CharacterClass> stateSetCC = null;
                StateSet<RegexAST, LookBehindAssertion> finishedLookBehinds = null;
                boolean containsPositionAssertion = false;
                boolean containsMatchFound = false;
                boolean containsPrefixStates = false;
                int lastGroup = -1;
                EconomicMap<Integer, TBitSet> matchedConditionGroupsMap = this.ast.getProperties().hasConditionalBackReferences() ? EconomicMap.create() : null;
                for (ASTTransition astTransition : (ASTTransition[])mergeBuilder.getTransitionSet().getTransitions()) {
                    Term target = astTransition.getTarget();
                    if (target instanceof CharacterClass) {
                        if (stateSetCC == null) {
                            stateSetCC = StateSet.create(this.ast);
                            finishedLookBehinds = StateSet.create(this.ast);
                        }
                        stateSetCC.add((CharacterClass)target);
                        if (target.isInLookBehindAssertion() && target == ((Sequence)target.getParent()).getLastTerm()) {
                            finishedLookBehinds.add((LookBehindAssertion)target.getSubTreeParent());
                        }
                    } else if (target instanceof PositionAssertion) {
                        containsPositionAssertion = true;
                    } else {
                        assert (target instanceof MatchFound);
                        containsMatchFound = true;
                    }
                    containsPrefixStates |= target.isPrefix();
                    astTransition.getGroupBoundaries().updateBitSets(this.transitionGBUpdateIndices, this.transitionGBClearIndices);
                    if (!target.isInLookAheadAssertion() && !target.isInLookBehindAssertion()) {
                        lastGroup = astTransition.getGroupBoundaries().getLastGroup();
                    }
                    if (!this.ast.getProperties().hasConditionalBackReferences()) continue;
                    matchedConditionGroupsMap.put(target.getId(), astTransition.getMatchedConditionGroups());
                }
                if (!(sourceState.isMustAdvance() && this.transitionGBUpdateIndices.get(0) && this.transitionGBUpdateIndices.get(1))) {
                    if (stateSetCC == null) {
                        if (containsPositionAssertion) {
                            this.transitionsBuffer.add(this.createTransition(sourceState, this.anchoredFinalState, this.ast.getEncoding().getFullSet(), lastGroup));
                        } else if (containsMatchFound) {
                            this.transitionsBuffer.add(this.createTransition(sourceState, this.finalState, this.ast.getEncoding().getFullSet(), lastGroup));
                            this.transitionGBUpdateIndices.clear();
                            this.transitionGBClearIndices.clear();
                            return this.transitionsBuffer.toArray(new NFAStateTransition[this.transitionsBuffer.size()]);
                        }
                    } else if (!containsPositionAssertion) {
                        assert (mergeBuilder.getCodePointSet().matchesSomething());
                        NFAState targetState = this.registerMatcherState(stateSetCC, mergeBuilder.getCodePointSet(), finishedLookBehinds, containsPrefixStates, sourceState.isMustAdvance() && !this.ast.getHardPrefixNodes().isDisjoint(stateSetCC), matchedConditionGroupsMap);
                        this.transitionsBuffer.add(this.createTransition(sourceState, targetState, mergeBuilder.getCodePointSet(), lastGroup));
                    }
                }
                this.transitionGBUpdateIndices.clear();
                this.transitionGBClearIndices.clear();
            }
        }
        return this.transitionsBuffer.toArray(new NFAStateTransition[this.transitionsBuffer.size()]);
    }

    private NFAState createFinalState(StateSet<RegexAST, ? extends RegexASTNode> stateSet, boolean mustAdvance) {
        NFAState state = new NFAState((short)this.stateID.inc(), stateSet, this.ast.getEncoding().getFullSet(), Collections.emptySet(), false, mustAdvance);
        assert (!this.nfaStates.containsKey(NFAStateID.create(state)));
        this.nfaStates.put(NFAStateID.create(state), state);
        return state;
    }

    private NFAStateTransition createTransition(NFAState source, NFAState target, CodePointSet codePointSet, int lastGroup) {
        return new NFAStateTransition((short)this.transitionID.inc(), source, target, codePointSet, this.ast.createGroupBoundaries(this.transitionGBUpdateIndices, this.transitionGBClearIndices, lastGroup));
    }

    private NFAState registerMatcherState(StateSet<RegexAST, CharacterClass> stateSetCC, CodePointSet matcherBuilder, StateSet<RegexAST, LookBehindAssertion> finishedLookBehinds, boolean containsPrefixStates, boolean mustAdvance, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        NFAStateID nfaStateID = new NFAStateID(stateSetCC, mustAdvance, matchedConditionGroupsMap);
        if (this.nfaStates.containsKey(nfaStateID)) {
            return this.nfaStates.get(nfaStateID);
        }
        NFAState state = new NFAState((short)this.stateID.inc(), stateSetCC, matcherBuilder, finishedLookBehinds, containsPrefixStates, mustAdvance, matchedConditionGroupsMap);
        this.expansionQueue.push(state);
        this.nfaStates.put(nfaStateID, state);
        return state;
    }

    private void addNewLoopBackTransition(NFAState source, NFAState target) {
        source.addLoopBackNext(this.createTransition(source, target, this.ast.getEncoding().getFullSet(), -1));
        if (this.ast.getHardPrefixNodes().isDisjoint(source.getStateSet()) || this.ast.getFlags().isSticky()) {
            target.incPredecessors();
        }
    }

    private static final class NFAStateID {
        private final StateSet<RegexAST, ? extends RegexASTNode> stateSet;
        private final boolean mustAdvance;
        private final EconomicMap<Integer, TBitSet> matchedConditionGroupsMap;

        NFAStateID(StateSet<RegexAST, ? extends RegexASTNode> stateSet, boolean mustAdvance, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
            this.stateSet = stateSet;
            this.mustAdvance = mustAdvance;
            this.matchedConditionGroupsMap = matchedConditionGroupsMap;
        }

        public static NFAStateID create(NFAState state) {
            return new NFAStateID(state.getStateSet(), state.isMustAdvance(), state.getMatchedConditionGroupsMap());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof NFAStateID)) {
                return false;
            }
            NFAStateID that = (NFAStateID)o2;
            return this.mustAdvance == that.mustAdvance && this.stateSet.equals(that.stateSet) && NFAStateID.mapEquals(this.matchedConditionGroupsMap, that.matchedConditionGroupsMap);
        }

        private static <K, V> boolean mapEquals(EconomicMap<K, V> mapA, EconomicMap<K, V> mapB) {
            if (mapA == null) {
                return mapB == null;
            }
            if (mapB == null) {
                return mapA == null;
            }
            if (mapA.size() != mapB.size()) {
                return false;
            }
            for (Object key : mapA.getKeys()) {
                if (mapB.containsKey(key) && mapA.get(key).equals(mapB.get(key))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.stateSet, this.mustAdvance, NFAStateID.mapHashCode(this.matchedConditionGroupsMap));
        }

        private static <K, V> int mapHashCode(EconomicMap<K, V> map) {
            if (map == null) {
                return 0;
            }
            int hashCode = 0;
            for (Object value : map.getValues()) {
                hashCode = 31 * hashCode + value.hashCode();
            }
            return hashCode;
        }
    }
}

