/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodesplitter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateIndex;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.ShortArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodesplitter.DFANodeSplitBailoutException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodesplitter.DominatorTree;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodesplitter.Graph;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodesplitter.GraphNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;

public final class DFANodeSplit
implements StateIndex<GraphNode> {
    public static final int EXTRA_INITIAL_CAPACITY = 20;
    private final DFAGenerator dfaGenerator;
    private final Graph graph;
    private final DominatorTree domTree;
    private final TBitSet flagDone;
    private final TBitSet flagActive;
    private short nextId;

    private DFANodeSplit(DFAGenerator dfaGenerator, DFAAbstractStateNode[] dfa) {
        this.dfaGenerator = dfaGenerator;
        this.graph = new Graph(dfa.length + 20);
        TBitSet successorBitSet = new TBitSet(dfa.length);
        ShortArrayBuffer successorBuffer = new ShortArrayBuffer();
        for (DFAAbstractStateNode n2 : dfa) {
            for (int i2 = 0; i2 < n2.getSuccessors().length; ++i2) {
                if (n2.getSuccessors()[i2] == -1) {
                    assert (n2 instanceof DFAInitialStateNode);
                    continue;
                }
                if (!successorBitSet.get(n2.getSuccessors()[i2])) {
                    successorBuffer.add((short)i2);
                }
                successorBitSet.set(n2.getSuccessors()[i2]);
            }
            GraphNode graphNode = new GraphNode(this, n2, successorBuffer.toArray());
            successorBitSet.clear();
            successorBuffer.clear();
            this.graph.addGraphNode(graphNode);
        }
        this.nextId = (short)this.graph.size();
        this.flagDone = new TBitSet(this.graph.size() + 20);
        this.flagActive = new TBitSet(this.graph.size() + 20);
        for (GraphNode graphNode : this.graph.getNodes()) {
            for (GraphNode successor : graphNode.getSuccessors(this)) {
                successor.addPredecessor(graphNode);
            }
        }
        this.graph.setStart(this.graph.getNodes().get(0));
        this.domTree = new DominatorTree(this.graph);
    }

    private boolean isDone(GraphNode node) {
        return this.flagDone.get(node.getId());
    }

    private void setDone(GraphNode node) {
        this.flagDone.set(node.getId());
    }

    private void clearDone(GraphNode node) {
        this.flagDone.clear(node.getId());
    }

    private boolean isActive(GraphNode node) {
        return this.flagActive.get(node.getId());
    }

    private void setActive(GraphNode node) {
        this.flagActive.set(node.getId());
    }

    private void clearActive(GraphNode node) {
        this.flagActive.clear(node.getId());
    }

    public void addGraphNode(GraphNode graphNode) {
        this.graph.addGraphNode(graphNode);
    }

    public static DFAAbstractStateNode[] createReducibleGraph(DFAAbstractStateNode[] nodes) throws DFANodeSplitBailoutException {
        return new DFANodeSplit(null, nodes).process();
    }

    public static DFAAbstractStateNode[] createReducibleGraphAndUpdateDFAGen(DFAGenerator dfaGen, DFAAbstractStateNode[] nodes) throws DFANodeSplitBailoutException {
        return new DFANodeSplit(dfaGen, nodes).process();
    }

    @Override
    public int getNumberOfStates() {
        return this.graph.getNumberOfStates();
    }

    @Override
    public int getId(GraphNode state) {
        return state.getId();
    }

    @Override
    public GraphNode getState(int id) {
        return this.graph.getState(id);
    }

    private DFAAbstractStateNode[] process() throws DFANodeSplitBailoutException {
        this.domTree.createDomTree();
        this.searchBackEdges(this.graph.getStart());
        this.markUndone();
        this.splitLoops(this.graph.getStart(), Collections.emptySet());
        DFAAbstractStateNode[] ret = new DFAAbstractStateNode[this.graph.size()];
        for (GraphNode node : this.graph.getNodes()) {
            ret[node.getDfaNode().getId()] = node.getDfaNode();
        }
        if (this.dfaGenerator != null) {
            this.updateDFAGenerator();
        }
        return ret;
    }

    private void updateDFAGenerator() {
        this.dfaGenerator.nodeSplitSetNewDFASize(this.graph.size());
        for (GraphNode node : this.graph.getNodes()) {
            node.registerDuplicate(this.dfaGenerator);
        }
        for (GraphNode node : this.graph.getNodes()) {
            node.updateSuccessors(this.dfaGenerator);
        }
    }

    private boolean splitLoops(GraphNode topNode, Set<GraphNode> set) throws DFANodeSplitBailoutException {
        boolean crossEdge = false;
        for (GraphNode child : topNode.getDomChildren(this)) {
            if (!set.isEmpty() && !set.contains(child) || !this.splitLoops(child, set)) continue;
            crossEdge = true;
        }
        if (crossEdge) {
            this.handleIrChildren(topNode, set);
        }
        for (GraphNode pred : topNode.getPredecessors()) {
            if (!pred.isBackEdge(topNode) || this.domTree.dom(topNode, pred)) continue;
            return true;
        }
        return false;
    }

    private void handleIrChildren(GraphNode topNode, Set<GraphNode> set) throws DFANodeSplitBailoutException {
        ArrayDeque<GraphNode> dfsList = new ArrayDeque<GraphNode>();
        ArrayList sccList = new ArrayList();
        for (GraphNode graphNode : topNode.getDomChildren(this)) {
            if (this.isDone(graphNode) || !set.isEmpty() && !set.contains(graphNode)) continue;
            this.scc1(dfsList, graphNode, set, topNode.getDomTreeDepth());
        }
        for (GraphNode graphNode : dfsList) {
            if (!this.isDone(graphNode)) continue;
            StateSet scc = StateSet.create(this);
            this.scc2(scc, graphNode, topNode.getDomTreeDepth());
            sccList.add(scc);
        }
        for (Set set2 : sccList) {
            if (set2.size() <= 1) continue;
            this.handleScc(topNode, set2);
        }
    }

    private void scc1(ArrayDeque<GraphNode> dfsList, GraphNode curNode, Set<GraphNode> set, int level) {
        this.setDone(curNode);
        for (GraphNode child : curNode.getSuccessors(this)) {
            if (this.isDone(child) || child.getDomTreeDepth() <= level || !set.isEmpty() && !set.contains(child)) continue;
            this.scc1(dfsList, child, set, level);
        }
        dfsList.push(curNode);
    }

    private void scc2(Set<GraphNode> scc, GraphNode curNode, int level) {
        this.clearDone(curNode);
        for (GraphNode pred : curNode.getPredecessors()) {
            if (!this.isDone(pred) || pred.getDomTreeDepth() <= level) continue;
            this.scc2(scc, pred, level);
        }
        scc.add(curNode);
    }

    private void handleScc(GraphNode topNode, Set<GraphNode> scc) throws DFANodeSplitBailoutException {
        StateSet msed = StateSet.create(this);
        for (GraphNode n2 : scc) {
            if (n2.getDomTreeDepth() != topNode.getDomTreeDepth() + 1) continue;
            n2.setWeightAndHeaders(this, n2, scc);
            msed.add(n2);
        }
        if (msed.size() <= 1) {
            return;
        }
        this.splitSCC(DFANodeSplit.chooseNode(msed), scc);
        this.domTree.createDomTree();
        this.markUndone();
        this.searchBackEdges(this.graph.getStart());
        this.markUndone();
        for (GraphNode tmp : this.findTopNodes(scc)) {
            this.splitLoops(tmp, scc);
        }
    }

    private void splitSCC(GraphNode headerNode, Set<GraphNode> scc) throws DFANodeSplitBailoutException {
        for (GraphNode n2 : scc) {
            if (n2.getHeader() == headerNode) continue;
            if (this.nextId == 4000) {
                CompilerDirectives.transferToInterpreter();
                throw new DFANodeSplitBailoutException();
            }
            short s2 = this.nextId;
            this.nextId = (short)(s2 + 1);
            n2.createCopy(this, s2);
        }
        for (GraphNode cur : scc) {
            if (cur.getHeader() == headerNode) continue;
            for (GraphNode suc : cur.getSuccessors(this)) {
                if (suc.getCopy() == null) {
                    suc.addPredecessor(cur.getCopy());
                    continue;
                }
                cur.getCopy().replaceSuccessor(suc);
                suc.getCopy().replacePredecessor(cur);
            }
            Iterator<GraphNode> curPredecessors = cur.getPredecessors().iterator();
            while (curPredecessors.hasNext()) {
                GraphNode pred = curPredecessors.next();
                if (pred.getCopy() != null) continue;
                if (scc.contains(pred)) {
                    pred.replaceSuccessor(cur);
                    curPredecessors.remove();
                    continue;
                }
                cur.getCopy().removePredecessor(pred);
            }
        }
        for (GraphNode g2 : new ArrayList<GraphNode>(scc)) {
            if (g2.getHeader() == headerNode) continue;
            scc.add(g2.getCopy());
            g2.clearCopy();
        }
    }

    private Set<GraphNode> findTopNodes(Set<GraphNode> scc) {
        StateSet tops = StateSet.create(this);
        for (GraphNode tmp : scc) {
            GraphNode top = this.domTree.idom(tmp);
            while (scc.contains(top)) {
                top = this.domTree.idom(top);
            }
            tops.add(top);
        }
        return tops;
    }

    private static GraphNode chooseNode(Set<GraphNode> msed) {
        int maxWeight = 0;
        GraphNode maxNode = null;
        for (GraphNode n2 : msed) {
            if (n2.getWeight() <= maxWeight) continue;
            maxWeight = n2.getWeight();
            maxNode = n2;
        }
        return maxNode;
    }

    private void searchBackEdges(GraphNode cnode) {
        this.setDone(cnode);
        this.setActive(cnode);
        cnode.clearBackEdges();
        for (GraphNode child : cnode.getSuccessors(this)) {
            if (this.isActive(child)) {
                cnode.markBackEdge(child);
                continue;
            }
            if (this.isDone(child)) continue;
            this.searchBackEdges(child);
        }
        this.clearActive(cnode);
    }

    private void markUndone() {
        this.flagDone.clear();
        this.flagActive.clear();
    }
}

