/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public final class ASTDotExportVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private final BufferedWriter writer;
    private final boolean showParentPointers;

    private ASTDotExportVisitor(BufferedWriter writer, boolean showParentPointers) {
        this.writer = writer;
        this.showParentPointers = showParentPointers;
    }

    @CompilerDirectives.TruffleBoundary
    public static void exportDot(RegexASTNode root, String path, boolean showParentPointers) {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(path, new String[0]), new OpenOption[0]);){
            ASTDotExportVisitor visitor = new ASTDotExportVisitor(writer, showParentPointers);
            writer.write("digraph ast {");
            writer.newLine();
            visitor.run(root);
            writer.write("}");
            writer.newLine();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String deadStyle(RegexASTNode node) {
        return node.isDead() ? ", style=filled, color=grey" : "";
    }

    @CompilerDirectives.TruffleBoundary
    private void writeln(String s2) {
        try {
            this.writer.write(s2);
            this.writer.newLine();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String nodeName(RegexASTNode node) {
        return String.format("node%d", node.getId());
    }

    private void printParentNextPrev(RegexASTNode node) {
        if (this.showParentPointers && node.getParent() != null) {
            this.writeln(String.format("%s -> %s [label=parent];", ASTDotExportVisitor.nodeName(node), ASTDotExportVisitor.nodeName(node.getParent())));
        }
    }

    @Override
    protected void visit(BackReference backReference) {
        this.writeln(String.format("%s [label=\"%s\", shape=box%s];", ASTDotExportVisitor.nodeName(backReference), backReference.toString().replace("\\", "\\\\"), ASTDotExportVisitor.deadStyle(backReference)));
        this.printParentNextPrev(backReference);
    }

    @Override
    protected void visit(Group group) {
        this.writeln(String.format("%s [label=group, shape=%s%s];", ASTDotExportVisitor.nodeName(group), group.isCapturing() ? "doublecircle" : "circle", ASTDotExportVisitor.deadStyle(group)));
        this.printParentNextPrev(group);
        int i2 = 0;
        for (Sequence s2 : group.getAlternatives()) {
            this.writeln(String.format("%s -> %s [label=alt%d];", ASTDotExportVisitor.nodeName(group), ASTDotExportVisitor.nodeName(s2), i2++));
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        this.writeln(String.format("%s [label=seq, shape=house%s];", ASTDotExportVisitor.nodeName(sequence), ASTDotExportVisitor.deadStyle(sequence)));
        this.printParentNextPrev(sequence);
        int i2 = 0;
        for (Term t2 : sequence.getTerms()) {
            this.writeln(String.format("%s -> %s [label=seq%d];", ASTDotExportVisitor.nodeName(sequence), ASTDotExportVisitor.nodeName(t2), i2++));
        }
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        this.writeln(String.format("%s [label=\"%s\", shape=box%s];", ASTDotExportVisitor.nodeName(assertion), assertion, ASTDotExportVisitor.deadStyle(assertion)));
        this.printParentNextPrev(assertion);
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        this.visitSubtreeRootNode(assertion, "lb", "ass");
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        this.visitSubtreeRootNode(assertion, "la", "ass");
    }

    @Override
    protected void visit(AtomicGroup atomicGroup) {
        this.visitSubtreeRootNode(atomicGroup, "atom", "grp");
    }

    private void visitSubtreeRootNode(RegexASTSubtreeRootNode subtreeRootNode, String nodeLabel, String edgeLabel) {
        this.writeln(String.format("%s [label=%s, shape=box%s];", ASTDotExportVisitor.nodeName(subtreeRootNode), nodeLabel, ASTDotExportVisitor.deadStyle(subtreeRootNode)));
        this.printParentNextPrev(subtreeRootNode);
        this.writeln(String.format("%s -> %s [label=%s];", ASTDotExportVisitor.nodeName(subtreeRootNode), ASTDotExportVisitor.nodeName(subtreeRootNode.getGroup()), edgeLabel));
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        this.writeln(String.format("%s [label=\"%s\", shape=box%s];", ASTDotExportVisitor.nodeName(characterClass), characterClass.toString().replace("\\", "\\\\"), ASTDotExportVisitor.deadStyle(characterClass)));
        this.printParentNextPrev(characterClass);
    }

    @Override
    protected void visit(SubexpressionCall subexpressionCall) {
        this.writeln(String.format("%s [label=\"%s\", shape=box%s];", ASTDotExportVisitor.nodeName(subexpressionCall), subexpressionCall.toString().replace("\\", "\\\\"), ASTDotExportVisitor.deadStyle(subexpressionCall)));
        this.printParentNextPrev(subexpressionCall);
    }
}

