/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Range;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonLocaleData {
    private static final int CACHE_SIZE = 16;
    private static final LRUCache<CacheKey, PythonLocaleData> CACHED_LOCALE_DATA = new LRUCache(16);
    private final CodePointSet wordChars;
    private final CodePointSet nonWordChars;
    private final byte[] caseFolding;

    public static PythonLocaleData getLocaleData(String locale) {
        if (locale.equals("C")) {
            return PythonLocaleData.createCachedLocaleData(false, Charset.forName("US-ASCII"));
        }
        int dot = locale.indexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("malformed locale: " + locale);
        }
        String language = locale.substring(0, dot);
        String encoding = locale.substring(dot + 1);
        try {
            return PythonLocaleData.createCachedLocaleData(language.startsWith("tr_"), Charset.forName(encoding));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e2) {
            throw new IllegalArgumentException("unsupported locale: " + locale);
        }
    }

    public CodePointSet getWordCharacters() {
        return this.wordChars;
    }

    public CodePointSet getNonWordCharacters() {
        return this.nonWordChars;
    }

    public void caseFoldUnfold(CodePointSetAccumulator charClass, CodePointSetAccumulator copy) {
        charClass.copyTo(copy);
        int iFolding = 0;
        for (Range r2 : copy) {
            for (iFolding = this.caseFoldingBinarySearch(iFolding, r2.lo); iFolding < this.caseFoldingSize() && this.caseFoldingFrom(iFolding) >= r2.lo && this.caseFoldingFrom(iFolding) <= r2.hi; ++iFolding) {
                charClass.addCodePoint(this.caseFoldingTo(iFolding));
            }
        }
    }

    private int caseFoldingFrom(int index) {
        return this.caseFolding[index << 1] & 0xFF;
    }

    private int caseFoldingTo(int index) {
        return this.caseFolding[(index << 1) + 1] & 0xFF;
    }

    private int caseFoldingSize() {
        return this.caseFolding.length >> 1;
    }

    private int caseFoldingBinarySearch(int minIndex, int target) {
        int lo = minIndex;
        int hi = this.caseFoldingSize() - 1;
        while (lo < hi) {
            int mid = lo + hi >> 1;
            if (this.caseFoldingFrom(mid) < target) {
                lo = mid + 1;
                continue;
            }
            if (this.caseFoldingFrom(mid) > target) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private static PythonLocaleData createCachedLocaleData(boolean turkish, Charset charset) {
        CacheKey key = new CacheKey(turkish, charset);
        PythonLocaleData localeData = (PythonLocaleData)CACHED_LOCALE_DATA.get(key);
        if (localeData == null) {
            localeData = new PythonLocaleData(turkish, charset);
            CACHED_LOCALE_DATA.put(key, localeData);
        }
        return localeData;
    }

    private PythonLocaleData(boolean turkish, Charset charset) {
        int[] codePoints = PythonLocaleData.charsetToCodePoints(charset);
        CodePointSetAccumulator wordCharsAccum = new CodePointSetAccumulator();
        for (int b2 = 0; b2 <= 255; ++b2) {
            int codePoint = codePoints[b2];
            if (!UCharacter.isUAlphabetic(codePoint) && !UCharacter.isDigit(codePoint) && codePoint != 95) continue;
            wordCharsAccum.appendCodePoint(b2);
        }
        this.wordChars = wordCharsAccum.toCodePointSet();
        this.nonWordChars = this.wordChars.createInverse(Encodings.LATIN_1);
        EconomicMap<Integer, Byte> invCodePoints = EconomicMap.create(256);
        for (int b3 = 0; b3 <= 255; ++b3) {
            invCodePoints.put(codePoints[b3], (byte)b3);
        }
        ArrayList<CaseFoldingEntry> caseFoldingAccum = new ArrayList<CaseFoldingEntry>();
        for (int b4 = 0; b4 <= 255; ++b4) {
            int codePoint = codePoints[b4];
            int lowerCase = PythonLocaleData.toLowerCase(codePoint, turkish);
            int upperCase = PythonLocaleData.toUpperCase(codePoint, turkish);
            if (lowerCase != codePoint && invCodePoints.containsKey(lowerCase)) {
                caseFoldingAccum.add(new CaseFoldingEntry((byte)b4, (Byte)invCodePoints.get(lowerCase)));
            }
            if (upperCase == codePoint || !invCodePoints.containsKey(upperCase)) continue;
            caseFoldingAccum.add(new CaseFoldingEntry((byte)b4, (Byte)invCodePoints.get(upperCase)));
        }
        Collections.sort(caseFoldingAccum);
        this.caseFolding = new byte[caseFoldingAccum.size() << 1];
        for (int i2 = 0; i2 < caseFoldingAccum.size(); ++i2) {
            this.caseFolding[i2 << 1] = ((CaseFoldingEntry)caseFoldingAccum.get((int)i2)).mapping;
            this.caseFolding[(i2 << 1) + 1] = ((CaseFoldingEntry)caseFoldingAccum.get((int)i2)).character;
        }
    }

    private static int toLowerCase(int codePoint, boolean turkish) {
        if (turkish && codePoint == 73) {
            return 305;
        }
        return UCharacter.toLowerCase(codePoint);
    }

    private static int toUpperCase(int codePoint, boolean turkish) {
        if (turkish && codePoint == 105) {
            return 304;
        }
        return UCharacter.toUpperCase(codePoint);
    }

    private static int[] charsetToCodePoints(Charset charset) {
        int[] codePoints = PythonLocaleData.charsetToCodePointsFast(charset);
        if (codePoints == null) {
            return PythonLocaleData.charsetToCodePointsSlow(charset);
        }
        assert (Arrays.equals(codePoints, PythonLocaleData.charsetToCodePointsSlow(charset)));
        return codePoints;
    }

    private static int[] charsetToCodePointsFast(Charset charset) {
        try {
            ByteBuffer byteRange = ByteBuffer.allocate(256);
            for (int b2 = 0; b2 <= 255; ++b2) {
                byteRange.put((byte)b2);
            }
            byteRange.rewind();
            CharBuffer decoded = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteRange);
            if (decoded.codePoints().count() == 256L) {
                return decoded.codePoints().toArray();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    private static int[] charsetToCodePointsSlow(Charset charset) {
        int[] codePoints = new int[256];
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer singleByte = ByteBuffer.allocate(1);
        for (int b2 = 0; b2 <= 255; ++b2) {
            decoder.reset();
            singleByte.put(0, (byte)b2);
            singleByte.rewind();
            try {
                CharBuffer codePoint = decoder.decode(singleByte);
                if (codePoint.codePoints().count() == 1L) {
                    codePoints[b2] = codePoint.codePoints().findFirst().getAsInt();
                    continue;
                }
                codePoints[b2] = 65533;
                continue;
            }
            catch (CharacterCodingException e2) {
                codePoints[b2] = 65533;
            }
        }
        return codePoints;
    }

    private static final class CacheKey {
        private final boolean turkish;
        private final Charset charset;

        CacheKey(boolean turkish, Charset charset) {
            this.turkish = turkish;
            this.charset = charset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.turkish == other.turkish && this.charset.equals(other.charset);
        }

        public int hashCode() {
            return Objects.hash(this.turkish, this.charset);
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 6638590251101633602L;
        private final int cacheSize;

        LRUCache(int cacheSize) {
            super(cacheSize + 1, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }

    private static final class CaseFoldingEntry
    implements Comparable<CaseFoldingEntry> {
        final byte character;
        final byte mapping;

        CaseFoldingEntry(byte character, byte mapping) {
            this.character = character;
            this.mapping = mapping;
        }

        @Override
        public int compareTo(CaseFoldingEntry o2) {
            int cmp = Integer.compare(this.mapping & 0xFF, o2.mapping & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(this.character & 0xFF, o2.character & 0xFF);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CaseFoldingEntry)) {
                return false;
            }
            CaseFoldingEntry other = (CaseFoldingEntry)obj;
            return this.character == other.character && this.mapping == other.mapping;
        }

        public int hashCode() {
            return Objects.hash(this.character, this.mapping);
        }
    }
}

