/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.AbstractRegexObject;

@ExportLibrary(value=InteropLibrary.class)
public class TruffleReadOnlyKeysArray
extends AbstractRegexObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final String[] keys;

    @CompilerDirectives.TruffleBoundary
    public TruffleReadOnlyKeysArray(String ... keys) {
        this.keys = keys;
        Arrays.sort(this.keys);
    }

    public int size() {
        return this.keys.length;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(String key) {
        return Arrays.binarySearch(this.keys, key) >= 0;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.keys.length;
    }

    @ExportMessage
    long getArraySize() {
        return this.keys.length;
    }

    @ExportMessage
    String readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create(index);
        }
        return this.keys[(int)index];
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "TRegexReadOnlyArray{keys=" + Arrays.toString(this.keys) + "}";
    }
}

