/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.collection.SerialQueue;

public final class DelegatingBlockingQueue<E>
implements BlockingQueue<E> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final SerialQueue<E> delegate;

    public DelegatingBlockingQueue(SerialQueue<E> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E x2) {
        this.lock.lock();
        try {
            boolean wasEmpty = this.isEmpty();
            this.delegate.add(x2);
            if (wasEmpty) {
                this.notEmpty.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addIndexOf(E x2) {
        this.lock.lock();
        try {
            boolean wasEmpty = this.isEmpty();
            int index = this.delegate.addIndexOf(x2);
            if (wasEmpty) {
                this.notEmpty.signalAll();
            }
            int n2 = index;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int indexOf(E x2) {
        this.lock.lock();
        try {
            int n2 = this.delegate.indexOf(x2);
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E x2) {
        return this.add(x2);
    }

    @Override
    public void put(E x2) throws InterruptedException {
        this.add(x2);
    }

    @Override
    public boolean offer(E x2, long l2, TimeUnit unit) throws InterruptedException {
        return this.add(x2);
    }

    private E lockedPoll() {
        return this.delegate.poll();
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e2 = this.lockedPoll();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock localLock = this.lock;
        localLock.lockInterruptibly();
        try {
            while ((result = this.lockedPoll()) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            localLock.unlock();
        }
        return result;
    }

    @Override
    public E remove() {
        this.lock.lock();
        try {
            E result = this.lockedPoll();
            if (result == null) {
                throw new NoSuchElementException();
            }
            E e2 = result;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e2 = this.delegate.peek();
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E element() {
        E result = this.peek();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public E take() throws InterruptedException {
        E result;
        this.lock.lockInterruptibly();
        try {
            while ((result = this.lockedPoll()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n2 = this.delegate.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        Object[] result = this.toArray();
        return Arrays.asList(result).iterator();
    }

    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        this.lock.lock();
        try {
            T[] TArray = this.delegate.toArray(a2);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        int count = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
            ++count;
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int i2) {
        throw new UnsupportedOperationException();
    }

    public int internalCapacity() {
        this.lock.lock();
        try {
            int n2 = this.delegate.internalCapacity();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

