/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CTypeConversion;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

abstract class BinaryOutput {
    private static final int MAX_LENGTH = 0x7FFFFFFB;
    private static final int MAX_SHORT_LENGTH = Short.MAX_VALUE;
    static final int LARGE_STRING_TAG = 128;
    static final byte NULL = 0;
    static final byte BOOLEAN = 1;
    static final byte BYTE = 2;
    static final byte SHORT = 3;
    static final byte CHAR = 4;
    static final byte INT = 5;
    static final byte LONG = 6;
    static final byte FLOAT = 7;
    static final byte DOUBLE = 8;
    static final byte STRING = 9;
    static final byte ARRAY = 10;
    private byte[] tempDecodingBuffer;
    protected int pos;

    private BinaryOutput() {
    }

    public final void writeBoolean(boolean value) {
        this.write(value ? 1 : 0);
    }

    public final void writeByte(int value) {
        this.write(value);
    }

    public final void writeShort(int value) {
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public final void writeChar(int value) {
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public final void writeInt(int value) {
        this.write(value >>> 24 & 0xFF);
        this.write(value >>> 16 & 0xFF);
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }

    public final void writeLong(long value) {
        this.write((int)(value >>> 56 & 0xFFL));
        this.write((int)(value >>> 48 & 0xFFL));
        this.write((int)(value >>> 40 & 0xFFL));
        this.write((int)(value >>> 32 & 0xFFL));
        this.write((int)(value >>> 24 & 0xFFL));
        this.write((int)(value >>> 16 & 0xFFL));
        this.write((int)(value >>> 8 & 0xFFL));
        this.write((int)(value & 0xFFL));
    }

    public final void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public abstract void write(int var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public abstract void skip(int var1);

    public final void writeUTF(String string) throws IllegalArgumentException {
        int i2;
        int headerSize;
        char c2;
        int len = string.length();
        int utfLen = 0;
        int count = 0;
        for (int i3 = 0; i3 < len; ++i3) {
            c2 = string.charAt(i3);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c2 > '\u07ff') {
                utfLen += 3;
                continue;
            }
            utfLen += 2;
        }
        if (utfLen > 0x7FFFFFFB) {
            throw new IllegalArgumentException("String too long to encode, " + utfLen + " bytes");
        }
        if (utfLen > Short.MAX_VALUE) {
            headerSize = 4;
            this.ensureBufferSize(headerSize, utfLen);
            this.tempDecodingBuffer[count++] = (byte)((0x80 | utfLen >>> 24) & 0xFF);
            this.tempDecodingBuffer[count++] = (byte)(utfLen >>> 16 & 0xFF);
        } else {
            headerSize = 2;
            this.ensureBufferSize(headerSize, utfLen);
        }
        this.tempDecodingBuffer[count++] = (byte)(utfLen >>> 8 & 0xFF);
        this.tempDecodingBuffer[count++] = (byte)(utfLen & 0xFF);
        for (i2 = 0; i2 < len && (c2 = string.charAt(i2)) >= '\u0001' && c2 <= '\u007f'; ++i2) {
            this.tempDecodingBuffer[count++] = (byte)c2;
        }
        while (i2 < len) {
            c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                this.tempDecodingBuffer[count++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                this.tempDecodingBuffer[count++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                this.tempDecodingBuffer[count++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this.tempDecodingBuffer[count++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                this.tempDecodingBuffer[count++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                this.tempDecodingBuffer[count++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++i2;
        }
        this.write(this.tempDecodingBuffer, 0, headerSize + utfLen);
    }

    public int getPosition() {
        return this.pos;
    }

    public static boolean isTypedValue(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof Object[] || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String;
    }

    public final void writeTypedValue(Object value) throws IllegalArgumentException {
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            this.writeByte(10);
            this.writeInt(arr.length);
            for (Object arrElement : arr) {
                this.writeTypedValue(arrElement);
            }
        } else if (value == null) {
            this.writeByte(0);
        } else if (value instanceof Boolean) {
            this.writeByte(1);
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte(2);
            this.writeByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.writeByte(3);
            this.writeShort(((Short)value).shortValue());
        } else if (value instanceof Character) {
            this.writeByte(4);
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeByte(5);
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeByte(6);
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeByte(7);
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeByte(8);
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeByte(9);
            this.writeUTF((String)value);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type %s", value.getClass()));
        }
    }

    public final void write(boolean[] array, int off, int len) {
        this.ensureBufferSize(0, len);
        int i2 = 0;
        int j2 = 0;
        while (i2 < len) {
            this.tempDecodingBuffer[j2] = (byte)(array[off + i2] ? 1 : 0);
            ++i2;
            ++j2;
        }
        this.write(this.tempDecodingBuffer, 0, len);
    }

    public final void write(short[] array, int off, int len) {
        int size = len * 2;
        this.ensureBufferSize(0, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 8 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] & 0xFF);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    public final void write(char[] array, int off, int len) {
        int size = len * 2;
        this.ensureBufferSize(0, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 8 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] & 0xFF);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    public final void write(int[] array, int off, int len) {
        int size = len * 4;
        this.ensureBufferSize(0, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 24 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 16 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 8 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] & 0xFF);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    public final void write(long[] array, int off, int len) {
        int size = len * 8;
        this.ensureBufferSize(0, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 56 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 48 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 40 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 32 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 24 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 16 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] >>> 8 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(array[off + i2] & 0xFFL);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    public final void write(float[] array, int off, int len) {
        int size = len * 4;
        this.ensureBufferSize(0, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int bits = Float.floatToIntBits(array[off + i2]);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 24 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 16 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 8 & 0xFF);
            this.tempDecodingBuffer[j2++] = (byte)(bits & 0xFF);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    public final void write(double[] array, int off, int len) {
        int size = len * 8;
        this.ensureBufferSize(4, size);
        int j2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            long bits = Double.doubleToLongBits(array[off + i2]);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 56 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 48 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 40 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 32 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 24 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 16 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits >>> 8 & 0xFFL);
            this.tempDecodingBuffer[j2++] = (byte)(bits & 0xFFL);
        }
        this.write(this.tempDecodingBuffer, 0, size);
    }

    private void ensureBufferSize(int headerSize, int dataSize) {
        if (this.tempDecodingBuffer == null || this.tempDecodingBuffer.length < headerSize + dataSize) {
            this.tempDecodingBuffer = new byte[BinaryOutput.bufferSize(headerSize, dataSize)];
        }
    }

    public static ByteArrayBinaryOutput create() {
        return new ByteArrayBinaryOutput(32);
    }

    public static ByteArrayBinaryOutput create(byte[] initialBuffer) {
        Objects.requireNonNull(initialBuffer, "InitialBuffer must be non null.");
        return new ByteArrayBinaryOutput(initialBuffer);
    }

    public static CCharPointerBinaryOutput create(CCharPointer address, int length, boolean dynamicallyAllocated) {
        return new CCharPointerBinaryOutput(address, length, dynamicallyAllocated);
    }

    static int bufferSize(int headerSize, int dataSize) {
        return headerSize + (dataSize <= Short.MAX_VALUE ? dataSize << 1 : dataSize);
    }

    public static final class ByteArrayBinaryOutput
    extends BinaryOutput {
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        static final int INITIAL_SIZE = 32;
        private byte[] buffer;

        private ByteArrayBinaryOutput(int size) {
            this.buffer = new byte[size];
        }

        private ByteArrayBinaryOutput(byte[] initialBuffer) {
            this.buffer = initialBuffer;
        }

        @Override
        public void write(int b2) {
            this.ensureCapacity(this.pos + 1);
            this.buffer[this.pos] = (byte)b2;
            ++this.pos;
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            this.ensureCapacity(this.pos + len);
            System.arraycopy(b2, off, this.buffer, this.pos, len);
            this.pos += len;
        }

        @Override
        public void skip(int numberOfBytes) {
            this.ensureCapacity(this.pos + numberOfBytes);
            this.pos += numberOfBytes;
        }

        public byte[] getArray() {
            return this.buffer;
        }

        private void ensureCapacity(int neededCapacity) {
            if (neededCapacity - this.buffer.length > 0) {
                int newCapacity = this.buffer.length << 1;
                if (newCapacity - neededCapacity < 0) {
                    newCapacity = neededCapacity;
                }
                if (newCapacity - 0x7FFFFFF7 > 0) {
                    throw new OutOfMemoryError();
                }
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
        }

        public static ByteArrayBinaryOutput create(int initialSize) {
            return new ByteArrayBinaryOutput(initialSize);
        }
    }

    public static final class CCharPointerBinaryOutput
    extends BinaryOutput
    implements Closeable {
        private static final int BYTEBUFFER_COPY_FROM_ARRAY_THRESHOLD = 6;
        private CCharPointer address;
        private int length;
        private boolean unmanaged;
        private ByteBuffer byteBufferView;

        private CCharPointerBinaryOutput(CCharPointer address, int length, boolean unmanaged) {
            this.address = address;
            this.length = length;
            this.unmanaged = unmanaged;
        }

        @Override
        public int getPosition() {
            this.checkClosed();
            return super.getPosition();
        }

        public CCharPointer getAddress() {
            this.checkClosed();
            return this.address;
        }

        @Override
        public void write(int b2) {
            this.checkClosed();
            this.ensureCapacity(this.pos + 1);
            this.address.write(this.pos++, (byte)b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            this.checkClosed();
            if ((off | len | b2.length) < 0 || b2.length - off < len) {
                throw new IndexOutOfBoundsException("offset: " + off + ", length: " + len + ", array length: " + b2.length);
            }
            this.ensureCapacity(this.pos + len);
            if (len > 6) {
                if (this.byteBufferView == null) {
                    this.byteBufferView = CTypeConversion.asByteBuffer(this.address, this.length);
                }
                this.byteBufferView.position(this.pos);
                this.byteBufferView.put(b2, off, len);
            } else {
                for (int i2 = 0; i2 < len; ++i2) {
                    this.address.write(this.pos + i2, b2[off + i2]);
                }
            }
            this.pos += len;
        }

        @Override
        public void skip(int numberOfBytes) {
            this.ensureCapacity(this.pos + numberOfBytes);
            this.pos += numberOfBytes;
        }

        @Override
        public void close() {
            if (this.unmanaged) {
                UnmanagedMemory.free(this.address);
                this.byteBufferView = null;
                this.address = (CCharPointer)WordFactory.nullPointer();
                this.length = 0;
                this.unmanaged = false;
                this.pos = Integer.MIN_VALUE;
            }
        }

        private void checkClosed() {
            if (this.pos == Integer.MIN_VALUE) {
                throw new IllegalStateException("Already closed");
            }
        }

        private void ensureCapacity(int neededCapacity) {
            if (neededCapacity - this.length > 0) {
                this.byteBufferView = null;
                int newCapacity = this.length << 1;
                if (newCapacity - neededCapacity < 0) {
                    newCapacity = neededCapacity;
                }
                if (newCapacity - Integer.MAX_VALUE > 0) {
                    throw new OutOfMemoryError();
                }
                if (this.unmanaged) {
                    this.address = UnmanagedMemory.realloc(this.address, WordFactory.unsigned(newCapacity));
                } else {
                    CCharPointer newAddress = (CCharPointer)UnmanagedMemory.malloc(newCapacity);
                    CCharPointerBinaryOutput.memcpy(newAddress, this.address, this.pos);
                    this.address = newAddress;
                }
                this.length = newCapacity;
                this.unmanaged = true;
            }
        }

        private static void memcpy(CCharPointer dst, CCharPointer src, int len) {
            for (int i2 = 0; i2 < len; ++i2) {
                dst.write(i2, src.read(i2));
            }
        }

        public static CCharPointerBinaryOutput create(int initialSize) {
            return new CCharPointerBinaryOutput((CCharPointer)UnmanagedMemory.malloc(initialSize), initialSize, true);
        }
    }
}

