/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal;

import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.TruffleCompilerListener;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.compiler.hotspot.HotSpotTruffleCompiler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.DestroyedIsolateException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraal;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalScope;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilationSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;

final class LibGraalHotSpotTruffleCompiler
implements HotSpotTruffleCompiler {
    private final HotSpotTruffleRuntime runtime;
    Integer pendingTransferToInterpreterOffset;

    private long getOrCreateIsolate(TruffleCompilable compilable, boolean firstInitialization) {
        return LibGraalHotSpotTruffleCompiler.resolveIsolateHandleImpl(() -> {
            long isolateThread = LibGraalScope.getIsolateThread();
            long compilerHandle = TruffleToLibGraalCalls.newCompiler(isolateThread, LibGraalTruffleCompilationSupport.handle(this.runtime));
            TruffleToLibGraalCalls.initializeCompiler(isolateThread, compilerHandle, compilable, firstInitialization);
            return new Handle(compilerHandle);
        });
    }

    private static long resolveIsolateHandleImpl(Supplier<Handle> handleSupplier) {
        try (LibGraalScope scope = new LibGraalScope();){
            long l2 = scope.getIsolate().getSingleton(Handle.class, handleSupplier).getHandle();
            return l2;
        }
    }

    LibGraalHotSpotTruffleCompiler(HotSpotTruffleRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void initialize(TruffleCompilable compilable, boolean firstInitialization) {
        this.getOrCreateIsolate(compilable, firstInitialization);
    }

    @Override
    public void doCompile(TruffleCompilationTask task, TruffleCompilable compilable, TruffleCompilerListener listener) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            TruffleToLibGraalCalls.doCompile(LibGraalScope.getIsolateThread(), this.getOrCreateIsolate(compilable, false), task, compilable, listener);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void installTruffleCallBoundaryMethod(ResolvedJavaMethod method, TruffleCompilable compilable) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            TruffleToLibGraalCalls.installTruffleCallBoundaryMethod(LibGraalScope.getIsolateThread(), this.getOrCreateIsolate(compilable, false), LibGraal.translate(method));
        }
    }

    @Override
    public void installTruffleReservedOopMethod(ResolvedJavaMethod method, TruffleCompilable compilable) {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            TruffleToLibGraalCalls.installTruffleReservedOopMethod(LibGraalScope.getIsolateThread(), this.getOrCreateIsolate(compilable, false), LibGraal.translate(method));
        }
    }

    @Override
    public int pendingTransferToInterpreterOffset(TruffleCompilable compilable) {
        if (this.pendingTransferToInterpreterOffset == null) {
            try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
                this.pendingTransferToInterpreterOffset = TruffleToLibGraalCalls.pendingTransferToInterpreterOffset(LibGraalScope.getIsolateThread(), this.getOrCreateIsolate(compilable, false), compilable);
            }
        }
        return this.pendingTransferToInterpreterOffset;
    }

    @Override
    public void purgePartialEvaluationCaches() {
        block9: {
            try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
                try {
                    Handle compilerHandle = scope.getIsolate().getSingleton(Handle.class, () -> null);
                    if (compilerHandle != null) {
                        TruffleToLibGraalCalls.purgePartialEvaluationCaches(LibGraalScope.getIsolateThread(), compilerHandle.getHandle());
                    }
                }
                catch (DestroyedIsolateException e2) {
                    if (e2.isVmExit()) {
                        break block9;
                    }
                    throw e2;
                }
            }
        }
    }

    static final class Handle
    extends LibGraalObject {
        Handle(long handle) {
            super(handle);
        }
    }
}

