/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge;

import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.DefaultStackTraceMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.MarshalledException;

final class DefaultThrowableMarshaller
implements BinaryMarshaller<Throwable> {
    private static final int THROWABLE_SIZE_ESTIMATE = 1024;
    private final DefaultStackTraceMarshaller stackTraceMarshaller = DefaultStackTraceMarshaller.INSTANCE;

    DefaultThrowableMarshaller() {
    }

    @Override
    public Throwable read(BinaryInput in) {
        String foreignExceptionClassName = in.readUTF();
        String foreignExceptionMessage = (String)in.readTypedValue();
        StackTraceElement[] foreignExceptionStack = this.stackTraceMarshaller.read(in);
        return new MarshalledException(foreignExceptionClassName, foreignExceptionMessage, ForeignException.mergeStackTrace(foreignExceptionStack));
    }

    @Override
    public void write(BinaryOutput out, Throwable object) {
        out.writeUTF(object instanceof MarshalledException ? ((MarshalledException)object).getForeignExceptionClassName() : object.getClass().getName());
        out.writeTypedValue(object.getMessage());
        this.stackTraceMarshaller.write(out, object.getStackTrace());
    }

    @Override
    public int inferSize(Throwable object) {
        return 1024;
    }
}

