/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;

@ExportLibrary(value=InteropLibrary.class, receiverType=Long.class)
final class DefaultLongExports {
    DefaultLongExports() {
    }

    @ExportMessage
    static boolean fitsInByte(Long receiver) {
        long l2 = receiver;
        return l2 == (long)((byte)l2);
    }

    @ExportMessage
    static boolean fitsInInt(Long receiver) {
        long l2 = receiver;
        return l2 == (long)((int)l2);
    }

    @ExportMessage
    static boolean fitsInShort(Long receiver) {
        long l2 = receiver;
        return l2 == (long)((short)l2);
    }

    @ExportMessage
    static boolean fitsInFloat(Long receiver) {
        long l2 = receiver;
        float f2 = l2;
        return l2 != Long.MAX_VALUE && (long)f2 == l2;
    }

    @ExportMessage
    static boolean fitsInDouble(Long receiver) {
        long l2 = receiver;
        double d2 = l2;
        return l2 != Long.MAX_VALUE && (long)d2 == l2;
    }

    @ExportMessage
    static byte asByte(Long receiver) throws UnsupportedMessageException {
        long l2 = receiver;
        byte b2 = (byte)l2;
        if ((long)b2 == l2) {
            return b2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Long receiver) throws UnsupportedMessageException {
        long l2 = receiver;
        short s2 = (short)l2;
        if ((long)s2 == l2) {
            return s2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static int asInt(Long receiver) throws UnsupportedMessageException {
        long l2 = receiver;
        int i2 = (int)l2;
        if ((long)i2 == l2) {
            return i2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static float asFloat(Long receiver) throws UnsupportedMessageException {
        long l2 = receiver;
        float f2 = l2;
        if (l2 != Long.MAX_VALUE && (long)f2 == l2) {
            return f2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static double asDouble(Long receiver) throws UnsupportedMessageException {
        long l2 = receiver;
        double d2 = l2;
        if (l2 != Long.MAX_VALUE && (long)d2 == l2) {
            return l2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isNumber(Long receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInLong(Long receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInBigInteger(Long receiver) {
        return true;
    }

    @ExportMessage
    static long asLong(Long receiver) {
        return receiver;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static BigInteger asBigInteger(Long receiver) {
        return BigInteger.valueOf(receiver);
    }

    @ExportMessage
    static boolean hasLanguage(Long receiver) {
        return false;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(Long receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasSourceLocation(Long receiver) {
        return false;
    }

    @ExportMessage
    static SourceSection getSourceLocation(Long receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(Long receiver) {
        return false;
    }

    @ExportMessage
    static Object getMetaObject(Long receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object toDisplayString(Long receiver, boolean allowSideEffects) {
        return receiver.toString();
    }
}

