/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.Map;

public abstract class GetDifferenceSettingsNode
extends JavaScriptBaseNode {
    protected GetDifferenceSettingsNode() {
    }

    public abstract GetDifferenceSettingsResult execute(int var1, JSDynamicObject var2, Map<TruffleString, TemporalUtil.Unit> var3, Map<TruffleString, TemporalUtil.Unit> var4, TemporalUtil.Unit var5, TemporalUtil.Unit var6);

    @Specialization
    final GetDifferenceSettingsResult getDifferenceSettings(int operation, JSDynamicObject resolvedOptions, Map<TruffleString, TemporalUtil.Unit> unitMappingOrAuto, Map<TruffleString, TemporalUtil.Unit> unitMapping, TemporalUtil.Unit fallbackSmallestUnit, TemporalUtil.Unit smallestLargestDefaultUnit, @Cached InlinedBranchProfile errorBranch, @Cached TemporalGetOptionNode getOptionNode, @Cached TruffleString.EqualNode equalNode, @Cached GetTemporalUnitNode getLargestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached GetTemporalUnitNode getSmallestUnit) {
        assert (unitMappingOrAuto.containsKey(TemporalConstants.AUTO) && !unitMapping.containsKey(TemporalConstants.AUTO));
        TemporalUtil.Unit largestUnit = getLargestUnit.execute(resolvedOptions, TemporalConstants.LARGEST_UNIT, unitMappingOrAuto, TemporalUtil.Unit.AUTO);
        int roundingIncrement = getRoundingIncrementOption.execute(resolvedOptions);
        TemporalUtil.RoundingMode roundingMode = JSTemporalBuiltinOperation.toTemporalRoundingMode(resolvedOptions, TemporalConstants.TRUNC, equalNode, getOptionNode);
        if (operation == -1) {
            roundingMode = TemporalUtil.negateTemporalRoundingMode(roundingMode);
        }
        TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(resolvedOptions, TemporalConstants.SMALLEST_UNIT, unitMapping, fallbackSmallestUnit);
        TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(smallestLargestDefaultUnit, smallestUnit);
        if (largestUnit == TemporalUtil.Unit.AUTO) {
            largestUnit = defaultLargestUnit;
        }
        TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
        Integer maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
        if (maximum != null) {
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum.intValue(), false, this, errorBranch);
        }
        return new GetDifferenceSettingsResult(smallestUnit, largestUnit, roundingMode, roundingIncrement);
    }

    public record GetDifferenceSettingsResult(TemporalUtil.Unit smallestUnit, TemporalUtil.Unit largestUnit, TemporalUtil.RoundingMode roundingMode, int roundingIncrement) {
    }
}

