/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSErrorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.doubleconv.DoubleConversion;
import com.oracle.truffle.js.runtime.external.DToA;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Nullish;
import com.oracle.truffle.js.runtime.objects.OperatorSet;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class JSRuntime {
    private static final long NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
    private static final long POSITIVE_INFINITY_DOUBLE_BITS = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    public static final double TWO32 = 4.294967296E9;
    public static final long INVALID_ARRAY_INDEX = -1L;
    public static final long MAX_ARRAY_LENGTH = 0xFFFFFFFFL;
    public static final int MAX_UINT32_DIGITS = 10;
    public static final double MAX_SAFE_INTEGER = Math.pow(2.0, 53.0) - 1.0;
    public static final double MIN_SAFE_INTEGER = -MAX_SAFE_INTEGER;
    public static final long MAX_SAFE_INTEGER_LONG = (long)MAX_SAFE_INTEGER;
    public static final long MIN_SAFE_INTEGER_LONG = (long)MIN_SAFE_INTEGER;
    public static final long INVALID_INTEGER_INDEX = -1L;
    public static final int MAX_INTEGER_INDEX_DIGITS = 16;
    public static final int MAX_SAFE_INTEGER_DIGITS = 16;
    public static final int MAX_SAFE_INTEGER_IN_FLOAT = 0x1000000;
    public static final int MIN_SAFE_INTEGER_IN_FLOAT = -16777216;
    public static final long INVALID_SAFE_INTEGER = Long.MIN_VALUE;
    public static final HiddenKey ENUMERATE_ITERATOR_ID = new HiddenKey("EnumerateIterator");
    public static final int ITERATION_KIND_KEY = 1;
    public static final int ITERATION_KIND_VALUE = 2;
    public static final int ITERATION_KIND_KEY_PLUS_VALUE = 3;

    private JSRuntime() {
    }

    public static boolean doubleIsRepresentableAsInt(double d2) {
        return JSRuntime.doubleIsRepresentableAsInt(d2, false);
    }

    public static boolean doubleIsRepresentableAsInt(double d2, boolean ignoreNegativeZero) {
        long longValue = (long)d2;
        return JSRuntime.doubleIsRepresentableAsLong(d2) && JSRuntime.longIsRepresentableAsInt(longValue) && (ignoreNegativeZero || !JSRuntime.isNegativeZero(d2));
    }

    public static boolean doubleIsRepresentableAsUnsignedInt(double d2, boolean ignoreNegativeZero) {
        long longValue = (long)d2;
        return JSRuntime.doubleIsRepresentableAsLong(d2) && JSRuntime.longIsRepresentableAsInt(longValue) && (ignoreNegativeZero || !JSRuntime.isNegativeZero(d2));
    }

    public static boolean isNegativeZero(double d2) {
        return Double.doubleToRawLongBits(d2) == NEGATIVE_ZERO_DOUBLE_BITS;
    }

    public static boolean isPositiveInfinity(double d2) {
        return Double.doubleToRawLongBits(d2) == POSITIVE_INFINITY_DOUBLE_BITS;
    }

    public static Number doubleToNarrowestNumber(double d2) {
        if (JSRuntime.doubleIsRepresentableAsInt(d2)) {
            return (int)d2;
        }
        return d2;
    }

    public static boolean longIsRepresentableAsInt(long value) {
        return value == (long)((int)value);
    }

    public static boolean isRepresentableAsUnsignedInt(long value) {
        return (value & 0xFFFFFFFFL) == value;
    }

    public static boolean doubleIsRepresentableAsLong(double d2) {
        return d2 == (double)((long)d2);
    }

    public static Object positiveLongToIntOrDouble(long value) {
        if (value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return (double)value;
    }

    public static Number longToIntOrDouble(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return (double)value;
    }

    public static boolean longFitsInDouble(long l2) {
        double d2 = l2;
        return l2 != Long.MAX_VALUE && (long)d2 == l2;
    }

    public static boolean isNaN(Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        double d2 = (Double)value;
        return Double.isNaN(d2);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString typeof(Object value) {
        if (value == Null.instance) {
            return Null.TYPE_NAME;
        }
        if (value == Undefined.instance) {
            return Undefined.TYPE_NAME;
        }
        if (Strings.isTString(value)) {
            return JSString.TYPE_NAME;
        }
        if (JSRuntime.isNumber(value) || value instanceof Long) {
            return JSNumber.TYPE_NAME;
        }
        if (JSRuntime.isBigInt(value)) {
            return JSBigInt.TYPE_NAME;
        }
        if (value instanceof Boolean) {
            return JSBoolean.TYPE_NAME;
        }
        if (value instanceof Symbol) {
            return JSSymbol.TYPE_NAME;
        }
        if (JSObject.isJSObject(value)) {
            JSObject object = (JSObject)value;
            if (JSProxy.isJSProxy(object)) {
                Object target = JSProxy.getTargetNonProxy(object);
                return JSRuntime.typeof(target);
            }
            if (JSFunction.isJSFunction(object)) {
                return JSFunction.TYPE_NAME;
            }
            return JSOrdinary.TYPE_NAME;
        }
        if (value instanceof TruffleObject) {
            TruffleLanguage.Env env;
            assert (!(value instanceof Symbol));
            JSRealm realm = JSRealm.get(null);
            if (realm.getContext().isOptionNashornCompatibilityMode() && (env = realm.getEnv()).isHostSymbol(value)) {
                return JSFunction.TYPE_NAME;
            }
            TruffleObject object = (TruffleObject)value;
            InteropLibrary interop = InteropLibrary.getUncached();
            if (interop.isBoolean(object)) {
                return JSBoolean.TYPE_NAME;
            }
            if (interop.isString(object)) {
                return JSString.TYPE_NAME;
            }
            if (interop.isNumber(object)) {
                return JSNumber.TYPE_NAME;
            }
            if (interop.isExecutable(object) || interop.isInstantiable(object)) {
                return JSFunction.TYPE_NAME;
            }
            return JSOrdinary.TYPE_NAME;
        }
        throw new UnsupportedOperationException("typeof: don't know " + value.getClass().getSimpleName());
    }

    public static boolean isObject(Object value) {
        return value instanceof JSObject;
    }

    public static boolean isNullOrUndefined(Object value) {
        return value instanceof Nullish;
    }

    public static boolean isNullish(Object value) {
        return value == Null.instance || value == Undefined.instance || InteropLibrary.getUncached(value).isNull(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(Object value) {
        return JSRuntime.toPrimitive(value, JSToPrimitiveNode.Hint.Default);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(Object value, JSToPrimitiveNode.Hint hint) {
        if (value == Null.instance || value == Undefined.instance) {
            return value;
        }
        if (JSObject.isJSObject(value)) {
            return JSObject.toPrimitive((JSObject)value, hint);
        }
        if (JSRuntime.isForeignObject(value)) {
            return JSRuntime.toPrimitiveFromForeign(value, hint);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitiveFromForeign(Object tObj, JSToPrimitiveNode.Hint hint) {
        assert (JSRuntime.isForeignObject(tObj));
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(tObj);
        Object primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(tObj, null, interop, TruffleString.SwitchEncodingNode.getUncached(), null);
        if (primitive != null) {
            return primitive;
        }
        JSDynamicObject proto = ForeignObjectPrototypeNode.getUncached().execute(tObj);
        Object exoticToPrim = JSObject.getOrDefault(proto, Symbol.SYMBOL_TO_PRIMITIVE, tObj, (Object)Undefined.instance);
        if (!JSRuntime.isNullOrUndefined(exoticToPrim)) {
            Object result = JSRuntime.call(exoticToPrim, tObj, new Object[]{hint.getHintName()});
            if (!IsPrimitiveNode.getUncached().executeBoolean(result)) throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", null);
            primitive = result;
        } else {
            Object maybeResult;
            if (JavaScriptLanguage.getCurrentEnv().isHostObject(tObj) && (maybeResult = JSToPrimitiveNode.tryHostObjectToPrimitive(tObj, hint, interop)) != null) {
                return maybeResult;
            }
            primitive = JSRuntime.foreignOrdinaryToPrimitive(tObj, hint == JSToPrimitiveNode.Hint.Default ? JSToPrimitiveNode.Hint.Number : hint, interop);
        }
        if ((primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(primitive, null, InteropLibrary.getUncached(primitive), TruffleString.SwitchEncodingNode.getUncached(), null)) == null) throw Errors.createTypeErrorCannotConvertToPrimitiveValue();
        return primitive;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object foreignOrdinaryToPrimitive(Object obj, JSToPrimitiveNode.Hint hint, InteropLibrary interop) {
        TruffleString[] methodNames;
        if (hint == JSToPrimitiveNode.Hint.String) {
            methodNames = new TruffleString[]{Strings.TO_STRING, Strings.VALUE_OF};
        } else {
            assert (hint == JSToPrimitiveNode.Hint.Number);
            methodNames = new TruffleString[]{Strings.VALUE_OF, Strings.TO_STRING};
        }
        JSDynamicObject proto = ForeignObjectPrototypeNode.getUncached().execute(obj);
        for (TruffleString name : methodNames) {
            Object method;
            if (interop.hasMembers(obj) && interop.isMemberInvocable(obj, Strings.toJavaString(name)) && !OrdinaryToPrimitiveNode.isJavaArray(obj, interop)) {
                try {
                    Object result = JSRuntime.importValue(interop.invokeMember(obj, Strings.toJavaString(name), new Object[0]));
                    if (IsPrimitiveNode.getUncached().executeBoolean(result)) {
                        return result;
                    }
                }
                catch (InteropException result) {
                    // empty catch block
                }
            }
            if (!JSRuntime.isCallable(method = JSObject.getMethod(proto, obj, name))) continue;
            Object result = JSRuntime.call(method, obj, new Object[0]);
            if (!IsPrimitiveNode.getUncached().executeBoolean(result)) continue;
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean toBoolean(Object value) {
        return JSToBooleanNode.getUncached().executeBoolean(value);
    }

    private static Object toPrimitiveHintNumber(Object value) {
        if (JSRuntime.isObject(value)) {
            return JSObject.toPrimitive((JSObject)value, JSToPrimitiveNode.Hint.Number);
        }
        if (JSRuntime.isForeignObject(value)) {
            return JSRuntime.toPrimitiveFromForeign(value, JSToPrimitiveNode.Hint.Number);
        }
        assert (IsPrimitiveNode.getUncached().executeBoolean(value)) : value;
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toNumber(Object value) {
        Object primitive = JSRuntime.toPrimitiveHintNumber(value);
        return JSRuntime.toNumberFromPrimitive(primitive);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toNumeric(Object value) {
        Object primitive = JSRuntime.toPrimitiveHintNumber(value);
        if (primitive instanceof BigInt) {
            BigInt bigInt = (BigInt)primitive;
            if (!bigInt.isForeign()) {
                return primitive;
            }
            return bigInt.doubleValue();
        }
        if (primitive instanceof Long) {
            Long longValue = (Long)primitive;
            return longValue.doubleValue();
        }
        return JSRuntime.toNumberFromPrimitive(primitive);
    }

    private static Number toNumberFromPrimitive(Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (JSRuntime.isNumber(value)) {
            return (Number)value;
        }
        if (value == Undefined.instance) {
            return Double.NaN;
        }
        if (value == Null.instance) {
            return 0;
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return JSRuntime.booleanToNumber(bool);
        }
        if (value instanceof TruffleString) {
            TruffleString str = (TruffleString)value;
            return JSRuntime.stringToNumber(str);
        }
        if (value instanceof Symbol) {
            throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value");
        }
        if (value instanceof BigInt) {
            BigInt bigInt = (BigInt)value;
            if (bigInt.isForeign()) {
                return bigInt.doubleValue();
            }
            throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value");
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue.doubleValue();
        }
        throw JSRuntime.toNumberTypeError(value);
    }

    private static JSException toNumberTypeError(Object value) {
        assert (false) : "should never reach here, type " + value.getClass().getName() + " not handled.";
        throw Errors.createTypeErrorCannotConvertToNumber(Strings.toJavaString(JSRuntime.safeToString(value)));
    }

    public static int booleanToNumber(boolean value) {
        return value ? 1 : 0;
    }

    public static boolean isNumber(Object value) {
        return value instanceof Integer || value instanceof Double || value instanceof SafeInteger;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt toBigInt(Object value) {
        return JSToBigIntNode.getUncached().execute(value);
    }

    public static boolean isBigInt(Object value) {
        return value instanceof BigInt;
    }

    public static boolean isJavaNumber(Object value) {
        return value instanceof Number;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number stringToNumber(TruffleString string) {
        TruffleString strCamel = JSRuntime.trimJSWhiteSpace(string);
        int camelLength = Strings.length(strCamel);
        if (camelLength == 0) {
            return 0;
        }
        char firstChar = Strings.charAt(strCamel, 0);
        if (camelLength >= Strings.length(Strings.INFINITY) && camelLength <= Strings.length(Strings.INFINITY) + 1 && Strings.endsWith(strCamel, Strings.INFINITY)) {
            return JSRuntime.identifyInfinity(firstChar, camelLength);
        }
        if (!JSRuntime.isAsciiDigit(firstChar) && firstChar != '-' && firstChar != '.' && firstChar != '+') {
            return Double.NaN;
        }
        return JSRuntime.stringToNumberParse(strCamel);
    }

    private static Number stringToNumberParse(TruffleString str) {
        assert (Strings.length(str) > 0);
        boolean hex = Strings.startsWith(str, Strings.LC_0X) || Strings.startsWith(str, Strings.UC_0X);
        int eIndex = JSRuntime.firstExpIndexInString(str);
        boolean sci = !hex && 0 <= eIndex && eIndex < Strings.length(str) - 1;
        try {
            if (!sci && Strings.length(str) <= 18 && Strings.indexOf(str, '.') == -1) {
                if (hex) {
                    return Strings.parseLong(Strings.lazySubstring(str, 2), 16);
                }
                return JSRuntime.stringToNumberLong(str);
            }
            return JSRuntime.parseDoubleOrNaN(str);
        }
        catch (TruffleString.NumberFormatException e2) {
            return Double.NaN;
        }
    }

    private static Number stringToNumberLong(TruffleString strLower) throws TruffleString.NumberFormatException {
        assert (Strings.length(strLower) > 0);
        long num = Strings.parseLong(strLower);
        if (JSRuntime.longIsRepresentableAsInt(num)) {
            if (num == 0L && Strings.charAt(strLower, 0) == '-') {
                return -0.0;
            }
            return (int)num;
        }
        return (double)num;
    }

    @CompilerDirectives.TruffleBoundary
    public static double parseDoubleOrNaN(TruffleString input) {
        if (Strings.isEmpty(input) || Strings.charAt(input, Strings.length(input) - 1) > '9') {
            return Double.NaN;
        }
        try {
            return Strings.parseDouble(input);
        }
        catch (TruffleString.NumberFormatException e2) {
            return Double.NaN;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int firstExpIndexInString(TruffleString str) {
        int firstIdx = Strings.indexOf(str, 101, 0);
        if (firstIdx >= 0) {
            return firstIdx;
        }
        return Strings.indexOf(str, 69, 0);
    }

    public static double identifyInfinity(char firstChar, int len) {
        int infinityLength = Strings.length(Strings.INFINITY);
        if (len == infinityLength) {
            return Double.POSITIVE_INFINITY;
        }
        if (len == infinityLength + 1) {
            if (firstChar == '+') {
                return Double.POSITIVE_INFINITY;
            }
            if (firstChar == '-') {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return Double.NaN;
    }

    public static long toInteger(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInteger(number);
    }

    public static long toInteger(Number number) {
        return JSRuntime.longValue(number);
    }

    public static long toLength(Object value) {
        long l2 = JSRuntime.toInteger(value);
        return JSRuntime.toLength(l2);
    }

    public static double toLength(double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 > MAX_SAFE_INTEGER) {
            return MAX_SAFE_INTEGER;
        }
        return d2;
    }

    public static long toLength(long l2) {
        if (l2 <= 0L) {
            return 0L;
        }
        if (l2 > MAX_SAFE_INTEGER_LONG) {
            return MAX_SAFE_INTEGER_LONG;
        }
        return l2;
    }

    public static int toLength(int value) {
        if (value <= 0) {
            return 0;
        }
        return value;
    }

    public static int toUInt16(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toUInt16(number);
    }

    public static int toUInt16(Number number) {
        Double d2;
        if (number instanceof Double && JSRuntime.isPositiveInfinity(d2 = (Double)number)) {
            return 0;
        }
        return JSRuntime.toUInt16(JSRuntime.longValue(number));
    }

    public static int toUInt16(long number) {
        return (int)(number & 0xFFFFL);
    }

    public static long toUInt32(Object value) {
        return JSRuntime.toUInt32(JSRuntime.toNumber(value));
    }

    public static long toUInt32(Number number) {
        if (number instanceof Integer) {
            return Integer.toUnsignedLong((Integer)number);
        }
        if (number instanceof Double) {
            return JSRuntime.toUInt32((Double)number);
        }
        if (number instanceof SafeInteger) {
            return JSRuntime.toUInt32(((SafeInteger)number).longValue());
        }
        return JSRuntime.toUInt32(JSRuntime.longValueVirtual(number));
    }

    public static long toUInt32(long value) {
        return value & 0xFFFFFFFFL;
    }

    public static long toUInt32(double value) {
        return JSRuntime.toUInt32NoTruncate(JSRuntime.truncateDouble(value));
    }

    public static long toUInt32NoTruncate(double value) {
        assert (!Double.isFinite(value) || value % 1.0 == 0.0);
        double d2 = JSRuntime.doubleModuloTwo32(value);
        return JSRuntime.toUInt32((long)d2);
    }

    public static double truncateDouble(double value) {
        return ExactMath.truncate(value);
    }

    public static int toInt32(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInt32(number);
    }

    public static int toInt32(Number number) {
        if (number instanceof Double) {
            return JSRuntime.toInt32((Double)number);
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number instanceof SafeInteger) {
            return (int)number.longValue();
        }
        if (number instanceof Long) {
            return (int)((Long)number).longValue();
        }
        return JSRuntime.toInt32Intl(number);
    }

    @CompilerDirectives.TruffleBoundary
    private static int toInt32Intl(Number number) {
        return JSRuntime.toInt32(number.doubleValue());
    }

    public static int toInt32(double value) {
        return JSRuntime.toInt32NoTruncate(JSRuntime.truncateDouble(value));
    }

    public static int toInt32NoTruncate(double value) {
        assert (!Double.isFinite(value) || value % 1.0 == 0.0);
        return (int)JSRuntime.doubleModuloTwo32(value);
    }

    private static double doubleModuloTwo32(double value) {
        return value - Math.floor(value / 4.294967296E9) * 4.294967296E9;
    }

    public static double toDouble(Object value) {
        return JSRuntime.doubleValue(JSRuntime.toNumber(value));
    }

    public static double toDouble(Number value) {
        return JSRuntime.doubleValue(value);
    }

    public static String toJavaString(Object value) {
        return Strings.toJavaString(JSRuntime.toString(value));
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toString(Object value) {
        if (value instanceof TruffleString) {
            return (TruffleString)value;
        }
        if (value == Undefined.instance) {
            return Undefined.NAME;
        }
        if (value == Null.instance) {
            return Null.NAME;
        }
        if (value instanceof Boolean) {
            return JSRuntime.booleanToString((Boolean)value);
        }
        if (JSRuntime.isNumber(value) || value instanceof Long) {
            return JSRuntime.numberToString((Number)value);
        }
        if (value instanceof Symbol) {
            throw Errors.createTypeErrorCannotConvertToString("a Symbol value");
        }
        if (value instanceof BigInt) {
            return Strings.fromBigInt((BigInt)value);
        }
        if (JSObject.isJSObject(value)) {
            return JSRuntime.toString(JSObject.toPrimitive((JSObject)value, JSToPrimitiveNode.Hint.String));
        }
        if (value instanceof TruffleObject) {
            assert (!JSRuntime.isJSNative(value));
            return JSRuntime.toString(JSRuntime.toPrimitiveFromForeign(value, JSToPrimitiveNode.Hint.String));
        }
        throw JSRuntime.toStringTypeError(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString safeToString(Object value) {
        return JSRuntime.toDisplayString(value, false, ToDisplayStringFormat.getDefaultFormat());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toDisplayString(Object value, boolean allowSideEffects) {
        return JSRuntime.toDisplayString(value, allowSideEffects, ToDisplayStringFormat.getDefaultFormat());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toDisplayString(Object value, boolean allowSideEffects, ToDisplayStringFormat format) {
        return JSRuntime.toDisplayStringImpl(value, allowSideEffects, format, 0, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString toDisplayStringInner(Object value, boolean allowSideEffects, ToDisplayStringFormat format, int currentDepth, Object parent) {
        return JSRuntime.toDisplayStringImpl(value, allowSideEffects, format.withQuoteString(true), currentDepth + 1, parent);
    }

    public static TruffleString toDisplayStringImpl(Object value, boolean allowSideEffects, ToDisplayStringFormat format, int depth, Object parent) {
        CompilerAsserts.neverPartOfCompilation();
        if (value == parent) {
            return Strings.PARENS_THIS;
        }
        if (value == Undefined.instance) {
            return Undefined.NAME;
        }
        if (value == Null.instance) {
            return Null.NAME;
        }
        if (value instanceof Boolean) {
            return JSRuntime.booleanToString((Boolean)value);
        }
        if (value instanceof TruffleString) {
            TruffleString str = (TruffleString)value;
            return format.quoteString() ? JSRuntime.quote(str) : str;
        }
        if (value instanceof String) {
            String str = (String)value;
            return format.quoteString() ? JSRuntime.quote(Strings.fromJavaString(str)) : Strings.fromJavaString(str);
        }
        if (JSObject.isJSObject(value)) {
            return ((JSObject)value).toDisplayStringImpl(allowSideEffects, format, depth);
        }
        if (value instanceof Symbol) {
            return ((Symbol)value).toTString();
        }
        if (value instanceof BigInt) {
            return Strings.concat(((BigInt)value).toTString(), Strings.N);
        }
        if (JSRuntime.isNumber(value)) {
            Number number = (Number)value;
            if (JSRuntime.isNegativeZero(number.doubleValue())) {
                return Strings.NEGATIVE_ZERO;
            }
            return JSRuntime.numberToString(number);
        }
        if (value instanceof InteropFunction) {
            return JSRuntime.toDisplayStringImpl(((InteropFunction)value).getFunction(), allowSideEffects, format, depth, parent);
        }
        if (value instanceof TruffleObject) {
            assert (!JSRuntime.isJSNative(value)) : value;
            return JSRuntime.foreignToString(value, allowSideEffects, format, depth);
        }
        return Strings.fromObject(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString objectToDisplayString(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth, TruffleString name) {
        return JSRuntime.objectToDisplayString(obj, allowSideEffects, format, depth, name, null, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString objectToDisplayString(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth, TruffleString name, TruffleString[] internalKeys, Object[] internalValues) {
        assert (!JSFunction.isJSFunction(obj) && !JSProxy.isJSProxy(obj));
        boolean v8CompatMode = JSObject.getJSContext(obj).isOptionV8CompatibilityMode();
        TruffleStringBuilderUTF16 sb = Strings.builderCreate();
        if (name != null) {
            Strings.builderAppend(sb, name);
        }
        boolean isArrayLike = false;
        boolean isArray = false;
        long length = -1L;
        if (JSArray.isJSArray(obj)) {
            isArrayLike = true;
            isArray = true;
            length = JSArray.arrayGetLength(obj);
        } else if (obj instanceof JSTypedArrayObject) {
            JSTypedArrayObject typedArrayObj = (JSTypedArrayObject)obj;
            isArrayLike = true;
            length = typedArrayObj.getLength();
        } else if (JSString.isJSString(obj)) {
            length = JSString.getStringLength(obj);
        }
        boolean isStringObj = JSString.isJSString(obj);
        long prevArrayIndex = -1L;
        if (isArrayLike) {
            if (length > 0L) {
                boolean topLevel;
                boolean bl = topLevel = depth == 0;
                if (depth >= format.getMaxDepth() || !topLevel && length > (long)format.getMaxElements()) {
                    if (name == null) {
                        Strings.builderAppend(sb, Strings.UC_ARRAY);
                    }
                    Strings.builderAppend(sb, Strings.PAREN_OPEN);
                    Strings.builderAppend(sb, length);
                    Strings.builderAppend(sb, Strings.PAREN_CLOSE);
                    return Strings.builderToString(sb);
                }
                if (topLevel && length >= 2L && !v8CompatMode && format.includeArrayLength()) {
                    Strings.builderAppend(sb, Strings.PAREN_OPEN);
                    Strings.builderAppend(sb, length);
                    Strings.builderAppend(sb, Strings.PAREN_CLOSE);
                }
            }
        } else if (depth >= format.getMaxDepth()) {
            Strings.builderAppend(sb, Strings.EMPTY_OBJECT_DOTS);
            return Strings.builderToString(sb);
        }
        char chr1 = isArrayLike ? (char)'[' : '{';
        Strings.builderAppend(sb, chr1);
        int propertyCount = 0;
        for (Object key : JSObject.ownPropertyKeys(obj)) {
            TruffleString valueStr;
            Property prop;
            if (!allowSideEffects && JSError.STACK_NAME.equals(key) && (prop = obj.getShape().getProperty(JSError.STACK_NAME)) != null && JSProperty.isProxy(prop)) continue;
            PropertyDescriptor desc = JSObject.getOwnProperty(obj, key);
            if ((isArrayLike || isStringObj) && key.equals(Strings.LENGTH) || isStringObj && JSRuntime.isArrayIndex(key) && JSRuntime.parseArrayIndexIsIndexRaw(key) < length) continue;
            if (propertyCount > 0) {
                Strings.builderAppend(sb, v8CompatMode ? "," : ", ");
                if (propertyCount >= format.getMaxElements()) {
                    Strings.builderAppend(sb, Strings.DOT_DOT_DOT);
                    break;
                }
            }
            if (isArray) {
                if (JSRuntime.isArrayIndex(key)) {
                    long index = JSRuntime.parseArrayIndexIsIndexRaw(key);
                    if (index < length && JSRuntime.fillEmptyArrayElements(sb, index, prevArrayIndex, false)) {
                        Strings.builderAppend(sb, ", ");
                        if (++propertyCount >= format.getMaxElements()) {
                            Strings.builderAppend(sb, "...");
                            break;
                        }
                    }
                    prevArrayIndex = index;
                } else {
                    if (JSRuntime.fillEmptyArrayElements(sb, length, prevArrayIndex, false)) {
                        Strings.builderAppend(sb, Strings.COMMA_SPC);
                        if (++propertyCount >= format.getMaxElements()) {
                            Strings.builderAppend(sb, "...");
                            break;
                        }
                    }
                    prevArrayIndex = Math.max(prevArrayIndex, length);
                }
            }
            if (!isArrayLike || !JSRuntime.isArrayIndex(key)) {
                Strings.builderAppend(sb, Strings.fromObject(key));
                Strings.builderAppend(sb, ": ");
            }
            if (desc.isDataDescriptor()) {
                Object value = desc.getValue();
                valueStr = JSRuntime.toDisplayStringInner(value, allowSideEffects, format, depth, obj);
            } else {
                valueStr = desc.isAccessorDescriptor() ? Strings.ACCESSOR : Strings.EMPTY;
            }
            Strings.builderAppend(sb, valueStr);
            ++propertyCount;
        }
        if (isArray && propertyCount < format.getMaxElements() && JSRuntime.fillEmptyArrayElements(sb, length, prevArrayIndex, propertyCount > 0)) {
            ++propertyCount;
        }
        if (internalKeys != null) {
            assert (internalValues != null && internalKeys.length == internalValues.length);
            for (int i2 = 0; i2 < internalKeys.length; ++i2) {
                if (propertyCount > 0) {
                    Strings.builderAppend(sb, Strings.COMMA_SPC);
                }
                Strings.builderAppend(sb, Strings.BRACKET_OPEN_2);
                Strings.builderAppend(sb, internalKeys[i2]);
                Strings.builderAppend(sb, Strings.BRACKET_CLOSE_2_COLON);
                Strings.builderAppend(sb, JSRuntime.toDisplayStringInner(internalValues[i2], allowSideEffects, format, depth, obj));
                ++propertyCount;
            }
        }
        char chr = isArrayLike ? (char)']' : '}';
        Strings.builderAppend(sb, chr);
        return Strings.builderToString(sb);
    }

    private static TruffleString foreignToString(Object value, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            InteropLibrary interop = InteropLibrary.getUncached(value);
            if (interop.isNull(value)) {
                return Strings.NULL;
            }
            if (interop.hasArrayElements(value)) {
                return JSRuntime.foreignArrayToString(value, allowSideEffects, format, depth);
            }
            if (interop.isString(value)) {
                return format.quoteString() ? Strings.fromJavaString(JSRuntime.quote(interop.asString(value))) : Strings.interopAsTruffleString(value);
            }
            if (interop.isBoolean(value)) {
                return JSRuntime.booleanToString(interop.asBoolean(value));
            }
            if (interop.isNumber(value)) {
                Object unboxed = Strings.UC_NUMBER;
                if (interop.fitsInInt(value)) {
                    unboxed = interop.asInt(value);
                } else if (interop.fitsInLong(value)) {
                    unboxed = interop.asLong(value);
                } else if (interop.fitsInDouble(value)) {
                    unboxed = interop.asDouble(value);
                }
                return JSRuntime.toDisplayString(unboxed, allowSideEffects, format);
            }
            if (JavaScriptLanguage.getCurrentEnv().isHostObject(value)) {
                return JSRuntime.hostObjectToString(value, interop);
            }
            if (interop.isMetaObject(value)) {
                return Strings.interopAsTruffleString(interop.getMetaQualifiedName(value));
            }
            if (interop.hasMembers(value) && !interop.isExecutable(value) && !interop.isInstantiable(value)) {
                return JSRuntime.foreignObjectToString(value, allowSideEffects, format, depth);
            }
            return Strings.interopAsTruffleString(interop.toDisplayString(value, allowSideEffects));
        }
        catch (InteropException e2) {
            return Strings.UC_OBJECT;
        }
    }

    private static TruffleString hostObjectToString(Object value, InteropLibrary interop) throws UnsupportedMessageException {
        if (interop.isMetaObject(value)) {
            return Strings.concatAll(Strings.JAVA_CLASS_BRACKET, Strings.interopAsTruffleString(interop.getMetaQualifiedName(value)), Strings.BRACKET_CLOSE);
        }
        Object metaObject = interop.getMetaObject(value);
        return Strings.concatAll(Strings.JAVA_OBJECT_BRACKET, Strings.interopAsTruffleString(InteropLibrary.getUncached().getMetaQualifiedName(metaObject)), Strings.BRACKET_CLOSE);
    }

    private static TruffleString foreignArrayToString(Object truffleObject, boolean allowSideEffects, ToDisplayStringFormat format, int depth) throws InteropException {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(truffleObject);
        assert (interop.hasArrayElements(truffleObject));
        long size = interop.getArraySize(truffleObject);
        if (size == 0L) {
            return Strings.EMPTY_ARRAY;
        }
        if (depth >= format.getMaxDepth()) {
            return Strings.concatAll(Strings.ARRAY_PAREN_OPEN, Strings.fromLong(size), Strings.PAREN_CLOSE);
        }
        boolean topLevel = depth == 0;
        TruffleStringBuilderUTF16 sb = Strings.builderCreate();
        if (topLevel && size >= 2L && format.includeArrayLength()) {
            Strings.builderAppend(sb, Strings.PAREN_OPEN);
            Strings.builderAppend(sb, size);
            Strings.builderAppend(sb, Strings.PAREN_CLOSE);
        }
        Strings.builderAppend(sb, '[');
        for (long i2 = 0L; i2 < size; ++i2) {
            if (i2 > 0L) {
                Strings.builderAppend(sb, Strings.COMMA_SPC);
                if (i2 >= (long)format.getMaxElements()) {
                    Strings.builderAppend(sb, Strings.DOT_DOT_DOT);
                    break;
                }
            }
            Object value = interop.readArrayElement(truffleObject, i2);
            Strings.builderAppend(sb, JSRuntime.toDisplayStringInner(value, allowSideEffects, format, depth, truffleObject));
        }
        Strings.builderAppend(sb, ']');
        return Strings.builderToString(sb);
    }

    private static TruffleString foreignObjectToString(Object truffleObject, boolean allowSideEffects, ToDisplayStringFormat format, int depth) throws InteropException {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary objInterop = InteropLibrary.getFactory().getUncached(truffleObject);
        assert (objInterop.hasMembers(truffleObject));
        if (allowSideEffects && objInterop.isMemberInvocable(truffleObject, "toString")) {
            return JSRuntime.toString(objInterop.invokeMember(truffleObject, "toString", new Object[0]));
        }
        Object keys = objInterop.getMembers(truffleObject);
        InteropLibrary keysInterop = InteropLibrary.getFactory().getUncached(keys);
        long keyCount = keysInterop.getArraySize(keys);
        if (keyCount == 0L) {
            return Strings.EMPTY_OBJECT;
        }
        if (depth >= format.getMaxDepth()) {
            return Strings.EMPTY_OBJECT_DOTS;
        }
        TruffleStringBuilderUTF16 sb = Strings.builderCreate();
        Strings.builderAppend(sb, '{');
        for (long i2 = 0L; i2 < keyCount; ++i2) {
            if (i2 > 0L) {
                Strings.builderAppend(sb, Strings.COMMA_SPC);
                if (i2 >= (long)format.getMaxElements()) {
                    Strings.builderAppend(sb, Strings.DOT_DOT_DOT);
                    break;
                }
            }
            Object key = keysInterop.readArrayElement(keys, i2);
            assert (InteropLibrary.getUncached().isString(key));
            String stringKey = Strings.interopAsString(key);
            Object value = objInterop.readMember(truffleObject, stringKey);
            Strings.builderAppend(sb, stringKey);
            Strings.builderAppend(sb, Strings.COLON_SPACE);
            Strings.builderAppend(sb, JSRuntime.toDisplayStringInner(value, allowSideEffects, format, depth, truffleObject));
        }
        Strings.builderAppend(sb, '}');
        return Strings.builderToString(sb);
    }

    private static boolean fillEmptyArrayElements(TruffleStringBuilderUTF16 sb, long index, long prevArrayIndex, boolean prependComma) {
        if (prevArrayIndex < index - 1L) {
            long count;
            if (prependComma) {
                Strings.builderAppend(sb, Strings.COMMA_SPC);
            }
            if ((count = index - prevArrayIndex - 1L) == 1L) {
                Strings.builderAppend(sb, Strings.EMPTY);
            } else {
                Strings.builderAppend(sb, Strings.EMPTY_X);
                Strings.builderAppend(sb, count);
            }
            return true;
        }
        return false;
    }

    public static TruffleString collectionToConsoleString(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, TruffleString name, JSHashMap map, int depth) {
        assert (JSMap.isJSMap(obj) || JSSet.isJSSet(obj));
        assert (name != null);
        int size = map.size();
        TruffleStringBuilderUTF16 sb = Strings.builderCreate();
        Strings.builderAppend(sb, name);
        Strings.builderAppend(sb, Strings.PAREN_OPEN);
        Strings.builderAppend(sb, size);
        Strings.builderAppend(sb, Strings.PAREN_CLOSE);
        if (size > 0 && depth < format.getMaxDepth()) {
            Strings.builderAppend(sb, '{');
            boolean isMap = JSMap.isJSMap(obj);
            boolean isFirst = true;
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                if (key == null) continue;
                if (!isFirst) {
                    Strings.builderAppend(sb, Strings.COMMA_SPC);
                }
                Strings.builderAppend(sb, JSRuntime.toDisplayStringInner(key, allowSideEffects, format, depth, obj));
                if (isMap) {
                    Strings.builderAppend(sb, Strings.BIG_ARROW_SPACES);
                    Object value = cursor.getValue();
                    Strings.builderAppend(sb, JSRuntime.toDisplayStringInner(value, allowSideEffects, format, depth, obj));
                }
                isFirst = false;
            }
            Strings.builderAppend(sb, '}');
        }
        return Strings.builderToString(sb);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException toStringTypeError(Object value) {
        String what = value == null ? "null" : (JSDynamicObject.isJSDynamicObject(value) ? Strings.toJavaString(JSObject.defaultToString((JSDynamicObject)value)) : value.getClass().getName());
        throw Errors.createTypeErrorCannotConvertToString(what);
    }

    public static TruffleString booleanToString(boolean value) {
        return value ? JSBoolean.TRUE_NAME : JSBoolean.FALSE_NAME;
    }

    public static TruffleString toString(JSDynamicObject value) {
        if (value == Undefined.instance) {
            return Undefined.NAME;
        }
        if (value == Null.instance) {
            return Null.NAME;
        }
        return JSRuntime.toString(JSObject.toPrimitive(value, JSToPrimitiveNode.Hint.String));
    }

    public static TruffleString numberToString(Number number) {
        CompilerAsserts.neverPartOfCompilation();
        if (number instanceof Integer) {
            return Strings.fromInt((Integer)number);
        }
        if (number instanceof SafeInteger) {
            return JSRuntime.doubleToString(((SafeInteger)number).doubleValue());
        }
        if (number instanceof Double) {
            return JSRuntime.doubleToString((Double)number);
        }
        if (number instanceof Long) {
            return Strings.fromLong(number.longValue());
        }
        throw new UnsupportedOperationException("unknown number value: " + number.toString() + " " + number.getClass().getSimpleName());
    }

    public static boolean propertyKeyEquals(TruffleString.EqualNode equalsNode, Object a2, Object b2) {
        assert (JSRuntime.isPropertyKey(a2));
        if (a2 instanceof TruffleString) {
            if (b2 instanceof TruffleString) {
                return Strings.equals(equalsNode, (TruffleString)a2, (TruffleString)b2);
            }
            return false;
        }
        if (a2 instanceof Symbol) {
            return ((Symbol)a2).equals(b2);
        }
        throw Errors.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public static Object doubleToString(double d2, int radix) {
        assert (radix >= 2 && radix <= 36);
        if (Double.isNaN(d2)) {
            return Strings.NAN;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return Strings.INFINITY;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Strings.NEGATIVE_INFINITY;
        }
        if (d2 == 0.0) {
            return Strings.ZERO;
        }
        return JSRuntime.formatDtoA(d2, radix);
    }

    public static TruffleString doubleToString(double d2) {
        if (Double.isNaN(d2)) {
            return Strings.NAN;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return Strings.INFINITY;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Strings.NEGATIVE_INFINITY;
        }
        if (d2 == 0.0) {
            return Strings.ZERO;
        }
        if (JSRuntime.doubleIsRepresentableAsInt(d2)) {
            return Strings.fromInt((int)d2);
        }
        return Strings.fromJavaString(JSRuntime.formatDtoA(d2));
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoA(double value) {
        return DoubleConversion.toShortest(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatDtoAPrecision(double value, int precision) {
        return Strings.fromJavaString(DoubleConversion.toPrecision(value, precision));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatDtoAExponential(double d2, int digits) {
        return Strings.fromJavaString(DoubleConversion.toExponential(d2, digits));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatDtoAExponential(double d2) {
        return Strings.fromJavaString(DoubleConversion.toExponential(d2, -1));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatDtoAFixed(double value, int digits) {
        return Strings.fromJavaString(DoubleConversion.toFixed(value, digits));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object formatDtoA(double d2, int radix) {
        return Strings.fromJavaString(DToA.jsDtobasestr(radix, d2));
    }

    public static Object toObject(Object value) {
        return JSToObjectNode.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isSameValue(Object x2, Object y2) {
        if (x2 == Undefined.instance && y2 == Undefined.instance) {
            return true;
        }
        if (x2 == Null.instance && y2 == Null.instance) {
            return true;
        }
        if (x2 instanceof Integer && y2 instanceof Integer) {
            return ((Integer)x2).intValue() == ((Integer)y2).intValue();
        }
        if ((JSRuntime.isNumber(x2) || x2 instanceof Long) && (JSRuntime.isNumber(y2) || y2 instanceof Long)) {
            double yd;
            double xd = JSRuntime.doubleValue((Number)x2);
            return Double.compare(xd, yd = JSRuntime.doubleValue((Number)y2)) == 0;
        }
        if (Strings.isTString(x2) && Strings.isTString(y2)) {
            return x2.toString().equals(y2.toString());
        }
        if (x2 instanceof Boolean && y2 instanceof Boolean) {
            return ((Boolean)x2).booleanValue() == ((Boolean)y2).booleanValue();
        }
        if (JSRuntime.isBigInt(x2) && JSRuntime.isBigInt(y2)) {
            return ((BigInt)x2).compareTo((BigInt)y2) == 0;
        }
        return x2 == y2;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equal(Object a2, Object b2) {
        if (a2 == b2) {
            return true;
        }
        if (JSRuntime.isNullOrUndefined(a2)) {
            return JSRuntime.isNullish(b2);
        }
        if (JSRuntime.isNullOrUndefined(b2)) {
            return JSRuntime.isNullish(a2);
        }
        if (a2 instanceof Boolean && b2 instanceof Boolean) {
            return a2.equals(b2);
        }
        if (Strings.isTString(a2) && Strings.isTString(b2)) {
            return Strings.equals((TruffleString)a2, (TruffleString)b2);
        }
        if (JSRuntime.isNumber(a2) && JSRuntime.isNumber(b2)) {
            double db;
            double da = JSRuntime.doubleValue((Number)a2);
            return da == (db = JSRuntime.doubleValue((Number)b2));
        }
        if (JSRuntime.isNumber(a2) && Strings.isTString(b2)) {
            return JSRuntime.equal(a2, JSRuntime.stringToNumber((TruffleString)b2));
        }
        if (Strings.isTString(a2) && JSRuntime.isNumber(b2)) {
            return JSRuntime.equal(JSRuntime.stringToNumber((TruffleString)a2), b2);
        }
        if (JSRuntime.isBigInt(a2) && JSRuntime.isBigInt(b2)) {
            return a2.equals(b2);
        }
        if (JSRuntime.isBigInt(a2) && Strings.isTString(b2)) {
            return a2.equals(JSRuntime.stringToBigInt((TruffleString)b2));
        }
        if (Strings.isTString(a2) && JSRuntime.isBigInt(b2)) {
            return b2.equals(JSRuntime.stringToBigInt((TruffleString)a2));
        }
        if (JSRuntime.isNumber(a2) && JSRuntime.isBigInt(b2)) {
            return JSRuntime.equalBigIntAndNumber((BigInt)b2, (Number)a2);
        }
        if (JSRuntime.isBigInt(a2) && JSRuntime.isNumber(b2)) {
            return JSRuntime.equalBigIntAndNumber((BigInt)a2, (Number)b2);
        }
        if (a2 instanceof Boolean) {
            return JSRuntime.equal(JSRuntime.booleanToNumber((Boolean)a2), b2);
        }
        if (b2 instanceof Boolean) {
            return JSRuntime.equal(a2, JSRuntime.booleanToNumber((Boolean)b2));
        }
        if (JSRuntime.isObject(a2)) {
            assert (!JSRuntime.isNullOrUndefined(b2));
            if (JSOverloadedOperatorsObject.hasOverloadedOperators(a2)) {
                if (JSRuntime.isObject(b2) && !JSOverloadedOperatorsObject.hasOverloadedOperators(b2)) {
                    return JSRuntime.equal(a2, JSObject.toPrimitive((JSDynamicObject)b2));
                }
                if (JSRuntime.isObject(b2) || JSRuntime.isNumber(b2) || JSRuntime.isBigInt(b2) || Strings.isTString(b2)) {
                    return JSRuntime.equalOverloaded(a2, b2);
                }
                return false;
            }
            if (IsPrimitiveNode.getUncached().executeBoolean(b2)) {
                if (JSRuntime.isNullish(b2)) {
                    return false;
                }
                return JSRuntime.equal(JSObject.toPrimitive((JSDynamicObject)a2), b2);
            }
        } else if (JSRuntime.isObject(b2)) {
            assert (!JSRuntime.isNullOrUndefined(a2) && !JSRuntime.isObject(a2));
            if (JSOverloadedOperatorsObject.hasOverloadedOperators(b2)) {
                if (JSRuntime.isNumber(a2) || JSRuntime.isBigInt(a2) || Strings.isTString(a2)) {
                    return JSRuntime.equalOverloaded(a2, b2);
                }
                return false;
            }
            if (IsPrimitiveNode.getUncached().executeBoolean(a2)) {
                if (JSRuntime.isNullish(a2)) {
                    return false;
                }
                return JSRuntime.equal(a2, JSObject.toPrimitive((JSDynamicObject)b2));
            }
        }
        if (JSGuards.isForeignObjectOrNumber(a2) || JSGuards.isForeignObjectOrNumber(b2)) {
            return JSRuntime.equalInterop(a2, b2);
        }
        return false;
    }

    public static boolean isForeignObject(Object value) {
        return value instanceof TruffleObject && JSRuntime.isForeignObject((TruffleObject)value);
    }

    public static boolean isForeignObject(TruffleObject value) {
        return !JSDynamicObject.isJSDynamicObject(value) && !(value instanceof Symbol) && !(value instanceof SafeInteger) && !(value instanceof BigInt) && !Strings.isTString(value);
    }

    private static boolean equalInterop(Object a2, Object b2) {
        Object primB;
        assert (a2 != null && b2 != null && (JSGuards.isForeignObjectOrNumber(a2) || JSGuards.isForeignObjectOrNumber(b2)));
        boolean isAPrimitive = IsPrimitiveNode.getUncached().executeBoolean(a2);
        boolean isBPrimitive = IsPrimitiveNode.getUncached().executeBoolean(b2);
        if (!isAPrimitive && !isBPrimitive) {
            return InteropLibrary.getUncached(a2).isIdentical(a2, b2, InteropLibrary.getUncached(b2));
        }
        if (JSRuntime.isNullish(a2)) {
            return JSRuntime.isNullish(b2);
        }
        if (JSRuntime.isNullish(b2)) {
            assert (!JSRuntime.isNullish(a2));
            return false;
        }
        Object primA = !isAPrimitive || JSGuards.isForeignObjectOrNumber(a2) ? JSRuntime.toPrimitive(a2) : a2;
        Object object = primB = !isBPrimitive || JSGuards.isForeignObjectOrNumber(b2) ? JSRuntime.toPrimitive(b2) : b2;
        assert (!JSRuntime.isForeignObject(primA) && !JSRuntime.isForeignObject(primB));
        primA = primA instanceof Long ? BigInt.valueOf((Long)primA) : primA;
        primB = primB instanceof Long ? BigInt.valueOf((Long)primB) : primB;
        return JSRuntime.equal(primA, primB);
    }

    private static boolean equalBigIntAndNumber(BigInt a2, Number b2) {
        if (b2 instanceof Double || b2 instanceof Float) {
            double numberVal = JSRuntime.doubleValue(b2);
            return !Double.isNaN(numberVal) && a2.compareValueTo(numberVal) == 0;
        }
        return a2.compareValueTo(JSRuntime.longValue(b2)) == 0;
    }

    private static boolean equalOverloaded(Object a2, Object b2) {
        Object operatorImplementation = OperatorSet.getOperatorImplementation(a2, b2, Strings.SYMBOL_EQUALS_EQUALS);
        if (operatorImplementation == null) {
            return false;
        }
        return JSRuntime.toBoolean(JSRuntime.call(operatorImplementation, Undefined.instance, new Object[]{a2, b2}));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean identical(Object a2, Object b2) {
        InteropLibrary bInterop;
        InteropLibrary aInterop;
        block27: {
            if (a2 == b2) {
                if (a2 instanceof Double) {
                    return !Double.isNaN((Double)a2);
                }
                return true;
            }
            if (a2 == Undefined.instance || b2 == Undefined.instance) {
                return false;
            }
            if (a2 == Null.instance) {
                assert (b2 != Undefined.instance);
                return InteropLibrary.getUncached(b2).isNull(b2);
            }
            if (b2 == Null.instance) {
                assert (a2 != Undefined.instance);
                return InteropLibrary.getUncached(a2).isNull(a2);
            }
            if (JSRuntime.isBigInt(a2) && JSRuntime.isBigInt(b2)) {
                return a2.equals(b2);
            }
            if (JSRuntime.isNumber(a2) && JSRuntime.isNumber(b2)) {
                if (a2 instanceof Integer && b2 instanceof Integer) {
                    return ((Integer)a2).intValue() == ((Integer)b2).intValue();
                }
                return JSRuntime.doubleValue((Number)a2) == JSRuntime.doubleValue((Number)b2);
            }
            if (a2 instanceof Boolean && b2 instanceof Boolean) {
                return a2.equals(b2);
            }
            if (Strings.isTString(a2) && Strings.isTString(b2)) {
                return Strings.equals((TruffleString)a2, (TruffleString)b2);
            }
            if (JSRuntime.isObject(a2) || JSRuntime.isObject(b2)) {
                return false;
            }
            boolean isAForeign = JSGuards.isForeignObjectOrNumber(a2);
            boolean isBForeign = JSGuards.isForeignObjectOrNumber(b2);
            if (!isAForeign && !isBForeign) {
                return false;
            }
            aInterop = InteropLibrary.getUncached(a2);
            bInterop = InteropLibrary.getUncached(b2);
            if (aInterop.isNumber(a2) && bInterop.isNumber(b2)) {
                try {
                    if (isAForeign != isBForeign) {
                        if (a2 instanceof BigInt) {
                            assert (!(b2 instanceof BigInt)) : b2;
                            return false;
                        }
                        if (b2 instanceof BigInt) {
                            assert (!(a2 instanceof BigInt)) : a2;
                            return false;
                        }
                    } else assert (isAForeign && isBForeign && !(a2 instanceof BigInt) && !(b2 instanceof BigInt));
                    if (aInterop.fitsInDouble(a2) && bInterop.fitsInDouble(b2)) {
                        return JSRuntime.doubleValue(aInterop.asDouble(a2)) == JSRuntime.doubleValue(bInterop.asDouble(b2));
                    }
                    if (aInterop.fitsInLong(a2) && bInterop.fitsInLong(b2)) {
                        return aInterop.asLong(a2) == bInterop.asLong(b2);
                    }
                    if (aInterop.fitsInBigInteger(a2) && bInterop.fitsInBigInteger(b2)) {
                        return BigInt.fromBigInteger(aInterop.asBigInteger(a2)).compareTo(BigInt.fromBigInteger(bInterop.asBigInteger(b2))) == 0;
                    }
                }
                catch (UnsupportedMessageException e2) {
                    if ($assertionsDisabled) break block27;
                    throw new AssertionError((Object)e2);
                }
            }
        }
        return aInterop.isIdentical(a2, b2, bInterop) || aInterop.isNull(a2) && bInterop.isNull(b2);
    }

    public static <T> T requireObjectCoercible(T argument) {
        if (argument == Undefined.instance || argument == Null.instance || JSRuntime.isForeignObject(argument) && InteropLibrary.getUncached(argument).isNull(argument)) {
            throw Errors.createTypeErrorNotObjectCoercible(argument, null);
        }
        return argument;
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor toPropertyDescriptor(Object property) {
        boolean hasSet;
        boolean hasGet;
        boolean hasWritable;
        boolean hasValue;
        if (!JSRuntime.isObject(property) && !JSRuntime.isForeignObject(property)) {
            throw Errors.createTypeErrorNotAnObject(property);
        }
        PropertyDescriptor desc = PropertyDescriptor.createEmpty();
        if (JSRuntime.hasProperty(property, JSAttributes.ENUMERABLE)) {
            desc.setEnumerable(JSRuntime.toBoolean(JSRuntime.get(property, JSAttributes.ENUMERABLE)));
        }
        if (JSRuntime.hasProperty(property, JSAttributes.CONFIGURABLE)) {
            desc.setConfigurable(JSRuntime.toBoolean(JSRuntime.get(property, JSAttributes.CONFIGURABLE)));
        }
        if (hasValue = JSRuntime.hasProperty(property, JSAttributes.VALUE)) {
            desc.setValue(JSRuntime.get(property, JSAttributes.VALUE));
        }
        if (hasWritable = JSRuntime.hasProperty(property, JSAttributes.WRITABLE)) {
            desc.setWritable(JSRuntime.toBoolean(JSRuntime.get(property, JSAttributes.WRITABLE)));
        }
        if (hasGet = JSRuntime.hasProperty(property, JSAttributes.GET)) {
            Object getter = JSRuntime.get(property, JSAttributes.GET);
            if (!JSRuntime.isCallable(getter) && getter != Undefined.instance) {
                throw Errors.createTypeError("Getter must be a function");
            }
            desc.setGet(getter);
        }
        if (hasSet = JSRuntime.hasProperty(property, JSAttributes.SET)) {
            Object setter = JSRuntime.get(property, JSAttributes.SET);
            if (!JSRuntime.isCallable(setter) && setter != Undefined.instance) {
                throw Errors.createTypeError("Setter must be a function");
            }
            desc.setSet(setter);
        }
        if ((hasGet || hasSet) && (hasValue || hasWritable)) {
            throw Errors.createTypeError("Invalid property. A property cannot both have accessors and be writable or have a value");
        }
        return desc;
    }

    public static int valueInRadix10(char c2) {
        if (JSRuntime.isAsciiDigit(c2)) {
            return c2 - 48;
        }
        return -1;
    }

    public static int valueInRadix(char c2, int radix) {
        int val = JSRuntime.valueInRadixIntl(c2);
        return val < radix ? val : -1;
    }

    private static int valueInRadixIntl(char c2) {
        if (JSRuntime.isAsciiDigit(c2)) {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'z') {
            return c2 - 97 + 10;
        }
        if ('A' <= c2 && c2 <= 'Z') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    public static int valueInHex(char c2) {
        if (JSRuntime.isAsciiDigit(c2)) {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    public static boolean isHex(char c2) {
        return JSRuntime.isAsciiDigit(c2) || 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F';
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseArrayIndexIsIndexRaw(Object o2) {
        TruffleString str;
        assert (JSRuntime.isArrayIndex(o2));
        assert (Strings.isTString(o2) || o2 instanceof Number);
        return JSRuntime.parseArrayIndexRaw(o2 instanceof TruffleString ? (str = (TruffleString)o2) : Strings.fromNumber((Number)o2), TruffleString.ReadCharUTF16Node.getUncached());
    }

    public static long parseArrayIndexRaw(TruffleString string, TruffleString.ReadCharUTF16Node charAtNode) {
        int pos;
        long value = 0L;
        int len = Strings.length(string);
        if (len > 1 && Strings.charAt(charAtNode, string, pos) == '0') {
            return -1L;
        }
        for (pos = 0; pos < len; ++pos) {
            char c2 = Strings.charAt(charAtNode, string, pos);
            if (!JSRuntime.isAsciiDigit(c2)) {
                return -1L;
            }
            value *= 10L;
            value += (long)(c2 - 48);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString trimJSWhiteSpace(TruffleString string) {
        int firstIdx = JSRuntime.firstNonWhitespaceIndex(string, TruffleString.ReadCharUTF16Node.getUncached());
        int lastIdx = JSRuntime.lastNonWhitespaceIndex(string, TruffleString.ReadCharUTF16Node.getUncached());
        if (firstIdx == 0) {
            if (lastIdx + 1 == Strings.length(string)) {
                return string;
            }
        } else if (firstIdx > lastIdx) {
            return Strings.EMPTY_STRING;
        }
        return Strings.lazySubstring(string, firstIdx, lastIdx + 1 - firstIdx);
    }

    public static int firstNonWhitespaceIndex(TruffleString string, TruffleString.ReadCharUTF16Node charAtNode) {
        char ch;
        int idx;
        int len = Strings.length(string);
        for (idx = 0; idx < len && JSRuntime.isWhiteSpaceOrLineTerminator(ch = Strings.charAt(charAtNode, string, idx)); ++idx) {
        }
        return idx;
    }

    public static int lastNonWhitespaceIndex(TruffleString string, TruffleString.ReadCharUTF16Node charAtNode) {
        char ch;
        int idx;
        for (idx = Strings.length(string) - 1; idx >= 0 && JSRuntime.isWhiteSpaceOrLineTerminator(ch = Strings.charAt(charAtNode, string, idx)); --idx) {
        }
        return idx;
    }

    public static boolean isWhiteSpaceOrLineTerminator(char cp) {
        return switch (cp) {
            case '\t', '\n', '\u000b', '\f', '\r', ' ', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000', '\ufeff' -> true;
            default -> false;
        };
    }

    public static boolean isWhiteSpaceExcludingLineTerminator(char cp) {
        return switch (cp) {
            case '\t', '\u000b', '\f', ' ', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202f', '\u205f', '\u3000', '\ufeff' -> true;
            default -> false;
        };
    }

    public static boolean isLineTerminator(char codePoint) {
        return switch (codePoint) {
            case '\n', '\r', '\u2028', '\u2029' -> true;
            default -> false;
        };
    }

    public static boolean isValidArrayLength(long longValue) {
        return 0L <= longValue && longValue <= 0xFFFFFFFFL;
    }

    public static boolean isValidArrayLength(double doubleValue) {
        long longValue = (long)doubleValue;
        return doubleValue == (double)longValue && JSRuntime.isValidArrayLength(longValue);
    }

    public static boolean isValidArrayLength(int intValue) {
        return intValue >= 0;
    }

    public static boolean isIntegerIndex(long longValue) {
        return 0L <= longValue && longValue <= MAX_SAFE_INTEGER_LONG;
    }

    public static boolean isArrayIndex(int intValue) {
        return intValue >= 0;
    }

    public static boolean isArrayIndex(long longValue) {
        return 0L <= longValue && longValue < 0xFFFFFFFFL;
    }

    public static boolean isArrayIndex(double doubleValue) {
        long longValue = (long)doubleValue;
        return (double)longValue == doubleValue && JSRuntime.isArrayIndex(longValue);
    }

    public static boolean isArrayIndexString(TruffleString property) {
        long idx = JSRuntime.propertyNameToArrayIndex(property, TruffleString.ReadCharUTF16Node.getUncached());
        return JSRuntime.isArrayIndex(idx);
    }

    @Idempotent
    public static boolean isArrayIndex(Object property) {
        if (property instanceof Integer) {
            return JSRuntime.isArrayIndex((Integer)property);
        }
        if (property instanceof Long) {
            return JSRuntime.isArrayIndex((Long)property);
        }
        if (property instanceof Double) {
            return JSRuntime.isArrayIndex((Double)property);
        }
        if (property instanceof TruffleString) {
            TruffleString propertyName = (TruffleString)property;
            long idx = JSRuntime.propertyNameToArrayIndex(propertyName, TruffleString.ReadCharUTF16Node.getUncached());
            return JSRuntime.isArrayIndex(idx);
        }
        return false;
    }

    public static long castArrayIndex(double doubleValue) {
        assert (JSRuntime.isArrayIndex(doubleValue));
        return (long)doubleValue & 0xFFFFFFFFL;
    }

    public static long castArrayIndex(long longValue) {
        assert (JSRuntime.isArrayIndex(longValue));
        return longValue;
    }

    public static boolean isAsciiDigit(int c2) {
        return 48 <= c2 && c2 <= 57;
    }

    @CompilerDirectives.TruffleBoundary
    public static long propertyNameToArrayIndex(TruffleString propertyName, TruffleString.ReadCharUTF16Node charAtNode) {
        if (propertyName != null && JSRuntime.arrayIndexLengthInRange(propertyName) && JSRuntime.isAsciiDigit(Strings.charAt(propertyName, 0))) {
            return JSRuntime.parseArrayIndexRaw(propertyName, charAtNode);
        }
        return -1L;
    }

    public static boolean arrayIndexLengthInRange(TruffleString indexStr) {
        int len = Strings.length(indexStr);
        return 0 < len && len <= 10;
    }

    public static long propertyKeyToArrayIndex(Object propertyKey) {
        long l2;
        if (propertyKey instanceof TruffleString) {
            TruffleString propertyName = (TruffleString)propertyKey;
            l2 = JSRuntime.propertyNameToArrayIndex(propertyName, TruffleString.ReadCharUTF16Node.getUncached());
        } else {
            l2 = -1L;
        }
        return l2;
    }

    @CompilerDirectives.TruffleBoundary
    public static long propertyNameToIntegerIndex(TruffleString propertyName) {
        if (propertyName != null && Strings.length(propertyName) > 0 && Strings.length(propertyName) <= 16 && JSRuntime.isAsciiDigit(Strings.charAt(propertyName, 0))) {
            return JSRuntime.parseArrayIndexRaw(propertyName, TruffleString.ReadCharUTF16Node.getUncached());
        }
        return -1L;
    }

    public static long propertyKeyToIntegerIndex(Object propertyKey) {
        long l2;
        if (propertyKey instanceof TruffleString) {
            TruffleString propertyName = (TruffleString)propertyKey;
            l2 = JSRuntime.propertyNameToIntegerIndex(propertyName);
        } else {
            l2 = -1L;
        }
        return l2;
    }

    public static boolean isJSNative(Object value) {
        return JSDynamicObject.isJSDynamicObject(value) || JSRuntime.isJSPrimitive(value);
    }

    public static boolean isJSPrimitive(Object value) {
        return JSRuntime.isNumber(value) || value instanceof Long || value instanceof BigInt || value instanceof Boolean || Strings.isTString(value) || value == Undefined.instance || value == Null.instance || value instanceof Symbol;
    }

    public static Object nullToUndefined(Object value) {
        return value == null ? Undefined.instance : value;
    }

    public static Object undefinedToNull(Object value) {
        return value == Undefined.instance ? null : value;
    }

    public static Object toJSNull(Object value) {
        return value == null ? Null.instance : value;
    }

    public static Object toJavaNull(Object value) {
        return value == Null.instance ? null : value;
    }

    public static boolean isPropertyKey(Object key) {
        return Strings.isTString(key) || key instanceof Symbol;
    }

    public static TruffleString propertyKeyToFunctionNameString(Object key) {
        assert (JSRuntime.isPropertyKey(key)) : key;
        if (key instanceof TruffleString) {
            return (TruffleString)key;
        }
        return ((Symbol)key).toFunctionNameString();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt stringToBigInt(TruffleString s2) {
        try {
            return Strings.parseBigInt(s2);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static int intValue(Number number) {
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number instanceof Double) {
            return ((Double)number).intValue();
        }
        return JSRuntime.intValueVirtual(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static int intValueVirtual(Number number) {
        return number.intValue();
    }

    public static double doubleValue(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number instanceof Integer) {
            return ((Integer)number).doubleValue();
        }
        if (number instanceof SafeInteger) {
            return ((SafeInteger)number).doubleValue();
        }
        return JSRuntime.doubleValueVirtual(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValueVirtual(Number number) {
        return number.doubleValue();
    }

    public static float floatValue(Number n2) {
        if (n2 instanceof Double) {
            return ((Double)n2).floatValue();
        }
        if (n2 instanceof Integer) {
            return ((Integer)n2).floatValue();
        }
        return JSRuntime.floatValueVirtual(n2);
    }

    @CompilerDirectives.TruffleBoundary
    public static float floatValueVirtual(Number n2) {
        return n2.floatValue();
    }

    public static long longValue(Number n2) {
        if (n2 instanceof Integer) {
            return ((Integer)n2).longValue();
        }
        if (n2 instanceof Double) {
            return ((Double)n2).longValue();
        }
        if (n2 instanceof SafeInteger) {
            return ((SafeInteger)n2).longValue();
        }
        return JSRuntime.longValueVirtual(n2);
    }

    @CompilerDirectives.TruffleBoundary
    private static long longValueVirtual(Number n2) {
        return n2.longValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject fromPropertyDescriptor(PropertyDescriptor desc, JSContext context) {
        if (desc == null) {
            return Undefined.instance;
        }
        JSObject obj = JSOrdinary.create(context, JSRealm.get(null));
        if (desc.hasValue()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.VALUE, desc.getValue());
        }
        if (desc.hasWritable()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.WRITABLE, (Object)desc.getWritable());
        }
        if (desc.hasGet()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.GET, desc.getGet());
        }
        if (desc.hasSet()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.SET, desc.getSet());
        }
        if (desc.hasEnumerable()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.ENUMERABLE, (Object)desc.getEnumerable());
        }
        if (desc.hasConfigurable()) {
            JSObject.set((JSDynamicObject)obj, JSAttributes.CONFIGURABLE, (Object)desc.getConfigurable());
        }
        return obj;
    }

    public static Object getArgOrUndefined(Object[] args, int i2) {
        return args.length > i2 ? args[i2] : Undefined.instance;
    }

    public static Object getArg(Object[] args, int i2, Object defaultValue) {
        return args.length > i2 ? args[i2] : defaultValue;
    }

    public static long getOffset(long start, long length, Node node, InlinedConditionProfile profile) {
        if (profile.profile(node, start < 0L)) {
            return Math.max(start + length, 0L);
        }
        return Math.min(start, length);
    }

    public static int getOffset(int start, int length, Node node, InlinedConditionProfile profile) {
        if (profile.profile(node, start < 0)) {
            return Math.max(start + length, 0);
        }
        return Math.min(start, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseSafeInteger(TruffleString s2) {
        return JSRuntime.parseSafeInteger(s2, 0, Strings.length(s2), 10);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseSafeInteger(TruffleString s2, int beginIndex, int endIndex, int radix) {
        return JSRuntime.parseLong(s2, beginIndex, endIndex, radix, radix == 10, MAX_SAFE_INTEGER_LONG);
    }

    private static long parseLong(TruffleString s2, int beginIndex, int endIndex, int radix, boolean parseSign, long limit) {
        assert (beginIndex >= 0 && beginIndex <= endIndex && endIndex <= Strings.length(s2));
        assert (radix >= 2 && radix <= 36);
        assert (limit <= Long.MAX_VALUE / (long)radix - (long)radix);
        boolean negative = false;
        int i2 = beginIndex;
        if (i2 >= endIndex) {
            return Long.MIN_VALUE;
        }
        if (parseSign) {
            char firstChar = Strings.charAt(s2, i2);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                } else if (firstChar != '+') {
                    return Long.MIN_VALUE;
                }
                ++i2;
            }
            if (i2 >= endIndex) {
                return Long.MIN_VALUE;
            }
        }
        long result = 0L;
        while (i2 < endIndex) {
            char c2 = Strings.charAt(s2, i2);
            int digit = JSRuntime.valueInRadix(c2, radix);
            if (digit < 0) {
                return Long.MIN_VALUE;
            }
            result *= (long)radix;
            if ((result += (long)digit) > limit) {
                return Long.MIN_VALUE;
            }
            ++i2;
        }
        assert (result >= 0L);
        if (negative && result == 0L) {
            return Long.MIN_VALUE;
        }
        return negative ? -result : result;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number parseRawFitsLong(TruffleString string, int radix, int startPos, int endPos, boolean negate) {
        long signedValue;
        assert (startPos < endPos);
        long value = 0L;
        for (int pos = startPos; pos < endPos; ++pos) {
            char c2 = Strings.charAt(string, pos);
            int cval = JSRuntime.valueInRadix(c2, radix);
            if (cval < 0) {
                if (pos != startPos) break;
                return Double.NaN;
            }
            value *= (long)radix;
            value += (long)cval;
        }
        if (value == 0L && negate && Strings.charAt(string, startPos) == '0') {
            return -0.0;
        }
        assert (value >= 0L);
        long l2 = signedValue = negate ? -value : value;
        if (value <= Integer.MAX_VALUE) {
            return (int)signedValue;
        }
        return (double)signedValue;
    }

    @CompilerDirectives.TruffleBoundary
    public static double parseRawDontFitLong(TruffleString string, int radix, int startPos, int endPos, boolean negate) {
        assert (startPos < endPos);
        double value = 0.0;
        for (int pos = startPos; pos < endPos; ++pos) {
            char c2 = Strings.charAt(string, pos);
            int cval = JSRuntime.valueInRadix(c2, radix);
            if (cval < 0) {
                if (pos != startPos) break;
                return Double.NaN;
            }
            value *= (double)radix;
            value += (double)cval;
        }
        assert (value >= 0.0);
        return negate ? -value : value;
    }

    public static boolean createDataProperty(JSDynamicObject o2, Object p2, Object v2) {
        assert (JSRuntime.isObject(o2));
        assert (JSRuntime.isPropertyKey(p2));
        return JSObject.defineOwnProperty(o2, p2, PropertyDescriptor.createDataDefault(v2));
    }

    public static boolean createDataProperty(JSDynamicObject o2, Object p2, Object v2, boolean doThrow) {
        assert (JSRuntime.isObject(o2));
        assert (JSRuntime.isPropertyKey(p2));
        boolean success = JSObject.defineOwnProperty(o2, p2, PropertyDescriptor.createDataDefault(v2), doThrow);
        assert (!doThrow || success) : "should have thrown";
        return success;
    }

    public static boolean createDataPropertyOrThrow(JSDynamicObject o2, Object p2, Object v2) {
        return JSRuntime.createDataProperty(o2, p2, v2, true);
    }

    public static void createNonEnumerableDataPropertyOrThrow(JSDynamicObject o2, Object p2, Object v2) {
        PropertyDescriptor newDesc = PropertyDescriptor.createData(v2, JSAttributes.getDefaultNotEnumerable());
        JSRuntime.definePropertyOrThrow(o2, p2, newDesc);
    }

    public static void definePropertyOrThrow(JSDynamicObject o2, Object key, PropertyDescriptor desc) {
        assert (JSRuntime.isObject(o2));
        assert (JSRuntime.isPropertyKey(key));
        boolean success = JSObject.getJSClass(o2).defineOwnProperty(o2, key, desc, true);
        assert (success);
    }

    public static boolean isPrototypeOf(JSDynamicObject object, JSDynamicObject prototype) {
        JSDynamicObject prototypeChainObject = object;
        do {
            if ((prototypeChainObject = JSObject.getPrototype(prototypeChainObject)) != prototype) continue;
            return true;
        } while (prototypeChainObject != Null.instance);
        return false;
    }

    public static JSDynamicObject createArrayFromList(JSContext context, JSRealm realm, List<? extends Object> list) {
        return JSArray.createConstant(context, realm, Boundaries.listToArray(list));
    }

    public static boolean isCallable(Object value) {
        if (JSFunction.isJSFunction(value)) {
            return true;
        }
        if (JSProxy.isJSProxy(value)) {
            return JSRuntime.isCallableProxy((JSDynamicObject)value);
        }
        if (value instanceof TruffleObject) {
            return JSRuntime.isCallableForeign(value);
        }
        return false;
    }

    public static boolean isCallableIsJSObject(JSDynamicObject value) {
        assert (JSDynamicObject.isJSDynamicObject(value));
        if (JSFunction.isJSFunction(value)) {
            return true;
        }
        if (JSProxy.isJSProxy(value)) {
            return JSRuntime.isCallableProxy(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isCallableForeign(Object value) {
        if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getUncached();
            return interop.isExecutable(value) || interop.isInstantiable(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isCallableProxy(JSDynamicObject proxy) {
        assert (JSProxy.isJSProxy(proxy));
        Object target = JSProxy.getTarget(proxy);
        return JSRuntime.isCallable(target);
    }

    public static boolean isArray(Object obj) {
        if (JSArray.isJSArray(obj)) {
            return true;
        }
        if (JSProxy.isJSProxy(obj)) {
            return JSRuntime.isProxyAnArray((JSDynamicObject)obj);
        }
        if (JSRuntime.isForeignObject(obj)) {
            return InteropLibrary.getUncached().hasArrayElements(obj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isProxyAnArray(JSDynamicObject proxy) {
        assert (JSProxy.isJSProxy(proxy));
        if (JSProxy.isRevoked(proxy)) {
            throw Errors.createTypeErrorProxyRevoked();
        }
        return JSRuntime.isArrayProxyRecurse(proxy);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isArrayProxyRecurse(JSDynamicObject proxy) {
        return JSRuntime.isArray(JSProxy.getTarget(proxy));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPropertyKey(Object arg) {
        if (Strings.isTString(arg)) {
            return arg;
        }
        if (arg instanceof Symbol) {
            return arg;
        }
        Object key = JSRuntime.toPrimitive(arg);
        if (key instanceof Symbol) {
            return key;
        }
        if (Strings.isTString(key)) {
            return key;
        }
        return JSRuntime.toString(key);
    }

    public static Object call(Object fnObj, Object holder, Object[] arguments) {
        if (JSFunction.isJSFunction(fnObj)) {
            return JSFunction.call((JSFunctionObject)fnObj, holder, arguments);
        }
        if (JSProxy.isJSProxy(fnObj)) {
            return JSProxy.call((JSDynamicObject)fnObj, holder, arguments);
        }
        if (JSRuntime.isForeignObject(fnObj)) {
            return JSInteropUtil.call(fnObj, arguments);
        }
        throw Errors.createTypeErrorNotAFunction(fnObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(Object fnObj, Object holder, Object[] arguments, Node encapsulatingNode) {
        EncapsulatingNodeReference encapsulating = null;
        Node prev = null;
        if (encapsulatingNode != null) {
            encapsulating = EncapsulatingNodeReference.getCurrent();
            prev = encapsulating.set(encapsulatingNode);
        }
        try {
            Object object = JSRuntime.call(fnObj, holder, arguments);
            return object;
        }
        finally {
            if (encapsulatingNode != null) {
                encapsulating.set(prev);
            }
        }
    }

    public static Object construct(Object fnObj, Object[] arguments) {
        if (JSFunction.isConstructor(fnObj)) {
            return JSFunction.construct((JSFunctionObject)fnObj, arguments);
        }
        if (JSProxy.isJSProxy(fnObj) && JSRuntime.isConstructorProxy((JSDynamicObject)fnObj)) {
            return JSProxy.construct((JSDynamicObject)fnObj, arguments);
        }
        if (JSRuntime.isForeignObject(fnObj)) {
            return JSInteropUtil.construct(fnObj, arguments);
        }
        throw Errors.createTypeErrorNotAConstructor(fnObj, JavaScriptLanguage.get(null).getJSContext());
    }

    @CompilerDirectives.TruffleBoundary
    public static Object canonicalNumericIndexString(TruffleString s2) {
        if (Strings.isEmpty(s2) || !JSRuntime.isNumericIndexStart(Strings.charAt(s2, 0))) {
            return Undefined.instance;
        }
        if (Strings.NEGATIVE_ZERO.equals(s2)) {
            return -0.0;
        }
        Number n2 = JSRuntime.stringToNumber(s2);
        if (!JSRuntime.numberToString(n2).equals(s2)) {
            return Undefined.instance;
        }
        return n2;
    }

    private static boolean isNumericIndexStart(char c2) {
        return JSRuntime.isAsciiDigit(c2) || c2 == '-' || c2 == 'I' || c2 == 'N';
    }

    public static boolean isInteger(Object obj) {
        if (!JSRuntime.isNumber(obj)) {
            return false;
        }
        double d2 = JSRuntime.doubleValue((Number)obj);
        return d2 - JSRuntime.truncateDouble(d2) == 0.0;
    }

    public static int comparePropertyKeys(Object key1, Object key2) {
        assert (JSRuntime.isPropertyKey(key1) && JSRuntime.isPropertyKey(key2));
        boolean isString1 = Strings.isTString(key1);
        boolean isString2 = Strings.isTString(key2);
        if (isString1 && isString2) {
            long index1 = JSRuntime.propertyNameToArrayIndex((TruffleString)key1, TruffleString.ReadCharUTF16Node.getUncached());
            long index2 = JSRuntime.propertyNameToArrayIndex((TruffleString)key2, TruffleString.ReadCharUTF16Node.getUncached());
            boolean isIndex1 = JSRuntime.isArrayIndex(index1);
            boolean isIndex2 = JSRuntime.isArrayIndex(index2);
            if (isIndex1 && isIndex2) {
                return Long.compare(index1, index2);
            }
            if (isIndex1) {
                return -1;
            }
            if (isIndex2) {
                return 1;
            }
            return 0;
        }
        if (isString1) {
            return -1;
        }
        if (isString2) {
            return 1;
        }
        return 0;
    }

    public static TruffleString getConstructorName(JSDynamicObject receiver) {
        Object constructor;
        JSDynamicObject prototype;
        Object toStringTag = JSRuntime.getDataProperty(receiver, Symbol.SYMBOL_TO_STRING_TAG);
        if (toStringTag instanceof TruffleString) {
            TruffleString str = (TruffleString)toStringTag;
            return str;
        }
        if (!JSRuntime.isProxy(receiver) && (prototype = JSObject.getPrototype(receiver)) != Null.instance && JSFunction.isJSFunction(constructor = JSRuntime.getDataProperty(prototype, JSObject.CONSTRUCTOR))) {
            return JSFunction.getName((JSFunctionObject)constructor);
        }
        return JSObject.getClassName(receiver);
    }

    public static Object getDataProperty(JSDynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        JSDynamicObject current = thisObj;
        while (current != Null.instance && current != null && !JSRuntime.isProxy(current)) {
            PropertyDescriptor desc = JSObject.getOwnProperty(current, key);
            if (desc != null) {
                if (!desc.isDataDescriptor()) break;
                return desc.getValue();
            }
            current = JSObject.getPrototype(current);
        }
        return null;
    }

    private static boolean isProxy(JSDynamicObject receiver) {
        return JSProxy.isJSProxy(receiver) || JSAdapter.isJSAdapter(receiver);
    }

    public static boolean isJSRootNode(RootNode rootNode) {
        return rootNode instanceof JavaScriptRootNode;
    }

    public static boolean isJSFunctionRootNode(RootNode rootNode) {
        return rootNode instanceof JavaScriptRootNode && ((JavaScriptRootNode)rootNode).isFunction();
    }

    public static boolean isSafeInteger(double value) {
        return value >= MIN_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
    }

    public static boolean isSafeInteger(long value) {
        return value >= MIN_SAFE_INTEGER_LONG && value <= MAX_SAFE_INTEGER_LONG;
    }

    @CompilerDirectives.TruffleBoundary
    public static JSRealm getFunctionRealm(Object obj, JSRealm currentRealm) {
        if (obj instanceof JSObject) {
            JSObject jsObj = (JSObject)obj;
            if (jsObj instanceof JSFunctionObject) {
                JSFunctionObject function = (JSFunctionObject)jsObj;
                if (jsObj instanceof JSFunctionObject.Bound) {
                    JSFunctionObject.Bound boundFunction = (JSFunctionObject.Bound)jsObj;
                    return JSRuntime.getFunctionRealm(boundFunction.getBoundTargetFunction(), currentRealm);
                }
                return JSFunction.getRealm(function);
            }
            if (jsObj instanceof JSProxyObject) {
                if (JSProxy.getHandler(jsObj) == Null.instance) {
                    throw Errors.createTypeErrorProxyRevoked();
                }
                return JSRuntime.getFunctionRealm(JSProxy.getTarget(jsObj), currentRealm);
            }
        }
        return currentRealm;
    }

    public static boolean isConstructor(Object constrObj) {
        if (JSFunction.isConstructor(constrObj)) {
            return true;
        }
        if (JSProxy.isJSProxy(constrObj)) {
            return JSRuntime.isConstructorProxy((JSDynamicObject)constrObj);
        }
        if (constrObj instanceof TruffleObject) {
            return JSRuntime.isConstructorForeign(constrObj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isConstructorForeign(Object value) {
        if (JSRuntime.isForeignObject(value)) {
            return InteropLibrary.getUncached().isInstantiable(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isConstructorProxy(JSDynamicObject constrObj) {
        assert (JSProxy.isJSProxy(constrObj));
        return JSRuntime.isConstructor(JSProxy.getTarget(constrObj));
    }

    public static boolean isGenerator(Object genObj) {
        if (JSFunction.isJSFunction(genObj) && JSFunction.isGenerator((JSFunctionObject)genObj)) {
            return true;
        }
        if (JSProxy.isJSProxy(genObj)) {
            return JSRuntime.isGeneratorProxy((JSDynamicObject)genObj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isGeneratorProxy(JSDynamicObject genObj) {
        assert (JSProxy.isJSProxy(genObj));
        return JSRuntime.isGenerator(JSProxy.getTarget(genObj));
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> createListFromArrayLikeAllowSymbolString(Object obj) {
        if (!JSRuntime.isObject(obj)) {
            throw Errors.createTypeErrorNotAnObject(obj);
        }
        JSDynamicObject jsObj = (JSDynamicObject)obj;
        long len = JSRuntime.toLength(JSObject.get(jsObj, JSAbstractArray.LENGTH));
        if (len > Integer.MAX_VALUE) {
            throw Errors.createRangeError("range exceeded");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (long index = 0L; index < len; ++index) {
            Object next = JSObject.get(jsObj, index);
            if (!Strings.isTString(next) && !(next instanceof Symbol)) {
                throw Errors.createTypeError("Symbol or String expected");
            }
            Boundaries.listAdd(list, next);
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static String quote(String value) {
        char ch;
        int pos;
        for (pos = 0; pos < value.length() && (ch = value.charAt(pos)) >= ' ' && ch != '\\' && ch != '\"'; ++pos) {
        }
        StringBuilder builder = new StringBuilder(value.length() + 2);
        builder.append('\"');
        builder.append(value, 0, pos);
        for (int i2 = pos; i2 < value.length(); ++i2) {
            char ch2 = value.charAt(i2);
            if (ch2 < ' ') {
                if (ch2 == '\b') {
                    builder.append("\\b");
                    continue;
                }
                if (ch2 == '\f') {
                    builder.append("\\f");
                    continue;
                }
                if (ch2 == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (ch2 == '\r') {
                    builder.append("\\r");
                    continue;
                }
                if (ch2 == '\t') {
                    builder.append("\\t");
                    continue;
                }
                builder.append("\\u00");
                builder.append(Character.forDigit((ch2 & 0xF0) >> 4, 16));
                builder.append(Character.forDigit(ch2 & 0xF, 16));
                continue;
            }
            if (ch2 == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (ch2 == '\"') {
                builder.append("\\\"");
                continue;
            }
            builder.append(ch2);
        }
        builder.append('\"');
        return builder.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString quote(TruffleString value) {
        char ch;
        int pos;
        int len = Strings.length(value);
        for (pos = 0; pos < len && (ch = Strings.charAt(value, pos)) >= ' ' && ch != '\\' && ch != '\"'; ++pos) {
        }
        TruffleStringBuilderUTF16 builder = Strings.builderCreate(len + 2);
        Strings.builderAppend(builder, '\"');
        Strings.builderAppend(builder, value, 0, pos);
        for (int i2 = pos; i2 < len; ++i2) {
            char ch2 = Strings.charAt(value, i2);
            if (ch2 < ' ') {
                if (ch2 == '\b') {
                    Strings.builderAppend(builder, Strings.BACKSLASH_B);
                    continue;
                }
                if (ch2 == '\f') {
                    Strings.builderAppend(builder, Strings.BACKSLASH_F);
                    continue;
                }
                if (ch2 == '\n') {
                    Strings.builderAppend(builder, Strings.BACKSLASH_N);
                    continue;
                }
                if (ch2 == '\r') {
                    Strings.builderAppend(builder, Strings.BACKSLASH_R);
                    continue;
                }
                if (ch2 == '\t') {
                    Strings.builderAppend(builder, Strings.BACKSLASH_T);
                    continue;
                }
                Strings.builderAppend(builder, Strings.BACKSLASH_U00);
                Strings.builderAppend(builder, Character.forDigit((ch2 & 0xF0) >> 4, 16));
                Strings.builderAppend(builder, Character.forDigit(ch2 & 0xF, 16));
                continue;
            }
            if (ch2 == '\\') {
                Strings.builderAppend(builder, Strings.BACKSLASH_BACKSLASH);
                continue;
            }
            if (ch2 == '\"') {
                Strings.builderAppend(builder, Strings.BACKSLASH_DOUBLE_QUOTE);
                continue;
            }
            Strings.builderAppend(builder, ch2);
        }
        Strings.builderAppend(builder, '\"');
        return Strings.builderToString(builder);
    }

    public static JSDynamicObject expectJSObject(Object to, BranchProfile errorBranch) {
        if (!JSDynamicObject.isJSDynamicObject(to)) {
            errorBranch.enter();
            throw Errors.createTypeErrorJSObjectExpected();
        }
        return (JSDynamicObject)to;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object exportValue(Object value) {
        return ExportValueNode.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object[] exportValueArray(Object[] arr) {
        Object[] newArr = new Object[arr.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            newArr[i2] = JSRuntime.exportValue(arr[i2]);
        }
        return newArr;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object importValue(Object value) {
        assert (value != null);
        return ImportValueNode.getUncached().executeWithTarget(value);
    }

    public static boolean intIsRepresentableAsFloat(int value) {
        return -16777216 <= value && value <= 0x1000000;
    }

    public static boolean isJavaPrimitive(Object value) {
        return value != null && value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static GraalJSException getException(Object errorObject) {
        return JSRuntime.getException(errorObject, null);
    }

    public static GraalJSException getException(Object errorObject, Node node) {
        if (errorObject instanceof JSErrorObject) {
            JSErrorObject jsErrorObject = (JSErrorObject)errorObject;
            return JSError.getException(jsErrorObject);
        }
        return UserScriptException.create(errorObject, node, JavaScriptLanguage.get(node).getJSContext().getLanguageOptions().stackTraceLimit());
    }

    public static IteratorRecord getIterator(Object iteratedObject) {
        JSDynamicObject target = iteratedObject instanceof JSDynamicObject ? (JSDynamicObject)iteratedObject : ForeignObjectPrototypeNode.getUncached().execute(iteratedObject);
        Object method = JSObject.getOrDefault(target, Symbol.SYMBOL_ITERATOR, iteratedObject, (Object)Undefined.instance);
        if (!JSRuntime.isCallable(method)) {
            throw Errors.createTypeErrorNotIterable(iteratedObject, null);
        }
        Object iterator = JSRuntime.call(method, iteratedObject, new Object[0]);
        if (IsObjectNode.getUncached().executeBoolean(iterator)) {
            return IteratorRecord.create(iterator, JSRuntime.get(iterator, Strings.NEXT), false);
        }
        throw Errors.createTypeErrorNotAnObject(iterator);
    }

    public static Object iteratorStep(IteratorRecord iteratorRecord) {
        Object nextMethod = iteratorRecord.getNextMethod();
        Object iterator = iteratorRecord.getIterator();
        Object result = JSRuntime.call(nextMethod, iterator, new Object[0]);
        if (!IsObjectNode.getUncached().executeBoolean(result)) {
            throw Errors.createTypeErrorIteratorResultNotObject(result, null);
        }
        boolean done = JSRuntime.toBoolean(JSRuntime.get(result, Strings.DONE));
        if (done) {
            return false;
        }
        return result;
    }

    public static Object iteratorValue(Object iterator) {
        return JSRuntime.get(iterator, Strings.VALUE);
    }

    public static void iteratorClose(Object iterator) {
        Object returnMethod = JSRuntime.get(iterator, Strings.RETURN);
        if (returnMethod != Undefined.instance) {
            Object innerResult = JSRuntime.call(returnMethod, iterator, new Object[0]);
            if (!IsObjectNode.getUncached().executeBoolean(innerResult)) {
                throw Errors.createTypeErrorIterResultNotAnObject(innerResult, null);
            }
        }
    }

    public static boolean isIntegralNumber(double arg) {
        return arg - JSRuntime.truncateDouble(arg) == 0.0;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(Object obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            return JSObject.get((JSDynamicObject)obj, key);
        }
        return JSInteropUtil.readMemberOrDefault(obj, key, Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(Object obj, long index) {
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            return JSObject.get((JSDynamicObject)obj, index);
        }
        return JSInteropUtil.readArrayElementOrDefault(obj, index, Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(Object obj, Object key) {
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            return JSObject.hasProperty((JSDynamicObject)obj, key);
        }
        return JSInteropUtil.hasProperty(obj, key);
    }

    public static boolean isPrivateSymbol(Object key) {
        return key instanceof Symbol && ((Symbol)key).isPrivate();
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> filterPrivateSymbols(List<Object> list) {
        boolean containsPrivateSymbol = false;
        for (Object key : list) {
            if (!JSRuntime.isPrivateSymbol(key)) continue;
            containsPrivateSymbol = true;
            break;
        }
        if (containsPrivateSymbol) {
            ArrayList<Object> filtered = new ArrayList<Object>(list.size());
            for (Object key : list) {
                if (JSRuntime.isPrivateSymbol(key)) continue;
                filtered.add(key);
            }
            return filtered;
        }
        return list;
    }

    public static Number toUint32(int value) {
        if (value >= 0) {
            return value;
        }
        return (double)((long)value & 0xFFFFFFFFL);
    }

    public static short toFloat16(Number number) {
        return JSRuntime.toFloat16(JSRuntime.doubleValue(number));
    }

    public static short toFloat16(double d2) {
        float f2 = (float)d2;
        short s2 = Float.floatToFloat16(f2);
        if ((double)f2 != d2) {
            if ((double)f2 < d2) {
                short sNextUp = Float.floatToFloat16(Math.nextUp(f2));
                if (s2 != sNextUp) {
                    float low = Float.float16ToFloat(s2);
                    float high = Float.float16ToFloat(sNextUp);
                    return (double)high - d2 < d2 - (double)low ? sNextUp : s2;
                }
            } else {
                short sNextDown = Float.floatToFloat16(Math.nextDown(f2));
                if (s2 != sNextDown) {
                    float low = Float.float16ToFloat(sNextDown);
                    float high = Float.float16ToFloat(s2);
                    return (double)high - d2 < d2 - (double)low ? s2 : sNextDown;
                }
            }
        }
        return s2;
    }

    public static Object getBufferElementDirect(ByteBufferAccess bufferAccess, ByteBuffer buffer, TypedArray.ElementType elementType, int index) {
        switch (elementType) {
            case Int8: {
                return (int)buffer.get(index);
            }
            case Uint8: 
            case Uint8Clamped: {
                return buffer.get(index) & 0xFF;
            }
            case Int16: {
                return bufferAccess.getInt16(buffer, index);
            }
            case Uint16: {
                return bufferAccess.getUint16(buffer, index);
            }
            case Int32: {
                return bufferAccess.getInt32(buffer, index);
            }
            case Uint32: {
                return JSRuntime.toUint32(bufferAccess.getInt32(buffer, index));
            }
            case BigInt64: 
            case BigUint64: {
                return BigInt.valueOf(bufferAccess.getInt64(buffer, index));
            }
            case Float16: {
                return (double)Float.float16ToFloat(bufferAccess.getFloat16(buffer, index));
            }
            case Float32: {
                return (double)bufferAccess.getFloat(buffer, index);
            }
            case Float64: {
                return bufferAccess.getDouble(buffer, index);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static void setBufferElementDirect(ByteBufferAccess bufferAccess, ByteBuffer buffer, TypedArray.ElementType elementType, int index, Object value) {
        switch (elementType) {
            case Int8: 
            case Uint8: {
                buffer.put(index, (byte)JSRuntime.toInt32((Number)value));
                break;
            }
            case Uint8Clamped: {
                int intValue = value instanceof Integer ? (Integer)value : (int)Math.rint(JSRuntime.toDouble((Number)value));
                int clampedValue = intValue < 0 ? 0 : (intValue > 255 ? 255 : intValue);
                buffer.put(index, (byte)clampedValue);
                break;
            }
            case Int16: {
                bufferAccess.putInt16(buffer, index, (short)JSRuntime.toInt32((Number)value));
                break;
            }
            case Uint16: {
                bufferAccess.putInt16(buffer, index, (char)JSRuntime.toInt32((Number)value));
                break;
            }
            case Int32: 
            case Uint32: {
                bufferAccess.putInt32(buffer, index, JSRuntime.toInt32((Number)value));
                break;
            }
            case BigInt64: 
            case BigUint64: {
                bufferAccess.putInt64(buffer, index, JSRuntime.toBigInt(value).longValue());
                break;
            }
            case Float16: {
                bufferAccess.putFloat16(buffer, index, JSRuntime.toFloat16((Number)value));
                break;
            }
            case Float32: {
                bufferAccess.putFloat(buffer, index, JSRuntime.floatValue((Number)value));
                break;
            }
            case Float64: {
                bufferAccess.putDouble(buffer, index, JSRuntime.doubleValue((Number)value));
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }
}

