/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.BasicState;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import java.util.Arrays;

public final class PureNFAState
extends BasicState<PureNFAState, PureNFATransition> {
    private static final PureNFATransition[] EMPTY_TRANSITIONS = new PureNFATransition[0];
    public static final short KIND_INITIAL_OR_FINAL_STATE = 0;
    public static final short KIND_CHARACTER_CLASS = 1;
    public static final short KIND_SUB_MATCHER = 2;
    public static final short KIND_BACK_REFERENCE = 3;
    public static final short KIND_EMPTY_MATCH = 4;
    private static final short FLAG_IS_LOOK_AROUND = 16;
    private static final short FLAG_IS_SUB_MATCHER_NEGATED = 32;
    private static final short FLAG_IS_DETERMINISTIC = 64;
    private static final short FLAG_IS_IGNORE_CASE_REFERENCE = 128;
    private static final short FLAG_IS_RECURSIVE_REFERENCE = 256;
    private static final short FLAG_IS_IGNORE_CASE_REFERENCE_ALTERNATIVE_MODE = 512;
    private final int astNodeId;
    private final int subtreeId;
    private final int[] referencedGroupNumbers;
    private final byte kind;
    private final CodePointSet charSet;

    public PureNFAState(int id, Term t2) {
        super(id, (AbstractTransition[])EMPTY_TRANSITIONS);
        this.astNodeId = t2.getId();
        this.kind = PureNFAState.getKind(t2);
        this.subtreeId = this.isSubMatcher() ? t2.asSubtreeRootNode().getSubTreeId() : -1;
        this.referencedGroupNumbers = this.isBackReference() ? t2.asBackReference().getGroupNumbers() : null;
        this.charSet = this.isCharacterClass() ? t2.asCharacterClass().getCharSet() : null;
        this.setLookAround(t2.isLookAroundAssertion());
        if (t2.isLookAroundAssertion()) {
            this.setSubMatcherNegated(t2.asLookAroundAssertion().isNegated());
        }
        if (t2.isBackReference()) {
            this.setIgnoreCaseReference(t2.asBackReference().isIgnoreCaseReference());
            this.setIgnoreCaseReferenceAlternativeMode(t2.asBackReference().isIgnoreCaseReferenceAltMode());
            this.setRecursiveReference(t2.asBackReference().isNestedBackReference());
        }
    }

    private int getAstNodeId() {
        return this.astNodeId;
    }

    public Term getAstNode(RegexAST ast) {
        return (Term)ast.getState(this.astNodeId);
    }

    public byte getKind() {
        return this.kind;
    }

    public boolean isCharacterClass() {
        return this.kind == 1;
    }

    public boolean isSubMatcher() {
        return this.kind == 2;
    }

    public boolean isLookAhead(RegexAST ast) {
        return this.isSubMatcher() && this.getAstNode(ast).isLookAheadAssertion();
    }

    public boolean isLookBehind(RegexAST ast) {
        return this.isSubMatcher() && this.getAstNode(ast).isLookBehindAssertion();
    }

    public boolean isAtomicGroup() {
        return this.isSubMatcher() && !this.isLookAround();
    }

    public boolean isBackReference() {
        return this.kind == 3;
    }

    public boolean isEmptyMatch() {
        return this.kind == 4;
    }

    public CodePointSet getCharSet() {
        assert (this.isCharacterClass());
        return this.charSet;
    }

    public int getSubtreeId() {
        assert (this.isSubMatcher());
        return this.subtreeId;
    }

    public int[] getBackRefNumbers() {
        assert (this.isBackReference());
        return this.referencedGroupNumbers;
    }

    public boolean isLookAround() {
        return this.getFlag((short)16);
    }

    public void setLookAround(boolean value) {
        this.setFlag((short)16, value);
    }

    public boolean isSubMatcherNegated() {
        return this.getFlag((short)32);
    }

    public void setSubMatcherNegated(boolean value) {
        this.setFlag((short)32, value);
    }

    public boolean isIgnoreCaseReference() {
        return this.getFlag((short)128);
    }

    public void setIgnoreCaseReference(boolean value) {
        this.setFlag((short)128, value);
    }

    public boolean isRecursiveReference() {
        return this.getFlag((short)256);
    }

    public void setRecursiveReference(boolean value) {
        this.setFlag((short)256, value);
    }

    public boolean isIgnoreCaseReferenceAlternativeMode() {
        return this.getFlag((short)512);
    }

    public void setIgnoreCaseReferenceAlternativeMode(boolean value) {
        this.setFlag((short)512, value);
    }

    public boolean isDeterministic() {
        return this.getFlag((short)64);
    }

    public void setDeterministic(boolean value) {
        this.setFlag((short)64, value);
    }

    public void initIsDeterministic(CompilationBuffer compilationBuffer) {
        this.setDeterministic(this.calcIsDeterministic(compilationBuffer));
    }

    private boolean calcIsDeterministic(CompilationBuffer compilationBuffer) {
        PureNFATransition[] successors = (PureNFATransition[])this.getSuccessors();
        if (successors.length <= 1) {
            return true;
        }
        if (!successors[0].getTarget().isCharacterClass()) {
            return false;
        }
        CodePointSetAccumulator acc = compilationBuffer.getCodePointSetAccumulator1();
        if (successors.length > 8) {
            acc.addSet(successors[0].getTarget().getCharSet());
        }
        for (int i2 = 1; i2 < successors.length; ++i2) {
            PureNFAState target = successors[i2].getTarget();
            if (!target.isCharacterClass()) {
                return false;
            }
            if (successors.length <= 8) {
                for (int j2 = 0; j2 < i2; ++j2) {
                    if (!successors[j2].getTarget().getCharSet().intersects(target.getCharSet())) continue;
                    return false;
                }
                continue;
            }
            if (target.getCharSet().intersects(acc.get())) {
                return false;
            }
            acc.addSet(target.getCharSet());
        }
        return true;
    }

    protected PureNFATransition[] createTransitionsArray(int length) {
        return new PureNFATransition[length];
    }

    public void addLoopBackNext(PureNFATransition transition) {
        AbstractTransition[] newSuccessors = Arrays.copyOf((PureNFATransition[])this.getSuccessors(), ((PureNFATransition[])this.getSuccessors()).length + 1);
        newSuccessors[newSuccessors.length - 1] = transition;
        this.setSuccessors(newSuccessors);
    }

    public void removeLoopBackNext() {
        this.setSuccessors(Arrays.copyOf((PureNFATransition[])this.getSuccessors(), ((PureNFATransition[])this.getSuccessors()).length - 1));
    }

    @Override
    protected boolean hasTransitionToUnAnchoredFinalState(boolean forward) {
        for (PureNFATransition t2 : (PureNFATransition[])this.getSuccessors(forward)) {
            if (!((PureNFAState)t2.getTarget(forward)).isUnAnchoredFinalState(forward)) continue;
            return true;
        }
        return false;
    }

    private static byte getKind(Term t2) {
        if (t2.isCharacterClass()) {
            return 1;
        }
        if (t2.isMatchFound() || t2.isPositionAssertion()) {
            return 0;
        }
        if (t2.isSubtreeRoot()) {
            return 2;
        }
        if (t2.isBackReference()) {
            return 3;
        }
        if (t2.isGroup()) {
            if (t2.getParent().isSubtreeRoot()) {
                return 0;
            }
            return 4;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public boolean canMatchZeroWidth() {
        return this.isSubMatcher() || this.isBackReference() || this.isEmptyMatch();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.getId() + " " + this.toStringIntl();
    }

    @CompilerDirectives.TruffleBoundary
    private String toStringIntl() {
        switch (this.getKind()) {
            case 0: {
                if (this.isUnAnchoredInitialState()) {
                    return "I";
                }
                if (this.isAnchoredInitialState()) {
                    return "^I";
                }
                if (this.isUnAnchoredFinalState()) {
                    return "F";
                }
                if (this.isAnchoredFinalState()) {
                    return "F$";
                }
                return "Dummy Initial State";
            }
            case 1: {
                return this.charSet.toString();
            }
            case 2: {
                return "?=" + this.getSubtreeId();
            }
            case 3: {
                if (this.referencedGroupNumbers.length == 1) {
                    return "\\" + this.referencedGroupNumbers[0];
                }
                StringBuilder sb = new StringBuilder();
                sb.append("\\k<");
                sb.append(this.referencedGroupNumbers[0]);
                for (int i2 = 1; i2 < this.referencedGroupNumbers.length; ++i2) {
                    sb.append(",");
                    sb.append(this.referencedGroupNumbers[i2]);
                }
                sb.append(">");
                return sb.toString();
            }
            case 4: {
                return "EMPTY";
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson(RegexAST ast) {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", Json.array(new int[]{this.getAstNodeId()})), Json.prop("sourceSections", RegexAST.sourceSectionsToJson(ast.getSourceSections(this.getAstNode(ast)))), Json.prop("matcherBuilder", this.isCharacterClass() ? Json.val(this.charSet.toString()) : Json.nullValue()), Json.prop("subMatcher", this.isSubMatcher() ? Json.val(this.getSubtreeId()) : Json.nullValue()), Json.prop("backReference", this.isBackReference() ? Json.array(Arrays.stream(this.getBackRefNumbers()).mapToObj(x2 -> Json.val(x2))) : Json.nullValue()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("unAnchoredFinalState", this.isUnAnchoredFinalState()), Json.prop("transitions", Arrays.stream((PureNFATransition[])this.getSuccessors()).map(x2 -> Json.val(x2.getId()))));
    }
}

