/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorConstantNodeGen;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.util.Objects;
import java.util.Set;

@NodeInfo(shortName="^")
public abstract class JSBitwiseXorConstantNode
extends JSUnaryNode {
    protected final boolean isInt;
    protected final int rightIntValue;
    protected final BigInt rightBigIntValue;

    protected JSBitwiseXorConstantNode(JavaScriptNode left, Object rightValue) {
        super(left);
        if (rightValue instanceof BigInt) {
            this.isInt = false;
            this.rightIntValue = 0;
            this.rightBigIntValue = (BigInt)rightValue;
        } else {
            this.isInt = true;
            this.rightIntValue = (Integer)rightValue;
            this.rightBigIntValue = null;
        }
    }

    public static JavaScriptNode create(JavaScriptNode left, Object rightValue) {
        return JSBitwiseXorConstantNodeGen.create(left, rightValue);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.create(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
            JSBitwiseXorNode node = JSBitwiseXorNodeGen.create(JSBitwiseXorConstantNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode);
            JSBitwiseXorConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSBitwiseXorConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract Object executeObject(Object var1);

    @Specialization(guards={"isInt"})
    protected int doInteger(int a2) {
        return a2 ^ this.rightIntValue;
    }

    @Specialization(guards={"isInt"})
    protected int doSafeInteger(SafeInteger a2) {
        return this.doInteger(a2.intValue());
    }

    @Specialization(guards={"isInt"})
    protected int doDouble(double a2, @Cached JSToInt32Node leftInt32) {
        return this.doInteger(leftInt32.executeInt(a2));
    }

    @Specialization(guards={"!isInt"})
    protected void doIntegerThrows(int a2) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected void doDoubleThrows(double a2) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"isInt"})
    protected void doBigIntThrows(BigInt a2) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected BigInt doBigInt(BigInt a2) {
        return a2.xor(this.rightBigIntValue);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_CARET;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "isInt"}, replaces={"doInteger", "doSafeInteger", "doDouble", "doBigIntThrows"})
    protected Object doGeneric(Object a2, @Cached @Cached.Shared JSToNumericNode toNumeric, @Cached @Cached.Shared InlinedConditionProfile profileIsBigInt, @Cached(value="makeCopy()") JavaScriptNode innerXorNode) {
        Object numericA = toNumeric.execute(a2);
        if (profileIsBigInt.profile(this, JSRuntime.isBigInt(numericA))) {
            throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
        }
        return ((JSBitwiseXorConstantNode)innerXorNode).executeObject(numericA);
    }

    @NeverDefault
    final JSBitwiseXorConstantNode makeCopy() {
        return JSBitwiseXorConstantNodeGen.create(null, this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!isInt"}, replaces={"doIntegerThrows", "doDoubleThrows", "doBigInt"})
    protected BigInt doGenericBigIntCase(Object a2, @Cached @Cached.Shared JSToNumericNode toNumeric, @Cached @Cached.Shared InlinedConditionProfile profileIsBigInt) {
        Object numericA = toNumeric.execute(a2);
        if (profileIsBigInt.profile(this, JSRuntime.isBigInt(numericA))) {
            return this.doBigInt((BigInt)numericA);
        }
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseXorConstantNodeGen.create(JSBitwiseXorConstantNode.cloneUninitialized(this.getOperand(), materializedTags), this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " ^ " + String.valueOf(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue) + ")";
        }
        return null;
    }
}

