/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.external;

import java.math.BigInteger;

public class DToA {
    private static final int Frac_mask = 1048575;
    private static final int Exp_shift = 20;
    private static final int Exp_msk1 = 0x100000;
    private static final long Frac_maskL = 0xFFFFFFFFFFFFFL;
    private static final int Exp_shiftL = 52;
    private static final long Exp_msk1L = 0x10000000000000L;
    private static final int Bias = 1023;
    private static final int P = 53;
    private static final int Exp_shift1 = 20;
    private static final int Exp_mask = 0x7FF00000;
    private static final int Exp_mask_shifted = 2047;
    private static final int Bndry_mask = 1048575;
    private static final int Log2P = 1;

    private DToA() {
    }

    private static char basedigit(int digit) {
        return (char)(digit >= 10 ? 87 + digit : 48 + digit);
    }

    private static int lo0bits(int y2) {
        int x2 = y2;
        if ((x2 & 7) != 0) {
            if ((x2 & 1) != 0) {
                return 0;
            }
            if ((x2 & 2) != 0) {
                return 1;
            }
            return 2;
        }
        int k2 = 0;
        if ((x2 & 0xFFFF) == 0) {
            k2 = 16;
            x2 >>>= 16;
        }
        if ((x2 & 0xFF) == 0) {
            k2 += 8;
            x2 >>>= 8;
        }
        if ((x2 & 0xF) == 0) {
            k2 += 4;
            x2 >>>= 4;
        }
        if ((x2 & 3) == 0) {
            k2 += 2;
            x2 >>>= 2;
        }
        if ((x2 & 1) == 0) {
            ++k2;
            if (((x2 >>>= 1) & 1) == 0) {
                return 32;
            }
        }
        return k2;
    }

    private static int hi0bits(int xParam) {
        int x2 = xParam;
        int k2 = 0;
        if ((x2 & 0xFFFF0000) == 0) {
            k2 = 16;
            x2 <<= 16;
        }
        if ((x2 & 0xFF000000) == 0) {
            k2 += 8;
            x2 <<= 8;
        }
        if ((x2 & 0xF0000000) == 0) {
            k2 += 4;
            x2 <<= 4;
        }
        if ((x2 & 0xC0000000) == 0) {
            k2 += 2;
            x2 <<= 2;
        }
        if ((x2 & Integer.MIN_VALUE) == 0) {
            ++k2;
            if ((x2 & 0x40000000) == 0) {
                return 32;
            }
        }
        return k2;
    }

    private static void stuffBits(byte[] bits, int offset, int val) {
        bits[offset] = (byte)(val >> 24);
        bits[offset + 1] = (byte)(val >> 16);
        bits[offset + 2] = (byte)(val >> 8);
        bits[offset + 3] = (byte)val;
    }

    private static BigInteger d2b(double d2, int[] e2, int[] bits) {
        int i2;
        int k2;
        byte[] dblBits;
        int y2;
        long dBits = Double.doubleToLongBits(d2);
        int d0 = (int)(dBits >>> 32);
        int d1 = (int)dBits;
        int z2 = d0 & 0xFFFFF;
        int de = (d0 &= Integer.MAX_VALUE) >>> 20;
        if (de != 0) {
            z2 |= 0x100000;
        }
        if ((y2 = d1) != 0) {
            dblBits = new byte[8];
            k2 = DToA.lo0bits(y2);
            y2 >>>= k2;
            if (k2 != 0) {
                DToA.stuffBits(dblBits, 4, y2 | z2 << 32 - k2);
                z2 >>= k2;
            } else {
                DToA.stuffBits(dblBits, 4, y2);
            }
            DToA.stuffBits(dblBits, 0, z2);
            i2 = z2 != 0 ? 2 : 1;
        } else {
            dblBits = new byte[4];
            k2 = DToA.lo0bits(z2);
            DToA.stuffBits(dblBits, 0, z2 >>>= k2);
            k2 += 32;
            i2 = 1;
        }
        if (de != 0) {
            e2[0] = de - 1023 - 52 + k2;
            bits[0] = 53 - k2;
        } else {
            e2[0] = de - 1023 - 52 + 1 + k2;
            bits[0] = 32 * i2 - DToA.hi0bits(z2);
        }
        return new BigInteger(dblBits);
    }

    public static String jsDtobasestr(int base, double dParam) {
        BigInteger mlo;
        String intDigits;
        boolean negative;
        if (2 > base || base > 36) {
            throw new IllegalArgumentException("Bad base: " + base);
        }
        double d2 = dParam;
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        if (Double.isInfinite(d2)) {
            return d2 > 0.0 ? "Infinity" : "-Infinity";
        }
        if (d2 == 0.0) {
            return "0";
        }
        if (d2 >= 0.0) {
            negative = false;
        } else {
            negative = true;
            d2 = -d2;
        }
        double dfloor = Math.floor(d2);
        long lfloor = (long)dfloor;
        if ((double)lfloor == dfloor) {
            intDigits = lfloor == 0L && negative ? "-0" : Long.toString(negative ? -lfloor : lfloor, base);
        } else {
            long floorBits = Double.doubleToLongBits(dfloor);
            int exp = (int)(floorBits >> 52) & 0x7FF;
            long mantissa = exp == 0 ? (floorBits & 0xFFFFFFFFFFFFFL) << 1 : floorBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (negative) {
                mantissa = -mantissa;
            }
            BigInteger x2 = BigInteger.valueOf(mantissa);
            if ((exp -= 1075) > 0) {
                x2 = x2.shiftLeft(exp);
            } else if (exp < 0) {
                x2 = x2.shiftRight(-exp);
            }
            intDigits = x2.toString(base);
        }
        if (d2 == dfloor) {
            return intDigits;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(intDigits).append('.');
        double df = d2 - dfloor;
        long dBits = Double.doubleToLongBits(d2);
        int word0 = (int)(dBits >> 32);
        int word1 = (int)dBits;
        int[] e2 = new int[1];
        int[] bbits = new int[1];
        BigInteger b2 = DToA.d2b(df, e2, bbits);
        int s2 = -(word0 >>> 20 & 0x7FF);
        if (s2 == 0) {
            s2 = -1;
        }
        s2 += 1076;
        BigInteger mhi = mlo = BigInteger.ONE;
        if (word1 == 0 && (word0 & 0xFFFFF) == 0 && (word0 & 0x7FE00000) != 0) {
            ++s2;
            mhi = BigInteger.valueOf(2L);
        }
        b2 = b2.shiftLeft(e2[0] + s2);
        BigInteger s3 = BigInteger.ONE;
        s3 = s3.shiftLeft(s2);
        BigInteger bigBase = BigInteger.valueOf(base);
        boolean done = false;
        do {
            int j1;
            b2 = b2.multiply(bigBase);
            BigInteger[] divResult = b2.divideAndRemainder(s3);
            b2 = divResult[1];
            int digit = divResult[0].intValue();
            if (mlo == mhi) {
                mlo = mhi = mlo.multiply(bigBase);
            } else {
                mlo = mlo.multiply(bigBase);
                mhi = mhi.multiply(bigBase);
            }
            int j2 = b2.compareTo(mlo);
            BigInteger delta = s3.subtract(mhi);
            int n2 = j1 = delta.signum() <= 0 ? 1 : b2.compareTo(delta);
            if (j1 == 0 && (word1 & 1) == 0) {
                if (j2 > 0) {
                    ++digit;
                }
                done = true;
            } else if (j2 < 0 || j2 == 0 && (word1 & 1) == 0) {
                if (j1 > 0 && (j1 = (b2 = b2.shiftLeft(1)).compareTo(s3)) > 0) {
                    ++digit;
                }
                done = true;
            } else if (j1 > 0) {
                ++digit;
                done = true;
            }
            buffer.append(DToA.basedigit(digit));
        } while (!done);
        return buffer.toString();
    }
}

