/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.interop.DynamicScopeWrapper;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=DynamicScopeWrapper.class)
final class DynamicScopeWrapperGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<DynamicObjectLibrary> DYNAMIC_OBJECT_LIBRARY_ = LibraryFactory.resolve(DynamicObjectLibrary.class);

    private DynamicScopeWrapperGen() {
    }

    static {
        LibraryExport.register(DynamicScopeWrapper.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=DynamicScopeWrapper.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, DynamicScopeWrapper.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof DynamicScopeWrapper);
            Uncached uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof DynamicScopeWrapper);
            return new Cached(receiver);
        }

        @GeneratedBy(value=DynamicScopeWrapper.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof DynamicScopeWrapper) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof DynamicScopeWrapper;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DynamicScopeWrapper)receiver).hasMembers();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                return arg0Value.getMembers(arg1Value, DYNAMIC_OBJECT_LIBRARY_.getUncached(arg0Value.scope));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, TruffleString.FromJavaStringNode.getUncached(), DYNAMIC_OBJECT_LIBRARY_.getUncached(arg0Value.scope));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, TruffleString.FromJavaStringNode.getUncached(), DYNAMIC_OBJECT_LIBRARY_.getUncached(arg0Value.scope));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((DynamicScopeWrapper)receiver).isMemberInsertable(member);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                return arg0Value.readMember(arg1Value, TruffleString.FromJavaStringNode.getUncached(), DYNAMIC_OBJECT_LIBRARY_.getUncached(arg0Value.scope), ExportValueNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, TruffleString.FromJavaStringNode.getUncached(), DYNAMIC_OBJECT_LIBRARY_.getUncached(arg0Value.scope));
            }
        }

        @GeneratedBy(value=DynamicScopeWrapper.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicObjectLibrary receiverScopeDynamicObjectLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode;
            @Node.Child
            private ExportValueNode readMemberNode__readMember_exportValueNode_;

            protected Cached(Object receiver) {
                DynamicScopeWrapper castReceiver = (DynamicScopeWrapper)receiver;
                this.receiverScopeDynamicObjectLibrary_ = DYNAMIC_OBJECT_LIBRARY_.create(castReceiver.scope);
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof DynamicScopeWrapper) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof DynamicScopeWrapper)) {
                    return false;
                }
                return this.receiverScopeDynamicObjectLibrary_.accepts(((DynamicScopeWrapper)receiver).scope);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert (receiver instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((DynamicScopeWrapper)receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                return arg0Value.getMembers(arg1Value, access__);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                assert (arg0Value_ instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (fromJavaStringNode_ = this.fromJavaStringNode) != null) {
                    DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                    return arg0Value.isMemberReadable(arg1Value, fromJavaStringNode_, access__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                int state_0 = this.state_0_;
                DynamicObjectLibrary access__ = null;
                TruffleString.FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                if (fromJavaStringNode__shared != null) {
                    fromJavaStringNode_ = fromJavaStringNode__shared;
                } else {
                    fromJavaStringNode_ = this.insert(TruffleString.FromJavaStringNode.create());
                    if (fromJavaStringNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaStringNode == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode = fromJavaStringNode_;
                }
                access__ = this.receiverScopeDynamicObjectLibrary_;
                this.state_0_ = state_0 |= 1;
                return arg0Value.isMemberReadable(arg1Value, fromJavaStringNode_, access__);
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                assert (arg0Value_ instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (fromJavaStringNode_ = this.fromJavaStringNode) != null) {
                    DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                    return arg0Value.isMemberModifiable(arg1Value, fromJavaStringNode_, access__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                int state_0 = this.state_0_;
                DynamicObjectLibrary access__ = null;
                TruffleString.FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                if (fromJavaStringNode__shared != null) {
                    fromJavaStringNode_ = fromJavaStringNode__shared;
                } else {
                    fromJavaStringNode_ = this.insert(TruffleString.FromJavaStringNode.create());
                    if (fromJavaStringNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaStringNode == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode = fromJavaStringNode_;
                }
                access__ = this.receiverScopeDynamicObjectLibrary_;
                this.state_0_ = state_0 |= 2;
                return arg0Value.isMemberModifiable(arg1Value, fromJavaStringNode_, access__);
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (receiver instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((DynamicScopeWrapper)receiver).isMemberInsertable(member);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                ExportValueNode exportValueNode__;
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                assert (arg0Value_ instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (fromJavaStringNode_ = this.fromJavaStringNode) != null && (exportValueNode__ = this.readMemberNode__readMember_exportValueNode_) != null) {
                    DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                    return arg0Value.readMember(arg1Value, fromJavaStringNode_, access__, exportValueNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) throws UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                int state_0 = this.state_0_;
                DynamicObjectLibrary access__ = null;
                TruffleString.FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                if (fromJavaStringNode__shared != null) {
                    fromJavaStringNode_ = fromJavaStringNode__shared;
                } else {
                    fromJavaStringNode_ = this.insert(TruffleString.FromJavaStringNode.create());
                    if (fromJavaStringNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaStringNode == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode = fromJavaStringNode_;
                }
                access__ = this.receiverScopeDynamicObjectLibrary_;
                ExportValueNode exportValueNode__ = this.insert(ExportValueNode.create());
                Objects.requireNonNull(exportValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.readMemberNode__readMember_exportValueNode_ = exportValueNode__;
                this.state_0_ = state_0 |= 4;
                return arg0Value.readMember(arg1Value, fromJavaStringNode_, access__, exportValueNode__);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                assert (arg0Value_ instanceof DynamicScopeWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                DynamicScopeWrapper arg0Value = (DynamicScopeWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (fromJavaStringNode_ = this.fromJavaStringNode) != null) {
                    DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                    arg0Value.writeMember(arg1Value, arg2Value, fromJavaStringNode_, access__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeMemberNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaStringNode_;
                int state_0 = this.state_0_;
                DynamicObjectLibrary access__ = null;
                TruffleString.FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                if (fromJavaStringNode__shared != null) {
                    fromJavaStringNode_ = fromJavaStringNode__shared;
                } else {
                    fromJavaStringNode_ = this.insert(TruffleString.FromJavaStringNode.create());
                    if (fromJavaStringNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaStringNode == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode = fromJavaStringNode_;
                }
                access__ = this.receiverScopeDynamicObjectLibrary_;
                this.state_0_ = state_0 |= 8;
                arg0Value.writeMember(arg1Value, arg2Value, fromJavaStringNode_, access__);
            }
        }
    }
}

