/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.Objects;

public final class PropertyImpl
extends Property {
    private final Object key;
    private final Location location;
    private final int flags;

    PropertyImpl(Object key, Location location, int flags) {
        CompilerAsserts.neverPartOfCompilation();
        this.key = Objects.requireNonNull(key);
        this.location = Objects.requireNonNull(location);
        this.flags = flags;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public Property relocate(Location newLocation) {
        if (!this.getLocation().equals(newLocation)) {
            return new PropertyImpl(this.key, newLocation, this.flags);
        }
        return this;
    }

    @Override
    public Object get(DynamicObject store, Shape shape) {
        return this.getLocation().get(store, shape);
    }

    @Override
    public Object get(DynamicObject store, boolean condition) {
        return this.getLocation().get(store, condition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return !(this.key != other.key && !this.key.equals(other.key) || this.flags != other.flags || this.location != other.location && !this.location.equals(other.location));
    }

    public boolean isSame(Property obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.key.equals(other.key) && this.flags == other.flags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.flags;
        return result;
    }

    public String toString() {
        return "\"" + String.valueOf(this.key) + "\":" + String.valueOf(this.location) + (String)(this.flags == 0 ? "" : "%" + this.flags);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean isHidden() {
        return this.key instanceof HiddenKey;
    }

    public Property copyWithFlags(int newFlags) {
        return new PropertyImpl(this.key, this.location, newFlags);
    }
}

