/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSPathGen;
import com.oracle.truffle.polyglot.enterprise.NativeDirectoryStreamFilter;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;

final class NativeDirectoryStreamFilterGen {
    NativeDirectoryStreamFilterGen() {
    }

    static NativeDirectoryStreamFilter createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeDirectoryStreamFilter createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeDirectoryStreamFilter create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeDirectoryStreamFilterGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeDirectoryStreamFilterGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeDirectoryStreamFilter {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public boolean accept(Path path) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                boolean bl = StartPoint.accept0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), path);
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native boolean accept0(long var0, long var2, Path var4) throws IOException;

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeDirectoryStreamFilterGen_00024StartPoint_accept0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean accept(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JObject jObject) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeDirectoryStreamFilterGen::accept", jNIEnv);
            try {
                boolean bl;
                DirectoryStream.Filter filter = NativeObjectHandles.resolve(l3, DirectoryStream.Filter.class);
                boolean bl2 = bl = filter.accept(jObject.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, jObject) : null);
                jNIMethodScope.close();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

