/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Expression;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.LexicalContext;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.LiteralNode;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.visitor.NodeVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public abstract class TemplateLiteralNode
extends Expression {
    protected TemplateLiteralNode(long token, int finish) {
        super(token, finish);
    }

    protected TemplateLiteralNode(TemplateLiteralNode literalNode) {
        super(literalNode);
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterTemplateLiteralNode(this);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterTemplateLiteralNode(this)) {
            return visitor.leaveTemplateLiteralNode(this);
        }
        return this;
    }

    public static TemplateLiteralNode newTagged(long token, int finish, List<Expression> rawStrings, List<Expression> cookedStrings) {
        return new TaggedTemplateLiteralNode(Token.withDelimiter(token), finish, rawStrings, cookedStrings);
    }

    public static TemplateLiteralNode newUntagged(long token, int finish, List<Expression> expressions) {
        return new UntaggedTemplateLiteralNode(Token.withDelimiter(token), finish, expressions);
    }

    public static class TaggedTemplateLiteralNode
    extends TemplateLiteralNode {
        private final List<Expression> rawStrings;
        private final List<Expression> cookedStrings;

        protected TaggedTemplateLiteralNode(long token, int finish, List<Expression> rawStrings, List<Expression> cookedStrings) {
            super(token, finish);
            this.rawStrings = List.copyOf(rawStrings);
            this.cookedStrings = List.copyOf(cookedStrings);
        }

        public List<Expression> getRawStrings() {
            return this.rawStrings;
        }

        public List<Expression> getCookedStrings() {
            return this.cookedStrings;
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
            if (visitor.enterTemplateLiteralNode(this)) {
                return visitor.leaveTemplateLiteralNode(this);
            }
            return this;
        }

        @Override
        public void toString(StringBuilder sb, boolean printType) {
            sb.append('`');
            for (int i2 = 0; i2 < this.rawStrings.size(); ++i2) {
                Expression expression = this.rawStrings.get(i2);
                if (expression instanceof LiteralNode) {
                    sb.append(((LiteralNode)expression).getString());
                } else {
                    expression.toString(sb, printType);
                }
                if (i2 >= this.rawStrings.size() - 1) continue;
                sb.append("${");
                sb.append(i2);
                sb.append("}");
            }
            sb.append('`');
        }
    }

    public static class UntaggedTemplateLiteralNode
    extends TemplateLiteralNode {
        private final List<Expression> expressions;

        protected UntaggedTemplateLiteralNode(long token, int finish, List<Expression> expressions) {
            super(token, finish);
            assert (UntaggedTemplateLiteralNode.verifyStringLiterals(expressions));
            this.expressions = List.copyOf(expressions);
        }

        public UntaggedTemplateLiteralNode(UntaggedTemplateLiteralNode literalNode, List<Expression> expressions) {
            super(literalNode);
            this.expressions = expressions;
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
            if (visitor.enterTemplateLiteralNode(this)) {
                List<Expression> newExpressions = Node.accept(visitor, this.expressions);
                return visitor.leaveTemplateLiteralNode(this.expressions != newExpressions ? new UntaggedTemplateLiteralNode(this, newExpressions) : this);
            }
            return this;
        }

        @Override
        public void toString(StringBuilder sb, boolean printType) {
            sb.append('`');
            for (int i2 = 0; i2 < this.expressions.size(); ++i2) {
                Expression expression = this.expressions.get(i2);
                if (i2 % 2 == 0) {
                    sb.append(((LiteralNode)expression).getString());
                    continue;
                }
                sb.append("${");
                expression.toString(sb, printType);
                sb.append("}");
            }
            sb.append('`');
        }

        private static boolean verifyStringLiterals(List<Expression> expressions) {
            for (int i2 = 0; i2 < expressions.size(); ++i2) {
                Expression expression;
                if (i2 % 2 != 0 || (expression = expressions.get(i2)) instanceof LiteralNode) continue;
                return false;
            }
            return true;
        }
    }
}

