/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalPartialDurationRecordNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalDurationRecordNode
extends JavaScriptBaseNode {
    protected ToTemporalDurationRecordNode() {
    }

    public abstract JSTemporalDurationRecord execute(Object var1);

    @Specialization
    protected final JSTemporalDurationRecord toTemporalDurationRecord(Object temporalDurationLike, @Cached InlinedConditionProfile isObjectProfile, @Cached ToTemporalPartialDurationRecordNode toTemporalPartialDurationRecord, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode) {
        JSTemporalDurationRecord result;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(temporalDurationLike))) {
            if (temporalDurationLike instanceof JSTemporalDurationObject) {
                JSTemporalDurationObject duration = (JSTemporalDurationObject)temporalDurationLike;
                result = JSTemporalDurationRecord.create(duration);
            } else {
                result = toTemporalPartialDurationRecord.execute(temporalDurationLike, JSTemporalDurationRecord.createZero());
                if (!TemporalUtil.isValidDuration(result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), result.getHours(), result.getMinutes(), result.getSeconds(), result.getMilliseconds(), result.getMicroseconds(), result.getNanoseconds())) {
                    errorBranch.enter(this);
                    throw TemporalErrors.createTypeErrorDurationOutsideRange();
                }
            }
        } else if (temporalDurationLike instanceof TruffleString) {
            TruffleString string = (TruffleString)temporalDurationLike;
            result = JSTemporalDuration.parseTemporalDurationString(string);
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(temporalDurationLike);
        }
        return result;
    }
}

