/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedRuntimeServiceProvider;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

public interface EngineCacheSupport
extends OptimizedRuntimeServiceProvider {
    public void onEngineCreated(EngineData var1);

    public void onEnginePatch(EngineData var1);

    public boolean onEngineClosing(EngineData var1);

    public void onEngineClosed(EngineData var1);

    public boolean isStoreEnabled(OptionValues var1);

    public Object tryLoadingCachedEngine(OptionValues var1, Function<String, TruffleLogger> var2);

    public static EngineCacheSupport get() {
        return OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport();
    }

    public static final class Disabled
    implements EngineCacheSupport {
        @Override
        public void onEngineCreated(EngineData e2) {
        }

        @Override
        public void onEnginePatch(EngineData e2) {
        }

        @Override
        public Object tryLoadingCachedEngine(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
            return null;
        }

        @Override
        public boolean onEngineClosing(EngineData e2) {
            return false;
        }

        @Override
        public boolean isStoreEnabled(OptionValues options) {
            return false;
        }

        @Override
        public void onEngineClosed(EngineData e2) {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public OptionDescriptors getEngineOptions() {
            return OptionDescriptors.EMPTY;
        }
    }
}

