/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.gametest;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;
import org.cyclops.integratedscripting.api.network.IScriptingData;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.gametest.GameTestHelpersIntegratedScripting;

@GameTestHolder(value="integratedscripting")
@PrefixGameTestTemplate(value=false)
public class GameTestsScripts {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testScriptsDisplayScriptConst(GameTestHelper helper) {
        GameTestHelpersIntegratedScripting.NetworkPositions positions = GameTestHelpersIntegratedScripting.createBasicNetwork(helper, POS);
        ScriptingNetworkHelpers.getScriptingData().setScript(positions.diskId(), Path.of("script0.js", new String[0]), "const abc = 3", IScriptingData.ChangeLocation.MEMORY);
        ItemStack variableScript = GameTestHelpersIntegratedScripting.createVariableForScript((Level)helper.getLevel(), positions.diskId(), Path.of("script0.js", new String[0]), "abc");
        Pair partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), (PartPos)positions.displayPanel(), (ItemStack)variableScript);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual((IValue)((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of((int)3)));
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testScriptsDisplayScriptApplied(GameTestHelper helper) {
        GameTestHelpersIntegratedScripting.NetworkPositions positions = GameTestHelpersIntegratedScripting.createBasicNetwork(helper, POS);
        ScriptingNetworkHelpers.getScriptingData().setScript(positions.diskId(), Path.of("script0.js", new String[0]), "function abc(a, b) { return a + b; }", IScriptingData.ChangeLocation.MEMORY);
        ItemStack variableScript = GameTestHelpersIntegratedScripting.createVariableForScript((Level)helper.getLevel(), positions.diskId(), Path.of("script0.js", new String[0]), "abc");
        ItemStack variableConst1 = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.INTEGER, (IValue)ValueTypeInteger.ValueInteger.of((int)3));
        ItemStack variableConst2 = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.INTEGER, (IValue)ValueTypeInteger.ValueInteger.of((int)8));
        positions.variableStore().getInventory().setItem(0, variableScript);
        positions.variableStore().getInventory().setItem(1, variableConst1);
        positions.variableStore().getInventory().setItem(2, variableConst2);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), (IOperator)Operators.OPERATOR_APPLY_2, (int[])new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableScript).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableConst1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableConst2).getId()});
        Pair partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), (PartPos)positions.displayPanel(), (ItemStack)variableAdded);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual((IValue)((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of((int)11)));
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testScriptsDisplayScriptOnItem(GameTestHelper helper) {
        GameTestHelpersIntegratedScripting.NetworkPositions positions = GameTestHelpersIntegratedScripting.createBasicNetwork(helper, POS);
        ScriptingNetworkHelpers.getScriptingData().setScript(positions.diskId(), Path.of("script0.js", new String[0]), "function abc(item) { return item.isStackable() && item.size() >= 16; }", IScriptingData.ChangeLocation.MEMORY);
        ItemStack variableScript = GameTestHelpersIntegratedScripting.createVariableForScript((Level)helper.getLevel(), positions.diskId(), Path.of("script0.js", new String[0]), "abc");
        ItemStack variableConst1 = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.APPLE, 32)));
        positions.variableStore().getInventory().setItem(0, variableScript);
        positions.variableStore().getInventory().setItem(1, variableConst1);
        ItemStack variableApplied = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), (IOperator)Operators.OPERATOR_APPLY, (int[])new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableScript).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableConst1).getId()});
        Pair partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), (PartPos)positions.displayPanel(), (ItemStack)variableApplied);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual((IValue)((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true)));
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testScriptsDisplayScriptInfiniteLoop(GameTestHelper helper) {
        GameTestHelpersIntegratedScripting.NetworkPositions positions = GameTestHelpersIntegratedScripting.createBasicNetwork(helper, POS);
        ScriptingNetworkHelpers.getScriptingData().setScript(positions.diskId(), Path.of("script0.js", new String[0]), "function oops() {\n    while (true) {}\n}", IScriptingData.ChangeLocation.MEMORY);
        ItemStack variableScript = GameTestHelpersIntegratedScripting.createVariableForScript((Level)helper.getLevel(), positions.diskId(), Path.of("script0.js", new String[0]), "abc");
        positions.variableStore().getInventory().setItem(0, variableScript);
        ItemStack variableAdded = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), (IOperator)Operators.OPERATOR_APPLY_0, (int[])new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), (ItemStack)variableScript).getId()});
        Pair partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), (PartPos)positions.displayPanel(), (ItemStack)variableAdded);
        helper.succeedWhen(() -> helper.assertValueEqual((Object)((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"script.integratedscripting.error.member_not_in_network", (Object[])new Object[]{positions.diskId(), "abc", "script0.js"}), Component.translatable((String)"script.integratedscripting.error.member_not_in_network", (Object[])new Object[]{positions.diskId(), "abc", "script0.js"})}), "Display panel errors do not match"));
    }
}

