/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.sort.SortComparator;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ForEachIndexCallNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.JSArrayDeleteRangeNode;
import com.oracle.truffle.js.nodes.array.JSArrayFirstElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayLastElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayToDenseObjectArrayNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.array.JSSetLengthNode;
import com.oracle.truffle.js.nodes.array.TestArrayNode;
import com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.Comparator;

public final class ArrayPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayPrototypeBuiltins();

    protected ArrayPrototypeBuiltins() {
        super(JSArray.PROTOTYPE_NAME, ArrayPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ArrayPrototypeBuiltinsFactory.JSArrayPushNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 1: {
                return ArrayPrototypeBuiltinsFactory.JSArrayPopNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return ArrayPrototypeBuiltinsFactory.JSArraySliceNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return ArrayPrototypeBuiltinsFactory.JSArrayShiftNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 4: {
                return ArrayPrototypeBuiltinsFactory.JSArrayUnshiftNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 5: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToStringNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 6: {
                return ArrayPrototypeBuiltinsFactory.JSArrayConcatNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 7: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 8: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 9: {
                return ArrayPrototypeBuiltinsFactory.JSArrayJoinNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToLocaleStringNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 11: {
                return ArrayPrototypeBuiltinsFactory.JSArraySpliceNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 12: {
                return ArrayPrototypeBuiltinsFactory.JSArrayEveryNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFilterNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 14: {
                return ArrayPrototypeBuiltinsFactory.JSArrayForEachNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 15: {
                return ArrayPrototypeBuiltinsFactory.JSArraySomeNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 16: {
                return ArrayPrototypeBuiltinsFactory.JSArrayMapNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 17: {
                return ArrayPrototypeBuiltinsFactory.JSArraySortNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 19: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 20: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReverseNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 21: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 22: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 32: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 33: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 23: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFillNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 24: {
                return ArrayPrototypeBuiltinsFactory.JSArrayCopyWithinNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 25: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 1, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 26: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 2, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 27: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 3, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 28: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIncludesNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 30: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFlatMapNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 29: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFlatNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 31: {
                return ArrayPrototypeBuiltinsFactory.JSArrayAtNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 34: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToReversedNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 35: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToSortedNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 36: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToSplicedNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 37: {
                return ArrayPrototypeBuiltinsFactory.JSArrayWithNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayPrototype implements BuiltinEnum<ArrayPrototype>
    {
        push(1),
        pop(0),
        slice(2),
        shift(0),
        unshift(1),
        toString(0),
        concat(1),
        indexOf(1),
        lastIndexOf(1),
        join(1),
        toLocaleString(0),
        splice(2),
        every(1),
        filter(1),
        forEach(1),
        some(1),
        map(1),
        sort(1),
        reduce(1),
        reduceRight(1),
        reverse(0),
        find(1),
        findIndex(1),
        fill(1),
        copyWithin(2),
        keys(0),
        values(0),
        entries(0),
        includes(1),
        flat(0),
        flatMap(1),
        at(1),
        findLast(1),
        findLastIndex(1),
        toReversed(0),
        toSorted(1),
        toSpliced(2),
        with(2);

        private final int length;

        private ArrayPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 21, 22, 23, 24, 25, 26, 27 -> 6;
                case 28 -> 7;
                case 29, 30 -> 10;
                case 31 -> 13;
                case 32, 33, 34, 35, 36, 37 -> 14;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    public static abstract class JSArrayPushNode
    extends JSArrayOperation {
        public JSArrayPushNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 0"})
        protected Object pushArrayNone(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.setLength((Object)thisObject, len);
            if (len >= Integer.MAX_VALUE) {
                return (double)len;
            }
            return (int)len;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 1"}, rewriteOn={SlowPathException.class})
        protected int pushArraySingle(JSDynamicObject thisObject, Object[] args) throws SlowPathException {
            long len = this.getLength(thisObject);
            if (len >= Integer.MAX_VALUE) {
                throw JSNodeUtil.slowPathException();
            }
            int iLen = (int)len;
            this.write((Object)thisObject, iLen, args[0]);
            int newLength = iLen + 1;
            this.setLength((Object)thisObject, newLength);
            return newLength;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 1"})
        protected double pushArraySingleLong(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.checkLength(args, len);
            this.write((Object)thisObject, len, args[0]);
            long newLength = len + 1L;
            this.setLength((Object)thisObject, newLength);
            return newLength;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length >= 2"}, rewriteOn={SlowPathException.class})
        protected int pushArrayAll(JSDynamicObject thisObject, Object[] args) throws SlowPathException {
            long len = this.getLength(thisObject);
            if (len + (long)args.length >= Integer.MAX_VALUE) {
                throw JSNodeUtil.slowPathException();
            }
            int ilen = (int)len;
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.write((Object)thisObject, ilen + i2, args[i2]);
            }
            this.setLength((Object)thisObject, ilen + args.length);
            return ilen + args.length;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length >= 2"})
        protected double pushArrayAllLong(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.checkLength(args, len);
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.write((Object)thisObject, len + (long)i2, args[i2]);
            }
            this.setLength((Object)thisObject, len + (long)args.length);
            return (double)len + (double)args.length;
        }

        @Specialization(guards={"!isJSArray(thisObject)"})
        protected double pushProperty(Object thisObject, Object[] args) {
            Object thisObj = this.toObject(thisObject);
            long len = this.getLength(thisObj);
            this.checkLength(args, len);
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.write(thisObj, len + (long)i2, args[i2]);
            }
            long newLength = len + (long)args.length;
            this.setLength(thisObj, newLength);
            return newLength;
        }

        private void checkLength(Object[] args, long len) {
            if ((double)(len + (long)args.length) > JSRuntime.MAX_SAFE_INTEGER) {
                this.errorBranch.enter();
                JSArrayPushNode.throwLengthError();
            }
        }
    }

    public static abstract class JSArrayPopNode
    extends JSArrayOperation {
        public JSArrayPopNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object popGeneric(Object thisObj, @Cached(value="create(getContext())") DeleteAndSetLengthNode deleteAndSetLength, @Cached InlinedConditionProfile lengthIsZero) {
            Object thisObject = this.toObject(thisObj);
            long length = this.getLength(thisObject);
            if (lengthIsZero.profile(this, length > 0L)) {
                long newLength = length - 1L;
                Object result = this.read(thisObject, newLength);
                deleteAndSetLength.executeVoid(thisObject, newLength);
                return result;
            }
            assert (length == 0L);
            this.setLength(thisObject, 0);
            return Undefined.instance;
        }
    }

    public static abstract class JSArraySliceNode
    extends ArrayForEachIndexCallOperation {
        public JSArraySliceNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object sliceGeneric(Object thisObj, Object begin, Object end, @Cached JSToIntegerAsLongNode toIntegerAsLong, @Cached InlinedConditionProfile sizeIsZero, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2) {
            Object thisArrayObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisArrayObj);
            long startPos = begin != Undefined.instance ? JSRuntime.getOffset(toIntegerAsLong.executeLong(begin), len, (Node)this, offsetProfile1) : 0L;
            long endPos = end == Undefined.instance ? len : JSRuntime.getOffset(toIntegerAsLong.executeLong(end), len, (Node)this, offsetProfile2);
            long size = startPos <= endPos ? endPos - startPos : 0L;
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisArrayObj, size);
            if (sizeIsZero.profile(this, size > 0L)) {
                if (this.isTypedArrayImplementation) {
                    this.checkOutOfBounds((JSTypedArrayObject)thisObj);
                    endPos = Math.min(endPos, this.getLength(thisArrayObj));
                }
                this.forEachIndexCall(thisArrayObj, null, startPos, startPos, endPos, resultArray);
            }
            if (!this.isTypedArrayImplementation) {
                this.setLength(resultArray, size);
            }
            return resultArray;
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private WriteElementNode writeOwnNode;
                {
                    this.writeOwnNode = WriteElementNode.create(this.getContext(), true, true);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    long startIndex = (Long)callbackResult;
                    this.writeOwnNode.executeWithTargetAndIndexAndValue(currentResult, index - startIndex, value);
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }

        @Override
        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return null;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSArrayShiftNode
    extends JSArrayOperation {
        public JSArrayShiftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean isSparseArray(JSDynamicObject thisObj) {
            return JSAbstractArray.arrayGetArrayType(thisObj) instanceof SparseArray;
        }

        protected static boolean isArrayWithoutHolesAndNotSealed(JSDynamicObject thisObj, IsArrayNode isArrayNode, TestArrayNode hasHolesNode, TestArrayNode isSealedNode) {
            boolean isArray = isArrayNode.execute(thisObj);
            return isArray && !hasHolesNode.executeBoolean(thisObj) && !isSealedNode.executeBoolean(thisObj);
        }

        @Specialization(guards={"isArrayWithoutHolesAndNotSealed(thisObj, isArrayNode, hasHolesNode, isSealedNode)"})
        protected Object shiftWithoutHoles(JSDynamicObject thisObj, @Cached.Shared @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared @Cached(value="createHasHolesOrUnused()") TestArrayNode hasHolesNode, @Cached.Shared @Cached(value="createIsSealed()") TestArrayNode isSealedNode, @Cached InlinedExactClassProfile arrayTypeProfile, @Cached.Shared @Cached InlinedConditionProfile lengthIsZero, @Cached @Cached.Exclusive InlinedConditionProfile lengthLargerOne) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len == 0L)) {
                this.setLength((Object)thisObj, 0);
                return Undefined.instance;
            }
            Object firstElement = this.read((Object)thisObj, 0);
            if (lengthLargerOne.profile(this, len > 1L)) {
                ScriptArray array = arrayTypeProfile.profile(this, JSAbstractArray.arrayGetArrayType(thisObj));
                JSAbstractArray.arraySetArrayType(thisObj, array.shiftRange(thisObj, 1L));
            }
            this.setLength((Object)thisObj, len - 1L);
            return firstElement;
        }

        protected static boolean isArrayWithHolesOrSealed(JSDynamicObject thisObj, IsArrayNode isArrayNode, TestArrayNode hasHolesNode, TestArrayNode isSealedNode) {
            boolean isArray = isArrayNode.execute(thisObj);
            return isArray && (hasHolesNode.executeBoolean(thisObj) || isSealedNode.executeBoolean(thisObj)) && !JSArrayShiftNode.isSparseArray(thisObj);
        }

        @Specialization(guards={"isArrayWithHolesOrSealed(thisObj, isArrayNode, hasHolesNode, isSealedNode)"})
        protected Object shiftWithHoles(JSDynamicObject thisObj, @Cached.Shared @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared @Cached(value="createHasHolesOrUnused()") TestArrayNode hasHolesNode, @Cached.Shared @Cached(value="createIsSealed()") TestArrayNode isSealedNode, @Cached.Shared @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached.Shared @Cached InlinedConditionProfile lengthIsZero) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len > 0L)) {
                Object firstElement = this.read((Object)thisObj, 0);
                for (long i2 = 0L; i2 < len - 1L; ++i2) {
                    if (this.hasProperty(thisObj, i2 + 1L)) {
                        this.write((Object)thisObj, i2, this.read((Object)thisObj, i2 + 1L));
                        continue;
                    }
                    deletePropertyNode.executeEvaluated(thisObj, i2);
                }
                deletePropertyNode.executeEvaluated(thisObj, len - 1L);
                this.setLength((Object)thisObj, len - 1L);
                this.reportLoopCount(len - 1L);
                return firstElement;
            }
            this.setLength((Object)thisObj, 0);
            return Undefined.instance;
        }

        @Specialization(guards={"isArrayNode.execute(thisObj)", "isSparseArray(thisObj)"})
        protected Object shiftSparse(JSDynamicObject thisObj, @Cached.Shared @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached.Shared @Cached InlinedConditionProfile lengthIsZero, @Cached(value="create(getContext())") JSArrayFirstElementIndexNode firstElementIndexNode, @Cached(value="create(getContext())") JSArrayLastElementIndexNode lastElementIndexNode) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len > 0L)) {
                Object firstElement = this.read((Object)thisObj, 0);
                long count = 0L;
                long i2 = firstElementIndexNode.executeLong(thisObj, len);
                while (i2 <= lastElementIndexNode.executeLong(thisObj, len)) {
                    if (i2 > 0L) {
                        this.write((Object)thisObj, i2 - 1L, this.read((Object)thisObj, i2));
                    }
                    if (!this.hasProperty(thisObj, i2 + 1L)) {
                        deletePropertyNode.executeEvaluated(thisObj, i2);
                    }
                    ++count;
                    i2 = this.nextElementIndex(thisObj, i2, len);
                }
                this.setLength((Object)thisObj, len - 1L);
                this.reportLoopCount(count);
                return firstElement;
            }
            this.setLength((Object)thisObj, 0);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSArray(thisObj)", "!isForeignObject(thisObj)"})
        protected Object shiftGeneric(Object thisObj, @Cached.Shared @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached.Shared @Cached InlinedConditionProfile lengthIsZero) {
            Object thisJSObj = this.toObject(thisObj);
            long len = this.getLength(thisJSObj);
            if (lengthIsZero.profile(this, len == 0L)) {
                this.setLength(thisJSObj, 0);
                return Undefined.instance;
            }
            Object firstObj = this.read(thisJSObj, 0);
            for (long i2 = 1L; i2 < len; ++i2) {
                if (this.hasProperty(thisJSObj, i2)) {
                    this.write(thisJSObj, i2 - 1L, this.read(thisObj, i2));
                    continue;
                }
                deletePropertyNode.executeEvaluated(thisJSObj, i2 - 1L);
            }
            deletePropertyNode.executeEvaluated(thisJSObj, len - 1L);
            this.setLength(thisJSObj, len - 1L);
            this.reportLoopCount(len);
            return firstObj;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignObject(thisObj)"})
        protected Object shiftForeign(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary arrays, @Cached.Shared @Cached InlinedConditionProfile lengthIsZero) {
            long len = JSInteropUtil.getArraySize(thisObj, arrays, this);
            if (lengthIsZero.profile(this, len == 0L)) {
                return Undefined.instance;
            }
            try {
                Object firstObj = arrays.readArrayElement(thisObj, 0L);
                for (long i2 = 1L; i2 < len; ++i2) {
                    Object val = arrays.readArrayElement(thisObj, i2);
                    arrays.writeArrayElement(thisObj, i2 - 1L, val);
                }
                arrays.removeArrayElement(thisObj, len - 1L);
                this.reportLoopCount(len);
                return firstObj;
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e2) {
                throw Errors.createTypeErrorInteropException(thisObj, e2, "shift", this);
            }
        }
    }

    public static abstract class JSArrayUnshiftNode
    extends JSArrayOperation {
        @Node.Child
        protected IsArrayNode isArrayNode = IsArrayNode.createIsArray();
        @Node.Child
        protected TestArrayNode hasHolesNode = TestArrayNode.createHasHolesOrUnused();

        public JSArrayUnshiftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isFastPath(Object thisObj) {
            boolean isArray = this.isArrayNode.execute(thisObj);
            return isArray && !this.hasHolesNode.executeBoolean((JSDynamicObject)thisObj);
        }

        private long unshiftHoleless(JSDynamicObject thisObj, Object[] args) {
            long len = this.getLength(thisObj);
            if (this.getContext().getEcmaScriptVersion() <= 5 || args.length > 0) {
                for (long l2 = len - 1L; l2 >= 0L; --l2) {
                    this.write((Object)thisObj, l2 + (long)args.length, this.read((Object)thisObj, l2));
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    this.write((Object)thisObj, i2, args[i2]);
                }
                this.reportLoopCount(len + (long)args.length);
            }
            long newLen = len + (long)args.length;
            this.setLength((Object)thisObj, newLen);
            return newLen;
        }

        @Specialization(guards={"isFastPath(thisObj)"}, rewriteOn={UnexpectedResultException.class})
        protected int unshiftInt(JSDynamicObject thisObj, Object[] args) throws UnexpectedResultException {
            long newLen = this.unshiftHoleless(thisObj, args);
            if (JSRuntime.longIsRepresentableAsInt(newLen)) {
                return (int)newLen;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(newLen);
        }

        @Specialization(guards={"isFastPath(thisObj)"}, replaces={"unshiftInt"})
        protected double unshiftDouble(JSDynamicObject thisObj, Object[] args) {
            return this.unshiftHoleless(thisObj, args);
        }

        @Specialization(guards={"!isFastPath(thisObjParam)"})
        protected double unshiftHoles(Object thisObjParam, Object[] args, @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached(value="create(getContext())") JSArrayLastElementIndexNode lastElementIndexNode, @Cached(value="create(getContext())") JSArrayFirstElementIndexNode firstElementIndexNode) {
            Object thisObj = this.toObject(thisObjParam);
            long len = this.getLength(thisObj);
            if (this.getContext().getEcmaScriptVersion() <= 5 || args.length > 0) {
                if ((long)args.length + len > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                    this.errorBranch.enter();
                    JSArrayUnshiftNode.throwLengthError();
                }
                long lastIdx = lastElementIndexNode.executeLong(thisObj, len);
                long firstIdx = firstElementIndexNode.executeLong(thisObj, len);
                long count = 0L;
                long i2 = lastIdx;
                while (i2 >= firstIdx) {
                    ++count;
                    if (this.hasProperty(thisObj, i2)) {
                        this.write(thisObj, i2 + (long)args.length, this.read(thisObj, i2));
                        if (args.length > 0 && i2 >= (long)args.length && !this.hasProperty(thisObj, i2 - (long)args.length)) {
                            deletePropertyNode.executeEvaluated(thisObj, i2);
                        }
                    }
                    i2 = this.previousElementIndex(thisObj, i2);
                }
                for (int i3 = 0; i3 < args.length; ++i3) {
                    this.write(thisObj, i3, args[i3]);
                }
                this.reportLoopCount(count + (long)args.length);
            }
            long newLen = len + (long)args.length;
            this.setLength(thisObj, newLen);
            return newLen;
        }
    }

    public static abstract class JSArrayToStringNode
    extends BasicArrayOperation {
        @Node.Child
        private PropertyNode joinPropertyNode;
        @Node.Child
        private PropertyNode toStringPropertyNode;
        @Node.Child
        private JSFunctionCallNode callJoinNode;
        @Node.Child
        private JSFunctionCallNode callToStringNode;
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;
        @Node.Child
        private InteropLibrary interopLibrary;
        @Node.Child
        private ImportValueNode importValueNode;
        @CompilerDirectives.CompilationFinal
        private Class<?> hostLanguageClass;

        public JSArrayToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.joinPropertyNode = PropertyNode.createProperty(context, null, Strings.JOIN);
        }

        private Object getJoinProperty(Object target, Object receiver) {
            return this.joinPropertyNode.executeWithTarget(target, receiver);
        }

        private Object getToStringProperty(Object target) {
            if (this.toStringPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringPropertyNode = this.insert(PropertyNode.createProperty(this.getContext(), null, Strings.TO_STRING));
            }
            return this.toStringPropertyNode.executeWithTarget(target);
        }

        private Object callJoin(Object target, Object function) {
            if (this.callJoinNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callJoinNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callJoinNode.executeCall(JSArguments.createZeroArg(target, function));
        }

        private Object callToString(Object target, Object function) {
            if (this.callToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callToStringNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callToStringNode.executeCall(JSArguments.createZeroArg(target, function));
        }

        private JSDynamicObject getForeignObjectPrototype(Object truffleObject) {
            assert (JSRuntime.isForeignObject(truffleObject));
            if (this.foreignObjectPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignObjectPrototypeNode = this.insert(ForeignObjectPrototypeNode.create());
            }
            return this.foreignObjectPrototypeNode.execute(truffleObject);
        }

        private InteropLibrary getInterop() {
            if (this.interopLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            return this.interopLibrary;
        }

        private Object importValue(Object value) {
            if (this.importValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.importValueNode = this.insert(ImportValueNode.create());
            }
            return this.importValueNode.executeWithTarget(value);
        }

        private Object toStringForeign(Object arrayObj) {
            Object join;
            InteropLibrary interop = this.getInterop();
            if (this.shouldTryOwnJoin(arrayObj) && interop.isMemberInvocable(arrayObj, Strings.JOIN_JLS)) {
                Object result;
                block8: {
                    try {
                        try {
                            result = interop.invokeMember(arrayObj, Strings.JOIN_JLS, new Object[0]);
                        }
                        catch (AbstractTruffleException e2) {
                            if (InteropLibrary.getUncached(e2).getExceptionType(e2) == ExceptionType.RUNTIME_ERROR) {
                                result = null;
                                break block8;
                            }
                            throw e2;
                        }
                    }
                    catch (InteropException e3) {
                        result = null;
                    }
                }
                if (result != null) {
                    return this.importValue(result);
                }
            }
            if (this.isCallable(join = this.getJoinProperty(this.getForeignObjectPrototype(arrayObj), arrayObj))) {
                return this.callJoin(arrayObj, join);
            }
            Object toString = this.getToStringProperty(this.getRealm().getObjectPrototype());
            return this.callToString(arrayObj, toString);
        }

        private boolean shouldTryOwnJoin(Object arrayObj) {
            InteropLibrary interop = this.getInterop();
            try {
                return !interop.hasLanguage(arrayObj) || interop.getLanguage(arrayObj) == this.getHostLanguageClass();
            }
            catch (UnsupportedMessageException umex) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private Class<?> getHostLanguageClass() {
            if (this.hostLanguageClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                try {
                    this.hostLanguageClass = InteropLibrary.getUncached().getLanguage(this.getRealm().getEnv().asGuestValue(new Object()));
                }
                catch (UnsupportedMessageException umex) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                catch (UnsupportedOperationException uoex) {
                    this.hostLanguageClass = Object.class;
                }
            }
            return this.hostLanguageClass;
        }

        @Specialization
        protected Object toString(Object thisObj, @Cached InlinedConditionProfile isJSObjectProfile) {
            Object arrayObj = this.toObject(thisObj);
            if (isJSObjectProfile.profile(this, JSObject.isJSObject(arrayObj))) {
                Object join = this.getJoinProperty(arrayObj, arrayObj);
                if (this.isCallable(join)) {
                    return this.callJoin(arrayObj, join);
                }
                return JSObject.defaultToString((JSDynamicObject)arrayObj);
            }
            return this.toStringForeign(arrayObj);
        }
    }

    public static abstract class JSArrayConcatNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode;
        @Node.Child
        private JSArrayFirstElementIndexNode firstElementIndexNode;
        @Node.Child
        private JSArrayLastElementIndexNode lastElementIndexNode;
        @Node.Child
        private PropertyGetNode getSpreadableNode;
        @Node.Child
        private JSIsArrayNode isArrayNode;
        private final ConditionProfile isFirstSpreadable = ConditionProfile.create();
        private final ConditionProfile hasFirstElements = ConditionProfile.create();
        private final ConditionProfile isSecondSpreadable = ConditionProfile.create();
        private final ConditionProfile hasSecondElements = ConditionProfile.create();
        private final ConditionProfile lengthErrorProfile = ConditionProfile.create();
        private final ConditionProfile hasMultipleArgs = ConditionProfile.create();
        private final ConditionProfile hasOneArg = ConditionProfile.create();
        private final ConditionProfile optimizationsObservable = ConditionProfile.create();
        private final ConditionProfile hasFirstOneElement = ConditionProfile.create();
        private final ConditionProfile hasSecondOneElement = ConditionProfile.create();

        public JSArrayConcatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean toBoolean(Object target) {
            if (this.toBooleanNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBooleanNode = this.insert(JSToBooleanNode.create());
            }
            return this.toBooleanNode.executeBoolean(target);
        }

        @Specialization
        protected Object concat(Object thisObj, Object[] args) {
            Object thisJSObj = this.toObject(thisObj);
            Object retObj = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            long n2 = this.concatElementIntl(retObj, thisJSObj, 0L, this.isFirstSpreadable, this.hasFirstElements, this.hasFirstOneElement);
            long resultLen = this.concatIntl(retObj, n2, args);
            this.setLength(retObj, resultLen);
            return retObj;
        }

        private long concatIntl(Object retObj, long initialLength, Object[] args) {
            long n2 = initialLength;
            if (this.hasOneArg.profile(args.length == 1)) {
                n2 = this.concatElementIntl(retObj, args[0], n2, this.isSecondSpreadable, this.hasSecondElements, this.hasSecondOneElement);
            } else if (this.hasMultipleArgs.profile(args.length > 1)) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    n2 = this.concatElementIntl(retObj, args[i2], n2, this.isSecondSpreadable, this.hasSecondElements, this.hasSecondOneElement);
                }
            }
            return n2;
        }

        private long concatElementIntl(Object retObj, Object el, long n2, ConditionProfile isSpreadable, ConditionProfile hasElements, ConditionProfile hasOneElement) {
            if (isSpreadable.profile(this.isConcatSpreadable(el))) {
                long len2 = this.getLength(el);
                if (hasElements.profile(len2 > 0L)) {
                    return this.concatSpreadable(retObj, n2, el, len2, hasOneElement);
                }
            } else {
                if (this.lengthErrorProfile.profile((double)n2 > JSRuntime.MAX_SAFE_INTEGER)) {
                    this.errorBranch.enter();
                    JSArrayConcatNode.throwLengthError();
                }
                this.writeOwn(retObj, n2, el);
                return n2 + 1L;
            }
            return n2;
        }

        private long concatSpreadable(Object retObj, long n2, Object elObj, long len2, ConditionProfile hasOneElement) {
            block4: {
                block5: {
                    block3: {
                        if (this.lengthErrorProfile.profile((double)(n2 + len2) > JSRuntime.MAX_SAFE_INTEGER)) {
                            this.errorBranch.enter();
                            JSArrayConcatNode.throwLengthError();
                        }
                        if (!this.optimizationsObservable.profile(JSProxy.isJSProxy(elObj) || !JSDynamicObject.isJSDynamicObject(elObj))) break block3;
                        for (long k2 = 0L; k2 < len2; ++k2) {
                            if (!this.hasProperty(elObj, k2)) continue;
                            this.writeOwn(retObj, n2 + k2, this.read(elObj, k2));
                        }
                        break block4;
                    }
                    if (!hasOneElement.profile(len2 == 1L)) break block5;
                    if (!this.hasProperty(elObj, 0L)) break block4;
                    this.writeOwn(retObj, n2, this.read(elObj, 0));
                    break block4;
                }
                long k3 = this.firstElementIndex((JSDynamicObject)elObj, len2);
                long lastI = this.lastElementIndex((JSDynamicObject)elObj, len2);
                while (k3 <= lastI) {
                    this.writeOwn(retObj, n2 + k3, this.read(elObj, k3));
                    k3 = this.nextElementIndex(elObj, k3, len2);
                }
            }
            return n2 + len2;
        }

        private boolean isConcatSpreadable(Object el) {
            JSObject obj;
            Object spreadable;
            if (el instanceof JSObject && (spreadable = this.getSpreadableProperty(obj = (JSObject)el)) != Undefined.instance) {
                return this.toBoolean(spreadable);
            }
            return this.isArray(el);
        }

        private boolean isArray(Object object) {
            if (this.isArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isArrayNode = this.insert(JSIsArrayNode.createIsArrayLike());
            }
            return this.isArrayNode.execute(object);
        }

        private Object getSpreadableProperty(Object obj) {
            if (this.getSpreadableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSpreadableNode = this.insert(PropertyGetNode.create(Symbol.SYMBOL_IS_CONCAT_SPREADABLE, false, this.getContext()));
            }
            return this.getSpreadableNode.getValue(obj);
        }

        private long firstElementIndex(JSDynamicObject target, long length) {
            if (this.firstElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.firstElementIndexNode = this.insert(JSArrayFirstElementIndexNode.create(this.getContext()));
            }
            return this.firstElementIndexNode.executeLong(target, length);
        }

        private long lastElementIndex(JSDynamicObject target, long length) {
            if (this.lastElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lastElementIndexNode = this.insert(JSArrayLastElementIndexNode.create(this.getContext()));
            }
            return this.lastElementIndexNode.executeLong(target, length);
        }
    }

    public static abstract class JSArrayIndexOfNode
    extends ArrayForEachIndexCallOperation {
        private final boolean isForward;

        public JSArrayIndexOfNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isForward) {
            super(context, builtin, isTypedArrayImplementation);
            this.isForward = isForward;
        }

        @Specialization
        protected Object indexOf(Object thisObj, Object[] args, @Cached InlinedBranchProfile arrayWithContentBranch, @Cached JSToIntegerAsLongNode toInteger) {
            long fromIndexValue;
            Object thisJSObject = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisJSObject);
            if (len == 0L) {
                return -1;
            }
            arrayWithContentBranch.enter(this);
            Object searchElement = JSRuntime.getArgOrUndefined(args, 0);
            Object fromIndex = JSRuntime.getArgOrUndefined(args, 1);
            long l2 = fromIndexValue = this.isForward() ? JSArrayIndexOfNode.calcFromIndexForward(args, len, fromIndex, toInteger) : JSArrayIndexOfNode.calcFromIndexBackward(args, len, fromIndex, toInteger);
            if (fromIndexValue < 0L) {
                return -1;
            }
            return this.forEachIndexCall(thisJSObject, Undefined.instance, searchElement, fromIndexValue, len, -1);
        }

        private static long calcFromIndexForward(Object[] args, long len, Object fromIndex, JSToIntegerAsLongNode toInteger) {
            if (args.length <= 1) {
                return 0L;
            }
            long fromIndexValue = toInteger.executeLong(fromIndex);
            if (fromIndexValue > len) {
                return -1L;
            }
            if (fromIndexValue < 0L) {
                fromIndexValue = (fromIndexValue += len) < 0L ? 0L : fromIndexValue;
            }
            return fromIndexValue;
        }

        private static long calcFromIndexBackward(Object[] args, long len, Object fromIndex, JSToIntegerAsLongNode toInteger) {
            if (args.length <= 1) {
                return len - 1L;
            }
            long fromIndexInt = toInteger.executeLong(fromIndex);
            if (fromIndexInt >= 0L) {
                return Math.min(fromIndexInt, len - 1L);
            }
            return fromIndexInt + len;
        }

        @Override
        protected boolean isForward() {
            return this.isForward;
        }

        @Override
        protected boolean shouldCheckHasProperty() {
            return true;
        }

        @Override
        protected final ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSIdenticalNode doIdenticalNode = JSIdenticalNode.createStrictEqualityComparison();
                @Node.Child
                protected LongToIntOrDoubleNode indexToNumber = LongToIntOrDoubleNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return this.doIdenticalNode.executeBoolean(value, callbackResult) ? ForEachIndexCallNode.MaybeResult.returnResult(this.boxIndex(index)) : ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }

                private Number boxIndex(long index) {
                    return this.indexToNumber.fromIndex(null, index);
                }
            };
        }

        @Override
        protected final ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return null;
        }
    }

    public static abstract class JSArrayJoinNode
    extends JSArrayOperation {
        @Node.Child
        private JSToStringNode separatorToStringNode;
        @Node.Child
        private JSToStringNode elementToStringNode = JSToStringNode.create();
        @Node.Child
        private TruffleString.ConcatNode stringConcatNode;
        @Node.Child
        private InteropLibrary interopLibrary;
        private final StringBuilderProfile stringBuilderProfile;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;

        public JSArrayJoinNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected TruffleString join(Object thisObj, Object joinStr, @Cached InlinedConditionProfile separatorNotEmpty, @Cached InlinedConditionProfile isZero, @Cached InlinedConditionProfile isOne, @Cached InlinedConditionProfile isTwo, @Cached InlinedConditionProfile isSparse, @Cached InlinedBranchProfile growProfile, @Cached InlinedBranchProfile stackGrowProfile) {
            Object thisJSObject = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObject);
            TruffleString joinSeparator = joinStr == Undefined.instance ? Strings.COMMA : this.getSeparatorToString().executeString(joinStr);
            JSRealm realm = this.getRealm();
            if (!realm.joinStackPush(thisObj, this, stackGrowProfile)) {
                return Strings.EMPTY_STRING;
            }
            try {
                if (isZero.profile(this, length == 0L)) {
                    TruffleString truffleString = Strings.EMPTY_STRING;
                    return truffleString;
                }
                if (isOne.profile(this, length == 1L)) {
                    TruffleString truffleString = this.joinOne(thisJSObject);
                    return truffleString;
                }
                boolean appendSep = separatorNotEmpty.profile(this, Strings.length(joinSeparator) > 0);
                if (isTwo.profile(this, length == 2L)) {
                    TruffleString truffleString = this.joinTwo(thisJSObject, joinSeparator, appendSep);
                    return truffleString;
                }
                if (isSparse.profile(this, JSArray.isJSArray(thisJSObject) && JSAbstractArray.arrayGetArrayType((JSDynamicObject)thisJSObject) instanceof SparseArray)) {
                    TruffleString truffleString = this.joinSparse(thisJSObject, length, joinSeparator, appendSep, this, growProfile);
                    return truffleString;
                }
                TruffleString truffleString = this.joinLoop(thisJSObject, length, joinSeparator, appendSep);
                return truffleString;
            }
            finally {
                realm.joinStackPop();
            }
        }

        private JSToStringNode getSeparatorToString() {
            if (this.separatorToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.separatorToStringNode = this.insert(JSToStringNode.create());
            }
            return this.separatorToStringNode;
        }

        private TruffleString concat(TruffleString a2, TruffleString b2) {
            if (this.stringConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringConcatNode = this.insert(TruffleString.ConcatNode.create());
            }
            return Strings.concat(this.stringConcatNode, a2, b2);
        }

        private void append(TruffleStringBuilderUTF16 sb, TruffleString s2) {
            if (this.appendStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendStringNode = this.insert(TruffleStringBuilder.AppendStringNode.create());
            }
            this.stringBuilderProfile.append(this.appendStringNode, sb, s2);
        }

        private TruffleString builderToString(TruffleStringBuilderUTF16 sb) {
            if (this.builderToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.builderToStringNode = this.insert(TruffleStringBuilder.ToStringNode.create());
            }
            return StringBuilderProfile.toString(this.builderToStringNode, sb);
        }

        private TruffleString joinOne(Object thisObject) {
            Object value = this.read(thisObject, 0);
            return this.toStringOrEmpty(value);
        }

        private TruffleString joinTwo(Object thisObject, TruffleString joinSeparator, boolean appendSep) {
            TruffleString first = this.toStringOrEmpty(this.read(thisObject, 0));
            TruffleString second = this.toStringOrEmpty(this.read(thisObject, 1));
            long resultLength = (long)Strings.length(first) + (appendSep ? (long)Strings.length(joinSeparator) : 0L) + (long)Strings.length(second);
            if (resultLength > (long)this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            TruffleString res = first;
            if (appendSep) {
                res = this.concat(res, joinSeparator);
            }
            return this.concat(res, second);
        }

        private TruffleString joinLoop(Object thisJSObject, long length, TruffleString joinSeparator, boolean appendSep) {
            TruffleStringBuilderUTF16 sb = this.stringBuilderProfile.newStringBuilder();
            long i2 = 0L;
            while (i2 < length) {
                if (appendSep && i2 != 0L) {
                    this.append(sb, joinSeparator);
                }
                Object value = this.read(thisJSObject, i2);
                TruffleString str = this.toStringOrEmpty(value);
                this.append(sb, str);
                if (appendSep) {
                    ++i2;
                    continue;
                }
                i2 = this.nextElementIndex(thisJSObject, i2, length);
            }
            return this.builderToString(sb);
        }

        private TruffleString toStringOrEmpty(Object value) {
            if (this.isValidEntry(value)) {
                return this.elementToStringNode.executeString(value);
            }
            return Strings.EMPTY_STRING;
        }

        private boolean isValidEntry(Object value) {
            return value != Undefined.instance && value != Null.instance && !this.isForeignNull(value);
        }

        private boolean isForeignNull(Object value) {
            if (value instanceof JSDynamicObject) {
                return false;
            }
            if (value instanceof TruffleObject) {
                if (this.interopLibrary == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.interopLibrary = this.insert(InteropLibrary.getFactory().createDispatched(5));
                }
                return this.interopLibrary.isNull(value);
            }
            return false;
        }

        private TruffleString joinSparse(Object thisObject, long length, TruffleString joinSeparator, boolean appendSep, Node node, InlinedBranchProfile growProfile) {
            SimpleArrayList<Object> converted = SimpleArrayList.create(length);
            long calculatedLength = 0L;
            long i2 = 0L;
            while (i2 < length) {
                TruffleString string;
                int stringLength;
                Object value = this.read(thisObject, i2);
                if (this.isValidEntry(value) && (stringLength = Strings.length(string = this.elementToStringNode.executeString(value))) > 0) {
                    calculatedLength += (long)stringLength;
                    converted.add(i2, node, growProfile);
                    converted.add(string, node, growProfile);
                }
                i2 = this.nextElementIndex(thisObject, i2, length);
            }
            if (appendSep) {
                calculatedLength += (length - 1L) * (long)Strings.length(joinSeparator);
            }
            if (calculatedLength > (long)this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            assert (calculatedLength <= Integer.MAX_VALUE);
            TruffleStringBuilderUTF16 sb = this.stringBuilderProfile.newStringBuilder((int)calculatedLength);
            long lastIndex = 0L;
            for (int j2 = 0; j2 < converted.size(); j2 += 2) {
                long index = (Long)converted.get(j2);
                Object value = converted.get(j2 + 1);
                if (appendSep) {
                    for (long k2 = lastIndex; k2 < index; ++k2) {
                        this.append(sb, joinSeparator);
                    }
                }
                this.append(sb, (TruffleString)value);
                lastIndex = index;
            }
            if (appendSep) {
                for (long k3 = lastIndex; k3 < length - 1L; ++k3) {
                    this.append(sb, joinSeparator);
                }
            }
            assert ((long)StringBuilderProfile.length(sb) == calculatedLength);
            return this.builderToString(sb);
        }
    }

    public static abstract class JSArrayToLocaleStringNode
    extends JSArrayOperation {
        private final boolean passArguments;
        private final StringBuilderProfile stringBuilderProfile;
        @Node.Child
        private PropertyGetNode getToLocaleStringNode;
        @Node.Child
        private JSFunctionCallNode callToLocaleStringNode;

        public JSArrayToLocaleStringNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
            this.passArguments = context.isOptionIntl402();
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected TruffleString toLocaleString(VirtualFrame frame, Object thisObj, @Cached JSToStringNode toStringNode, @Cached TruffleStringBuilder.AppendCharUTF16Node appendCharNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode builderToStringNode, @Cached InlinedBranchProfile stackGrowProfile) {
            Object arrayObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(arrayObj);
            if (len == 0L) {
                return Strings.EMPTY_STRING;
            }
            JSRealm realm = this.getRealm();
            if (!realm.joinStackPush(thisObj, this, stackGrowProfile)) {
                return Strings.EMPTY_STRING;
            }
            try {
                Object[] userArguments;
                if (this.passArguments) {
                    Object[] args = frame.getArguments();
                    int argc = JSArguments.getUserArgumentCount(args);
                    JSDynamicObject locales = argc > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                    JSDynamicObject options = argc > 1 ? JSArguments.getUserArgument(args, 1) : Undefined.instance;
                    userArguments = new Object[]{locales, options};
                } else {
                    userArguments = JSArguments.EMPTY_ARGUMENTS_ARRAY;
                }
                TruffleStringBuilderUTF16 sb = this.stringBuilderProfile.newStringBuilder();
                for (long k2 = 0L; k2 < len; ++k2) {
                    Object nextElement;
                    if (k2 > 0L) {
                        this.stringBuilderProfile.append(appendCharNode, sb, ',');
                    }
                    if ((nextElement = this.read(arrayObj, k2)) == Null.instance || nextElement == Undefined.instance) continue;
                    Object result = this.callToLocaleString(nextElement, userArguments);
                    TruffleString resultString = toStringNode.executeString(result);
                    this.stringBuilderProfile.append(appendStringNode, sb, resultString);
                }
                TruffleString truffleString = StringBuilderProfile.toString(builderToStringNode, sb);
                return truffleString;
            }
            finally {
                realm.joinStackPop();
            }
        }

        private Object callToLocaleString(Object nextElement, Object[] userArguments) {
            if (this.getToLocaleStringNode == null || this.callToLocaleStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getToLocaleStringNode = this.insert(PropertyGetNode.create(Strings.TO_LOCALE_STRING, false, this.getContext()));
                this.callToLocaleStringNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object toLocaleString = this.getToLocaleStringNode.getValue(nextElement);
            return this.callToLocaleStringNode.executeCall(JSArguments.create(nextElement, toLocaleString, userArguments));
        }
    }

    public static abstract class JSArraySpliceNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;
        private final BranchProfile branchA = BranchProfile.create();
        private final BranchProfile branchB = BranchProfile.create();
        private final BranchProfile needMoveDeleteBranch = BranchProfile.create();
        @Node.Child
        private InteropLibrary arrayInterop;

        public JSArraySpliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.deletePropertyNode = DeletePropertyNode.create(true);
        }

        @Specialization
        protected Object splice(Object thisArg, Object[] args, @Cached SpliceJSArrayNode spliceJSArray, @Cached InlinedBranchProfile branchDelete, @Cached InlinedBranchProfile objectBranch, @Cached InlinedConditionProfile argsLength0Profile, @Cached InlinedConditionProfile argsLength1Profile, @Cached InlinedConditionProfile offsetProfile, @Cached InlinedBranchProfile needInsertBranch) {
            long actualDeleteCount;
            long insertCount;
            Object thisObj = this.toObject(thisArg);
            long len = this.getLength(thisObj);
            long actualStart = JSRuntime.getOffset(this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 0)), len, (Node)this, offsetProfile);
            if (argsLength0Profile.profile(this, args.length == 0)) {
                insertCount = 0L;
                actualDeleteCount = 0L;
            } else if (argsLength1Profile.profile(this, args.length == 1)) {
                insertCount = 0L;
                actualDeleteCount = len - actualStart;
            } else {
                assert (args.length >= 2);
                insertCount = args.length - 2;
                long deleteCount = this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 1));
                actualDeleteCount = Math.min(Math.max(deleteCount, 0L), len - actualStart);
            }
            if (len + insertCount - actualDeleteCount > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                this.errorBranch.enter();
                JSArraySpliceNode.throwLengthError();
            }
            Object aObj = this.getArraySpeciesConstructorNode().createEmptyContainer(thisObj, actualDeleteCount);
            if (actualDeleteCount > 0L) {
                branchDelete.enter(this);
                this.spliceRead(thisObj, actualStart, actualDeleteCount, aObj, len);
            }
            this.setLength(aObj, actualDeleteCount);
            long itemCount = insertCount;
            boolean isJSArray = JSArray.isJSArray(thisObj);
            if (isJSArray) {
                JSArrayObject dynObj = (JSArrayObject)thisObj;
                ScriptArray arrayType = JSAbstractArray.arrayGetArrayType(dynObj);
                spliceJSArray.execute(dynObj, len, actualStart, actualDeleteCount, itemCount, arrayType, this);
            } else if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                objectBranch.enter(this);
                this.spliceJSObject(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else {
                this.spliceForeignArray(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
            if (itemCount > 0L) {
                needInsertBranch.enter(this);
                this.spliceInsert(thisObj, actualStart, args);
            }
            long newLength = len - actualDeleteCount + itemCount;
            this.setLength(thisObj, newLength);
            this.reportLoopCount(len);
            return aObj;
        }

        final boolean mustUseElementwise(JSDynamicObject obj, long expectedLength, ScriptArray array, GetPrototypeNode getPrototypeNode) {
            return array instanceof SparseArray || array.isLengthNotWritable() || getPrototypeNode.execute(obj) != this.getRealm().getArrayPrototype() || !this.getContext().getArrayPrototypeNoElementsAssumption().isValid() || !this.getContext().getFastArrayAssumption().isValid() && JSSlowArray.isJSSlowArray(obj) || array.length(obj) != expectedLength;
        }

        private void spliceRead(Object thisObj, long actualStart, long actualDeleteCount, Object aObj, long length) {
            long kPlusStart = actualStart;
            if (!this.hasProperty(thisObj, kPlusStart)) {
                kPlusStart = this.nextElementIndex(thisObj, kPlusStart, length);
            }
            while (kPlusStart < actualDeleteCount + actualStart) {
                Object fromValue = this.read(thisObj, kPlusStart);
                this.writeOwn(aObj, kPlusStart - actualStart, fromValue);
                kPlusStart = this.nextElementIndex(thisObj, kPlusStart, length);
            }
        }

        private void spliceInsert(Object thisObj, long actualStart, Object[] args) {
            int itemOffset = 2;
            for (int i2 = 2; i2 < args.length; ++i2) {
                this.write(thisObj, actualStart + (long)i2 - 2L, args[i2]);
            }
        }

        private void spliceJSObject(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                this.spliceJSObjectShrink(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                this.spliceJSObjectMove(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
        }

        private void spliceJSObjectMove(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            for (long k2 = len - actualDeleteCount; k2 > actualStart; --k2) {
                this.spliceMoveValue(thisObj, k2 + actualDeleteCount - 1L, k2 + itemCount - 1L);
            }
        }

        private void spliceJSObjectShrink(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k2;
            for (k2 = actualStart; k2 < len - actualDeleteCount; ++k2) {
                this.spliceMoveValue(thisObj, k2 + actualDeleteCount, k2 + itemCount);
            }
            for (k2 = len; k2 > len - actualDeleteCount + itemCount; --k2) {
                this.deletePropertyNode.executeEvaluated(thisObj, k2 - 1L);
            }
        }

        private void spliceMoveValue(Object thisObj, long fromIndex, long toIndex) {
            if (this.hasProperty(thisObj, fromIndex)) {
                Object val = this.read(thisObj, fromIndex);
                this.write(thisObj, toIndex, val);
            } else {
                this.needMoveDeleteBranch.enter();
                this.deletePropertyNode.executeEvaluated(thisObj, toIndex);
            }
        }

        final void spliceJSArrayElementwise(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            assert (JSArray.isJSArray(thisObj));
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                this.spliceJSArrayElementwiseWalkUp(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                this.spliceJSArrayElementwiseWalkDown(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
        }

        private void spliceJSArrayElementwiseWalkDown(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k2 = len - 1L;
            long delta = itemCount - actualDeleteCount;
            while (k2 > actualStart + actualDeleteCount - 1L) {
                this.spliceMoveValue(thisObj, k2, k2 + delta);
                if (k2 - delta > actualStart + actualDeleteCount - 1L && !this.hasProperty(thisObj, k2 - delta)) {
                    this.deletePropertyNode.executeEvaluated(thisObj, k2);
                }
                k2 = this.previousElementIndex(thisObj, k2);
            }
        }

        private void spliceJSArrayElementwiseWalkUp(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k2 = actualStart + actualDeleteCount;
            long delta = itemCount - actualDeleteCount;
            while (k2 < len) {
                this.spliceMoveValue(thisObj, k2, k2 + delta);
                if (k2 - delta < len && !this.hasProperty(thisObj, k2 - delta)) {
                    this.deletePropertyNode.executeEvaluated(thisObj, k2);
                }
                k2 = this.nextElementIndex(thisObj, k2, len);
            }
            k2 = len - 1L;
            while (k2 >= len + delta) {
                this.deletePropertyNode.executeEvaluated(thisObj, k2);
                k2 = this.previousElementIndex(thisObj, k2);
            }
        }

        final void spliceJSArrayBlockwise(JSDynamicObject thisObj, long actualStart, long actualDeleteCount, long itemCount, ScriptArray array) {
            assert (JSArray.isJSArray(thisObj));
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                JSAbstractArray.arraySetArrayType(thisObj, array.removeRange(thisObj, actualStart + itemCount, actualStart + actualDeleteCount, this.errorBranch));
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                JSAbstractArray.arraySetArrayType(thisObj, array.addRange(thisObj, actualStart, (int)(itemCount - actualDeleteCount)));
            }
        }

        private void spliceForeignArray(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            InteropLibrary arrays = this.arrayInterop;
            if (arrays == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayInterop = arrays = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            try {
                if (itemCount < actualDeleteCount) {
                    this.branchA.enter();
                    JSArraySpliceNode.spliceForeignArrayShrink(thisObj, len, actualStart, actualDeleteCount, itemCount, arrays);
                } else if (itemCount > actualDeleteCount) {
                    this.branchB.enter();
                    JSArraySpliceNode.spliceForeignArrayMove(thisObj, len, actualStart, actualDeleteCount, itemCount, arrays);
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e2) {
                throw Errors.createTypeErrorInteropException(thisObj, e2, "splice", this);
            }
        }

        private static void spliceForeignArrayMove(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            for (long k2 = len - actualDeleteCount; k2 > actualStart; --k2) {
                JSArraySpliceNode.spliceForeignMoveValue(thisObj, k2 + actualDeleteCount - 1L, k2 + itemCount - 1L, arrays);
            }
        }

        private static void spliceForeignArrayShrink(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            long k2;
            for (k2 = actualStart; k2 < len - actualDeleteCount; ++k2) {
                JSArraySpliceNode.spliceForeignMoveValue(thisObj, k2 + actualDeleteCount, k2 + itemCount, arrays);
            }
            for (k2 = len; k2 > len - actualDeleteCount + itemCount; --k2) {
                arrays.removeArrayElement(thisObj, k2 - 1L);
            }
        }

        private static void spliceForeignMoveValue(Object thisObj, long fromIndex, long toIndex, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            Object val = arrays.readArrayElement(thisObj, fromIndex);
            arrays.writeArrayElement(thisObj, toIndex, val);
        }

        static abstract class SpliceJSArrayNode
        extends JavaScriptBaseNode {
            SpliceJSArrayNode() {
            }

            abstract void execute(JSDynamicObject var1, long var2, long var4, long var6, long var8, ScriptArray var10, JSArraySpliceNode var11);

            @Specialization(guards={"cachedArrayType.isInstance(arrayType)"}, limit="5")
            static void doCached(JSDynamicObject array, long len, long actualStart, long actualDeleteCount, long itemCount, ScriptArray arrayType, JSArraySpliceNode parent, @Cached(value="arrayType") ScriptArray cachedArrayType, @Bind(value="this") Node node, @Cached @Cached.Shared GetPrototypeNode getPrototypeNode, @Cached @Cached.Shared InlinedConditionProfile arrayElementwise) {
                if (arrayElementwise.profile(node, parent.mustUseElementwise(array, len, cachedArrayType.cast(arrayType), getPrototypeNode))) {
                    parent.spliceJSArrayElementwise(array, len, actualStart, actualDeleteCount, itemCount);
                } else {
                    parent.spliceJSArrayBlockwise(array, actualStart, actualDeleteCount, itemCount, cachedArrayType.cast(arrayType));
                }
            }

            @Specialization(replaces={"doCached"})
            static void doUncached(JSDynamicObject array, long len, long actualStart, long actualDeleteCount, long itemCount, ScriptArray arrayType, JSArraySpliceNode parent, @Bind(value="this") Node node, @Cached @Cached.Shared GetPrototypeNode getPrototypeNode, @Cached @Cached.Shared InlinedConditionProfile arrayElementwise) {
                if (arrayElementwise.profile(node, parent.mustUseElementwise(array, len, arrayType, getPrototypeNode))) {
                    parent.spliceJSArrayElementwise(array, len, actualStart, actualDeleteCount, itemCount);
                } else {
                    parent.spliceJSArrayBlockwise(array, actualStart, actualDeleteCount, itemCount, arrayType);
                }
            }
        }
    }

    public static abstract class JSArrayEveryNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayEveryNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean every(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return (Boolean)this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, true);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return this.toBooleanNode.executeBoolean(callbackResult) ? ForEachIndexCallNode.MaybeResult.continueResult(currentResult) : ForEachIndexCallNode.MaybeResult.returnResult(false);
                }
            };
        }
    }

    public static abstract class JSArrayFilterNode
    extends ArrayForEachIndexCallOperation {
        private final ValueProfile arrayTypeProfile = ValueProfile.createClassProfile();
        private final ValueProfile resultArrayTypeProfile = ValueProfile.createClassProfile();

        public JSArrayFilterNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object filter(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object resultArray = this.isTypedArrayImplementation ? JSArray.createEmpty(this.getContext(), this.getRealm(), 0) : this.getArraySpeciesConstructorNode().arraySpeciesCreate(thisJSObj, 0L);
            this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, new FilterState(resultArray, 0L));
            if (this.isTypedArrayImplementation) {
                return this.getTypedResult((JSTypedArrayObject)thisJSObj, (JSArrayObject)resultArray);
            }
            return resultArray;
        }

        private JSTypedArrayObject getTypedResult(JSTypedArrayObject thisJSObj, JSArrayObject resultArray) {
            long resultLen = JSAbstractArray.arrayGetLength(resultArray);
            JSTypedArrayObject typedResult = this.getArraySpeciesConstructorNode().typedArraySpeciesCreate(thisJSObj, JSRuntime.longToIntOrDouble(resultLen));
            TypedArray typedArray = this.arrayTypeProfile.profile(JSArrayBufferView.typedArrayGetArrayType(typedResult));
            ScriptArray array = this.resultArrayTypeProfile.profile(JSAbstractArray.arrayGetArrayType(resultArray));
            for (long i2 = 0L; i2 < resultLen; ++i2) {
                typedArray.setElement(typedResult, i2, array.getElement(resultArray, i2), true);
                TruffleSafepoint.poll(this);
            }
            return typedResult;
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
                @Node.Child
                private WriteElementNode writeOwnNode = WriteElementNode.create(this.getContext(), true, true);

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    if (this.toBooleanNode.executeBoolean(callbackResult)) {
                        FilterState filterState = (FilterState)currentResult;
                        this.writeOwnNode.executeWithTargetAndIndexAndValue(filterState.resultArray, filterState.toIndex++, value);
                    }
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }

        static final class FilterState {
            final Object resultArray;
            long toIndex;

            FilterState(Object resultArray, long toIndex) {
                this.resultArray = resultArray;
                this.toIndex = toIndex;
            }
        }
    }

    public static abstract class JSArrayForEachNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object forEach(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObject(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, Undefined.instance);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArraySomeNode
    extends ArrayForEachIndexCallOperation {
        public JSArraySomeNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean some(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return (Boolean)this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, false);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return this.toBooleanNode.executeBoolean(callbackResult) ? ForEachIndexCallNode.MaybeResult.returnResult(true) : ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArrayMapNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayMapNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object map(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, length);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, resultArray);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private WriteElementNode writeOwnNode;
                {
                    this.writeOwnNode = WriteElementNode.create(this.getContext(), true, !isTypedArrayImplementation);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    this.writeOwnNode.executeWithTargetAndIndexAndValue(currentResult, index, callbackResult);
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArraySortNode
    extends AbstractArraySortNode {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;
        @Node.Child
        private InteropLibrary interopNode;
        @Node.Child
        private ImportValueNode importValueNode;
        private final ConditionProfile isSparse = ConditionProfile.create();
        private final BranchProfile hasCompareFnBranch = BranchProfile.create();
        private final BranchProfile noCompareFnBranch = BranchProfile.create();

        public JSArraySortNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization(guards={"isJSFastArray(thisObj)"}, assumptions={"getContext().getArrayPrototypeNoElementsAssumption()"})
        protected JSArrayObject sortArray(JSArrayObject thisObj, Object compare, @Cached JSArrayToDenseObjectArrayNode arrayToObjectArrayNode, @Cached(value="create(getContext(), true)") JSArrayDeleteRangeNode arrayDeleteRangeNode) {
            this.checkCompareCallableOrUndefined(compare);
            long len = this.getLength(thisObj);
            if (len < 2L) {
                return thisObj;
            }
            ScriptArray scriptArray = JSAbstractArray.arrayGetArrayType(thisObj);
            Object[] array = arrayToObjectArrayNode.executeObjectArray(thisObj, scriptArray, len);
            this.sortAndWriteBack(array, thisObj, compare);
            if (this.isSparse.profile((long)array.length < len)) {
                arrayDeleteRangeNode.execute(thisObj, scriptArray, array.length, len);
            }
            return thisObj;
        }

        private void delete(Object obj, Object i2) {
            if (this.deletePropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.deletePropertyNode = this.insert(DeletePropertyNode.create(true));
            }
            this.deletePropertyNode.executeEvaluated(obj, i2);
        }

        @Specialization
        protected final Object sort(Object thisObj, Object comparefn, @Cached InlinedConditionProfile isJSObject, @Cached InlinedBranchProfile growProfile) {
            this.checkCompareCallableOrUndefined(comparefn);
            Object obj = this.toObject(thisObj);
            if (isJSObject.profile(this, obj instanceof JSObject)) {
                return this.sortJSObject(comparefn, (JSObject)obj, growProfile);
            }
            return this.sortForeignObject(comparefn, obj);
        }

        private JSDynamicObject sortJSObject(Object comparefn, JSObject thisJSObj, InlinedBranchProfile growProfile) {
            long len = this.getLength(thisJSObj);
            if (len == 0L) {
                return thisJSObj;
            }
            Object[] array = JSArraySortNode.jsobjectToArray(thisJSObj, len, true, this, growProfile);
            this.sortAndWriteBack(array, thisJSObj, comparefn);
            if (this.isSparse.profile((long)array.length < len)) {
                this.deleteGenericElements(thisJSObj, array.length, len);
            }
            return thisJSObj;
        }

        public Object sortForeignObject(Object comparefn, Object thisObj) {
            assert (JSGuards.isForeignObject(thisObj));
            long len = this.getLength(thisObj);
            if (len < 2L) {
                return thisObj;
            }
            if (len >= Integer.MAX_VALUE) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidArrayLength(this);
            }
            Object[] array = this.foreignArrayToObjectArray(thisObj, (int)len);
            this.sortAndWriteBack(array, thisObj, comparefn);
            return thisObj;
        }

        private void sortAndWriteBack(Object[] array, Object thisObj, Object comparefn) {
            Comparator<Object> comparator = this.getComparator(thisObj, comparefn);
            Boundaries.arraySort(array, comparator);
            for (int i2 = 0; i2 < array.length; ++i2) {
                this.write(thisObj, i2, array[i2]);
            }
            this.reportLoopCount(array.length);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] jsobjectToArray(JSDynamicObject thisObj, long len, boolean skipHoles, Node node, InlinedBranchProfile growProfile) {
            SimpleArrayList<Object> list = SimpleArrayList.create(len);
            for (long k2 = 0L; k2 < len; ++k2) {
                if (skipHoles && !JSObject.hasProperty(thisObj, k2)) continue;
                list.add(JSObject.get(thisObj, k2), node, growProfile);
            }
            return list.toArray();
        }

        private Object[] foreignArrayToObjectArray(Object thisObj, int len) {
            InteropLibrary interop = this.interopNode;
            ImportValueNode importValue = this.importValueNode;
            if (interop == null || importValue == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopNode = interop = this.insert(InteropLibrary.getFactory().createDispatched(5));
                this.importValueNode = importValue = this.insert(ImportValueNode.create());
            }
            Object[] array = new Object[len];
            for (int index = 0; index < len; ++index) {
                array[index] = JSInteropUtil.readArrayElementOrDefault(thisObj, index, Undefined.instance, interop, importValue);
            }
            return array;
        }

        private Comparator<Object> getComparator(Object thisObj, Object compare) {
            if (compare == Undefined.instance) {
                this.noCompareFnBranch.enter();
                return this.getDefaultComparator(thisObj);
            }
            assert (this.isCallable(compare));
            this.hasCompareFnBranch.enter();
            return new SortComparator(compare);
        }

        private Comparator<Object> getDefaultComparator(Object thisObj) {
            return SortComparator.getDefaultComparator(this.getContext(), thisObj, this.isTypedArrayImplementation);
        }

        private void deleteGenericElements(Object obj, long fromIndex, long toIndex) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.delete(obj, index);
            }
        }
    }

    public static abstract class JSArrayReduceNode
    extends ArrayForEachIndexCallOperation {
        private final boolean isForward;
        @Node.Child
        private ForEachIndexCallNode forEachIndexFindInitialNode;

        public JSArrayReduceNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isForward) {
            super(context, builtin, isTypedArrayImplementation);
            this.isForward = isForward;
        }

        @Specialization
        protected Object reduce(Object thisObj, Object callback, Object[] initialValueOpt, @Cached InlinedBranchProfile findInitialValueBranch) {
            long currentIndex;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object currentValue = initialValueOpt.length > 0 ? initialValueOpt[0] : null;
            long l2 = currentIndex = this.isForward() ? 0L : length - 1L;
            if (currentValue == null) {
                findInitialValueBranch.enter(this);
                Pair<Long, Object> res = this.findInitialValue(thisJSObj, currentIndex, length);
                currentIndex = res.getFirst() + (long)(this.isForward() ? 1 : -1);
                currentValue = res.getSecond();
            }
            return this.forEachIndexCall(thisJSObj, callbackFn, Undefined.instance, currentIndex, length, currentValue);
        }

        @Override
        protected boolean isForward() {
            return this.isForward;
        }

        protected final Pair<Long, Object> findInitialValue(Object arrayObj, long fromIndex, long length) {
            Pair res;
            if (length >= 0L && (res = (Pair)this.getForEachIndexFindInitialNode().executeForEachIndex(arrayObj, null, null, fromIndex, length, null)) != null) {
                return res;
            }
            this.errorBranch.enter();
            throw JSArrayReduceNode.reduceNoInitialValueError();
        }

        private ForEachIndexCallNode getForEachIndexFindInitialNode() {
            if (this.forEachIndexFindInitialNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexFindInitialNode = this.insert(ForEachIndexCallNode.create(this.getContext(), null, new ForEachIndexCallNode.MaybeResultNode(){

                    @Override
                    public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                        return ForEachIndexCallNode.MaybeResult.returnResult(new Pair<Long, Object>(index, value));
                    }
                }, this.isForward(), this.shouldCheckHasProperty()));
            }
            return this.forEachIndexFindInitialNode;
        }

        @Override
        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return new ArrayForEachIndexCallOperation.DefaultCallbackNode(){

                @Override
                public Object apply(long index, Object value, Object target, Object callback, Object callbackThisArg, Object currentResult) {
                    return this.callNode.executeCall(JSArguments.create(callbackThisArg, callback, currentResult, value, this.boxIndex(index), target));
                }
            };
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(callbackResult);
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        protected static RuntimeException reduceNoInitialValueError() {
            throw Errors.createTypeError("Reduce of empty array with no initial value");
        }
    }

    public static abstract class JSArrayReverseNode
    extends JSArrayOperation {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;

        public JSArrayReverseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private boolean deleteProperty(Object array, long index) {
            if (this.deletePropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.deletePropertyNode = this.insert(DeletePropertyNode.create(true));
            }
            return this.deletePropertyNode.executeEvaluated(array, index);
        }

        @Specialization
        protected final Object reverseJSArray(JSArrayObject thisObj, @Cached.Shared @Cached(value="createHasHolesOrUnused()") TestArrayNode hasHolesNode, @Cached.Shared @Cached InlinedConditionProfile bothExistProfile, @Cached.Shared @Cached InlinedConditionProfile onlyUpperExistsProfile, @Cached.Shared @Cached InlinedConditionProfile onlyLowerExistsProfile) {
            return this.reverse(thisObj, true, hasHolesNode, bothExistProfile, onlyUpperExistsProfile, onlyLowerExistsProfile);
        }

        @Specialization(replaces={"reverseJSArray"})
        protected final Object reverseGeneric(Object thisObj, @Cached.Shared @Cached(value="createHasHolesOrUnused()") TestArrayNode hasHolesNode, @Cached.Shared @Cached InlinedConditionProfile bothExistProfile, @Cached.Shared @Cached InlinedConditionProfile onlyUpperExistsProfile, @Cached.Shared @Cached InlinedConditionProfile onlyLowerExistsProfile) {
            Object array = this.toObject(thisObj);
            return this.reverse(array, JSArray.isJSArray(array), hasHolesNode, bothExistProfile, onlyUpperExistsProfile, onlyLowerExistsProfile);
        }

        private Object reverse(Object array, boolean isArray, TestArrayNode hasHolesNode, InlinedConditionProfile bothExistProfile, InlinedConditionProfile onlyUpperExistsProfile, InlinedConditionProfile onlyLowerExistsProfile) {
            boolean hasHoles;
            long length = this.getLength(array);
            long lower = 0L;
            long upper = length - 1L;
            boolean bl = hasHoles = isArray && hasHolesNode.executeBoolean((JSDynamicObject)array);
            while (lower < upper) {
                boolean upperExists;
                boolean lowerExists;
                Object lowerValue = null;
                Object upperValue = null;
                if (this.getContext().getEcmaScriptVersion() < 6) {
                    lowerValue = this.read(array, lower);
                    upperValue = this.read(array, upper);
                    lowerExists = lowerValue != Undefined.instance || this.hasProperty(array, lower);
                    upperExists = upperValue != Undefined.instance || this.hasProperty(array, upper);
                } else {
                    lowerExists = this.hasProperty(array, lower);
                    if (lowerExists) {
                        lowerValue = this.read(array, lower);
                    }
                    if (upperExists = this.hasProperty(array, upper)) {
                        upperValue = this.read(array, upper);
                    }
                }
                if (bothExistProfile.profile(this, lowerExists && upperExists)) {
                    this.write(array, lower, upperValue);
                    this.write(array, upper, lowerValue);
                } else if (onlyUpperExistsProfile.profile(this, !lowerExists && upperExists)) {
                    this.write(array, lower, upperValue);
                    this.deleteProperty(array, upper);
                } else if (onlyLowerExistsProfile.profile(this, lowerExists && !upperExists)) {
                    this.deleteProperty(array, lower);
                    this.write(array, upper, lowerValue);
                } else assert (!lowerExists && !upperExists);
                if (hasHoles) {
                    long nextUpper;
                    long nextLower = this.nextElementIndex(array, lower, length);
                    if (length - nextLower - 1L >= (nextUpper = this.previousElementIndex(array, upper))) {
                        lower = nextLower;
                        upper = length - lower - 1L;
                    } else {
                        lower = length - nextUpper - 1L;
                        upper = nextUpper;
                    }
                } else {
                    ++lower;
                    --upper;
                }
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(lower);
            return array;
        }
    }

    public static abstract class JSArrayFindNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        private final boolean isLast;

        public JSArrayFindNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isLast) {
            super(context, builtin, isTypedArrayImplementation);
            this.isLast = isLast;
        }

        private Object callPredicate(Object function, Object target, Object value, double index, Object thisObj) {
            return this.callNode.executeCall(JSArguments.create(target, function, value, index, thisObj));
        }

        @Specialization
        protected Object find(Object thisObj, Object callback, Object thisArg) {
            long idx;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            long l2 = idx = this.isLast ? length - 1L : 0L;
            while (this.isLast ? idx >= 0L : idx < length) {
                Object value = this.read(thisObj, idx);
                Object callbackResult = this.callPredicate(callbackFn, thisArg, value, idx, thisJSObj);
                boolean testResult = this.toBooleanNode.executeBoolean(callbackResult);
                if (testResult) {
                    this.reportLoopCount(this.isLast ? length - idx - 1L : idx);
                    return value;
                }
                idx = this.isLast ? idx - 1L : idx + 1L;
            }
            this.reportLoopCount(length);
            return Undefined.instance;
        }
    }

    public static abstract class JSArrayFindIndexNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        private final boolean isLast;

        public JSArrayFindIndexNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isLast) {
            super(context, builtin, isTypedArrayImplementation);
            this.isLast = isLast;
        }

        private Object callPredicate(Object function, Object target, Object value, double index, Object thisObj) {
            return this.callNode.executeCall(JSArguments.create(target, function, value, index, thisObj));
        }

        @Specialization
        protected Object findIndex(Object thisObj, Object callback, Object thisArg) {
            long idx;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            long l2 = idx = this.isLast ? length - 1L : 0L;
            while (this.isLast ? idx >= 0L : idx < length) {
                Object value = this.read(thisObj, idx);
                Object callbackResult = this.callPredicate(callbackFn, thisArg, value, idx, thisJSObj);
                boolean testResult = this.toBooleanNode.executeBoolean(callbackResult);
                if (testResult) {
                    this.reportLoopCount(this.isLast ? length - idx - 1L : idx);
                    return JSRuntime.positiveLongToIntOrDouble(idx);
                }
                idx = this.isLast ? idx - 1L : idx + 1L;
            }
            this.reportLoopCount(length);
            return -1;
        }
    }

    public static abstract class JSArrayFillNode
    extends JSArrayOperationWithToInt {
        public JSArrayFillNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object fill(Object thisObj, Object value, Object start, Object end, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisJSObj);
            long lStart = JSRuntime.getOffset(this.toIntegerAsLong(start), len, (Node)this, offsetProfile1);
            long lEnd = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, (Node)this, offsetProfile2);
            for (long idx = lStart; idx < lEnd; ++idx) {
                this.write(thisJSObj, idx, value);
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(lEnd - lStart);
            return thisJSObj;
        }
    }

    public static abstract class JSArrayCopyWithinNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private DeletePropertyNode deletePropertyNode = DeletePropertyNode.create(true);

        public JSArrayCopyWithinNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object copyWithin(Object thisObj, Object target, Object start, Object end, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2, @Cached InlinedConditionProfile offsetProfile3) {
            long count;
            Object obj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(obj);
            long to = JSRuntime.getOffset(this.toIntegerAsLong(target), len, (Node)this, offsetProfile1);
            long from = JSRuntime.getOffset(this.toIntegerAsLong(start), len, (Node)this, offsetProfile2);
            long finalIdx = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, (Node)this, offsetProfile3);
            long expectedCount = count = Math.min(finalIdx - from, len - to);
            if (count > 0L) {
                long direction;
                if (this.isTypedArrayImplementation) {
                    this.checkOutOfBounds((JSTypedArrayObject)thisObj);
                    len = this.getLength(obj);
                }
                if (from < to && to < from + count) {
                    direction = -1L;
                    from = from + count - 1L;
                    to = to + count - 1L;
                } else {
                    direction = 1L;
                }
                while (count > 0L) {
                    if (this.isTypedArrayImplementation || this.hasProperty(obj, from)) {
                        if (this.isTypedArrayImplementation && (from >= len || to >= len)) break;
                        Object fromVal = this.read(obj, from);
                        this.write(obj, to, fromVal);
                    } else {
                        this.deletePropertyNode.executeEvaluated(obj, to);
                    }
                    from += direction;
                    to += direction;
                    --count;
                    TruffleSafepoint.poll(this);
                }
                this.reportLoopCount(expectedCount);
            }
            return obj;
        }
    }

    public static abstract class JSArrayIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        public JSArrayIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
        }

        private JSObject createArrayIterator(Object thisObj) {
            return JSArrayIterator.create(this.getContext(), this.getRealm(), thisObj, 0L, this.iterationKind);
        }

        @Specialization
        protected final JSObject doJSObject(JSObject thisObj) {
            return this.createArrayIterator(thisObj);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected final JSObject doNotJSObject(Object thisObj, @Cached JSToObjectNode toObjectNode) {
            return this.createArrayIterator(toObjectNode.execute(thisObj));
        }
    }

    public static abstract class JSArrayIncludesNode
    extends JSArrayOperationWithToInt {
        public JSArrayIncludesNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean includes(Object thisValue, Object searchElement, Object fromIndex, @Cached(value="createSameValueZero()") JSIdenticalNode identicalNode) {
            long k2;
            Object thisObj = this.toObjectOrValidateTypedArray(thisValue);
            long len = this.getLength(thisObj);
            if (len == 0L) {
                return false;
            }
            long n2 = this.toIntegerAsLong(fromIndex);
            if (n2 >= 0L) {
                k2 = n2;
            } else {
                k2 = len + n2;
                if (k2 < 0L) {
                    k2 = 0L;
                }
            }
            long startIdx = k2;
            while (k2 < len) {
                Object currentElement = this.read(thisObj, k2);
                if (identicalNode.executeBoolean(searchElement, currentElement)) {
                    this.reportLoopCount(k2 - startIdx);
                    return true;
                }
                ++k2;
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(len - startIdx);
            return false;
        }
    }

    public static abstract class JSArrayFlatMapNode
    extends JSArrayOperation {
        public JSArrayFlatMapNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected Object flatMap(Object thisObj, Object callback, Object thisArg, @Cached(value="createFlattenIntoArrayNode(getContext())") FlattenIntoArrayNode flattenIntoArrayNode) {
            Object thisJSObj = this.toObject(thisObj);
            long length = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            flattenIntoArrayNode.flatten(resultArray, thisJSObj, length, 0L, 1L, callbackFn, thisArg);
            return resultArray;
        }

        @NeverDefault
        protected static final FlattenIntoArrayNode createFlattenIntoArrayNode(JSContext context) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, true);
        }
    }

    public static abstract class JSArrayFlatNode
    extends JSArrayOperation {
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;

        public JSArrayFlatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected Object flat(Object thisObj, Object depth, @Cached(value="createFlattenIntoArrayNode(getContext())") FlattenIntoArrayNode flattenIntoArrayNode) {
            Object thisJSObj = this.toObject(thisObj);
            long length = this.getLength(thisJSObj);
            long depthNum = depth == Undefined.instance ? 1L : (long)this.toIntegerAsInt(depth);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            flattenIntoArrayNode.flatten(resultArray, thisJSObj, length, 0L, depthNum, null, null);
            return resultArray;
        }

        private int toIntegerAsInt(Object depth) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = this.insert(JSToIntegerAsIntNode.create());
            }
            return this.toIntegerNode.executeInt(depth);
        }

        @NeverDefault
        protected static final FlattenIntoArrayNode createFlattenIntoArrayNode(JSContext context) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, false);
        }
    }

    public static abstract class JSArrayAtNode
    extends JSArrayOperationWithToInt {
        public JSArrayAtNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object at(Object thisObj, Object index) {
            Object o2 = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(o2);
            long relativeIndex = this.toIntegerAsLong(index);
            long k2 = relativeIndex >= 0L ? relativeIndex : length + relativeIndex;
            if (k2 < 0L || k2 >= length) {
                return Undefined.instance;
            }
            return this.read(o2, k2);
        }
    }

    public static abstract class JSArrayToReversedNode
    extends JSArrayOperation {
        public JSArrayToReversedNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object reverse(Object thisObj) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length = this.getLength(thisJSObj);
            JSObject result = this.createEmpty(thisJSObj, length);
            for (long i2 = 0L; i2 < length; ++i2) {
                Object value = this.read(thisJSObj, length - 1L - i2);
                this.write((Object)result, i2, value);
            }
            return result;
        }
    }

    public static abstract class JSArrayToSortedNode
    extends AbstractArraySortNode {
        protected JSArrayToSortedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected final JSArrayObject toSorted(Object thisObj, Object compare, @Cached JSToObjectArrayNode toObjectArray) {
            this.checkCompareCallableOrUndefined(compare);
            Object obj = this.toObject(thisObj);
            Object[] array = toObjectArray.executeObjectArray(obj);
            int length = array.length;
            JSArrayObject result = this.arrayCreate(length);
            Comparator comparator = compare == Undefined.instance ? JSArray.DEFAULT_JSARRAY_COMPARATOR : new SortComparator(compare);
            Boundaries.arraySort(array, comparator);
            for (int i2 = 0; i2 < length; ++i2) {
                this.write((Object)result, i2, array[i2]);
            }
            return result;
        }
    }

    public static abstract class JSArrayToSplicedNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private InteropLibrary arrayInterop;
        @Node.Child
        private ImportValueNode importValueNode;

        public JSArrayToSplicedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject toSpliced(Object thisArg, Object[] args, @Cached InlinedConditionProfile offsetProfile, @Cached InlinedConditionProfile argsLength0Profile, @Cached InlinedConditionProfile argsLength1Profile, @Cached InlinedBranchProfile objectBranch) {
            long actualDeleteCount;
            long insertCount;
            Object thisObj = this.toObject(thisArg);
            long len = this.getLength(thisObj);
            long actualStart = JSRuntime.getOffset(this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 0)), len, (Node)this, offsetProfile);
            if (argsLength0Profile.profile(this, args.length == 0)) {
                insertCount = 0L;
                actualDeleteCount = 0L;
            } else if (argsLength1Profile.profile(this, args.length == 1)) {
                insertCount = 0L;
                actualDeleteCount = len - actualStart;
            } else {
                assert (args.length >= 2);
                insertCount = args.length - 2;
                long deleteCount = this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 1));
                actualDeleteCount = Math.min(Math.max(deleteCount, 0L), len - actualStart);
            }
            long newLen = len + insertCount - actualDeleteCount;
            if (newLen > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                this.errorBranch.enter();
                JSArrayToSplicedNode.throwLengthError();
            }
            JSArrayObject resObj = this.getArraySpeciesConstructorNode().arrayCreate(newLen);
            if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                objectBranch.enter(this);
                this.spliceJSObject(resObj, thisObj, len, actualStart, actualDeleteCount, args);
            } else {
                this.spliceForeignArray(resObj, thisObj, len, actualStart, actualDeleteCount, args);
            }
            this.reportLoopCount(len);
            return resObj;
        }

        private long spliceInsert(JSDynamicObject dstObj, long toIndex, Object[] args) {
            int itemOffset = 2;
            long dstIdx = toIndex;
            for (int argIdx = itemOffset; argIdx < args.length; ++argIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, args[argIdx]);
            }
            return dstIdx;
        }

        private void spliceJSObject(JSArrayObject dstObj, Object srcObj, long len, long actualStart, long actualDeleteCount, Object[] args) {
            long srcIdx;
            long dstIdx = 0L;
            for (srcIdx = 0L; srcIdx < actualStart; ++srcIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, this.read(srcObj, srcIdx));
            }
            dstIdx = this.spliceInsert(dstObj, dstIdx, args);
            for (srcIdx = actualStart + actualDeleteCount; srcIdx < len; ++srcIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, this.read(srcObj, srcIdx));
            }
        }

        private void spliceForeignArray(JSArrayObject dstObj, Object srcObj, long len, long actualStart, long actualDeleteCount, Object[] args) {
            long srcIdx;
            InteropLibrary arrays = this.arrayInterop;
            if (arrays == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayInterop = arrays = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            long dstIdx = 0L;
            for (srcIdx = 0L; srcIdx < actualStart; ++srcIdx) {
                this.spliceForeignMoveValue(dstObj, srcObj, srcIdx, dstIdx++, arrays);
            }
            dstIdx = this.spliceInsert(dstObj, dstIdx, args);
            for (srcIdx = actualStart + actualDeleteCount; srcIdx < len; ++srcIdx) {
                this.spliceForeignMoveValue(dstObj, srcObj, srcIdx, dstIdx++, arrays);
            }
        }

        private void spliceForeignMoveValue(JSArrayObject destObj, Object srcObj, long fromIndex, long toIndex, InteropLibrary arrays) {
            if (this.importValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.importValueNode = this.insert(ImportValueNode.create());
            }
            Object val = JSInteropUtil.readArrayElementOrDefault(srcObj, fromIndex, Undefined.instance, arrays, this.importValueNode);
            this.writeOwn((Object)destObj, toIndex, val);
        }
    }

    public static abstract class JSArrayWithNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToBigIntNode toBigIntNode;

        public JSArrayWithNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        protected Object toNumber(Object value) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.execute(value);
        }

        protected Object toBigInt(Object value) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.execute(value);
        }

        @Specialization
        protected Object withGeneric(Object thisObj, Object index, Object valueParam) {
            long k2;
            long lengthForCheck;
            Object value = valueParam;
            Object array = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(array);
            long relativeIndex = this.toIntegerAsLong(index);
            long actualIndex = relativeIndex >= 0L ? relativeIndex : len + relativeIndex;
            if (this.isTypedArrayImplementation) {
                value = JSArrayBufferView.isBigIntArrayBufferView((JSDynamicObject)array) ? this.toBigInt(value) : this.toNumber(value);
            }
            long l2 = this.isTypedArrayImplementation ? (JSArrayBufferView.isOutOfBounds((JSTypedArrayObject)array, this.getContext()) ? 0L : this.getLength(thisObj)) : (lengthForCheck = len);
            if (actualIndex >= lengthForCheck || actualIndex < 0L) {
                this.errorBranch.enter();
                throw Errors.createRangeError("invalid index");
            }
            JSObject resultArray = this.createEmpty(array, len);
            for (k2 = 0L; k2 < len; ++k2) {
                Object val = k2 == actualIndex ? value : this.read(array, k2);
                this.writeOwn((Object)resultArray, k2, val);
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(k2);
            return resultArray;
        }
    }

    public static abstract class AbstractArraySortNode
    extends JSArrayOperation {
        public AbstractArraySortNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        protected final void checkCompareCallableOrUndefined(Object compare) {
            if (compare != Undefined.instance && !this.isCallable(compare)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("The comparison function must be either a function or undefined");
            }
        }
    }

    public static abstract class FlattenIntoArrayNode
    extends JavaScriptBaseNode {
        protected final JSContext context;
        protected final boolean withMapCallback;
        @Node.Child
        private ForEachIndexCallNode forEachIndexNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;

        protected FlattenIntoArrayNode(JSContext context, boolean withMapCallback) {
            this.context = context;
            this.withMapCallback = withMapCallback;
        }

        @NeverDefault
        public static FlattenIntoArrayNode create(JSContext context, boolean withCallback) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, withCallback);
        }

        protected abstract long executeLong(Object var1, Object var2, long var3, long var5, long var7, Object var9, Object var10);

        @Specialization
        protected long flatten(Object resultArray, Object source, long sourceLen, long start, long depth, Object callback, Object thisArg) {
            boolean callbackUndefined = callback == null;
            FlattenState flattenState = new FlattenState(resultArray, start, depth, callbackUndefined);
            Object thisJSObj = this.toObject(source);
            this.forEachIndexCall(thisJSObj, callback, thisArg, 0L, sourceLen, flattenState);
            return flattenState.targetIndex;
        }

        protected final Object forEachIndexCall(Object arrayObj, Object callbackObj, Object thisArg, long fromIndex, long length, Object initialResult) {
            if (this.forEachIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexNode = this.insert(this.makeForEachIndexCallNode());
            }
            return this.forEachIndexNode.executeForEachIndex(arrayObj, callbackObj, thisArg, fromIndex, length, initialResult);
        }

        private ForEachIndexCallNode makeForEachIndexCallNode() {
            return ForEachIndexCallNode.create(this.context, this.makeCallbackNode(), this.makeMaybeResultNode(), true, true);
        }

        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return this.withMapCallback ? new ArrayForEachIndexCallOperation.DefaultCallbackNode() : null;
        }

        protected final Object toObject(Object target) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(target);
        }

        protected long getLength(Object thisObject) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(JSGetLengthNode.create(this.context));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                protected final BranchProfile errorBranch = BranchProfile.create();
                @Node.Child
                private WriteElementNode writeOwnNode;
                @Node.Child
                private DirectCallNode innerFlattenCall;
                {
                    this.writeOwnNode = WriteElementNode.create(context, true, true);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object originalValue, Object callbackResult, Object resultState) {
                    Object value;
                    boolean shouldFlatten = false;
                    FlattenState state = (FlattenState)resultState;
                    Object object = value = state.callbackUndefined ? originalValue : callbackResult;
                    if (state.depth > 0L) {
                        shouldFlatten = JSRuntime.isArray(value);
                    }
                    if (shouldFlatten) {
                        long elementLen = this.getLength(this.toObject(value));
                        state.targetIndex = this.makeFlattenCall(state.resultArray, value, elementLen, state.targetIndex, state.depth - 1L);
                    } else {
                        if (state.targetIndex >= JSRuntime.MAX_SAFE_INTEGER_LONG) {
                            this.errorBranch.enter();
                            throw Errors.createTypeError("Index out of bounds in flatten into array");
                        }
                        this.writeOwnNode.executeWithTargetAndIndexAndValue(state.resultArray, state.targetIndex++, value);
                    }
                    return ForEachIndexCallNode.MaybeResult.continueResult(resultState);
                }

                private long makeFlattenCall(Object targetArray, Object element, long elementLength, long targetIndex, long depth) {
                    if (this.innerFlattenCall == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        JSFunctionData flattenFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFlattenIntoArray, c2 -> FlattenIntoArrayNode.createOrGetFlattenCallFunctionData(c2));
                        this.innerFlattenCall = this.insert(DirectCallNode.create(flattenFunctionData.getCallTarget()));
                    }
                    return (Long)this.innerFlattenCall.call(targetArray, element, elementLength, targetIndex, depth);
                }
            };
        }

        private static JSFunctionData createOrGetFlattenCallFunctionData(JSContext context) {
            return JSFunctionData.createCallOnly(context, new InnerFlattenCallNode(context, FlattenIntoArrayNode.create(context, false)).getCallTarget(), 0, Strings.EMPTY_STRING);
        }

        static final class FlattenState {
            final Object resultArray;
            final boolean callbackUndefined;
            final long depth;
            long targetIndex;

            FlattenState(Object resultArray, long toIndex, long depth, boolean callbackUndefined) {
                this.resultArray = resultArray;
                this.callbackUndefined = callbackUndefined;
                this.targetIndex = toIndex;
                this.depth = depth;
            }
        }

        private static final class InnerFlattenCallNode
        extends JavaScriptRootNode {
            @Node.Child
            private FlattenIntoArrayNode flattenNode;

            InnerFlattenCallNode(JSContext context, FlattenIntoArrayNode flattenNode) {
                super(context.getLanguage(), null, null);
                this.flattenNode = flattenNode;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                JSDynamicObject resultArray = (JSDynamicObject)arguments[0];
                Object element = arguments[1];
                long elementLen = (Long)arguments[2];
                long targetIndex = (Long)arguments[3];
                long depth = (Long)arguments[4];
                return this.flattenNode.flatten(resultArray, element, elementLen, targetIndex, depth, null, null);
            }
        }
    }

    public static abstract class ArrayForEachIndexCallOperation
    extends JSArrayOperation {
        @Node.Child
        private ForEachIndexCallNode forEachIndexNode;

        public ArrayForEachIndexCallOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public ArrayForEachIndexCallOperation(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected final Object forEachIndexCall(Object arrayObj, Object callbackObj, Object thisArg, long fromIndex, long length, Object initialResult) {
            if (this.forEachIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexNode = this.insert(this.makeForEachIndexCallNode());
            }
            return this.forEachIndexNode.executeForEachIndex(arrayObj, callbackObj, thisArg, fromIndex, length, initialResult);
        }

        private ForEachIndexCallNode makeForEachIndexCallNode() {
            return ForEachIndexCallNode.create(this.getContext(), this.makeCallbackNode(), this.makeMaybeResultNode(), this.isForward(), this.shouldCheckHasProperty());
        }

        protected boolean isForward() {
            return true;
        }

        protected boolean shouldCheckHasProperty() {
            return !this.isTypedArrayImplementation;
        }

        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return new DefaultCallbackNode();
        }

        protected abstract ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode();

        protected static class DefaultCallbackNode
        extends ForEachIndexCallNode.CallbackNode {
            @Node.Child
            protected JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
            @Node.Child
            private LongToIntOrDoubleNode indexToJSNumber = LongToIntOrDoubleNode.create();

            protected DefaultCallbackNode() {
            }

            @Override
            public Object apply(long index, Object value, Object target, Object callback, Object callbackThisArg, Object currentResult) {
                return this.callNode.executeCall(JSArguments.create(callbackThisArg, callback, value, this.boxIndex(index), target));
            }

            protected final Number boxIndex(long index) {
                return this.indexToJSNumber.fromIndex(null, index);
            }
        }
    }

    @ImportStatic(value={JSRuntime.class, JSConfig.class})
    protected static abstract class DeleteAndSetLengthNode
    extends JavaScriptBaseNode {
        protected static final boolean THROW_ERROR = true;
        protected final JSContext context;

        protected DeleteAndSetLengthNode(JSContext context) {
            this.context = context;
        }

        public abstract void executeVoid(Object var1, long var2);

        @NeverDefault
        protected final PropertySetNode createSetLengthProperty() {
            return PropertySetNode.create(JSArray.LENGTH, false, this.context, true);
        }

        protected static boolean isArray(JSDynamicObject object) {
            return JSArray.isJSFastArray(object);
        }

        @Specialization(guards={"isArray(object)", "longIsRepresentableAsInt(longLength)"})
        protected static void setArrayLength(JSObject object, long longLength, @Cached(value="createSetOrDelete(THROW_ERROR)") ArrayLengthNode.ArrayLengthWriteNode arrayLengthWriteNode) {
            arrayLengthWriteNode.executeVoid(object, (int)longLength);
        }

        @Specialization(guards={"longIsRepresentableAsInt(longLength)"})
        protected static void setIntLength(JSObject object, long longLength, @Cached.Shared @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached.Shared @Cached(value="createSetLengthProperty()") PropertySetNode setLengthProperty) {
            int intLength = (int)longLength;
            deletePropertyNode.executeEvaluated(object, intLength);
            setLengthProperty.setValueInt(object, intLength);
        }

        @Specialization(replaces={"setIntLength"})
        protected void setLength(JSObject object, long longLength, @Cached.Shared @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode, @Cached.Shared @Cached(value="createSetLengthProperty()") PropertySetNode setLengthProperty, @Cached(inline=true) LongToIntOrDoubleNode indexToNumber) {
            Number boxedLength = indexToNumber.fromIndex(this, longLength);
            deletePropertyNode.executeEvaluated(object, boxedLength);
            setLengthProperty.setValue(object, boxedLength);
        }

        @Specialization(guards={"!isJSObject(object)"})
        protected static void foreignArray(Object object, long newLength, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary arrays) {
            try {
                arrays.removeArrayElement(object, newLength);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e2) {
                throw Errors.createTypeErrorInteropException(object, e2, "removeArrayElement", null);
            }
        }
    }

    public static abstract class JSArrayOperationWithToInt
    extends JSArrayOperation {
        @Node.Child
        private JSToIntegerAsLongNode toIntegerAsLongNode;

        public JSArrayOperationWithToInt(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public JSArrayOperationWithToInt(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected long toIntegerAsLong(Object target) {
            if (this.toIntegerAsLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerAsLongNode = this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntegerAsLongNode.executeLong(target);
        }
    }

    public static abstract class JSArrayOperation
    extends BasicArrayOperation {
        protected static final boolean THROW_ERROR = true;
        @Node.Child
        private JSSetLengthNode setLengthNode;
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private WriteElementNode writeOwnNode;
        @Node.Child
        private ReadElementNode readNode;
        @Node.Child
        private JSHasPropertyNode hasPropertyNode;
        @Node.Child
        private JSArrayNextElementIndexNode nextElementIndexNode;
        @Node.Child
        private JSArrayPreviousElementIndexNode previousElementIndexNode;
        @Node.Child
        private ArrayCreateNode arrayCreateNode;

        public JSArrayOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public JSArrayOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        protected void setLength(Object thisObject, int length) {
            this.setLengthIntl(thisObject, length);
        }

        protected void setLength(Object thisObject, long length) {
            this.setLengthIntl(thisObject, JSRuntime.longToIntOrDouble(length));
        }

        private void setLengthIntl(Object thisObject, Object length) {
            assert (!(length instanceof Long));
            if (this.setLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLengthNode = this.insert(JSSetLengthNode.create(this.getContext(), true));
            }
            this.setLengthNode.execute(thisObject, length);
        }

        private ReadElementNode getOrCreateReadNode() {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNode;
        }

        protected Object read(Object target, int index) {
            return this.getOrCreateReadNode().executeWithTargetAndIndex(target, index);
        }

        protected Object read(Object target, long index) {
            ReadElementNode read = this.getOrCreateReadNode();
            return read.executeWithTargetAndIndex(target, index);
        }

        private WriteElementNode getOrCreateWriteNode() {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = this.insert(WriteElementNode.create(this.getContext(), true));
            }
            return this.writeNode;
        }

        protected void write(Object target, int index, Object value) {
            this.getOrCreateWriteNode().executeWithTargetAndIndexAndValue(target, index, value);
        }

        protected void write(Object target, long index, Object value) {
            WriteElementNode write = this.getOrCreateWriteNode();
            write.executeWithTargetAndIndexAndValue(target, index, value);
        }

        private WriteElementNode getOrCreateWriteOwnNode() {
            if (this.writeOwnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeOwnNode = this.insert(WriteElementNode.create(this.getContext(), true, true));
            }
            return this.writeOwnNode;
        }

        protected void writeOwn(Object target, int index, Object value) {
            this.getOrCreateWriteOwnNode().executeWithTargetAndIndexAndValue(target, index, value);
        }

        protected void writeOwn(Object target, long index, Object value) {
            WriteElementNode write = this.getOrCreateWriteOwnNode();
            write.executeWithTargetAndIndexAndValue(target, index, value);
        }

        private JSHasPropertyNode getOrCreateHasPropertyNode() {
            if (this.hasPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasPropertyNode = this.insert(JSHasPropertyNode.create());
            }
            return this.hasPropertyNode;
        }

        protected boolean hasProperty(Object target, long propertyIdx) {
            return this.getOrCreateHasPropertyNode().executeBoolean(target, propertyIdx);
        }

        protected long nextElementIndex(Object target, long currentIndex, long length) {
            if (this.nextElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextElementIndexNode = this.insert(JSArrayNextElementIndexNode.create(this.getContext()));
            }
            return this.nextElementIndexNode.executeLong(target, currentIndex, length);
        }

        protected long previousElementIndex(Object target, long currentIndex) {
            if (this.previousElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.previousElementIndexNode = this.insert(JSArrayPreviousElementIndexNode.create(this.getContext()));
            }
            return this.previousElementIndexNode.executeLong(target, currentIndex);
        }

        protected static final void throwLengthError() {
            throw Errors.createTypeError("length too big");
        }

        protected final JSObject createEmpty(Object thisObj, long length) {
            if (this.isTypedArrayImplementation) {
                return this.typedArrayCreateSameType((JSTypedArrayObject)thisObj, length);
            }
            return this.arrayCreate(length);
        }

        protected final JSTypedArrayObject typedArrayCreateSameType(JSTypedArrayObject thisObj, long length) {
            return this.getArraySpeciesConstructorNode().typedArrayCreateSameType(thisObj, JSRuntime.longToIntOrDouble(length));
        }

        protected JSArrayObject arrayCreate(long length) {
            if (this.arrayCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayCreateNode = this.insert(ArrayCreateNode.create(this.getContext()));
            }
            return this.arrayCreateNode.execute(length);
        }
    }

    protected static class ArraySpeciesConstructorNode
    extends JavaScriptBaseNode {
        private final boolean isTypedArrayImplementation;
        @Node.Child
        private JSFunctionCallNode constructorCall;
        @Node.Child
        private PropertyGetNode getConstructorNode;
        @Node.Child
        private PropertyGetNode getSpeciesNode;
        @Node.Child
        private JSIsArrayNode isArrayNode;
        @Node.Child
        private IsConstructorNode isConstructorNode = IsConstructorNode.create();
        @Node.Child
        private ArrayCreateNode arrayCreateNode;
        private final BranchProfile errorBranch = BranchProfile.create();
        private final BranchProfile arraySpeciesIsArray = BranchProfile.create();
        private final BranchProfile arraySpeciesGetSymbol = BranchProfile.create();
        private final BranchProfile differentRealm = BranchProfile.create();
        private final BranchProfile defaultConstructorBranch = BranchProfile.create();
        private final ConditionProfile arraySpeciesEmpty = ConditionProfile.create();
        private final JSContext context;

        protected ArraySpeciesConstructorNode(JSContext context, boolean isTypedArrayImplementation) {
            this.context = context;
            this.isTypedArrayImplementation = isTypedArrayImplementation;
            this.isArrayNode = JSIsArrayNode.createIsArray();
            this.constructorCall = JSFunctionCallNode.createNew();
        }

        @NeverDefault
        protected static ArraySpeciesConstructorNode create(JSContext context, boolean isTypedArrayImplementation) {
            return new ArraySpeciesConstructorNode(context, isTypedArrayImplementation);
        }

        protected final Object createEmptyContainer(Object thisObj, long size) {
            if (this.isTypedArrayImplementation) {
                return this.typedArraySpeciesCreate((JSTypedArrayObject)thisObj, JSRuntime.longToIntOrDouble(size));
            }
            return this.arraySpeciesCreate(thisObj, size);
        }

        protected final JSTypedArrayObject typedArraySpeciesCreate(JSTypedArrayObject thisObj, Object ... args) {
            Object constr = this.speciesConstructor(thisObj, ArraySpeciesConstructorNode.getDefaultConstructor(this.getRealm(), thisObj));
            return this.typedArrayCreate(constr, args);
        }

        protected final JSTypedArrayObject typedArrayCreateSameType(JSTypedArrayObject thisObj, Object ... args) {
            JSFunctionObject constr = ArraySpeciesConstructorNode.getDefaultConstructor(this.getRealm(), thisObj);
            return this.typedArrayCreate(constr, args);
        }

        public final JSTypedArrayObject typedArrayCreate(Object constr, Object ... args) {
            Object newObject = this.construct(constr, args);
            if (!JSArrayBufferView.isJSArrayBufferView(newObject)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            JSTypedArrayObject newTypedArray = (JSTypedArrayObject)newObject;
            if (JSArrayBufferView.isOutOfBounds(newTypedArray, this.context)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
            if (args.length == 1 && JSRuntime.isNumber(args[0]) && (double)newTypedArray.getLength() < JSRuntime.doubleValue((Number)args[0])) {
                this.errorBranch.enter();
                throw Errors.createTypeError("invalid TypedArray created");
            }
            return newTypedArray;
        }

        protected final Object arraySpeciesCreate(Object originalArray, long length) {
            Object ctor = Undefined.instance;
            if (this.isArray(originalArray)) {
                this.arraySpeciesIsArray.enter();
                ctor = this.getConstructorProperty(originalArray);
                if (ctor instanceof JSObject) {
                    JSRealm ctorRealm;
                    JSRealm thisRealm;
                    JSObject ctorObj = (JSObject)ctor;
                    if (JSFunction.isJSFunction(ctorObj) && JSFunction.isConstructor(ctorObj) && (thisRealm = this.getRealm()) != (ctorRealm = JSFunction.getRealm((JSFunctionObject)ctorObj))) {
                        this.differentRealm.enter();
                        if (ctorRealm.getArrayConstructor() == ctor) {
                            return this.arrayCreate(length);
                        }
                    }
                    this.arraySpeciesGetSymbol.enter();
                    ctor = this.getSpeciesProperty(ctor);
                    ctor = ctor == Null.instance ? Undefined.instance : ctor;
                }
            }
            if (this.arraySpeciesEmpty.profile(ctor == Undefined.instance)) {
                return this.arrayCreate(length);
            }
            if (!this.isConstructorNode.executeBoolean(ctor)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAConstructor(ctor, this.context);
            }
            return this.construct(ctor, JSRuntime.longToIntOrDouble(length));
        }

        protected final boolean isArray(Object thisObj) {
            return this.isArrayNode.execute(thisObj);
        }

        private JSArrayObject arrayCreate(long length) {
            if (this.arrayCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayCreateNode = this.insert(ArrayCreateNode.create(this.context));
            }
            return this.arrayCreateNode.execute(length);
        }

        protected Object construct(Object constructor, Object ... userArgs) {
            Object[] args = JSArguments.createInitial(JSFunction.CONSTRUCT, constructor, userArgs.length);
            System.arraycopy(userArgs, 0, args, 2, userArgs.length);
            return this.constructorCall.executeCall(args);
        }

        protected static final JSFunctionObject getDefaultConstructor(JSRealm realm, JSTypedArrayObject thisObj) {
            TypedArray arrayType = JSArrayBufferView.typedArrayGetArrayType(thisObj);
            return realm.getArrayBufferViewConstructor(arrayType.getFactory());
        }

        protected final Object speciesConstructor(JSDynamicObject thisObj, JSDynamicObject defaultConstructor) {
            Object c2 = this.getConstructorProperty(thisObj);
            if (c2 == Undefined.instance) {
                this.defaultConstructorBranch.enter();
                return defaultConstructor;
            }
            if (!(c2 instanceof JSObject)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAnObject(c2);
            }
            Object speciesConstructor = this.getSpeciesProperty(c2);
            if (speciesConstructor == Undefined.instance || speciesConstructor == Null.instance) {
                this.defaultConstructorBranch.enter();
                return defaultConstructor;
            }
            if (!this.isConstructorNode.executeBoolean(speciesConstructor)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAConstructor(speciesConstructor, this.context);
            }
            return speciesConstructor;
        }

        private Object getConstructorProperty(Object obj) {
            if (this.getConstructorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getConstructorNode = this.insert(PropertyGetNode.create(JSObject.CONSTRUCTOR, false, this.context));
            }
            return this.getConstructorNode.getValue(obj);
        }

        private Object getSpeciesProperty(Object obj) {
            if (this.getSpeciesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSpeciesNode = this.insert(PropertyGetNode.create(Symbol.SYMBOL_SPECIES, false, this.context));
            }
            return this.getSpeciesNode.getValue(obj);
        }
    }

    public static abstract class BasicArrayOperation
    extends JSBuiltinNode {
        protected final boolean isTypedArrayImplementation;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;
        @Node.Child
        private TypedArrayLengthNode typedArrayLengthNode;
        @Node.Child
        private ArraySpeciesConstructorNode arraySpeciesCreateNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        protected final BranchProfile errorBranch = BranchProfile.create();

        public BasicArrayOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin);
            this.isTypedArrayImplementation = isTypedArrayImplementation;
        }

        public BasicArrayOperation(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected final Object toObject(Object target) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(target);
        }

        protected long getLength(Object thisObject) {
            if (this.isTypedArrayImplementation) {
                if (this.typedArrayLengthNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.typedArrayLengthNode = this.insert(TypedArrayLengthNode.create());
                }
                return this.typedArrayLengthNode.execute(null, (JSTypedArrayObject)thisObject, this.getContext());
            }
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(JSGetLengthNode.create(this.getContext()));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        protected final Object toObjectOrValidateTypedArray(Object thisObj) {
            return this.isTypedArrayImplementation ? this.validateTypedArray(thisObj) : this.toObject(thisObj);
        }

        protected final boolean isCallable(Object callback) {
            if (this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isCallableNode = this.insert(IsCallableNode.create());
            }
            return this.isCallableNode.executeBoolean(callback);
        }

        protected final Object checkCallbackIsFunction(Object callback) {
            if (!this.isCallable(callback)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAFunction(callback, this);
            }
            return callback;
        }

        protected final ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArraySpeciesConstructorNode.create(this.getContext(), this.isTypedArrayImplementation));
            }
            return this.arraySpeciesCreateNode;
        }

        protected final void checkOutOfBounds(JSTypedArrayObject view) {
            if (JSArrayBufferView.isOutOfBounds(view, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
        }

        protected final JSTypedArrayObject validateTypedArray(Object obj) {
            if (!JSArrayBufferView.isJSArrayBufferView(obj)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            JSTypedArrayObject typedArrayObject = (JSTypedArrayObject)obj;
            if (JSArrayBufferView.isOutOfBounds(typedArrayObject, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
            return typedArrayObject;
        }

        protected void reportLoopCount(long count) {
            BasicArrayOperation.reportLoopCount(this, count);
        }

        public static void reportLoopCount(Node node, long count) {
            if (count > 0L) {
                LoopNode.reportLoopCount(node, count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count);
            }
        }
    }
}

