/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.BigIntFunctionBuiltins;
import com.oracle.truffle.js.builtins.BigIntPrototypeBuiltins;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSBigIntObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSPrimitive;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSBigInt
extends JSPrimitive
implements JSConstructorFactory.WithFunctions {
    public static final TruffleString TYPE_NAME = Strings.constant("bigint");
    public static final TruffleString CLASS_NAME = Strings.constant("BigInt");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("BigInt.prototype");
    public static final JSBigInt INSTANCE = new JSBigInt();

    private JSBigInt() {
    }

    @HostCompilerDirectives.InliningCutoff
    public static JSBigIntObject create(JSContext context, JSRealm realm, BigInt value) {
        return JSBigInt.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), value);
    }

    @HostCompilerDirectives.InliningCutoff
    public static JSBigIntObject create(JSContext context, JSRealm realm, JSDynamicObject proto, BigInt value) {
        JSObjectFactory factory = context.getBigIntFactory();
        Shape shape = factory.getShape(realm, proto);
        JSBigIntObject newObj = factory.initProto(new JSBigIntObject(shape, proto, value), realm, proto);
        return factory.trackAllocation(newObj);
    }

    private static BigInt getBigIntegerField(JSDynamicObject obj) {
        assert (JSBigInt.isJSBigInt(obj));
        return ((JSBigIntObject)obj).getBigIntValue();
    }

    public static BigInt valueOf(JSDynamicObject obj) {
        return JSBigInt.getBigIntegerField(obj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject bigIntPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(bigIntPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, bigIntPrototype, BigIntPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(bigIntPrototype, CLASS_NAME);
        return bigIntPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, BigIntFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSBigInt(Object obj) {
        return obj instanceof JSBigIntObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getBigIntPrototype();
    }
}

