/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import java.util.concurrent.atomic.AtomicInteger;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotThreadTask
implements Runnable {
    public static final PolyglotThreadTask ISOLATE_POLYGLOT_THREAD = new PolyglotThreadTask();
    private static final AtomicInteger THREAD_INIT_NUMBER = new AtomicInteger(0);
    private final PolyglotLanguageContext languageContext;
    private final Runnable userRunnable;
    final Thread parentThread;
    final Runnable beforeEnter;
    final Runnable afterLeave;
    private final CallTarget callTarget;

    PolyglotThreadTask(PolyglotLanguageContext languageContext, Runnable runnable, Runnable beforeEnter, Runnable afterLeave) {
        this.languageContext = languageContext;
        this.userRunnable = runnable;
        this.parentThread = Thread.currentThread();
        this.beforeEnter = beforeEnter;
        this.afterLeave = afterLeave;
        this.callTarget = ThreadSpawnRootNode.lookup(languageContext.getLanguageInstance());
    }

    private PolyglotThreadTask() {
        this.languageContext = null;
        this.userRunnable = null;
        this.parentThread = null;
        this.beforeEnter = null;
        this.afterLeave = null;
        this.callTarget = null;
    }

    static String createDefaultName(PolyglotLanguageContext creator) {
        return "Polyglot-" + creator.language.getId() + "-" + THREAD_INIT_NUMBER.getAndIncrement();
    }

    @Override
    public void run() {
        try {
            this.callTarget.call(null, this.languageContext, this, this.userRunnable);
        }
        catch (Throwable t2) {
            throw PolyglotImpl.engineToLanguageException(t2);
        }
    }

    static final class ThreadSpawnRootNode
    extends RootNode {
        ThreadSpawnRootNode(PolyglotLanguageInstance languageInstance) {
            super(languageInstance.spi);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] args = frame.getArguments();
            return ThreadSpawnRootNode.executeImpl((PolyglotLanguageContext)args[0], (PolyglotThreadTask)args[1], (Runnable)args[2]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private static Object executeImpl(PolyglotLanguageContext languageContext, PolyglotThreadTask polyglotThreadTask, Runnable runnable) {
            Object[] prev = languageContext.enterThread(polyglotThreadTask);
            assert (prev == null);
            try (AbstractPolyglotImpl.ThreadScope scope = languageContext.getImpl().getRootImpl().createThreadScope();){
                runnable.run();
            }
            catch (PolyglotEngineImpl.CancelExecution cancel) {
                if (PolyglotEngineOptions.TriggerUncaughtExceptionHandlerForCancel.getValue(languageContext.context.engine.getEngineOptionValues()).booleanValue()) {
                    throw cancel;
                }
                Object var5_7 = null;
                return var5_7;
            }
            finally {
                languageContext.leaveAndDisposePolyglotThread(prev, polyglotThreadTask);
            }
            return null;
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        public static CallTarget lookup(PolyglotLanguageInstance languageInstance) {
            CallTarget target = languageInstance.lookupCallTarget(ThreadSpawnRootNode.class);
            if (target == null) {
                target = languageInstance.installCallTarget(new ThreadSpawnRootNode(languageInstance));
            }
            return target;
        }
    }
}

