/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.RegexASTVisitorIterable;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.ArrayList;
import java.util.stream.Collectors;

public final class Sequence
extends RegexASTNode
implements RegexASTVisitorIterable {
    private final ArrayList<Term> terms = new ArrayList();
    private short visitorIterationIndex = 0;

    Sequence() {
    }

    private Sequence(Sequence copy) {
        super(copy);
    }

    @Override
    public Sequence copy(RegexAST ast) {
        return ast.register(new Sequence(this));
    }

    @Override
    public Sequence copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        Sequence copy = this.copy(ast);
        for (Term t2 : this.terms) {
            copy.add(t2.copyRecursive(ast, compilationBuffer));
        }
        return copy;
    }

    @Override
    public Group getParent() {
        return (Group)super.getParent();
    }

    @Override
    public void setParent(RegexASTNode parent) {
        assert (parent instanceof Group);
        super.setParent(parent);
    }

    public ArrayList<Term> getTerms() {
        return this.terms;
    }

    public boolean isEmpty() {
        return this.terms.isEmpty();
    }

    public int size() {
        return this.terms.size();
    }

    public Term getFirstTerm() {
        return this.terms.get(0);
    }

    public Term get(int i2) {
        return this.terms.get(i2);
    }

    public Term getLastTerm() {
        return this.terms.get(this.terms.size() - 1);
    }

    public void add(Term term) {
        term.setParent(this);
        term.setSeqIndex(this.terms.size());
        this.terms.add(term);
    }

    public void replace(int index, Term term) {
        term.setParent(this);
        term.setSeqIndex(index);
        this.terms.set(index, term);
    }

    public void removeTerm(int i2, CompilationBuffer compilationBuffer) {
        int j2;
        ObjectArrayBuffer<Term> buf = compilationBuffer.getObjectBuffer1();
        int size = this.size();
        for (j2 = i2 + 1; j2 < size; ++j2) {
            buf.add(this.getLastTerm());
            this.removeLastTerm();
        }
        this.removeLastTerm();
        for (j2 = buf.length() - 1; j2 >= 0; --j2) {
            this.add((Term)buf.get(j2));
        }
    }

    public void removeLastTerm() {
        this.terms.remove(this.terms.size() - 1);
    }

    public boolean isFirstInGroup() {
        return this.getParent().getFirstAlternative() == this;
    }

    public boolean isLastInGroup() {
        return this.getParent().getAlternatives().get(this.getParent().getAlternatives().size() - 1) == this;
    }

    public boolean isPenultimateInGroup() {
        ArrayList<Sequence> alt = this.getParent().getAlternatives();
        return alt.size() > 1 && alt.get(alt.size() - 2) == this;
    }

    public boolean isLiteral() {
        if (this.isEmpty()) {
            return false;
        }
        for (Term t2 : this.terms) {
            if (t2.isCharacterClass() && !t2.asCharacterClass().hasNotUnrolledQuantifier()) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleCharClass() {
        return this.size() == 1 && this.isLiteral();
    }

    public int getEnclosedCaptureGroupsLow() {
        int lo = Integer.MAX_VALUE;
        for (Term t2 : this.terms) {
            if (!(t2 instanceof Group)) continue;
            Group g2 = (Group)t2;
            if (g2.getEnclosedCaptureGroupsLow() != g2.getEnclosedCaptureGroupsHigh()) {
                lo = Math.min(lo, g2.getEnclosedCaptureGroupsLow());
            }
            if (!g2.isCapturing()) continue;
            lo = Math.min(lo, g2.getGroupNumber());
        }
        return lo == Integer.MAX_VALUE ? -1 : lo;
    }

    public int getEnclosedCaptureGroupsHigh() {
        int hi = Integer.MIN_VALUE;
        for (Term t2 : this.terms) {
            if (!(t2 instanceof Group)) continue;
            Group g2 = (Group)t2;
            if (g2.getEnclosedCaptureGroupsLow() != g2.getEnclosedCaptureGroupsHigh()) {
                hi = Math.max(hi, g2.getEnclosedCaptureGroupsHigh());
            }
            if (!g2.isCapturing()) continue;
            hi = Math.max(hi, g2.getGroupNumber() + 1);
        }
        return hi == Integer.MIN_VALUE ? -1 : hi;
    }

    @Override
    public RegexASTSubtreeRootNode getSubTreeParent() {
        return this.getParent().getSubTreeParent();
    }

    @Override
    public boolean visitorHasNext() {
        return this.visitorIterationIndex < this.terms.size();
    }

    @Override
    public void resetVisitorIterator() {
        this.visitorIterationIndex = 0;
    }

    @Override
    public RegexASTNode visitorGetNext(boolean reverse) {
        if (reverse) {
            this.visitorIterationIndex = (short)(this.visitorIterationIndex + 1);
            return this.terms.get(this.terms.size() - this.visitorIterationIndex);
        }
        short s2 = this.visitorIterationIndex;
        this.visitorIterationIndex = (short)(s2 + 1);
        return this.terms.get(s2);
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence o2 = (Sequence)obj;
        if (this.size() != o2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.terms.get(i2).equalsSemantic(o2.terms.get(i2))) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.terms.stream().map(Object::toString).collect(Collectors.joining(""));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return this.toJson("Sequence").append(Json.prop("terms", this.terms));
    }
}

