/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.RegistryEntries;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslatorRegistry;
import org.cyclops.integratedscripting.api.language.ILanguageHandlerRegistry;
import org.cyclops.integratedscripting.block.BlockMendesiteConfig;
import org.cyclops.integratedscripting.block.BlockScriptingDriveConfig;
import org.cyclops.integratedscripting.blockentity.BlockEntityScriptingDriveConfig;
import org.cyclops.integratedscripting.capability.ScriptingNetworkCapabilityConstructors;
import org.cyclops.integratedscripting.command.CommandTestScript;
import org.cyclops.integratedscripting.component.DataComponentDiskIdConfig;
import org.cyclops.integratedscripting.core.client.model.ScriptingVariableModelProviders;
import org.cyclops.integratedscripting.core.evaluate.ScriptVariableFacadeHandler;
import org.cyclops.integratedscripting.core.language.LanguageHandlerRegistry;
import org.cyclops.integratedscripting.core.language.LanguageHandlers;
import org.cyclops.integratedscripting.core.network.ScriptingData;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslatorRegistry;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.inventory.container.ContainerScriptingDriveConfig;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScriptingConfig;
import org.cyclops.integratedscripting.item.ItemScriptingDiskConfig;
import org.cyclops.integratedscripting.part.PartTypes;
import org.cyclops.integratedscripting.proxy.ClientProxy;
import org.cyclops.integratedscripting.proxy.CommonProxy;

@Mod(value="integratedscripting")
public class IntegratedScripting
extends ModBaseNeoForge<IntegratedScripting> {
    public static IntegratedScripting _instance;
    public ScriptingData scriptingData;

    public IntegratedScripting(IEventBus modEventBus) {
        super("integratedscripting", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(IValueTranslatorRegistry.class, (IRegistry)ValueTranslatorRegistry.getInstance());
        this.getRegistryManager().addRegistry(ILanguageHandlerRegistry.class, (IRegistry)LanguageHandlerRegistry.getInstance());
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::afterSetup);
        modEventBus.register((Object)new ScriptingNetworkCapabilityConstructors());
        NeoForge.EVENT_BUS.addListener(x$0 -> this.onServerStarting((ServerStartingEvent)x$0));
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler((IVariableFacadeHandler)ScriptVariableFacadeHandler.getInstance());
        if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
            ScriptingVariableModelProviders.load();
        }
        PartTypes.load();
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder root = super.constructBaseCommand(selection, context);
        root.then(CommandTestScript.make());
        return root;
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        ValueTranslators.load();
        LanguageHandlers.load();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        this.scriptingData = new ScriptingData(event.getServer().getWorldPath(ScriptingData.LEVEL_RESOURCE));
    }

    protected void onServerStopping(ServerStoppingEvent event) {
        if (this.scriptingData != null) {
            this.scriptingData.close();
        }
        this.scriptingData = null;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        if (this.scriptingData != null) {
            this.scriptingData.tick();
        }
    }

    protected void afterSetup(FMLLoadCompleteEvent event) {
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedscripting/info/scripting_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedscripting/info/scripting_tutorials.xml");
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_SCRIPTING_DISK));
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemScriptingDiskConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new BlockScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new BlockMendesiteConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new BlockEntityScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerTerminalScriptingConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new DataComponentDiskIdConfig());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public static void clog(String message) {
        IntegratedScripting.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

