/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.proxy.ProxyExecutable;

public class OperatorProxyExecutable
implements ProxyExecutable {
    private final Context context;
    private final ValueTypeOperator.ValueOperator value;
    private final IEvaluationExceptionFactory exceptionFactory;
    private final ValueDeseralizationContext valueDeseralizationContext;

    public OperatorProxyExecutable(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) {
        this.context = context;
        this.value = value;
        this.exceptionFactory = exceptionFactory;
        this.valueDeseralizationContext = valueDeseralizationContext;
    }

    public ValueTypeOperator.ValueOperator getValue() {
        return this.value;
    }

    @Override
    public Object execute(Value ... args) {
        try {
            IVariable[] variables = new IVariable[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                variables[i2] = new Variable(ValueTranslators.REGISTRY.translateFromGraal(this.context, args[i2], this.exceptionFactory, this.valueDeseralizationContext));
            }
            return ValueTranslators.REGISTRY.translateToGraal(this.context, this.value.getRawValue().evaluate(variables), this.exceptionFactory, this.valueDeseralizationContext);
        }
        catch (EvaluationException e2) {
            ScriptHelpers.sneakyThrow(e2);
            return null;
        }
    }
}

