/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.DateFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;

public final class DateFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<DateFunction> {
    public static final JSBuiltinsContainer BUILTINS = new DateFunctionBuiltins();

    protected DateFunctionBuiltins() {
        super(JSDate.CLASS_NAME, DateFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DateFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DateFunctionBuiltinsFactory.DateParseNodeGen.create(context, builtin, DateFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return DateFunctionBuiltinsFactory.DateNowNodeGen.create(context, builtin, DateFunctionBuiltins.args().createArgumentNodes(context));
            }
            case 2: {
                return DateFunctionBuiltinsFactory.DateUTCNodeGen.create(context, builtin, DateFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum DateFunction implements BuiltinEnum<DateFunction>
    {
        parse(1),
        now(0),
        UTC(7);

        private final int length;

        private DateFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class DateParseNode
    extends JSBuiltinNode {
        public DateParseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double parse(Object parseDate, @Cached JSToStringNode toStringNode) {
            TruffleString dateString = toStringNode.executeString(parseDate);
            return ConstructorBuiltins.ConstructDateNode.parseDate(this.getJSContext(), this.getRealm(), dateString);
        }
    }

    public static abstract class DateNowNode
    extends JSBuiltinNode {
        public DateNowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected double now() {
            return this.getRealm().currentTimeMillis();
        }
    }

    public static abstract class DateUTCNode
    extends JSBuiltinNode {
        public DateUTCNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double utc(Object[] args, @Cached JSToNumberNode toNumberNode) {
            double[] argsEvaluated = new double[args.length];
            boolean isNaN = false;
            for (int i2 = 0; i2 < args.length; ++i2) {
                double d2 = JSRuntime.doubleValue(toNumberNode.executeNumber(args[i2]));
                if (Double.isNaN(d2)) {
                    isNaN = true;
                }
                argsEvaluated[i2] = d2;
            }
            if (isNaN) {
                return Double.NaN;
            }
            return JSDate.executeConstructor(argsEvaluated, true);
        }
    }
}

